-- $Id$ 

-- test for physical types

-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library std;
use std.standard.all;
package types is
	type length is range -2147483647 to 2147483647
		units 
			mm;
			cm = 10 mm;
			m = 100 cm;
			km = 1000 m;
			
			inch = 254 mm;
		end units; 
		
	type data is range -2147483647 to 2147483647
		units 
			bit;
			nibble = 4 bit;
			byte = 8 bit;
			word = 2 byte;
			kbit = 1000 bit;
			mbit = 1000 kbit;
			kb = 1024 byte;
			mb = 1024 kb;
			gb = 1024 mb;
			--meterbit = 10 mm; -- should throw an error.
		end units;
end package types;

library std;
use std.standard.all;
use types.all;
entity nullentity is
end entity nullentity;

architecture implementation of nullentity is
begin	
	x : process 
		variable foo : length;
		variable bar : length;
	begin
		foo := 48 mm;
		bar := 2 * foo + 3 cm;
		foo := bar - 5 km;
		bar := foo + 100 inch;
	end process;
end implementation;
