//
// The Fontaine Font Analysis Project 
// 
// Copyright (c) 2009 by Edward H. Trager
// All Rights Reserved
// 
// Released under the GNU GPL version 2.0 or later.
//     

//
// Afrikaans.h
//

#ifndef ORTHOGRAPHY_DATA
#include "../OrthographyData.h"
#endif

#ifndef AFRIKAANS
#define AFRIKAANS

//
// 2009.08.31.ET :: Revised and expanded based on patch from Dwayne Bailey
//
namespace Afrikaans{

//
// Unicode values 
//
UINT32 values[]={
	0x00C0, // À LATIN CAPITAL LETTER A WITH GRAVE
	0x00E0, // à LATIN SMALL LETTER A WITH GRAVE
	0x00C1, // Á LATIN CAPITAL LETTER A WITH ACUTE
	0x00E1, // á LATIN SMALL LETTER A WITH ACUTE
	0x00C4, // Ä LATIN CAPITAL LETTER A WITH DIAERESIS
	0x00E4, // ä LATIN SMALL LETTER A WITH DIAERESIS
	0x00C8, // È LATIN CAPITAL LETTER E WITH GRAVE
	0x00E8, // è LATIN SMALL LETTER E WITH GRAVE
	0x00C9, // É LATIN CAPITAL LETTER E WITH ACUTE
	0x00E9, // é LATIN SMALL LETTER E WITH ACUTE
	0x00CA, // Ê LATIN CAPITAL LETTER E WITH CIRCUMFLEX
	0x00EA, // ê LATIN SMALL LETTER E WITH CIRCUMFLEX
	0x00CB, // Ë LATIN CAPITAL LETTER E WITH DIAERESIS
	0x00EB, // ë LATIN SMALL LETTER E WITH DIAERESIS
	0x00CD, // Í LATIN CAPITAL LETTER I WITH ACUTE
	0x00ED, // í LATIN SMALL LETTER I WITH ACUTE
	0x00CE, // Î LATIN CAPITAL LETTER I WITH CIRCUMFLEX
	0x00EE, // î LATIN SMALL LETTER I WITH CIRCUMFLEX
	0x00CF, // Ï LATIN CAPITAL LETTER I WITH DIAERESIS
	0x00EF, // ï LATIN SMALL LETTER I WITH DIAERESIS
	0x00D2, // Ò LATIN CAPITAL LETTER O WITH GRAVE
	0x00F2, // ò LATIN SMALL LETTER O WITH GRAVE
	0x00D3, // Ó LATIN CAPITAL LETTER O WITH ACUTE
	0x00F3, // ó LATIN SMALL LETTER O WITH ACUTE
	0x00D4, // Ô LATIN CAPITAL LETTER O WITH CIRCUMFLEX
	0x00F4, // ô LATIN SMALL LETTER O WITH CIRCUMFLEX
	0x00D6, // Ö LATIN CAPITAL LETTER O WITH DIAERESIS
	0x00F6, // ö LATIN SMALL LETTER O WITH DIAERESIS
	0x00DA, // Ú LATIN CAPITAL LETTER U WITH ACUTE
	0x00FA, // ú LATIN SMALL LETTER U WITH ACUTE
	0x00DB, // Û LATIN CAPITAL LETTER U WITH CIRCUMFLEX
	0x00FB, // û LATIN SMALL LETTER U WITH CIRCUMFLEX
	0x00DC, // Ü LATIN CAPITAL LETTER U WITH DIAERESIS
	0x00FC, // ü LATIN SMALL LETTER U WITH DIAERESIS
	0x00DD, // Ý LATIN CAPITAL LETTER Y WITH ACUTE
	0x00FD, // ý LATIN SMALL LETTER Y WITH ACUTE
	0x0149, // ŉ LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
	END_OF_DATA
};

//
// Sample sentences
// 
const char *sentences[]={
	"Alle menslike wesens word vry, met gelyke waardigheid en regte, gebore.",
	END_OF_DATA
};


//
// 
//
OrthographyData data={
	"Afrikaans",
	"Afrikaans",
	0x0149, // LATIN SMALL LETTER N PRECEDED BY APOSTROPHE
	values,
	"ÈèËëÔôÛûŉ",
	sentences
};

const OrthographyData *pData = &data;

}; // end of namespace

#endif
