//
// The Fontaine Font Analysis Project 
// 
// Copyright (c) 2009 by Edward H. Trager
// All Rights Reserved
// 
// Released under the GNU GPL version 2.0 or later.
//     


//
// Joyo.h
//

#ifndef ORTHOGRAPHY_DATA
#include "../OrthographyData.h"
#endif

#ifndef JOYO
#define JOYO

//
// Japanese Jōyō (常用漢字) character list
//
// Current jōyō kanji are 1,945 characters issued on October 10, 1981
// One source of these is: http://www.aozora.gr.jp/kanji_table/
//
namespace Joyo{

//
// Unicode values 
//
UINT32 values[]={
	0x4e9c,
	0x54c0,
	0x611b,
	0x60aa,
	0x63e1,
	0x5727,
	0x6271,
	0x5b89,
	0x6697,
	0x6848,
	0x4ee5,
	0x4f4d,
	0x4f9d,
	0x5049,
	0x56f2,
	0x59d4,
	0x5a01,
	0x5c09,
	0x610f,
	0x6170,
	0x6613,
	0x70ba,
	0x7570,
	0x79fb,
	0x7dad,
	0x7def,
	0x80c3,
	0x8863,
	0x9055,
	0x907a,
	0x533b,
	0x4e95,
	0x57df,
	0x80b2,
	0x4e00,
	0x58f1,
	0x9038,
	0x7a32,
	0x828b,
	0x5370,
	0x54e1,
	0x56e0,
	0x59fb,
	0x5f15,
	0x98f2,
	0x9662,
	0x9670,
	0x96a0,
	0x97fb,
	0x53f3,
	0x5b87,
	0x7fbd,
	0x96e8,
	0x6e26,
	0x6d66,
	0x904b,
	0x96f2,
	0x55b6,
	0x5f71,
	0x6620,
	0x6804,
	0x6c38,
	0x6cf3,
	0x82f1,
	0x885b,
	0x8a60,
	0x92ed,
	0x6db2,
	0x75ab,
	0x76ca,
	0x99c5,
	0x60a6,
	0x8b01,
	0x8d8a,
	0x95b2,
	0x5186,
	0x5712,
	0x5bb4,
	0x5ef6,
	0x63f4,
	0x6cbf,
	0x6f14,
	0x708e,
	0x7159,
	0x733f,
	0x7e01,
	0x9060,
	0x925b,
	0x5869,
	0x6c5a,
	0x51f9,
	0x592e,
	0x5965,
	0x5f80,
	0x5fdc,
	0x62bc,
	0x6a2a,
	0x6b27,
	0x6bb4,
	0x738b,
	0x7fc1,
	0x9ec4,
	0x6c96,
	0x5104,
	0x5c4b,
	0x61b6,
	0x4e59,
	0x5378,
	0x6069,
	0x6e29,
	0x7a4f,
	0x97f3,
	0x4e0b,
	0x5316,
	0x4eee,
	0x4f55,
	0x4fa1,
	0x4f73,
	0x52a0,
	0x53ef,
	0x590f,
	0x5ac1,
	0x5bb6,
	0x5be1,
	0x79d1,
	0x6687,
	0x679c,
	0x67b6,
	0x6b4c,
	0x6cb3,
	0x706b,
	0x798d,
	0x7a3c,
	0x7b87,
	0x82b1,
	0x8377,
	0x83ef,
	0x83d3,
	0x8ab2,
	0x8ca8,
	0x904e,
	0x868a,
	0x6211,
	0x753b,
	0x82bd,
	0x8cc0,
	0x96c5,
	0x9913,
	0x4ecb,
	0x4f1a,
	0x89e3,
	0x56de,
	0x584a,
	0x58ca,
	0x5feb,
	0x602a,
	0x6094,
	0x61d0,
	0x6212,
	0x62d0,
	0x6539,
	0x68b0,
	0x6d77,
	0x7070,
	0x754c,
	0x7686,
	0x7d75,
	0x958b,
	0x968e,
	0x8c9d,
	0x52be,
	0x5916,
	0x5bb3,
	0x6168,
	0x6982,
	0x6daf,
	0x8857,
	0x8a72,
	0x57a3,
	0x5687,
	0x5404,
	0x62e1,
	0x683c,
	0x6838,
	0x6bbb,
	0x7372,
	0x78ba,
	0x7a6b,
	0x899a,
	0x89d2,
	0x8f03,
	0x90ed,
	0x95a3,
	0x9694,
	0x9769,
	0x5b66,
	0x5cb3,
	0x697d,
	0x984d,
	0x639b,
	0x6f5f,
	0x5272,
	0x559d,
	0x62ec,
	0x6d3b,
	0x6e07,
	0x6ed1,
	0x8910,
	0x8f44,
	0x4e14,
	0x682a,
	0x5208,
	0x4e7e,
	0x51a0,
	0x5bd2,
	0x520a,
	0x52d8,
	0x52e7,
	0x5dfb,
	0x559a,
	0x582a,
	0x5b8c,
	0x5b98,
	0x5bdb,
	0x5e72,
	0x5e79,
	0x60a3,
	0x611f,
	0x6163,
	0x61be,
	0x63db,
	0x6562,
	0x68fa,
	0x6b3e,
	0x6b53,
	0x6c57,
	0x6f22,
	0x74b0,
	0x7518,
	0x76e3,
	0x770b,
	0x7ba1,
	0x7c21,
	0x7de9,
	0x7f36,
	0x809d,
	0x8266,
	0x89b3,
	0x8cab,
	0x9084,
	0x9451,
	0x9593,
	0x9591,
	0x95a2,
	0x9665,
	0x9928,
	0x4e38,
	0x542b,
	0x5cb8,
	0x773c,
	0x5ca9,
	0x9811,
	0x9854,
	0x9858,
	0x4f01,
	0x5371,
	0x559c,
	0x5668,
	0x57fa,
	0x5947,
	0x5bc4,
	0x5c90,
	0x5e0c,
	0x5e7e,
	0x5fcc,
	0x63ee,
	0x673a,
	0x65d7,
	0x65e2,
	0x671f,
	0x68cb,
	0x68c4,
	0x6a5f,
	0x5e30,
	0x6c17,
	0x6c7d,
	0x7948,
	0x5b63,
	0x7d00,
	0x898f,
	0x8a18,
	0x8cb4,
	0x8d77,
	0x8ecc,
	0x8f1d,
	0x98e2,
	0x9a0e,
	0x9b3c,
	0x507d,
	0x5100,
	0x5b9c,
	0x622f,
	0x6280,
	0x64ec,
	0x6b3a,
	0x72a0,
	0x7591,
	0x7fa9,
	0x8b70,
	0x83ca,
	0x5409,
	0x55ab,
	0x8a70,
	0x5374,
	0x5ba2,
	0x811a,
	0x8650,
	0x9006,
	0x4e18,
	0x4e45,
	0x4f11,
	0x53ca,
	0x5438,
	0x5bae,
	0x5f13,
	0x6025,
	0x6551,
	0x673d,
	0x6c42,
	0x6ce3,
	0x7403,
	0x7a76,
	0x7aae,
	0x7d1a,
	0x7cfe,
	0x7d66,
	0x65e7,
	0x725b,
	0x53bb,
	0x5c45,
	0x5de8,
	0x62d2,
	0x62e0,
	0x6319,
	0x865a,
	0x8a31,
	0x8ddd,
	0x6f01,
	0x9b5a,
	0x4eab,
	0x4eac,
	0x4f9b,
	0x7af6,
	0x5171,
	0x51f6,
	0x5354,
	0x53eb,
	0x5883,
	0x5ce1,
	0x5f37,
	0x6050,
	0x606d,
	0x631f,
	0x6559,
	0x6a4b,
	0x6cc1,
	0x72c2,
	0x72ed,
	0x77ef,
	0x80f8,
	0x8105,
	0x8208,
	0x90f7,
	0x93e1,
	0x97ff,
	0x9a5a,
	0x4ef0,
	0x51dd,
	0x6681,
	0x696d,
	0x5c40,
	0x66f2,
	0x6975,
	0x7389,
	0x52e4,
	0x5747,
	0x65a4,
	0x7434,
	0x7981,
	0x7b4b,
	0x7dca,
	0x83cc,
	0x895f,
	0x8b39,
	0x8fd1,
	0x91d1,
	0x541f,
	0x9280,
	0x4e5d,
	0x53e5,
	0x533a,
	0x82e6,
	0x99c6,
	0x5177,
	0x611a,
	0x865e,
	0x7a7a,
	0x5076,
	0x9047,
	0x9685,
	0x5c48,
	0x6398,
	0x9774,
	0x7e70,
	0x6851,
	0x52f2,
	0x541b,
	0x85ab,
	0x8a13,
	0x7fa4,
	0x8ecd,
	0x90e1,
	0x4fc2,
	0x50be,
	0x5211,
	0x5144,
	0x5553,
	0x578b,
	0x5951,
	0x5f62,
	0x5f84,
	0x6075,
	0x6176,
	0x61a9,
	0x63b2,
	0x643a,
	0x656c,
	0x666f,
	0x6e13,
	0x7cfb,
	0x7d4c,
	0x7d99,
	0x830e,
	0x86cd,
	0x8a08,
	0x8b66,
	0x8efd,
	0x9d8f,
	0x82b8,
	0x8fce,
	0x9be8,
	0x5287,
	0x6483,
	0x6fc0,
	0x5091,
	0x6b20,
	0x6c7a,
	0x6f54,
	0x7a74,
	0x7d50,
	0x8840,
	0x6708,
	0x4ef6,
	0x5039,
	0x5065,
	0x517c,
	0x5238,
	0x5263,
	0x570f,
	0x5805,
	0x5acc,
	0x5efa,
	0x61b2,
	0x61f8,
	0x691c,
	0x6a29,
	0x72ac,
	0x732e,
	0x7814,
	0x7d79,
	0x770c,
	0x80a9,
	0x898b,
	0x8b19,
	0x8ce2,
	0x8ed2,
	0x9063,
	0x967a,
	0x9855,
	0x9a13,
	0x5143,
	0x539f,
	0x53b3,
	0x5e7b,
	0x5f26,
	0x6e1b,
	0x6e90,
	0x7384,
	0x73fe,
	0x8a00,
	0x9650,
	0x500b,
	0x53e4,
	0x547c,
	0x56fa,
	0x5b64,
	0x5df1,
	0x5eab,
	0x5f27,
	0x6238,
	0x6545,
	0x67af,
	0x6e56,
	0x8a87,
	0x96c7,
	0x9867,
	0x9f13,
	0x4e94,
	0x4e92,
	0x5348,
	0x5449,
	0x5a2f,
	0x5f8c,
	0x5fa1,
	0x609f,
	0x7881,
	0x8a9e,
	0x8aa4,
	0x8b77,
	0x4ea4,
	0x4faf,
	0x5019,
	0x5149,
	0x516c,
	0x529f,
	0x52b9,
	0x539a,
	0x53e3,
	0x5411,
	0x540e,
	0x5751,
	0x597d,
	0x5b54,
	0x5b5d,
	0x5de5,
	0x5de7,
	0x5e78,
	0x5e83,
	0x5eb7,
	0x6052,
	0x614c,
	0x6297,
	0x62d8,
	0x63a7,
	0x653b,
	0x66f4,
	0x6821,
	0x69cb,
	0x6c5f,
	0x6d2a,
	0x6e2f,
	0x6e9d,
	0x7532,
	0x7687,
	0x786c,
	0x7a3f,
	0x7d05,
	0x7d5e,
	0x7db1,
	0x8015,
	0x8003,
	0x80af,
	0x822a,
	0x8352,
	0x884c,
	0x8861,
	0x8b1b,
	0x8ca2,
	0x8cfc,
	0x90ca,
	0x9175,
	0x9271,
	0x92fc,
	0x964d,
	0x9805,
	0x9999,
	0x9ad8,
	0x525b,
	0x53f7,
	0x5408,
	0x62f7,
	0x8c6a,
	0x514b,
	0x523b,
	0x544a,
	0x56fd,
	0x7a40,
	0x9177,
	0x9ed2,
	0x7344,
	0x8170,
	0x9aa8,
	0x8fbc,
	0x4eca,
	0x56f0,
	0x58be,
	0x5a5a,
	0x6068,
	0x61c7,
	0x6606,
	0x6839,
	0x6df7,
	0x7d3a,
	0x9b42,
	0x4f50,
	0x5506,
	0x5de6,
	0x5dee,
	0x67fb,
	0x7802,
	0x8a50,
	0x9396,
	0x5ea7,
	0x50b5,
	0x50ac,
	0x518d,
	0x6700,
	0x59bb,
	0x5bb0,
	0x5f69,
	0x624d,
	0x63a1,
	0x683d,
	0x6b73,
	0x6e08,
	0x707d,
	0x7815,
	0x796d,
	0x658e,
	0x7d30,
	0x83dc,
	0x88c1,
	0x8f09,
	0x969b,
	0x5264,
	0x5728,
	0x6750,
	0x7f6a,
	0x8ca1,
	0x5742,
	0x54b2,
	0x5d0e,
	0x4f5c,
	0x524a,
	0x643e,
	0x6628,
	0x7b56,
	0x7d22,
	0x932f,
	0x685c,
	0x518a,
	0x5237,
	0x5bdf,
	0x64ae,
	0x64e6,
	0x672d,
	0x6bba,
	0x96d1,
	0x76bf,
	0x4e09,
	0x5098,
	0x53c2,
	0x5c71,
	0x60e8,
	0x6563,
	0x685f,
	0x7523,
	0x7b97,
	0x8695,
	0x8cdb,
	0x9178,
	0x66ab,
	0x6b8b,
	0x4ed5,
	0x4f3a,
	0x4f7f,
	0x523a,
	0x53f8,
	0x53f2,
	0x55e3,
	0x56db,
	0x58eb,
	0x59cb,
	0x59c9,
	0x59ff,
	0x5b50,
	0x5e02,
	0x5e2b,
	0x5fd7,
	0x601d,
	0x6307,
	0x652f,
	0x65bd,
	0x65e8,
	0x679d,
	0x6b62,
	0x6b7b,
	0x6c0f,
	0x7949,
	0x79c1,
	0x7cf8,
	0x7d19,
	0x7d2b,
	0x80a2,
	0x8102,
	0x81f3,
	0x8996,
	0x8a5e,
	0x8a69,
	0x8a66,
	0x8a8c,
	0x8aee,
	0x8cc7,
	0x8cdc,
	0x96cc,
	0x98fc,
	0x6b6f,
	0x4e8b,
	0x4f3c,
	0x4f8d,
	0x5150,
	0x5b57,
	0x5bfa,
	0x6148,
	0x6301,
	0x6642,
	0x6b21,
	0x6ecb,
	0x6cbb,
	0x74bd,
	0x78c1,
	0x793a,
	0x8033,
	0x81ea,
	0x8f9e,
	0x5f0f,
	0x8b58,
	0x8ef8,
	0x4e03,
	0x57f7,
	0x5931,
	0x5ba4,
	0x6e7f,
	0x6f06,
	0x75be,
	0x8cea,
	0x5b9f,
	0x829d,
	0x820e,
	0x5199,
	0x5c04,
	0x6368,
	0x8d66,
	0x659c,
	0x716e,
	0x793e,
	0x8005,
	0x8b1d,
	0x8eca,
	0x906e,
	0x86c7,
	0x90aa,
	0x501f,
	0x52fa,
	0x5c3a,
	0x7235,
	0x914c,
	0x91c8,
	0x82e5,
	0x5bc2,
	0x5f31,
	0x4e3b,
	0x53d6,
	0x5b88,
	0x624b,
	0x6731,
	0x6b8a,
	0x72e9,
	0x73e0,
	0x7a2e,
	0x8da3,
	0x9152,
	0x9996,
	0x5112,
	0x53d7,
	0x5bff,
	0x6388,
	0x6a39,
	0x9700,
	0x56da,
	0x53ce,
	0x5468,
	0x5b97,
	0x5c31,
	0x5dde,
	0x4fee,
	0x6101,
	0x62fe,
	0x79c0,
	0x79cb,
	0x7d42,
	0x7fd2,
	0x81ed,
	0x821f,
	0x8846,
	0x8972,
	0x9031,
	0x916c,
	0x96c6,
	0x919c,
	0x4f4f,
	0x5145,
	0x5341,
	0x5f93,
	0x67d4,
	0x6c41,
	0x6e0b,
	0x7363,
	0x7e26,
	0x91cd,
	0x9283,
	0x53d4,
	0x5bbf,
	0x6dd1,
	0x795d,
	0x7e2e,
	0x7c9b,
	0x587e,
	0x719f,
	0x51fa,
	0x8853,
	0x8ff0,
	0x4fca,
	0x6625,
	0x77ac,
	0x51c6,
	0x5faa,
	0x65ec,
	0x6b89,
	0x6e96,
	0x6f64,
	0x76fe,
	0x7d14,
	0x5de1,
	0x9075,
	0x9806,
	0x51e6,
	0x521d,
	0x6240,
	0x6691,
	0x5eb6,
	0x7dd2,
	0x7f72,
	0x66f8,
	0x8af8,
	0x52a9,
	0x53d9,
	0x5973,
	0x5e8f,
	0x5f90,
	0x9664,
	0x50b7,
	0x511f,
	0x52dd,
	0x5320,
	0x5347,
	0x53ec,
	0x5546,
	0x5531,
	0x5968,
	0x5bb5,
	0x5c06,
	0x5c0f,
	0x5c11,
	0x5c1a,
	0x5e8a,
	0x5f70,
	0x627f,
	0x6284,
	0x62db,
	0x638c,
	0x6607,
	0x662d,
	0x6676,
	0x677e,
	0x6cbc,
	0x6d88,
	0x6e09,
	0x713c,
	0x7126,
	0x7167,
	0x75c7,
	0x7701,
	0x785d,
	0x7901,
	0x7965,
	0x79f0,
	0x7ae0,
	0x7b11,
	0x7ca7,
	0x7d39,
	0x8096,
	0x885d,
	0x8a1f,
	0x8a3c,
	0x8a54,
	0x8a73,
	0x8c61,
	0x8cde,
	0x9418,
	0x969c,
	0x4e0a,
	0x4e08,
	0x4e57,
	0x5197,
	0x5270,
	0x57ce,
	0x5834,
	0x58cc,
	0x5b22,
	0x5e38,
	0x60c5,
	0x6761,
	0x6d44,
	0x72b6,
	0x7573,
	0x84b8,
	0x8b72,
	0x91b8,
	0x9320,
	0x5631,
	0x98fe,
	0x690d,
	0x6b96,
	0x7e54,
	0x8077,
	0x8272,
	0x89e6,
	0x98df,
	0x8fb1,
	0x4f38,
	0x4fe1,
	0x4fb5,
	0x5507,
	0x5a20,
	0x5bdd,
	0x5be9,
	0x5fc3,
	0x614e,
	0x632f,
	0x65b0,
	0x68ee,
	0x6d78,
	0x6df1,
	0x7533,
	0x771f,
	0x795e,
	0x7d33,
	0x81e3,
	0x85aa,
	0x89aa,
	0x8a3a,
	0x8eab,
	0x8f9b,
	0x9032,
	0x91dd,
	0x9707,
	0x4eba,
	0x4ec1,
	0x5203,
	0x5c0b,
	0x751a,
	0x5c3d,
	0x8fc5,
	0x9663,
	0x9162,
	0x56f3,
	0x5439,
	0x5782,
	0x5e25,
	0x63a8,
	0x6c34,
	0x708a,
	0x7761,
	0x7c8b,
	0x8870,
	0x9042,
	0x9154,
	0x9318,
	0x968f,
	0x9ac4,
	0x5d07,
	0x6570,
	0x67a2,
	0x636e,
	0x6749,
	0x6f84,
	0x5bf8,
	0x4e16,
	0x702c,
	0x755d,
	0x662f,
	0x5236,
	0x52e2,
	0x59d3,
	0x5f81,
	0x6027,
	0x6210,
	0x653f,
	0x6574,
	0x661f,
	0x6674,
	0x6b63,
	0x6e05,
	0x7272,
	0x751f,
	0x76db,
	0x7cbe,
	0x8056,
	0x58f0,
	0x88fd,
	0x897f,
	0x8aa0,
	0x8a93,
	0x8acb,
	0x901d,
	0x9752,
	0x9759,
	0x6589,
	0x7a0e,
	0x96bb,
	0x5e2d,
	0x60dc,
	0x65a5,
	0x6614,
	0x6790,
	0x77f3,
	0x7a4d,
	0x7c4d,
	0x7e3e,
	0x8cac,
	0x8d64,
	0x8de1,
	0x5207,
	0x62d9,
	0x63a5,
	0x6442,
	0x6298,
	0x8a2d,
	0x7a83,
	0x7bc0,
	0x8aac,
	0x96ea,
	0x7d76,
	0x820c,
	0x4ed9,
	0x5148,
	0x5343,
	0x5360,
	0x5ba3,
	0x5c02,
	0x5ddd,
	0x6226,
	0x6247,
	0x6813,
	0x6cc9,
	0x6d45,
	0x6d17,
	0x67d3,
	0x6f5c,
	0x65cb,
	0x7dda,
	0x7e4a,
	0x8239,
	0x85a6,
	0x8df5,
	0x9078,
	0x9077,
	0x92ad,
	0x9291,
	0x9bae,
	0x524d,
	0x5584,
	0x6f38,
	0x7136,
	0x5168,
	0x7985,
	0x7e55,
	0x5851,
	0x63aa,
	0x758e,
	0x790e,
	0x7956,
	0x79df,
	0x7c97,
	0x7d20,
	0x7d44,
	0x8a34,
	0x963b,
	0x50e7,
	0x5275,
	0x53cc,
	0x5009,
	0x55aa,
	0x58ee,
	0x594f,
	0x5c64,
	0x60f3,
	0x635c,
	0x6383,
	0x633f,
	0x64cd,
	0x65e9,
	0x66f9,
	0x5de3,
	0x69fd,
	0x71e5,
	0x4e89,
	0x76f8,
	0x7a93,
	0x7dcf,
	0x8349,
	0x8358,
	0x846c,
	0x85fb,
	0x88c5,
	0x8d70,
	0x9001,
	0x906d,
	0x971c,
	0x9a12,
	0x50cf,
	0x5897,
	0x618e,
	0x81d3,
	0x8535,
	0x8d08,
	0x9020,
	0x4fc3,
	0x5074,
	0x5247,
	0x5373,
	0x606f,
	0x675f,
	0x6e2c,
	0x8db3,
	0x901f,
	0x4fd7,
	0x5c5e,
	0x8cca,
	0x65cf,
	0x7d9a,
	0x5352,
	0x5b58,
	0x5b6b,
	0x5c0a,
	0x640d,
	0x6751,
	0x4ed6,
	0x591a,
	0x592a,
	0x5815,
	0x59a5,
	0x60f0,
	0x6253,
	0x99c4,
	0x4f53,
	0x5bfe,
	0x8010,
	0x5e2f,
	0x5f85,
	0x6020,
	0x614b,
	0x66ff,
	0x6cf0,
	0x6ede,
	0x80ce,
	0x888b,
	0x8cb8,
	0x9000,
	0x902e,
	0x968a,
	0x4ee3,
	0x53f0,
	0x5927,
	0x7b2c,
	0x984c,
	0x6edd,
	0x5353,
	0x5b85,
	0x629e,
	0x62d3,
	0x6ca2,
	0x6fef,
	0x8a17,
	0x6fc1,
	0x8afe,
	0x4f46,
	0x9054,
	0x596a,
	0x8131,
	0x68da,
	0x8c37,
	0x4e39,
	0x5358,
	0x5606,
	0x62c5,
	0x63a2,
	0x6de1,
	0x70ad,
	0x77ed,
	0x7aef,
	0x80c6,
	0x8a95,
	0x935b,
	0x56e3,
	0x58c7,
	0x5f3e,
	0x65ad,
	0x6696,
	0x6bb5,
	0x7537,
	0x8ac7,
	0x5024,
	0x77e5,
	0x5730,
	0x6065,
	0x6c60,
	0x75f4,
	0x7a1a,
	0x7f6e,
	0x81f4,
	0x9045,
	0x7bc9,
	0x755c,
	0x7af9,
	0x84c4,
	0x9010,
	0x79e9,
	0x7a92,
	0x8336,
	0x5ae1,
	0x7740,
	0x4e2d,
	0x4ef2,
	0x5b99,
	0x5fe0,
	0x62bd,
	0x663c,
	0x67f1,
	0x6ce8,
	0x866b,
	0x8877,
	0x92f3,
	0x99d0,
	0x8457,
	0x8caf,
	0x4e01,
	0x5146,
	0x5e33,
	0x5e81,
	0x5f14,
	0x5f35,
	0x5f6b,
	0x5fb4,
	0x61f2,
	0x6311,
	0x671d,
	0x6f6e,
	0x753a,
	0x773a,
	0x8074,
	0x8139,
	0x8178,
	0x8abf,
	0x8d85,
	0x8df3,
	0x9577,
	0x9802,
	0x9ce5,
	0x52c5,
	0x76f4,
	0x6715,
	0x6c88,
	0x73cd,
	0x8cc3,
	0x93ae,
	0x9673,
	0x6d25,
	0x589c,
	0x8ffd,
	0x75db,
	0x901a,
	0x585a,
	0x6f2c,
	0x576a,
	0x91e3,
	0x4ead,
	0x4f4e,
	0x505c,
	0x5075,
	0x8c9e,
	0x5448,
	0x5824,
	0x5b9a,
	0x5e1d,
	0x5e95,
	0x5ead,
	0x5ef7,
	0x5f1f,
	0x62b5,
	0x63d0,
	0x7a0b,
	0x7de0,
	0x8247,
	0x8a02,
	0x9013,
	0x90b8,
	0x6ce5,
	0x6458,
	0x6575,
	0x6ef4,
	0x7684,
	0x7b1b,
	0x9069,
	0x54f2,
	0x5fb9,
	0x64a4,
	0x8fed,
	0x9244,
	0x5178,
	0x5929,
	0x5c55,
	0x5e97,
	0x6dfb,
	0x8ee2,
	0x70b9,
	0x4f1d,
	0x6bbf,
	0x7530,
	0x96fb,
	0x5410,
	0x5857,
	0x5f92,
	0x6597,
	0x6e21,
	0x767b,
	0x9014,
	0x90fd,
	0x52aa,
	0x5ea6,
	0x571f,
	0x5974,
	0x6012,
	0x5012,
	0x515a,
	0x51ac,
	0x51cd,
	0x5200,
	0x5510,
	0x5854,
	0x5cf6,
	0x60bc,
	0x6295,
	0x642d,
	0x6771,
	0x6843,
	0x68df,
	0x76d7,
	0x6e6f,
	0x706f,
	0x5f53,
	0x75d8,
	0x7b49,
	0x7b54,
	0x7b52,
	0x7cd6,
	0x7d71,
	0x5230,
	0x8a0e,
	0x8b04,
	0x8c46,
	0x8e0f,
	0x9003,
	0x900f,
	0x9676,
	0x982d,
	0x9a30,
	0x95d8,
	0x50cd,
	0x52d5,
	0x540c,
	0x5802,
	0x5c0e,
	0x6d1e,
	0x7ae5,
	0x80f4,
	0x9053,
	0x9285,
	0x5ce0,
	0x533f,
	0x5f97,
	0x5fb3,
	0x7279,
	0x7763,
	0x7be4,
	0x6bd2,
	0x72ec,
	0x8aad,
	0x51f8,
	0x7a81,
	0x5c4a,
	0x5c6f,
	0x8c5a,
	0x66c7,
	0x920d,
	0x5185,
	0x7e04,
	0x5357,
	0x8edf,
	0x96e3,
	0x4e8c,
	0x5c3c,
	0x5f10,
	0x8089,
	0x65e5,
	0x4e73,
	0x5165,
	0x5982,
	0x5c3f,
	0x4efb,
	0x598a,
	0x5fcd,
	0x8a8d,
	0x5be7,
	0x732b,
	0x71b1,
	0x5e74,
	0x5ff5,
	0x71c3,
	0x7c98,
	0x60a9,
	0x6fc3,
	0x7d0d,
	0x80fd,
	0x8133,
	0x8fb2,
	0x628a,
	0x8987,
	0x6ce2,
	0x6d3e,
	0x7834,
	0x5a46,
	0x99ac,
	0x4ff3,
	0x5ec3,
	0x62dd,
	0x6392,
	0x6557,
	0x676f,
	0x80cc,
	0x80ba,
	0x8f29,
	0x914d,
	0x500d,
	0x57f9,
	0x5a92,
	0x6885,
	0x8cb7,
	0x58f2,
	0x8ce0,
	0x966a,
	0x4f2f,
	0x535a,
	0x62cd,
	0x6cca,
	0x767d,
	0x8236,
	0x8584,
	0x8feb,
	0x6f20,
	0x7206,
	0x7e1b,
	0x9ea6,
	0x7bb1,
	0x808c,
	0x7551,
	0x516b,
	0x9262,
	0x767a,
	0x9aea,
	0x4f10,
	0x7f70,
	0x629c,
	0x95a5,
	0x4f34,
	0x5224,
	0x534a,
	0x53cd,
	0x5e06,
	0x642c,
	0x677f,
	0x7248,
	0x72af,
	0x73ed,
	0x7554,
	0x7e41,
	0x822c,
	0x85e9,
	0x8ca9,
	0x7bc4,
	0x7169,
	0x9812,
	0x98ef,
	0x6669,
	0x756a,
	0x76e4,
	0x86ee,
	0x5351,
	0x5426,
	0x5983,
	0x5f7c,
	0x60b2,
	0x6249,
	0x6279,
	0x62ab,
	0x6bd4,
	0x6ccc,
	0x75b2,
	0x76ae,
	0x7891,
	0x79d8,
	0x7f77,
	0x80a5,
	0x88ab,
	0x8cbb,
	0x907f,
	0x975e,
	0x98db,
	0x5099,
	0x5c3e,
	0x5fae,
	0x7f8e,
	0x9f3b,
	0x5339,
	0x5fc5,
	0x7b46,
	0x59eb,
	0x767e,
	0x4ff5,
	0x6a19,
	0x6c37,
	0x6f02,
	0x7968,
	0x8868,
	0x8a55,
	0x63cf,
	0x75c5,
	0x79d2,
	0x82d7,
	0x54c1,
	0x6d5c,
	0x8ca7,
	0x8cd3,
	0x983b,
	0x654f,
	0x74f6,
	0x4e0d,
	0x4ed8,
	0x592b,
	0x5a66,
	0x5bcc,
	0x5e03,
	0x5e9c,
	0x6016,
	0x6276,
	0x6577,
	0x666e,
	0x6d6e,
	0x7236,
	0x7b26,
	0x8150,
	0x819a,
	0x8b5c,
	0x8ca0,
	0x8ce6,
	0x8d74,
	0x9644,
	0x4fae,
	0x6b66,
	0x821e,
	0x90e8,
	0x5c01,
	0x98a8,
	0x4f0f,
	0x526f,
	0x5fa9,
	0x5e45,
	0x670d,
	0x798f,
	0x8179,
	0x8907,
	0x8986,
	0x6255,
	0x6cb8,
	0x4ecf,
	0x7269,
	0x5206,
	0x5674,
	0x58b3,
	0x61a4,
	0x596e,
	0x7c89,
	0x7d1b,
	0x96f0,
	0x6587,
	0x805e,
	0x4e19,
	0x4f75,
	0x5175,
	0x5840,
	0x5e63,
	0x5e73,
	0x5f0a,
	0x67c4,
	0x4e26,
	0x9589,
	0x965b,
	0x7c73,
	0x58c1,
	0x7656,
	0x5225,
	0x504f,
	0x5909,
	0x7247,
	0x7de8,
	0x8fba,
	0x8fd4,
	0x904d,
	0x4fbf,
	0x52c9,
	0x5f01,
	0x4fdd,
	0x8217,
	0x6355,
	0x6b69,
	0x88dc,
	0x7a42,
	0x52df,
	0x5893,
	0x6155,
	0x66ae,
	0x6bcd,
	0x7c3f,
	0x5023,
	0x4ff8,
	0x5305,
	0x5831,
	0x5949,
	0x5b9d,
	0x5cf0,
	0x5d29,
	0x62b1,
	0x653e,
	0x65b9,
	0x6cd5,
	0x6ce1,
	0x7832,
	0x7e2b,
	0x80de,
	0x82b3,
	0x8912,
	0x8a2a,
	0x8c4a,
	0x90a6,
	0x98fd,
	0x4e4f,
	0x4ea1,
	0x508d,
	0x5256,
	0x574a,
	0x59a8,
	0x5e3d,
	0x5fd8,
	0x5fd9,
	0x623f,
	0x66b4,
	0x671b,
	0x67d0,
	0x68d2,
	0x5192,
	0x7d21,
	0x80aa,
	0x81a8,
	0x8b00,
	0x8cbf,
	0x9632,
	0x5317,
	0x50d5,
	0x58a8,
	0x64b2,
	0x6734,
	0x7267,
	0x6ca1,
	0x5800,
	0x5954,
	0x672c,
	0x7ffb,
	0x51e1,
	0x76c6,
	0x6469,
	0x78e8,
	0x9b54,
	0x9ebb,
	0x57cb,
	0x59b9,
	0x679a,
	0x6bce,
	0x5e55,
	0x819c,
	0x53c8,
	0x62b9,
	0x672b,
	0x7e6d,
	0x4e07,
	0x6162,
	0x6e80,
	0x6f2b,
	0x5473,
	0x672a,
	0x9b45,
	0x5cac,
	0x5bc6,
	0x8108,
	0x5999,
	0x6c11,
	0x7720,
	0x52d9,
	0x5922,
	0x7121,
	0x77db,
	0x9727,
	0x5a7f,
	0x5a18,
	0x540d,
	0x547d,
	0x660e,
	0x76df,
	0x8ff7,
	0x9298,
	0x9cf4,
	0x6ec5,
	0x514d,
	0x7dbf,
	0x9762,
	0x6a21,
	0x8302,
	0x5984,
	0x6bdb,
	0x731b,
	0x76f2,
	0x7db2,
	0x8017,
	0x6728,
	0x9ed9,
	0x76ee,
	0x623b,
	0x554f,
	0x7d0b,
	0x9580,
	0x5301,
	0x591c,
	0x91ce,
	0x77e2,
	0x5384,
	0x5f79,
	0x7d04,
	0x85ac,
	0x8a33,
	0x8e8d,
	0x67f3,
	0x6109,
	0x6cb9,
	0x7652,
	0x8aed,
	0x8f38,
	0x552f,
	0x512a,
	0x52c7,
	0x53cb,
	0x5e7d,
	0x60a0,
	0x6182,
	0x6709,
	0x7336,
	0x7531,
	0x88d5,
	0x8a98,
	0x904a,
	0x90f5,
	0x96c4,
	0x878d,
	0x5915,
	0x4e88,
	0x4f59,
	0x4e0e,
	0x8a89,
	0x9810,
	0x5e7c,
	0x5bb9,
	0x5eb8,
	0x63da,
	0x63fa,
	0x64c1,
	0x66dc,
	0x69d8,
	0x6d0b,
	0x6eb6,
	0x7528,
	0x7aaf,
	0x7f8a,
	0x8449,
	0x8981,
	0x8b21,
	0x8e0a,
	0x967d,
	0x990a,
	0x6291,
	0x6b32,
	0x6d74,
	0x7fcc,
	0x7ffc,
	0x7f85,
	0x88f8,
	0x6765,
	0x983c,
	0x96f7,
	0x7d61,
	0x843d,
	0x916a,
	0x4e71,
	0x5375,
	0x6b04,
	0x6feb,
	0x89a7,
	0x5229,
	0x540f,
	0x5c65,
	0x7406,
	0x75e2,
	0x88cf,
	0x91cc,
	0x96e2,
	0x9678,
	0x5f8b,
	0x7387,
	0x7acb,
	0x7565,
	0x6d41,
	0x7559,
	0x786b,
	0x7c92,
	0x9686,
	0x7adc,
	0x616e,
	0x65c5,
	0x865c,
	0x4e86,
	0x50da,
	0x4e21,
	0x5bee,
	0x6599,
	0x6dbc,
	0x731f,
	0x7642,
	0x7ce7,
	0x826f,
	0x91cf,
	0x9675,
	0x9818,
	0x529b,
	0x7dd1,
	0x502b,
	0x5398,
	0x6797,
	0x81e8,
	0x8f2a,
	0x96a3,
	0x5841,
	0x6d99,
	0x7d2f,
	0x985e,
	0x4ee4,
	0x4f8b,
	0x51b7,
	0x52b1,
	0x793c,
	0x9234,
	0x96b7,
	0x96f6,
	0x970a,
	0x9e97,
	0x9f62,
	0x66a6,
	0x6b74,
	0x5217,
	0x52a3,
	0x70c8,
	0x88c2,
	0x5ec9,
	0x604b,
	0x7df4,
	0x9023,
	0x932c,
	0x7089,
	0x8def,
	0x9732,
	0x52b4,
	0x5eca,
	0x6717,
	0x697c,
	0x6d6a,
	0x6f0f,
	0x8001,
	0x90ce,
	0x516d,
	0x9332,
	0x8ad6,
	0x548c,
	0x8a71,
	0x8cc4,
	0x60d1,
	0x67a0,
	0x6e7e,
	0x8155,
	END_OF_DATA
};

//
// Sample sentences
// 
const char *sentences[]={
	"常用漢字...",
	END_OF_DATA
};


//
// 
//
OrthographyData data={
	"Japanese Joyo",
	"日本常用漢字",
	0x4ed9, // 
	values,
	"凹渦靴稼拐涯仙",
	sentences
};

const OrthographyData *pData = &data;

}; // end of namespace

#endif
