#
# Removes unused glyphs
#
from mojo.roboFont import version

SC_ROMAN = [
  "A.smcp",
  "B.smcp",
  "C.smcp",
  "D.smcp",
  "E.smcp",
  "F.smcp",
  "G.smcp",
  "H.smcp",
  "I.smcp",
  "J.smcp",
  "K.smcp",
  "L.smcp",
  "M.smcp",
  "N.smcp",
  "O.smcp",
  "P.smcp",
  "Q.smcp",
  "R.smcp",
  "S.smcp",
  "T.smcp",
  "U.smcp",
  "V.smcp",
  "W.smcp",
  "X.smcp",
  "Y.smcp",
  "Z.smcp",
  "AE.smcp",
  "AEacute.smcp",
  "Aacute.smcp",
  "Abreve.smcp",
  "Acircumflex.smcp",
  "Adieresis.smcp",
  "Agrave.smcp",
  "Alpha.smcp",
  "Alphatonos.smcp",
  "Amacron.smcp",
  "Aogonek.smcp",
  "Aogonek.smcp.NAV",
  "Aring.smcp",
  "Aringacute.smcp",
  "Atilde.smcp",
  "Beta.smcp",
  "Cacute.smcp",
  "Ccaron.smcp",
  "Ccedilla.smcp",
  "Ccircumflex.smcp",
  "Chi.smcp",
  "Dcaron.smcp",
  "Dcroat.smcp",
  "Delta.smcp",
  "Eacute.smcp",
  "Ebreve.smcp",
  "Ecaron.smcp",
  "Ecircumflex.smcp",
  "Edieresis.smcp",
  "Edotaccent.smcp",
  "Egrave.smcp",
  "Emacron.smcp",
  "Eng.smcp",
  "Eogonek.smcp",
  "Eogonek.smcp.NAV",
  "Epsilon.smcp",
  "Epsilontonos.smcp",
  "Eta.smcp",
  "Etatonos.smcp",
  "Eth.smcp",
  "Gamma.smcp",
  "Gbreve.smcp",
  "Gcircumflex.smcp",
  "Gcommaaccent.smcp",
  "Germandbls.smcp",
  "Hbar.smcp",
  "Hcircumflex.smcp",
  "IJ.smcp",
  "Iacute.smcp",
  "Ibreve.smcp",
  "Icircumflex.smcp",
  "Idieresis.smcp",
  "Igrave.smcp",
  "Imacron.smcp",
  "Iogonek.smcp",
  "Iota.smcp",
  "Iotadieresis.smcp",
  "Iotatonos.smcp",
  "Itilde.smcp",
  "Jcircumflex.smcp",
  "Kappa.smcp",
  "Kcommaaccent.smcp",
  "Lacute.smcp",
  "Lambda.smcp",
  "Lcaron.smcp",
  "Lcommaaccent.smcp",
  "Ldot.smcp",
  "Lslash.smcp",
  "Nacute.smcp",
  "Ncaron.smcp",
  "Ncommaaccent.smcp",
  "Ntilde.smcp",
  "Nu.smcp",
  "OE.smcp",
  "Oacute.smcp",
  "Obreve.smcp",
  "Ocircumflex.smcp",
  "Odieresis.smcp",
  "Ograve.smcp",
  "Ohungarumlaut.smcp",
  "Omacron.smcp",
  "Omega.smcp",
  "Omegatonos.smcp",
  "Omicron.smcp",
  "Omicrontonos.smcp",
  "Oogonek.smcp",
  "Oogonek.smcp.NAV",
  "Oslash.smcp",
  "Oslashacute.smcp",
  "Otilde.smcp",
  "Phi.smcp",
  "Pi.smcp",
  "Psi.smcp",
  "Racute.smcp",
  "Rcaron.smcp",
  "Rcommaaccent.smcp",
  "Rho.smcp",
  "Sacute.smcp",
  "Scaron.smcp",
  "Scedilla.smcp",
  "Scircumflex.smcp",
  "Sigma.smcp",
  "Tau.smcp",
  "Tbar.smcp",
  "Tcaron.smcp",
  "Theta.smcp",
  "Thorn.smcp",
  "Uacute.smcp",
  "Ubreve.smcp",
  "Ucircumflex.smcp",
  "Udieresis.smcp",
  "Ugrave.smcp",
  "Uhungarumlaut.smcp",
  "Umacron.smcp",
  "Uogonek.smcp",
  "Upsilon.smcp",
  "Upsilondieresis.smcp",
  "Upsilontonos.smcp",
  "Uring.smcp",
  "Utilde.smcp",
  "Wacute.smcp",
  "Wcircumflex.smcp",
  "Wdieresis.smcp",
  "Wgrave.smcp",
  "Xi.smcp",
  "Yacute.smcp",
  "Ycircumflex.smcp",
  "Ydieresis.smcp",
  "Ygrave.smcp",
  "Zacute.smcp",
  "Zcaron.smcp",
  "Zdotaccent.smcp",
  "Zeta.smcp",
  "ampersand.smcp",
  "uni010A.smcp",
  "uni0120.smcp",
  "uni0162.smcp",
  "Scommaaccent.smcp",
  "Tcommaaccent.smcp",
  "uni037F.smcp"
]


SC_SET1 = [
  "zero.smcp",
  "one.smcp",
  "two.smcp",
  "three.smcp",
  "four.smcp",
  "five.smcp",
  "six.smcp",
  "seven.smcp",
  "eight.smcp",
  "nine.smcp",
  "Euro.smcp",
  "Idotaccent.smcp",
  "Mu.smcp",
  "dollar.smcp",
  "lira.smcp",
  "sterling.smcp",
  "uni0401.smcp",
  "uni0402.smcp",
  "uni0403.smcp",
  "uni0404.smcp",
  "uni0405.smcp",
  "uni0406.smcp",
  "uni0407.smcp",
  "uni0408.smcp",
  "uni0409.smcp",
  "uni040A.smcp",
  "uni040B.smcp",
  "uni040C.smcp",
  "uni040E.smcp",
  "uni040F.smcp",
  "uni0410.smcp",
  "uni0411.smcp",
  "uni0412.smcp",
  "uni0413.smcp",
  "uni0414.smcp",
  "uni0415.smcp",
  "uni0416.smcp",
  "uni0417.smcp",
  "uni0418.smcp",
  "uni0419.smcp",
  "uni041A.smcp",
  "uni041B.smcp",
  "uni041C.smcp",
  "uni041D.smcp",
  "uni041E.smcp",
  "uni041F.smcp",
  "uni0420.smcp",
  "uni0421.smcp",
  "uni0422.smcp",
  "uni0423.smcp",
  "uni0424.smcp",
  "uni0425.smcp",
  "uni0426.smcp",
  "uni0427.smcp",
  "uni0428.smcp",
  "uni0429.smcp",
  "uni042A.smcp",
  "uni042B.smcp",
  "uni042C.smcp",
  "uni042D.smcp",
  "uni042E.smcp",
  "uni042F.smcp",
  "uni0490.smcp",
  "uni0492.smcp",
  "uni0496.smcp",
  "uni0498.smcp",
  "uni049A.smcp",
  "uni049C.smcp",
  "uni04A0.smcp",
  "uni04A2.smcp",
  "uni04A8.smcp",
  "uni04AA.smcp",
  "uni04AE.smcp",
  "uni04B0.smcp",
  "uni04B2.smcp",
  "uni04B4.smcp",
  "uni04B8.smcp",
  "uni04BA.smcp",
  "uni04BC.smcp",
  "uni04BE.smcp",
  "uni04D8.smcp",
  "uni04E0.smcp",
  "uni04E2.smcp",
  "uni04E8.smcp",
  "uni04EE.smcp",
  "uni20B4.smcp",
  "uni20B8.smcp",
  "uni20BD.smcp",
  "uni2116.smcp",
  "yen.smcp"
]


SC_SET2 = [
  "I.smcp",
  "Sigma.smcp",
  "Mu.smcp",
  "uni0410.smcp",
  "uni0411.smcp",
  "uni0412.smcp",
  "uni0413.smcp",
  "uni0414.smcp",
  "uni0415.smcp",
  "uni0416.smcp",
  "uni0417.smcp",
  "uni0418.smcp",
  "uni0419.smcp",
  "uni041A.smcp",
  "uni041B.smcp",
  "uni041C.smcp",
  "uni041D.smcp",
  "uni041E.smcp",
  "uni041F.smcp",
  "uni0420.smcp",
  "uni0421.smcp",
  "uni0422.smcp",
  "uni0423.smcp",
  "uni0424.smcp",
  "uni0425.smcp",
  "uni0426.smcp",
  "uni0427.smcp",
  "uni0428.smcp",
  "uni0429.smcp",
  "uni042A.smcp",
  "uni042B.smcp",
  "uni042C.smcp",
  "uni042D.smcp",
  "uni042E.smcp",
  "uni042F.smcp",
  "uni0401.smcp",
  "uni0402.smcp",
  "uni0403.smcp",
  "uni0404.smcp",
  "uni0405.smcp",
  "uni0406.smcp",
  "uni0407.smcp",
  "uni0408.smcp",
  "uni0409.smcp",
  "uni040A.smcp",
  "uni040B.smcp",
  "uni040C.smcp",
  "uni040E.smcp",
  "uni040F.smcp",
  "uni0490.smcp",
  "uni0492.smcp",
  "uni0496.smcp",
  "uni0498.smcp",
  "uni049A.smcp",
  "uni049C.smcp",
  "uni04A0.smcp",
  "uni04A2.smcp",
  "uni04A8.smcp",
  "uni04AA.smcp",
  "uni04AE.smcp",
  "uni04B0.smcp",
  "uni04B2.smcp",
  "uni04B4.smcp",
  "uni04B8.smcp",
  "uni04BA.smcp",
  "uni04BC.smcp",
  "uni04BE.smcp",
  "uni04D8.smcp",
  "uni04E0.smcp",
  "uni04E2.smcp",
  "uni04E8.smcp",
  "uni04EE.smcp"
]


STRIP_NAME_SET = set(SC_ROMAN).union(SC_SET1).union(SC_SET2)

STRIP_SUFFIXES = (
  '.smcp',
  '.unic',
  '.alt',
  '.alt2',
  '.ss06',
  '.ss07',
  '.onum',
  '.pnum',
  '.tnum'
)

def hasStripSuffix(g):
  name = g.name
  for suffix in STRIP_SUFFIXES:
    if str.endswith(name, suffix):
      return True
  return False

if __name__ == "__main__":
  font = CurrentFont()
  if font is not None:
    for g in font:
      if g.name in STRIP_NAME_SET or hasStripSuffix(g):
        
        if g.unicode is not None:
          # glyph maps to a codepoint -- keep it
          continue

        print 'Removing "%s"' % g.name

        font.removeGlyph(g.name)
    font.update()
  else:
    print "No fonts open"

  print "Done"
