/*
 * ProgressStatusDialog.java
 *
 * Created on May 4, 2011, 6:26:10 PM
 */
package com.epam.indigo.controls;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;

public class ProgressStatusDialog extends javax.swing.JDialog
{
   private Announcer<ActionListener> cancel_listeners = Announcer.to(ActionListener.class);
   private boolean need_to_cancel = false;
   
   /** Creates new form ProgressStatusDialog */
   public ProgressStatusDialog (java.awt.Frame parent, boolean modal)
   {
      super(parent, modal);
      initComponents();
      setLocationRelativeTo(parent);
      progress_bar.setMaximum(100);
   }

   public boolean neenToCancel ()
   {
      return need_to_cancel;
   }

   public void setProgress (int percent)
   {
      progress_bar.setValue(percent);
   }

   public void setStepName (String step_name)
   {
      progress_bar.setString(step_name);
      progress_bar.setStringPainted(true);
   }
   
   public void cancel ()
   {
      need_to_cancel = true;
      cancel_button.setEnabled(false);
      setStepName("Cancelling...");
      cancel_listeners.announce().actionPerformed(new ActionEvent(this, 0, ""));
   }
   
   /* Wrappers for cancel event listeners listeners */
   public void addCancelListener (ActionListener listener)
   {
      cancel_listeners.addListener(listener);
   }

   public void removeCancelListener (ActionListener listener)
   {
      cancel_listeners.removeListener(listener);
   }
   
   public <T, V> void executeSwingWorker (final SwingWorker<T, V> worker)
   {
      need_to_cancel = false;
      cancel_button.setEnabled(true);
      setStepName("");
      setProgress(0);
      
      worker.addPropertyChangeListener(new PropertyChangeListener()
      {
         @Override
         public void propertyChange (PropertyChangeEvent evt)
         {
            int progress = worker.getProgress();
            setProgress(progress);

            if (worker.isCancelled() || worker.isDone())
               setVisible(false);
         }
      });
    
      addCancelListener(new ActionListener()
      {
         public void actionPerformed (ActionEvent e)
         {
            worker.cancel(false);
         }
      });
      
      worker.execute();
            
      if (!neenToCancel())
         setVisible(true);
   }
   
   /** This method is called from within the constructor to
    * initialize the form.
    * WARNING: Do NOT modify this code. The content of this method is
    * always regenerated by the Form Editor.
    */
   @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        cancel_button = new javax.swing.JButton();
        progress_bar = new javax.swing.JProgressBar();

        setDefaultCloseOperation(javax.swing.WindowConstants.DO_NOTHING_ON_CLOSE);
        setModal(true);
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        cancel_button.setText("Cancel");
        cancel_button.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancel_buttonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(progress_bar, javax.swing.GroupLayout.DEFAULT_SIZE, 305, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(cancel_button)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                    .addComponent(progress_bar, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cancel_button, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

   private void cancel_buttonActionPerformed (java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancel_buttonActionPerformed
   {//GEN-HEADEREND:event_cancel_buttonActionPerformed
      cancel();
   }//GEN-LAST:event_cancel_buttonActionPerformed

   private void formWindowClosing (java.awt.event.WindowEvent evt)//GEN-FIRST:event_formWindowClosing
   {//GEN-HEADEREND:event_formWindowClosing
      cancel();
   }//GEN-LAST:event_formWindowClosing

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancel_button;
    private javax.swing.JProgressBar progress_bar;
    // End of variables declaration//GEN-END:variables
}
