/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause)
 *
 * Copyright (C) 2022 Renesas Electronics Corp.
 */
#ifndef __DT_BINDINGS_CLOCK_R9A07G043_CPG_H__
#define __DT_BINDINGS_CLOCK_R9A07G043_CPG_H__

#include <dt-bindings/clock/renesas-cpg-mssr.h>

/* R9A07G043 CPG Core Clocks */
#define R9A07G043_CLK_I			0
#define R9A07G043_CLK_I2		1
#define R9A07G043_CLK_S0		2
#define R9A07G043_CLK_SPI0		3
#define R9A07G043_CLK_SPI1		4
#define R9A07G043_CLK_SD0		5
#define R9A07G043_CLK_SD1		6
#define R9A07G043_CLK_M0		7
#define R9A07G043_CLK_M2		8
#define R9A07G043_CLK_M3		9
#define R9A07G043_CLK_HP		10
#define R9A07G043_CLK_TSU		11
#define R9A07G043_CLK_ZT		12
#define R9A07G043_CLK_P0		13
#define R9A07G043_CLK_P1		14
#define R9A07G043_CLK_P2		15
#define R9A07G043_CLK_AT		16
#define R9A07G043_OSCCLK		17
#define R9A07G043_CLK_P0_DIV2		18

/* R9A07G043 Module Clocks */
#define R9A07G043_CA55_SCLK		0	/* RZ/G2UL Only */
#define R9A07G043_CA55_PCLK		1	/* RZ/G2UL Only */
#define R9A07G043_CA55_ATCLK		2	/* RZ/G2UL Only */
#define R9A07G043_CA55_GICCLK		3	/* RZ/G2UL Only */
#define R9A07G043_CA55_PERICLK		4	/* RZ/G2UL Only */
#define R9A07G043_CA55_ACLK		5	/* RZ/G2UL Only */
#define R9A07G043_CA55_TSCLK		6	/* RZ/G2UL Only */
#define R9A07G043_GIC600_GICCLK		7	/* RZ/G2UL Only */
#define R9A07G043_IA55_CLK		8	/* RZ/G2UL Only */
#define R9A07G043_IA55_PCLK		9	/* RZ/G2UL Only */
#define R9A07G043_MHU_PCLK		10	/* RZ/G2UL Only */
#define R9A07G043_SYC_CNT_CLK		11
#define R9A07G043_DMAC_ACLK		12
#define R9A07G043_DMAC_PCLK		13
#define R9A07G043_OSTM0_PCLK		14
#define R9A07G043_OSTM1_PCLK		15
#define R9A07G043_OSTM2_PCLK		16
#define R9A07G043_MTU_X_MCK_MTU3	17
#define R9A07G043_POE3_CLKM_POE		18
#define R9A07G043_WDT0_PCLK		19
#define R9A07G043_WDT0_CLK		20
#define R9A07G043_WDT2_PCLK		21	/* RZ/G2UL Only */
#define R9A07G043_WDT2_CLK		22	/* RZ/G2UL Only */
#define R9A07G043_SPI_CLK2		23
#define R9A07G043_SPI_CLK		24
#define R9A07G043_SDHI0_IMCLK		25
#define R9A07G043_SDHI0_IMCLK2		26
#define R9A07G043_SDHI0_CLK_HS		27
#define R9A07G043_SDHI0_ACLK		28
#define R9A07G043_SDHI1_IMCLK		29
#define R9A07G043_SDHI1_IMCLK2		30
#define R9A07G043_SDHI1_CLK_HS		31
#define R9A07G043_SDHI1_ACLK		32
#define R9A07G043_ISU_ACLK		33	/* RZ/G2UL Only */
#define R9A07G043_ISU_PCLK		34	/* RZ/G2UL Only */
#define R9A07G043_CRU_SYSCLK		35	/* RZ/G2UL Only */
#define R9A07G043_CRU_VCLK		36	/* RZ/G2UL Only */
#define R9A07G043_CRU_PCLK		37	/* RZ/G2UL Only */
#define R9A07G043_CRU_ACLK		38	/* RZ/G2UL Only */
#define R9A07G043_LCDC_CLK_A		39	/* RZ/G2UL Only */
#define R9A07G043_LCDC_CLK_P		40	/* RZ/G2UL Only */
#define R9A07G043_LCDC_CLK_D		41	/* RZ/G2UL Only */
#define R9A07G043_SSI0_PCLK2		42
#define R9A07G043_SSI0_PCLK_SFR		43
#define R9A07G043_SSI1_PCLK2		44
#define R9A07G043_SSI1_PCLK_SFR		45
#define R9A07G043_SSI2_PCLK2		46
#define R9A07G043_SSI2_PCLK_SFR		47
#define R9A07G043_SSI3_PCLK2		48
#define R9A07G043_SSI3_PCLK_SFR		49
#define R9A07G043_SRC_CLKP		50	/* RZ/G2UL Only */
#define R9A07G043_USB_U2H0_HCLK		51
#define R9A07G043_USB_U2H1_HCLK		52
#define R9A07G043_USB_U2P_EXR_CPUCLK	53
#define R9A07G043_USB_PCLK		54
#define R9A07G043_ETH0_CLK_AXI		55
#define R9A07G043_ETH0_CLK_CHI		56
#define R9A07G043_ETH1_CLK_AXI		57
#define R9A07G043_ETH1_CLK_CHI		58
#define R9A07G043_I2C0_PCLK		59
#define R9A07G043_I2C1_PCLK		60
#define R9A07G043_I2C2_PCLK		61
#define R9A07G043_I2C3_PCLK		62
#define R9A07G043_SCIF0_CLK_PCK		63
#define R9A07G043_SCIF1_CLK_PCK		64
#define R9A07G043_SCIF2_CLK_PCK		65
#define R9A07G043_SCIF3_CLK_PCK		66
#define R9A07G043_SCIF4_CLK_PCK		67
#define R9A07G043_SCI0_CLKP		68
#define R9A07G043_SCI1_CLKP		69
#define R9A07G043_IRDA_CLKP		70
#define R9A07G043_RSPI0_CLKB		71
#define R9A07G043_RSPI1_CLKB		72
#define R9A07G043_RSPI2_CLKB		73
#define R9A07G043_CANFD_PCLK		74
#define R9A07G043_GPIO_HCLK		75
#define R9A07G043_ADC_ADCLK		76
#define R9A07G043_ADC_PCLK		77
#define R9A07G043_TSU_PCLK		78
#define R9A07G043_NCEPLDM_DM_CLK	79	/* RZ/Five Only */
#define R9A07G043_NCEPLDM_ACLK		80	/* RZ/Five Only */
#define R9A07G043_NCEPLDM_TCK		81	/* RZ/Five Only */
#define R9A07G043_NCEPLMT_ACLK		82	/* RZ/Five Only */
#define R9A07G043_NCEPLIC_ACLK		83	/* RZ/Five Only */
#define R9A07G043_AX45MP_CORE0_CLK	84	/* RZ/Five Only */
#define R9A07G043_AX45MP_ACLK		85	/* RZ/Five Only */
#define R9A07G043_IAX45_CLK		86	/* RZ/Five Only */
#define R9A07G043_IAX45_PCLK		87	/* RZ/Five Only */

/* R9A07G043 Resets */
#define R9A07G043_CA55_RST_1_0		0	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_1_1		1	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_3_0		2	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_3_1		3	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_4		4	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_5		5	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_6		6	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_7		7	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_8		8	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_9		9	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_10		10	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_11		11	/* RZ/G2UL Only */
#define R9A07G043_CA55_RST_12		12	/* RZ/G2UL Only */
#define R9A07G043_GIC600_GICRESET_N	13	/* RZ/G2UL Only */
#define R9A07G043_GIC600_DBG_GICRESET_N	14	/* RZ/G2UL Only */
#define R9A07G043_IA55_RESETN		15	/* RZ/G2UL Only */
#define R9A07G043_MHU_RESETN		16	/* RZ/G2UL Only */
#define R9A07G043_DMAC_ARESETN		17
#define R9A07G043_DMAC_RST_ASYNC	18
#define R9A07G043_SYC_RESETN		19
#define R9A07G043_OSTM0_PRESETZ		20
#define R9A07G043_OSTM1_PRESETZ		21
#define R9A07G043_OSTM2_PRESETZ		22
#define R9A07G043_MTU_X_PRESET_MTU3	23
#define R9A07G043_POE3_RST_M_REG	24
#define R9A07G043_WDT0_PRESETN		25
#define R9A07G043_WDT2_PRESETN		26	/* RZ/G2UL Only */
#define R9A07G043_SPI_RST		27
#define R9A07G043_SDHI0_IXRST		28
#define R9A07G043_SDHI1_IXRST		29
#define R9A07G043_ISU_ARESETN		30	/* RZ/G2UL Only */
#define R9A07G043_ISU_PRESETN		31	/* RZ/G2UL Only */
#define R9A07G043_CRU_CMN_RSTB		32	/* RZ/G2UL Only */
#define R9A07G043_CRU_PRESETN		33	/* RZ/G2UL Only */
#define R9A07G043_CRU_ARESETN		34	/* RZ/G2UL Only */
#define R9A07G043_LCDC_RESET_N		35	/* RZ/G2UL Only */
#define R9A07G043_SSI0_RST_M2_REG	36
#define R9A07G043_SSI1_RST_M2_REG	37
#define R9A07G043_SSI2_RST_M2_REG	38
#define R9A07G043_SSI3_RST_M2_REG	39
#define R9A07G043_SRC_RST		40	/* RZ/G2UL Only */
#define R9A07G043_USB_U2H0_HRESETN	41
#define R9A07G043_USB_U2H1_HRESETN	42
#define R9A07G043_USB_U2P_EXL_SYSRST	43
#define R9A07G043_USB_PRESETN		44
#define R9A07G043_ETH0_RST_HW_N		45
#define R9A07G043_ETH1_RST_HW_N		46
#define R9A07G043_I2C0_MRST		47
#define R9A07G043_I2C1_MRST		48
#define R9A07G043_I2C2_MRST		49
#define R9A07G043_I2C3_MRST		50
#define R9A07G043_SCIF0_RST_SYSTEM_N	51
#define R9A07G043_SCIF1_RST_SYSTEM_N	52
#define R9A07G043_SCIF2_RST_SYSTEM_N	53
#define R9A07G043_SCIF3_RST_SYSTEM_N	54
#define R9A07G043_SCIF4_RST_SYSTEM_N	55
#define R9A07G043_SCI0_RST		56
#define R9A07G043_SCI1_RST		57
#define R9A07G043_IRDA_RST		58
#define R9A07G043_RSPI0_RST		59
#define R9A07G043_RSPI1_RST		60
#define R9A07G043_RSPI2_RST		61
#define R9A07G043_CANFD_RSTP_N		62
#define R9A07G043_CANFD_RSTC_N		63
#define R9A07G043_GPIO_RSTN		64
#define R9A07G043_GPIO_PORT_RESETN	65
#define R9A07G043_GPIO_SPARE_RESETN	66
#define R9A07G043_ADC_PRESETN		67
#define R9A07G043_ADC_ADRST_N		68
#define R9A07G043_TSU_PRESETN		69
#define R9A07G043_NCEPLDM_DTM_PWR_RST_N	70	/* RZ/Five Only */
#define R9A07G043_NCEPLDM_ARESETN	71	/* RZ/Five Only */
#define R9A07G043_NCEPLMT_POR_RSTN	72	/* RZ/Five Only */
#define R9A07G043_NCEPLMT_ARESETN	73	/* RZ/Five Only */
#define R9A07G043_NCEPLIC_ARESETN	74	/* RZ/Five Only */
#define R9A07G043_AX45MP_ARESETNM	75	/* RZ/Five Only */
#define R9A07G043_AX45MP_ARESETNS	76	/* RZ/Five Only */
#define R9A07G043_AX45MP_L2_RESETN	77	/* RZ/Five Only */
#define R9A07G043_AX45MP_CORE0_RESETN	78	/* RZ/Five Only */
#define R9A07G043_IAX45_RESETN		79	/* RZ/Five Only */


#endif /* __DT_BINDINGS_CLOCK_R9A07G043_CPG_H__ */
