// RUN: llvm-mc -triple x86_64-unknown-unknown --show-encoding %s | FileCheck %s

// CHECK: vfrczpd 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x81,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096, %xmm15

// CHECK: vfrczpd 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096, %xmm6

// CHECK: vfrczpd 485498096, %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096, %ymm7

// CHECK: vfrczpd 485498096, %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x81,0x0c,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczpd 485498096, %ymm9

// CHECK: vfrczpd 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x81,0x7c,0x82,0x40]
vfrczpd 64(%rdx,%rax,4), %xmm15

// CHECK: vfrczpd -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x81,0x7c,0x82,0xc0]
vfrczpd -64(%rdx,%rax,4), %xmm15

// CHECK: vfrczpd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x74,0x82,0x40]
vfrczpd 64(%rdx,%rax,4), %xmm6

// CHECK: vfrczpd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x74,0x82,0xc0]
vfrczpd -64(%rdx,%rax,4), %xmm6

// CHECK: vfrczpd 64(%rdx,%rax,4), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x7c,0x82,0x40]
vfrczpd 64(%rdx,%rax,4), %ymm7

// CHECK: vfrczpd -64(%rdx,%rax,4), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x7c,0x82,0xc0]
vfrczpd -64(%rdx,%rax,4), %ymm7

// CHECK: vfrczpd 64(%rdx,%rax,4), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x81,0x4c,0x82,0x40]
vfrczpd 64(%rdx,%rax,4), %ymm9

// CHECK: vfrczpd -64(%rdx,%rax,4), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x81,0x4c,0x82,0xc0]
vfrczpd -64(%rdx,%rax,4), %ymm9

// CHECK: vfrczpd 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x81,0x7c,0x02,0x40]
vfrczpd 64(%rdx,%rax), %xmm15

// CHECK: vfrczpd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x74,0x02,0x40]
vfrczpd 64(%rdx,%rax), %xmm6

// CHECK: vfrczpd 64(%rdx,%rax), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x7c,0x02,0x40]
vfrczpd 64(%rdx,%rax), %ymm7

// CHECK: vfrczpd 64(%rdx,%rax), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x81,0x4c,0x02,0x40]
vfrczpd 64(%rdx,%rax), %ymm9

// CHECK: vfrczpd 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x81,0x7a,0x40]
vfrczpd 64(%rdx), %xmm15

// CHECK: vfrczpd 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x72,0x40]
vfrczpd 64(%rdx), %xmm6

// CHECK: vfrczpd 64(%rdx), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x7a,0x40]
vfrczpd 64(%rdx), %ymm7

// CHECK: vfrczpd 64(%rdx), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x81,0x4a,0x40]
vfrczpd 64(%rdx), %ymm9

// CHECK: vfrczpd (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x81,0x3a]
vfrczpd (%rdx), %xmm15

// CHECK: vfrczpd (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0x32]
vfrczpd (%rdx), %xmm6

// CHECK: vfrczpd (%rdx), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0x3a]
vfrczpd (%rdx), %ymm7

// CHECK: vfrczpd (%rdx), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x81,0x0a]
vfrczpd (%rdx), %ymm9

// CHECK: vfrczpd %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0x81,0xff]
vfrczpd %xmm15, %xmm15

// CHECK: vfrczpd %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x81,0xf6]
vfrczpd %xmm6, %xmm6

// CHECK: vfrczpd %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x81,0xff]
vfrczpd %ymm7, %ymm7

// CHECK: vfrczpd %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x49,0x7c,0x81,0xc9]
vfrczpd %ymm9, %ymm9

// CHECK: vfrczps 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x80,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096, %xmm15

// CHECK: vfrczps 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096, %xmm6

// CHECK: vfrczps 485498096, %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096, %ymm7

// CHECK: vfrczps 485498096, %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x80,0x0c,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczps 485498096, %ymm9

// CHECK: vfrczps 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x80,0x7c,0x82,0x40]
vfrczps 64(%rdx,%rax,4), %xmm15

// CHECK: vfrczps -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x80,0x7c,0x82,0xc0]
vfrczps -64(%rdx,%rax,4), %xmm15

// CHECK: vfrczps 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x74,0x82,0x40]
vfrczps 64(%rdx,%rax,4), %xmm6

// CHECK: vfrczps -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x74,0x82,0xc0]
vfrczps -64(%rdx,%rax,4), %xmm6

// CHECK: vfrczps 64(%rdx,%rax,4), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x7c,0x82,0x40]
vfrczps 64(%rdx,%rax,4), %ymm7

// CHECK: vfrczps -64(%rdx,%rax,4), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x7c,0x82,0xc0]
vfrczps -64(%rdx,%rax,4), %ymm7

// CHECK: vfrczps 64(%rdx,%rax,4), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x80,0x4c,0x82,0x40]
vfrczps 64(%rdx,%rax,4), %ymm9

// CHECK: vfrczps -64(%rdx,%rax,4), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x80,0x4c,0x82,0xc0]
vfrczps -64(%rdx,%rax,4), %ymm9

// CHECK: vfrczps 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x80,0x7c,0x02,0x40]
vfrczps 64(%rdx,%rax), %xmm15

// CHECK: vfrczps 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x74,0x02,0x40]
vfrczps 64(%rdx,%rax), %xmm6

// CHECK: vfrczps 64(%rdx,%rax), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x7c,0x02,0x40]
vfrczps 64(%rdx,%rax), %ymm7

// CHECK: vfrczps 64(%rdx,%rax), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x80,0x4c,0x02,0x40]
vfrczps 64(%rdx,%rax), %ymm9

// CHECK: vfrczps 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x80,0x7a,0x40]
vfrczps 64(%rdx), %xmm15

// CHECK: vfrczps 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x72,0x40]
vfrczps 64(%rdx), %xmm6

// CHECK: vfrczps 64(%rdx), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x7a,0x40]
vfrczps 64(%rdx), %ymm7

// CHECK: vfrczps 64(%rdx), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x80,0x4a,0x40]
vfrczps 64(%rdx), %ymm9

// CHECK: vfrczps (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x80,0x3a]
vfrczps (%rdx), %xmm15

// CHECK: vfrczps (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0x32]
vfrczps (%rdx), %xmm6

// CHECK: vfrczps (%rdx), %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0x3a]
vfrczps (%rdx), %ymm7

// CHECK: vfrczps (%rdx), %ymm9
// CHECK: encoding: [0x8f,0x69,0x7c,0x80,0x0a]
vfrczps (%rdx), %ymm9

// CHECK: vfrczps %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0x80,0xff]
vfrczps %xmm15, %xmm15

// CHECK: vfrczps %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x80,0xf6]
vfrczps %xmm6, %xmm6

// CHECK: vfrczps %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe9,0x7c,0x80,0xff]
vfrczps %ymm7, %ymm7

// CHECK: vfrczps %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x49,0x7c,0x80,0xc9]
vfrczps %ymm9, %ymm9

// CHECK: vfrczsd 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x83,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczsd 485498096, %xmm15

// CHECK: vfrczsd 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczsd 485498096, %xmm6

// CHECK: vfrczsd 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x83,0x7c,0x82,0x40]
vfrczsd 64(%rdx,%rax,4), %xmm15

// CHECK: vfrczsd -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x83,0x7c,0x82,0xc0]
vfrczsd -64(%rdx,%rax,4), %xmm15

// CHECK: vfrczsd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x74,0x82,0x40]
vfrczsd 64(%rdx,%rax,4), %xmm6

// CHECK: vfrczsd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x74,0x82,0xc0]
vfrczsd -64(%rdx,%rax,4), %xmm6

// CHECK: vfrczsd 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x83,0x7c,0x02,0x40]
vfrczsd 64(%rdx,%rax), %xmm15

// CHECK: vfrczsd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x74,0x02,0x40]
vfrczsd 64(%rdx,%rax), %xmm6

// CHECK: vfrczsd 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x83,0x7a,0x40]
vfrczsd 64(%rdx), %xmm15

// CHECK: vfrczsd 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x72,0x40]
vfrczsd 64(%rdx), %xmm6

// CHECK: vfrczsd (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x83,0x3a]
vfrczsd (%rdx), %xmm15

// CHECK: vfrczsd (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0x32]
vfrczsd (%rdx), %xmm6

// CHECK: vfrczsd %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0x83,0xff]
vfrczsd %xmm15, %xmm15

// CHECK: vfrczsd %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x83,0xf6]
vfrczsd %xmm6, %xmm6

// CHECK: vfrczss 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x82,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczss 485498096, %xmm15

// CHECK: vfrczss 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vfrczss 485498096, %xmm6

// CHECK: vfrczss 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x82,0x7c,0x82,0x40]
vfrczss 64(%rdx,%rax,4), %xmm15

// CHECK: vfrczss -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x82,0x7c,0x82,0xc0]
vfrczss -64(%rdx,%rax,4), %xmm15

// CHECK: vfrczss 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x74,0x82,0x40]
vfrczss 64(%rdx,%rax,4), %xmm6

// CHECK: vfrczss -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x74,0x82,0xc0]
vfrczss -64(%rdx,%rax,4), %xmm6

// CHECK: vfrczss 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x82,0x7c,0x02,0x40]
vfrczss 64(%rdx,%rax), %xmm15

// CHECK: vfrczss 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x74,0x02,0x40]
vfrczss 64(%rdx,%rax), %xmm6

// CHECK: vfrczss 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x82,0x7a,0x40]
vfrczss 64(%rdx), %xmm15

// CHECK: vfrczss 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x72,0x40]
vfrczss 64(%rdx), %xmm6

// CHECK: vfrczss (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0x82,0x3a]
vfrczss (%rdx), %xmm15

// CHECK: vfrczss (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0x32]
vfrczss (%rdx), %xmm6

// CHECK: vfrczss %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0x82,0xff]
vfrczss %xmm15, %xmm15

// CHECK: vfrczss %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0x82,0xf6]
vfrczss %xmm6, %xmm6

// CHECK: vpcmov 485498096, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa2,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpcmov 485498096, %xmm15, %xmm15, %xmm15

// CHECK: vpcmov 485498096, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa2,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpcmov 485498096, %xmm6, %xmm6, %xmm6

// CHECK: vpcmov 485498096, %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0xc4,0xa2,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x70]
vpcmov 485498096, %ymm7, %ymm7, %ymm7

// CHECK: vpcmov 485498096, %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0xb4,0xa2,0x0c,0x25,0xf0,0x1c,0xf0,0x1c,0x90]
vpcmov 485498096, %ymm9, %ymm9, %ymm9

// CHECK: vpcmov 64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa2,0x7c,0x82,0x40,0xf0]
vpcmov 64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15

// CHECK: vpcmov -64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa2,0x7c,0x82,0xc0,0xf0]
vpcmov -64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15

// CHECK: vpcmov 64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa2,0x74,0x82,0x40,0x60]
vpcmov 64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6

// CHECK: vpcmov -64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa2,0x74,0x82,0xc0,0x60]
vpcmov -64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6

// CHECK: vpcmov 64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0xc4,0xa2,0x7c,0x82,0x40,0x70]
vpcmov 64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7

// CHECK: vpcmov -64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0xc4,0xa2,0x7c,0x82,0xc0,0x70]
vpcmov -64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7

// CHECK: vpcmov 64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0xb4,0xa2,0x4c,0x82,0x40,0x90]
vpcmov 64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9

// CHECK: vpcmov -64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0xb4,0xa2,0x4c,0x82,0xc0,0x90]
vpcmov -64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9

// CHECK: vpcmov 64(%rdx,%rax), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa2,0x7c,0x02,0x40,0xf0]
vpcmov 64(%rdx,%rax), %xmm15, %xmm15, %xmm15

// CHECK: vpcmov 64(%rdx,%rax), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa2,0x74,0x02,0x40,0x60]
vpcmov 64(%rdx,%rax), %xmm6, %xmm6, %xmm6

// CHECK: vpcmov 64(%rdx,%rax), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0xc4,0xa2,0x7c,0x02,0x40,0x70]
vpcmov 64(%rdx,%rax), %ymm7, %ymm7, %ymm7

// CHECK: vpcmov 64(%rdx,%rax), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0xb4,0xa2,0x4c,0x02,0x40,0x90]
vpcmov 64(%rdx,%rax), %ymm9, %ymm9, %ymm9

// CHECK: vpcmov 64(%rdx), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa2,0x7a,0x40,0xf0]
vpcmov 64(%rdx), %xmm15, %xmm15, %xmm15

// CHECK: vpcmov 64(%rdx), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa2,0x72,0x40,0x60]
vpcmov 64(%rdx), %xmm6, %xmm6, %xmm6

// CHECK: vpcmov 64(%rdx), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0xc4,0xa2,0x7a,0x40,0x70]
vpcmov 64(%rdx), %ymm7, %ymm7, %ymm7

// CHECK: vpcmov 64(%rdx), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0xb4,0xa2,0x4a,0x40,0x90]
vpcmov 64(%rdx), %ymm9, %ymm9, %ymm9

// CHECK: vpcmov (%rdx), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa2,0x3a,0xf0]
vpcmov (%rdx), %xmm15, %xmm15, %xmm15

// CHECK: vpcmov (%rdx), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa2,0x32,0x60]
vpcmov (%rdx), %xmm6, %xmm6, %xmm6

// CHECK: vpcmov (%rdx), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0xc4,0xa2,0x3a,0x70]
vpcmov (%rdx), %ymm7, %ymm7, %ymm7

// CHECK: vpcmov (%rdx), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0xb4,0xa2,0x0a,0x90]
vpcmov (%rdx), %ymm9, %ymm9, %ymm9

// CHECK: vpcmov %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa2,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpcmov %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpcmov %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa2,0x7c,0x82,0x40,0xf0]
vpcmov %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcmov %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa2,0x7c,0x82,0xc0,0xf0]
vpcmov %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcmov %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa2,0x7c,0x02,0x40,0xf0]
vpcmov %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcmov %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa2,0x7a,0x40,0xf0]
vpcmov %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpcmov %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa2,0x3a,0xf0]
vpcmov %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpcmov %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xa2,0xff,0xf0]
vpcmov %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpcmov %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa2,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpcmov %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpcmov %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa2,0x74,0x82,0x40,0x60]
vpcmov %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcmov %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa2,0x74,0x82,0xc0,0x60]
vpcmov %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcmov %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa2,0x74,0x02,0x40,0x60]
vpcmov %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcmov %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa2,0x72,0x40,0x60]
vpcmov %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpcmov %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa2,0x32,0x60]
vpcmov %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpcmov %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa2,0xf6,0x60]
vpcmov %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpcmov %ymm7, 485498096, %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0x44,0xa2,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x70]
vpcmov %ymm7, 485498096, %ymm7, %ymm7

// CHECK: vpcmov %ymm7, 64(%rdx,%rax,4), %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0x44,0xa2,0x7c,0x82,0x40,0x70]
vpcmov %ymm7, 64(%rdx,%rax,4), %ymm7, %ymm7

// CHECK: vpcmov %ymm7, -64(%rdx,%rax,4), %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0x44,0xa2,0x7c,0x82,0xc0,0x70]
vpcmov %ymm7, -64(%rdx,%rax,4), %ymm7, %ymm7

// CHECK: vpcmov %ymm7, 64(%rdx,%rax), %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0x44,0xa2,0x7c,0x02,0x40,0x70]
vpcmov %ymm7, 64(%rdx,%rax), %ymm7, %ymm7

// CHECK: vpcmov %ymm7, 64(%rdx), %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0x44,0xa2,0x7a,0x40,0x70]
vpcmov %ymm7, 64(%rdx), %ymm7, %ymm7

// CHECK: vpcmov %ymm7, (%rdx), %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0x44,0xa2,0x3a,0x70]
vpcmov %ymm7, (%rdx), %ymm7, %ymm7

// CHECK: vpcmov %ymm7, %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0x8f,0xe8,0x44,0xa2,0xff,0x70]
vpcmov %ymm7, %ymm7, %ymm7, %ymm7

// CHECK: vpcmov %ymm9, 485498096, %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0x34,0xa2,0x0c,0x25,0xf0,0x1c,0xf0,0x1c,0x90]
vpcmov %ymm9, 485498096, %ymm9, %ymm9

// CHECK: vpcmov %ymm9, 64(%rdx,%rax,4), %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0x34,0xa2,0x4c,0x82,0x40,0x90]
vpcmov %ymm9, 64(%rdx,%rax,4), %ymm9, %ymm9

// CHECK: vpcmov %ymm9, -64(%rdx,%rax,4), %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0x34,0xa2,0x4c,0x82,0xc0,0x90]
vpcmov %ymm9, -64(%rdx,%rax,4), %ymm9, %ymm9

// CHECK: vpcmov %ymm9, 64(%rdx,%rax), %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0x34,0xa2,0x4c,0x02,0x40,0x90]
vpcmov %ymm9, 64(%rdx,%rax), %ymm9, %ymm9

// CHECK: vpcmov %ymm9, 64(%rdx), %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0x34,0xa2,0x4a,0x40,0x90]
vpcmov %ymm9, 64(%rdx), %ymm9, %ymm9

// CHECK: vpcmov %ymm9, (%rdx), %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x68,0x34,0xa2,0x0a,0x90]
vpcmov %ymm9, (%rdx), %ymm9, %ymm9

// CHECK: vpcmov %ymm9, %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0x8f,0x48,0x34,0xa2,0xc9,0x90]
vpcmov %ymm9, %ymm9, %ymm9, %ymm9

// CHECK: vpcomltb 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcc,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltb 485498096, %xmm15, %xmm15

// CHECK: vpcomltb 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcc,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltb 485498096, %xmm6, %xmm6

// CHECK: vpcomltb 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcc,0x7c,0x82,0x40,0x00]
vpcomltb 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltb -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcc,0x7c,0x82,0xc0,0x00]
vpcomltb -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltb 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcc,0x74,0x82,0x40,0x00]
vpcomltb 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltb -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcc,0x74,0x82,0xc0,0x00]
vpcomltb -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltb 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcc,0x7c,0x02,0x40,0x00]
vpcomltb 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcomltb 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcc,0x74,0x02,0x40,0x00]
vpcomltb 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcomltb 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcc,0x7a,0x40,0x00]
vpcomltb 64(%rdx), %xmm15, %xmm15

// CHECK: vpcomltb 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcc,0x72,0x40,0x00]
vpcomltb 64(%rdx), %xmm6, %xmm6

// CHECK: vpcomltb (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcc,0x3a,0x00]
vpcomltb (%rdx), %xmm15, %xmm15

// CHECK: vpcomltb (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcc,0x32,0x00]
vpcomltb (%rdx), %xmm6, %xmm6

// CHECK: vpcomltb %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xcc,0xff,0x00]
vpcomltb %xmm15, %xmm15, %xmm15

// CHECK: vpcomltb %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcc,0xf6,0x00]
vpcomltb %xmm6, %xmm6, %xmm6

// CHECK: vpcomltd 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xce,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltd 485498096, %xmm15, %xmm15

// CHECK: vpcomltd 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xce,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltd 485498096, %xmm6, %xmm6

// CHECK: vpcomltd 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xce,0x7c,0x82,0x40,0x00]
vpcomltd 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltd -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xce,0x7c,0x82,0xc0,0x00]
vpcomltd -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltd 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xce,0x74,0x82,0x40,0x00]
vpcomltd 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltd -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xce,0x74,0x82,0xc0,0x00]
vpcomltd -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltd 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xce,0x7c,0x02,0x40,0x00]
vpcomltd 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcomltd 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xce,0x74,0x02,0x40,0x00]
vpcomltd 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcomltd 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xce,0x7a,0x40,0x00]
vpcomltd 64(%rdx), %xmm15, %xmm15

// CHECK: vpcomltd 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xce,0x72,0x40,0x00]
vpcomltd 64(%rdx), %xmm6, %xmm6

// CHECK: vpcomltd (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xce,0x3a,0x00]
vpcomltd (%rdx), %xmm15, %xmm15

// CHECK: vpcomltd (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xce,0x32,0x00]
vpcomltd (%rdx), %xmm6, %xmm6

// CHECK: vpcomltd %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xce,0xff,0x00]
vpcomltd %xmm15, %xmm15, %xmm15

// CHECK: vpcomltd %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xce,0xf6,0x00]
vpcomltd %xmm6, %xmm6, %xmm6

// CHECK: vpcomltq 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcf,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltq 485498096, %xmm15, %xmm15

// CHECK: vpcomltq 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcf,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltq 485498096, %xmm6, %xmm6

// CHECK: vpcomltq 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcf,0x7c,0x82,0x40,0x00]
vpcomltq 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltq -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcf,0x7c,0x82,0xc0,0x00]
vpcomltq -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltq 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcf,0x74,0x82,0x40,0x00]
vpcomltq 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltq -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcf,0x74,0x82,0xc0,0x00]
vpcomltq -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltq 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcf,0x7c,0x02,0x40,0x00]
vpcomltq 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcomltq 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcf,0x74,0x02,0x40,0x00]
vpcomltq 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcomltq 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcf,0x7a,0x40,0x00]
vpcomltq 64(%rdx), %xmm15, %xmm15

// CHECK: vpcomltq 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcf,0x72,0x40,0x00]
vpcomltq 64(%rdx), %xmm6, %xmm6

// CHECK: vpcomltq (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcf,0x3a,0x00]
vpcomltq (%rdx), %xmm15, %xmm15

// CHECK: vpcomltq (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcf,0x32,0x00]
vpcomltq (%rdx), %xmm6, %xmm6

// CHECK: vpcomltq %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xcf,0xff,0x00]
vpcomltq %xmm15, %xmm15, %xmm15

// CHECK: vpcomltq %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcf,0xf6,0x00]
vpcomltq %xmm6, %xmm6, %xmm6

// CHECK: vpcomltub 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xec,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltub 485498096, %xmm15, %xmm15

// CHECK: vpcomltub 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xec,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltub 485498096, %xmm6, %xmm6

// CHECK: vpcomltub 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xec,0x7c,0x82,0x40,0x00]
vpcomltub 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltub -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xec,0x7c,0x82,0xc0,0x00]
vpcomltub -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltub 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xec,0x74,0x82,0x40,0x00]
vpcomltub 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltub -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xec,0x74,0x82,0xc0,0x00]
vpcomltub -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltub 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xec,0x7c,0x02,0x40,0x00]
vpcomltub 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcomltub 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xec,0x74,0x02,0x40,0x00]
vpcomltub 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcomltub 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xec,0x7a,0x40,0x00]
vpcomltub 64(%rdx), %xmm15, %xmm15

// CHECK: vpcomltub 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xec,0x72,0x40,0x00]
vpcomltub 64(%rdx), %xmm6, %xmm6

// CHECK: vpcomltub (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xec,0x3a,0x00]
vpcomltub (%rdx), %xmm15, %xmm15

// CHECK: vpcomltub (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xec,0x32,0x00]
vpcomltub (%rdx), %xmm6, %xmm6

// CHECK: vpcomltub %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xec,0xff,0x00]
vpcomltub %xmm15, %xmm15, %xmm15

// CHECK: vpcomltub %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xec,0xf6,0x00]
vpcomltub %xmm6, %xmm6, %xmm6

// CHECK: vpcomltud 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xee,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltud 485498096, %xmm15, %xmm15

// CHECK: vpcomltud 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xee,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltud 485498096, %xmm6, %xmm6

// CHECK: vpcomltud 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xee,0x7c,0x82,0x40,0x00]
vpcomltud 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltud -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xee,0x7c,0x82,0xc0,0x00]
vpcomltud -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltud 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xee,0x74,0x82,0x40,0x00]
vpcomltud 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltud -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xee,0x74,0x82,0xc0,0x00]
vpcomltud -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltud 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xee,0x7c,0x02,0x40,0x00]
vpcomltud 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcomltud 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xee,0x74,0x02,0x40,0x00]
vpcomltud 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcomltud 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xee,0x7a,0x40,0x00]
vpcomltud 64(%rdx), %xmm15, %xmm15

// CHECK: vpcomltud 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xee,0x72,0x40,0x00]
vpcomltud 64(%rdx), %xmm6, %xmm6

// CHECK: vpcomltud (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xee,0x3a,0x00]
vpcomltud (%rdx), %xmm15, %xmm15

// CHECK: vpcomltud (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xee,0x32,0x00]
vpcomltud (%rdx), %xmm6, %xmm6

// CHECK: vpcomltud %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xee,0xff,0x00]
vpcomltud %xmm15, %xmm15, %xmm15

// CHECK: vpcomltud %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xee,0xf6,0x00]
vpcomltud %xmm6, %xmm6, %xmm6

// CHECK: vpcomltuq 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xef,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuq 485498096, %xmm15, %xmm15

// CHECK: vpcomltuq 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xef,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuq 485498096, %xmm6, %xmm6

// CHECK: vpcomltuq 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xef,0x7c,0x82,0x40,0x00]
vpcomltuq 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltuq -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xef,0x7c,0x82,0xc0,0x00]
vpcomltuq -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltuq 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xef,0x74,0x82,0x40,0x00]
vpcomltuq 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltuq -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xef,0x74,0x82,0xc0,0x00]
vpcomltuq -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltuq 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xef,0x7c,0x02,0x40,0x00]
vpcomltuq 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcomltuq 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xef,0x74,0x02,0x40,0x00]
vpcomltuq 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcomltuq 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xef,0x7a,0x40,0x00]
vpcomltuq 64(%rdx), %xmm15, %xmm15

// CHECK: vpcomltuq 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xef,0x72,0x40,0x00]
vpcomltuq 64(%rdx), %xmm6, %xmm6

// CHECK: vpcomltuq (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xef,0x3a,0x00]
vpcomltuq (%rdx), %xmm15, %xmm15

// CHECK: vpcomltuq (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xef,0x32,0x00]
vpcomltuq (%rdx), %xmm6, %xmm6

// CHECK: vpcomltuq %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xef,0xff,0x00]
vpcomltuq %xmm15, %xmm15, %xmm15

// CHECK: vpcomltuq %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xef,0xf6,0x00]
vpcomltuq %xmm6, %xmm6, %xmm6

// CHECK: vpcomltuw 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xed,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuw 485498096, %xmm15, %xmm15

// CHECK: vpcomltuw 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xed,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltuw 485498096, %xmm6, %xmm6

// CHECK: vpcomltuw 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xed,0x7c,0x82,0x40,0x00]
vpcomltuw 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltuw -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xed,0x7c,0x82,0xc0,0x00]
vpcomltuw -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltuw 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xed,0x74,0x82,0x40,0x00]
vpcomltuw 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltuw -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xed,0x74,0x82,0xc0,0x00]
vpcomltuw -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltuw 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xed,0x7c,0x02,0x40,0x00]
vpcomltuw 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcomltuw 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xed,0x74,0x02,0x40,0x00]
vpcomltuw 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcomltuw 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xed,0x7a,0x40,0x00]
vpcomltuw 64(%rdx), %xmm15, %xmm15

// CHECK: vpcomltuw 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xed,0x72,0x40,0x00]
vpcomltuw 64(%rdx), %xmm6, %xmm6

// CHECK: vpcomltuw (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xed,0x3a,0x00]
vpcomltuw (%rdx), %xmm15, %xmm15

// CHECK: vpcomltuw (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xed,0x32,0x00]
vpcomltuw (%rdx), %xmm6, %xmm6

// CHECK: vpcomltuw %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xed,0xff,0x00]
vpcomltuw %xmm15, %xmm15, %xmm15

// CHECK: vpcomltuw %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xed,0xf6,0x00]
vpcomltuw %xmm6, %xmm6, %xmm6

// CHECK: vpcomltw 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcd,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltw 485498096, %xmm15, %xmm15

// CHECK: vpcomltw 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcd,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vpcomltw 485498096, %xmm6, %xmm6

// CHECK: vpcomltw 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcd,0x7c,0x82,0x40,0x00]
vpcomltw 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltw -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcd,0x7c,0x82,0xc0,0x00]
vpcomltw -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpcomltw 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcd,0x74,0x82,0x40,0x00]
vpcomltw 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltw -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcd,0x74,0x82,0xc0,0x00]
vpcomltw -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpcomltw 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcd,0x7c,0x02,0x40,0x00]
vpcomltw 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpcomltw 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcd,0x74,0x02,0x40,0x00]
vpcomltw 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpcomltw 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcd,0x7a,0x40,0x00]
vpcomltw 64(%rdx), %xmm15, %xmm15

// CHECK: vpcomltw 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcd,0x72,0x40,0x00]
vpcomltw 64(%rdx), %xmm6, %xmm6

// CHECK: vpcomltw (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xcd,0x3a,0x00]
vpcomltw (%rdx), %xmm15, %xmm15

// CHECK: vpcomltw (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcd,0x32,0x00]
vpcomltw (%rdx), %xmm6, %xmm6

// CHECK: vpcomltw %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xcd,0xff,0x00]
vpcomltw %xmm15, %xmm15, %xmm15

// CHECK: vpcomltw %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xcd,0xf6,0x00]
vpcomltw %xmm6, %xmm6, %xmm6

// CHECK: vpermil2pd $0, 485498096, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x49,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpermil2pd $0, 485498096, %xmm15, %xmm15, %xmm15

// CHECK: vpermil2pd $0, 485498096, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x49,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpermil2pd $0, 485498096, %xmm6, %xmm6, %xmm6

// CHECK: vpermil2pd $0, 485498096, %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x49,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x70]
vpermil2pd $0, 485498096, %ymm7, %ymm7, %ymm7

// CHECK: vpermil2pd $0, 485498096, %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x49,0x0c,0x25,0xf0,0x1c,0xf0,0x1c,0x90]
vpermil2pd $0, 485498096, %ymm9, %ymm9, %ymm9

// CHECK: vpermil2pd $0, 64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x49,0x7c,0x82,0x40,0xf0]
vpermil2pd $0, 64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2pd $0, -64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x49,0x7c,0x82,0xc0,0xf0]
vpermil2pd $0, -64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2pd $0, 64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x49,0x74,0x82,0x40,0x60]
vpermil2pd $0, 64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2pd $0, -64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x49,0x74,0x82,0xc0,0x60]
vpermil2pd $0, -64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2pd $0, 64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x49,0x7c,0x82,0x40,0x70]
vpermil2pd $0, 64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2pd $0, -64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x49,0x7c,0x82,0xc0,0x70]
vpermil2pd $0, -64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2pd $0, 64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x49,0x4c,0x82,0x40,0x90]
vpermil2pd $0, 64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2pd $0, -64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x49,0x4c,0x82,0xc0,0x90]
vpermil2pd $0, -64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2pd $0, 64(%rdx,%rax), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x49,0x7c,0x02,0x40,0xf0]
vpermil2pd $0, 64(%rdx,%rax), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2pd $0, 64(%rdx,%rax), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x49,0x74,0x02,0x40,0x60]
vpermil2pd $0, 64(%rdx,%rax), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2pd $0, 64(%rdx,%rax), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x49,0x7c,0x02,0x40,0x70]
vpermil2pd $0, 64(%rdx,%rax), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2pd $0, 64(%rdx,%rax), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x49,0x4c,0x02,0x40,0x90]
vpermil2pd $0, 64(%rdx,%rax), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2pd $0, 64(%rdx), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x49,0x7a,0x40,0xf0]
vpermil2pd $0, 64(%rdx), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2pd $0, 64(%rdx), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x49,0x72,0x40,0x60]
vpermil2pd $0, 64(%rdx), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2pd $0, 64(%rdx), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x49,0x7a,0x40,0x70]
vpermil2pd $0, 64(%rdx), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2pd $0, 64(%rdx), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x49,0x4a,0x40,0x90]
vpermil2pd $0, 64(%rdx), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2pd $0, (%rdx), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x49,0x3a,0xf0]
vpermil2pd $0, (%rdx), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2pd $0, (%rdx), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x49,0x32,0x60]
vpermil2pd $0, (%rdx), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2pd $0, (%rdx), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x49,0x3a,0x70]
vpermil2pd $0, (%rdx), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2pd $0, (%rdx), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x49,0x0a,0x90]
vpermil2pd $0, (%rdx), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2pd $0, %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x49,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpermil2pd $0, %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpermil2pd $0, %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x49,0x7c,0x82,0x40,0xf0]
vpermil2pd $0, %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpermil2pd $0, %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x49,0x7c,0x82,0xc0,0xf0]
vpermil2pd $0, %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpermil2pd $0, %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x49,0x7c,0x02,0x40,0xf0]
vpermil2pd $0, %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpermil2pd $0, %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x49,0x7a,0x40,0xf0]
vpermil2pd $0, %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpermil2pd $0, %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x49,0x3a,0xf0]
vpermil2pd $0, %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpermil2pd $0, %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x43,0x01,0x49,0xff,0xf0]
vpermil2pd $0, %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpermil2pd $0, %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x49,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpermil2pd $0, %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpermil2pd $0, %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x49,0x74,0x82,0x40,0x60]
vpermil2pd $0, %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpermil2pd $0, %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x49,0x74,0x82,0xc0,0x60]
vpermil2pd $0, %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpermil2pd $0, %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x49,0x74,0x02,0x40,0x60]
vpermil2pd $0, %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpermil2pd $0, %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x49,0x72,0x40,0x60]
vpermil2pd $0, %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpermil2pd $0, %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x49,0x32,0x60]
vpermil2pd $0, %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpermil2pd $0, %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x49,0xf6,0x60]
vpermil2pd $0, %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpermil2pd $0, %ymm7, 485498096, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x49,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x70]
vpermil2pd $0, %ymm7, 485498096, %ymm7, %ymm7

// CHECK: vpermil2pd $0, %ymm7, 64(%rdx,%rax,4), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x49,0x7c,0x82,0x40,0x70]
vpermil2pd $0, %ymm7, 64(%rdx,%rax,4), %ymm7, %ymm7

// CHECK: vpermil2pd $0, %ymm7, -64(%rdx,%rax,4), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x49,0x7c,0x82,0xc0,0x70]
vpermil2pd $0, %ymm7, -64(%rdx,%rax,4), %ymm7, %ymm7

// CHECK: vpermil2pd $0, %ymm7, 64(%rdx,%rax), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x49,0x7c,0x02,0x40,0x70]
vpermil2pd $0, %ymm7, 64(%rdx,%rax), %ymm7, %ymm7

// CHECK: vpermil2pd $0, %ymm7, 64(%rdx), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x49,0x7a,0x40,0x70]
vpermil2pd $0, %ymm7, 64(%rdx), %ymm7, %ymm7

// CHECK: vpermil2pd $0, %ymm7, (%rdx), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x49,0x3a,0x70]
vpermil2pd $0, %ymm7, (%rdx), %ymm7, %ymm7

// CHECK: vpermil2pd $0, %ymm7, %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x49,0xff,0x70]
vpermil2pd $0, %ymm7, %ymm7, %ymm7, %ymm7

// CHECK: vpermil2pd $0, %ymm9, 485498096, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x49,0x0c,0x25,0xf0,0x1c,0xf0,0x1c,0x90]
vpermil2pd $0, %ymm9, 485498096, %ymm9, %ymm9

// CHECK: vpermil2pd $0, %ymm9, 64(%rdx,%rax,4), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x49,0x4c,0x82,0x40,0x90]
vpermil2pd $0, %ymm9, 64(%rdx,%rax,4), %ymm9, %ymm9

// CHECK: vpermil2pd $0, %ymm9, -64(%rdx,%rax,4), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x49,0x4c,0x82,0xc0,0x90]
vpermil2pd $0, %ymm9, -64(%rdx,%rax,4), %ymm9, %ymm9

// CHECK: vpermil2pd $0, %ymm9, 64(%rdx,%rax), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x49,0x4c,0x02,0x40,0x90]
vpermil2pd $0, %ymm9, 64(%rdx,%rax), %ymm9, %ymm9

// CHECK: vpermil2pd $0, %ymm9, 64(%rdx), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x49,0x4a,0x40,0x90]
vpermil2pd $0, %ymm9, 64(%rdx), %ymm9, %ymm9

// CHECK: vpermil2pd $0, %ymm9, (%rdx), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x49,0x0a,0x90]
vpermil2pd $0, %ymm9, (%rdx), %ymm9, %ymm9

// CHECK: vpermil2pd $0, %ymm9, %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x43,0x35,0x49,0xc9,0x90]
vpermil2pd $0, %ymm9, %ymm9, %ymm9, %ymm9

// CHECK: vpermil2ps $0, 485498096, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x48,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpermil2ps $0, 485498096, %xmm15, %xmm15, %xmm15

// CHECK: vpermil2ps $0, 485498096, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x48,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpermil2ps $0, 485498096, %xmm6, %xmm6, %xmm6

// CHECK: vpermil2ps $0, 485498096, %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x48,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x70]
vpermil2ps $0, 485498096, %ymm7, %ymm7, %ymm7

// CHECK: vpermil2ps $0, 485498096, %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x48,0x0c,0x25,0xf0,0x1c,0xf0,0x1c,0x90]
vpermil2ps $0, 485498096, %ymm9, %ymm9, %ymm9

// CHECK: vpermil2ps $0, 64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x48,0x7c,0x82,0x40,0xf0]
vpermil2ps $0, 64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2ps $0, -64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x48,0x7c,0x82,0xc0,0xf0]
vpermil2ps $0, -64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2ps $0, 64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x48,0x74,0x82,0x40,0x60]
vpermil2ps $0, 64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2ps $0, -64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x48,0x74,0x82,0xc0,0x60]
vpermil2ps $0, -64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2ps $0, 64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x48,0x7c,0x82,0x40,0x70]
vpermil2ps $0, 64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2ps $0, -64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x48,0x7c,0x82,0xc0,0x70]
vpermil2ps $0, -64(%rdx,%rax,4), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2ps $0, 64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x48,0x4c,0x82,0x40,0x90]
vpermil2ps $0, 64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2ps $0, -64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x48,0x4c,0x82,0xc0,0x90]
vpermil2ps $0, -64(%rdx,%rax,4), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2ps $0, 64(%rdx,%rax), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x48,0x7c,0x02,0x40,0xf0]
vpermil2ps $0, 64(%rdx,%rax), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2ps $0, 64(%rdx,%rax), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x48,0x74,0x02,0x40,0x60]
vpermil2ps $0, 64(%rdx,%rax), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2ps $0, 64(%rdx,%rax), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x48,0x7c,0x02,0x40,0x70]
vpermil2ps $0, 64(%rdx,%rax), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2ps $0, 64(%rdx,%rax), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x48,0x4c,0x02,0x40,0x90]
vpermil2ps $0, 64(%rdx,%rax), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2ps $0, 64(%rdx), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x48,0x7a,0x40,0xf0]
vpermil2ps $0, 64(%rdx), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2ps $0, 64(%rdx), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x48,0x72,0x40,0x60]
vpermil2ps $0, 64(%rdx), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2ps $0, 64(%rdx), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x48,0x7a,0x40,0x70]
vpermil2ps $0, 64(%rdx), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2ps $0, 64(%rdx), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x48,0x4a,0x40,0x90]
vpermil2ps $0, 64(%rdx), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2ps $0, (%rdx), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x81,0x48,0x3a,0xf0]
vpermil2ps $0, (%rdx), %xmm15, %xmm15, %xmm15

// CHECK: vpermil2ps $0, (%rdx), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0xc9,0x48,0x32,0x60]
vpermil2ps $0, (%rdx), %xmm6, %xmm6, %xmm6

// CHECK: vpermil2ps $0, (%rdx), %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0xc5,0x48,0x3a,0x70]
vpermil2ps $0, (%rdx), %ymm7, %ymm7, %ymm7

// CHECK: vpermil2ps $0, (%rdx), %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0xb5,0x48,0x0a,0x90]
vpermil2ps $0, (%rdx), %ymm9, %ymm9, %ymm9

// CHECK: vpermil2ps $0, %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x48,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpermil2ps $0, %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpermil2ps $0, %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x48,0x7c,0x82,0x40,0xf0]
vpermil2ps $0, %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpermil2ps $0, %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x48,0x7c,0x82,0xc0,0xf0]
vpermil2ps $0, %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpermil2ps $0, %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x48,0x7c,0x02,0x40,0xf0]
vpermil2ps $0, %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpermil2ps $0, %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x48,0x7a,0x40,0xf0]
vpermil2ps $0, %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpermil2ps $0, %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x63,0x01,0x48,0x3a,0xf0]
vpermil2ps $0, %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpermil2ps $0, %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0xc4,0x43,0x01,0x48,0xff,0xf0]
vpermil2ps $0, %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpermil2ps $0, %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x48,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpermil2ps $0, %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpermil2ps $0, %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x48,0x74,0x82,0x40,0x60]
vpermil2ps $0, %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpermil2ps $0, %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x48,0x74,0x82,0xc0,0x60]
vpermil2ps $0, %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpermil2ps $0, %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x48,0x74,0x02,0x40,0x60]
vpermil2ps $0, %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpermil2ps $0, %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x48,0x72,0x40,0x60]
vpermil2ps $0, %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpermil2ps $0, %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x48,0x32,0x60]
vpermil2ps $0, %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpermil2ps $0, %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0xc4,0xe3,0x49,0x48,0xf6,0x60]
vpermil2ps $0, %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpermil2ps $0, %ymm7, 485498096, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x48,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x70]
vpermil2ps $0, %ymm7, 485498096, %ymm7, %ymm7

// CHECK: vpermil2ps $0, %ymm7, 64(%rdx,%rax,4), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x48,0x7c,0x82,0x40,0x70]
vpermil2ps $0, %ymm7, 64(%rdx,%rax,4), %ymm7, %ymm7

// CHECK: vpermil2ps $0, %ymm7, -64(%rdx,%rax,4), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x48,0x7c,0x82,0xc0,0x70]
vpermil2ps $0, %ymm7, -64(%rdx,%rax,4), %ymm7, %ymm7

// CHECK: vpermil2ps $0, %ymm7, 64(%rdx,%rax), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x48,0x7c,0x02,0x40,0x70]
vpermil2ps $0, %ymm7, 64(%rdx,%rax), %ymm7, %ymm7

// CHECK: vpermil2ps $0, %ymm7, 64(%rdx), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x48,0x7a,0x40,0x70]
vpermil2ps $0, %ymm7, 64(%rdx), %ymm7, %ymm7

// CHECK: vpermil2ps $0, %ymm7, (%rdx), %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x48,0x3a,0x70]
vpermil2ps $0, %ymm7, (%rdx), %ymm7, %ymm7

// CHECK: vpermil2ps $0, %ymm7, %ymm7, %ymm7, %ymm7
// CHECK: encoding: [0xc4,0xe3,0x45,0x48,0xff,0x70]
vpermil2ps $0, %ymm7, %ymm7, %ymm7, %ymm7

// CHECK: vpermil2ps $0, %ymm9, 485498096, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x48,0x0c,0x25,0xf0,0x1c,0xf0,0x1c,0x90]
vpermil2ps $0, %ymm9, 485498096, %ymm9, %ymm9

// CHECK: vpermil2ps $0, %ymm9, 64(%rdx,%rax,4), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x48,0x4c,0x82,0x40,0x90]
vpermil2ps $0, %ymm9, 64(%rdx,%rax,4), %ymm9, %ymm9

// CHECK: vpermil2ps $0, %ymm9, -64(%rdx,%rax,4), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x48,0x4c,0x82,0xc0,0x90]
vpermil2ps $0, %ymm9, -64(%rdx,%rax,4), %ymm9, %ymm9

// CHECK: vpermil2ps $0, %ymm9, 64(%rdx,%rax), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x48,0x4c,0x02,0x40,0x90]
vpermil2ps $0, %ymm9, 64(%rdx,%rax), %ymm9, %ymm9

// CHECK: vpermil2ps $0, %ymm9, 64(%rdx), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x48,0x4a,0x40,0x90]
vpermil2ps $0, %ymm9, 64(%rdx), %ymm9, %ymm9

// CHECK: vpermil2ps $0, %ymm9, (%rdx), %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x63,0x35,0x48,0x0a,0x90]
vpermil2ps $0, %ymm9, (%rdx), %ymm9, %ymm9

// CHECK: vpermil2ps $0, %ymm9, %ymm9, %ymm9, %ymm9
// CHECK: encoding: [0xc4,0x43,0x35,0x48,0xc9,0x90]
vpermil2ps $0, %ymm9, %ymm9, %ymm9, %ymm9

// CHECK: vphaddbd 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc2,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddbd 485498096, %xmm15

// CHECK: vphaddbd 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddbd 485498096, %xmm6

// CHECK: vphaddbd 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc2,0x7c,0x82,0x40]
vphaddbd 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddbd -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc2,0x7c,0x82,0xc0]
vphaddbd -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddbd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x74,0x82,0x40]
vphaddbd 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddbd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x74,0x82,0xc0]
vphaddbd -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddbd 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc2,0x7c,0x02,0x40]
vphaddbd 64(%rdx,%rax), %xmm15

// CHECK: vphaddbd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x74,0x02,0x40]
vphaddbd 64(%rdx,%rax), %xmm6

// CHECK: vphaddbd 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc2,0x7a,0x40]
vphaddbd 64(%rdx), %xmm15

// CHECK: vphaddbd 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x72,0x40]
vphaddbd 64(%rdx), %xmm6

// CHECK: vphaddbd (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc2,0x3a]
vphaddbd (%rdx), %xmm15

// CHECK: vphaddbd (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0x32]
vphaddbd (%rdx), %xmm6

// CHECK: vphaddbd %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xc2,0xff]
vphaddbd %xmm15, %xmm15

// CHECK: vphaddbd %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc2,0xf6]
vphaddbd %xmm6, %xmm6

// CHECK: vphaddbq 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc3,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddbq 485498096, %xmm15

// CHECK: vphaddbq 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddbq 485498096, %xmm6

// CHECK: vphaddbq 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc3,0x7c,0x82,0x40]
vphaddbq 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddbq -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc3,0x7c,0x82,0xc0]
vphaddbq -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddbq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x74,0x82,0x40]
vphaddbq 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddbq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x74,0x82,0xc0]
vphaddbq -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddbq 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc3,0x7c,0x02,0x40]
vphaddbq 64(%rdx,%rax), %xmm15

// CHECK: vphaddbq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x74,0x02,0x40]
vphaddbq 64(%rdx,%rax), %xmm6

// CHECK: vphaddbq 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc3,0x7a,0x40]
vphaddbq 64(%rdx), %xmm15

// CHECK: vphaddbq 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x72,0x40]
vphaddbq 64(%rdx), %xmm6

// CHECK: vphaddbq (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc3,0x3a]
vphaddbq (%rdx), %xmm15

// CHECK: vphaddbq (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0x32]
vphaddbq (%rdx), %xmm6

// CHECK: vphaddbq %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xc3,0xff]
vphaddbq %xmm15, %xmm15

// CHECK: vphaddbq %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc3,0xf6]
vphaddbq %xmm6, %xmm6

// CHECK: vphaddbw 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc1,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddbw 485498096, %xmm15

// CHECK: vphaddbw 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddbw 485498096, %xmm6

// CHECK: vphaddbw 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc1,0x7c,0x82,0x40]
vphaddbw 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddbw -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc1,0x7c,0x82,0xc0]
vphaddbw -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddbw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x74,0x82,0x40]
vphaddbw 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddbw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x74,0x82,0xc0]
vphaddbw -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddbw 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc1,0x7c,0x02,0x40]
vphaddbw 64(%rdx,%rax), %xmm15

// CHECK: vphaddbw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x74,0x02,0x40]
vphaddbw 64(%rdx,%rax), %xmm6

// CHECK: vphaddbw 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc1,0x7a,0x40]
vphaddbw 64(%rdx), %xmm15

// CHECK: vphaddbw 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x72,0x40]
vphaddbw 64(%rdx), %xmm6

// CHECK: vphaddbw (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc1,0x3a]
vphaddbw (%rdx), %xmm15

// CHECK: vphaddbw (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0x32]
vphaddbw (%rdx), %xmm6

// CHECK: vphaddbw %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xc1,0xff]
vphaddbw %xmm15, %xmm15

// CHECK: vphaddbw %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc1,0xf6]
vphaddbw %xmm6, %xmm6

// CHECK: vphadddq 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xcb,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphadddq 485498096, %xmm15

// CHECK: vphadddq 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphadddq 485498096, %xmm6

// CHECK: vphadddq 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xcb,0x7c,0x82,0x40]
vphadddq 64(%rdx,%rax,4), %xmm15

// CHECK: vphadddq -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xcb,0x7c,0x82,0xc0]
vphadddq -64(%rdx,%rax,4), %xmm15

// CHECK: vphadddq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x74,0x82,0x40]
vphadddq 64(%rdx,%rax,4), %xmm6

// CHECK: vphadddq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x74,0x82,0xc0]
vphadddq -64(%rdx,%rax,4), %xmm6

// CHECK: vphadddq 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xcb,0x7c,0x02,0x40]
vphadddq 64(%rdx,%rax), %xmm15

// CHECK: vphadddq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x74,0x02,0x40]
vphadddq 64(%rdx,%rax), %xmm6

// CHECK: vphadddq 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xcb,0x7a,0x40]
vphadddq 64(%rdx), %xmm15

// CHECK: vphadddq 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x72,0x40]
vphadddq 64(%rdx), %xmm6

// CHECK: vphadddq (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xcb,0x3a]
vphadddq (%rdx), %xmm15

// CHECK: vphadddq (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0x32]
vphadddq (%rdx), %xmm6

// CHECK: vphadddq %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xcb,0xff]
vphadddq %xmm15, %xmm15

// CHECK: vphadddq %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xcb,0xf6]
vphadddq %xmm6, %xmm6

// CHECK: vphaddubd 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd2,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddubd 485498096, %xmm15

// CHECK: vphaddubd 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddubd 485498096, %xmm6

// CHECK: vphaddubd 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd2,0x7c,0x82,0x40]
vphaddubd 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddubd -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd2,0x7c,0x82,0xc0]
vphaddubd -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddubd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x74,0x82,0x40]
vphaddubd 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddubd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x74,0x82,0xc0]
vphaddubd -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddubd 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd2,0x7c,0x02,0x40]
vphaddubd 64(%rdx,%rax), %xmm15

// CHECK: vphaddubd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x74,0x02,0x40]
vphaddubd 64(%rdx,%rax), %xmm6

// CHECK: vphaddubd 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd2,0x7a,0x40]
vphaddubd 64(%rdx), %xmm15

// CHECK: vphaddubd 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x72,0x40]
vphaddubd 64(%rdx), %xmm6

// CHECK: vphaddubd (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd2,0x3a]
vphaddubd (%rdx), %xmm15

// CHECK: vphaddubd (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0x32]
vphaddubd (%rdx), %xmm6

// CHECK: vphaddubd %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xd2,0xff]
vphaddubd %xmm15, %xmm15

// CHECK: vphaddubd %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd2,0xf6]
vphaddubd %xmm6, %xmm6

// CHECK: vphaddubq 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd3,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddubq 485498096, %xmm15

// CHECK: vphaddubq 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddubq 485498096, %xmm6

// CHECK: vphaddubq 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd3,0x7c,0x82,0x40]
vphaddubq 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddubq -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd3,0x7c,0x82,0xc0]
vphaddubq -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddubq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x74,0x82,0x40]
vphaddubq 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddubq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x74,0x82,0xc0]
vphaddubq -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddubq 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd3,0x7c,0x02,0x40]
vphaddubq 64(%rdx,%rax), %xmm15

// CHECK: vphaddubq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x74,0x02,0x40]
vphaddubq 64(%rdx,%rax), %xmm6

// CHECK: vphaddubq 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd3,0x7a,0x40]
vphaddubq 64(%rdx), %xmm15

// CHECK: vphaddubq 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x72,0x40]
vphaddubq 64(%rdx), %xmm6

// CHECK: vphaddubq (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd3,0x3a]
vphaddubq (%rdx), %xmm15

// CHECK: vphaddubq (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0x32]
vphaddubq (%rdx), %xmm6

// CHECK: vphaddubq %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xd3,0xff]
vphaddubq %xmm15, %xmm15

// CHECK: vphaddubq %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd3,0xf6]
vphaddubq %xmm6, %xmm6

// CHECK: vphaddubw 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd1,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddubw 485498096, %xmm15

// CHECK: vphaddubw 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddubw 485498096, %xmm6

// CHECK: vphaddubw 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd1,0x7c,0x82,0x40]
vphaddubw 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddubw -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd1,0x7c,0x82,0xc0]
vphaddubw -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddubw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x74,0x82,0x40]
vphaddubw 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddubw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x74,0x82,0xc0]
vphaddubw -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddubw 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd1,0x7c,0x02,0x40]
vphaddubw 64(%rdx,%rax), %xmm15

// CHECK: vphaddubw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x74,0x02,0x40]
vphaddubw 64(%rdx,%rax), %xmm6

// CHECK: vphaddubw 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd1,0x7a,0x40]
vphaddubw 64(%rdx), %xmm15

// CHECK: vphaddubw 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x72,0x40]
vphaddubw 64(%rdx), %xmm6

// CHECK: vphaddubw (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd1,0x3a]
vphaddubw (%rdx), %xmm15

// CHECK: vphaddubw (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0x32]
vphaddubw (%rdx), %xmm6

// CHECK: vphaddubw %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xd1,0xff]
vphaddubw %xmm15, %xmm15

// CHECK: vphaddubw %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd1,0xf6]
vphaddubw %xmm6, %xmm6

// CHECK: vphaddudq 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xdb,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddudq 485498096, %xmm15

// CHECK: vphaddudq 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddudq 485498096, %xmm6

// CHECK: vphaddudq 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xdb,0x7c,0x82,0x40]
vphaddudq 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddudq -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xdb,0x7c,0x82,0xc0]
vphaddudq -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddudq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x74,0x82,0x40]
vphaddudq 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddudq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x74,0x82,0xc0]
vphaddudq -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddudq 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xdb,0x7c,0x02,0x40]
vphaddudq 64(%rdx,%rax), %xmm15

// CHECK: vphaddudq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x74,0x02,0x40]
vphaddudq 64(%rdx,%rax), %xmm6

// CHECK: vphaddudq 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xdb,0x7a,0x40]
vphaddudq 64(%rdx), %xmm15

// CHECK: vphaddudq 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x72,0x40]
vphaddudq 64(%rdx), %xmm6

// CHECK: vphaddudq (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xdb,0x3a]
vphaddudq (%rdx), %xmm15

// CHECK: vphaddudq (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0x32]
vphaddudq (%rdx), %xmm6

// CHECK: vphaddudq %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xdb,0xff]
vphaddudq %xmm15, %xmm15

// CHECK: vphaddudq %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xdb,0xf6]
vphaddudq %xmm6, %xmm6

// CHECK: vphadduwd 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphadduwd 485498096, %xmm15

// CHECK: vphadduwd 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphadduwd 485498096, %xmm6

// CHECK: vphadduwd 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd6,0x7c,0x82,0x40]
vphadduwd 64(%rdx,%rax,4), %xmm15

// CHECK: vphadduwd -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd6,0x7c,0x82,0xc0]
vphadduwd -64(%rdx,%rax,4), %xmm15

// CHECK: vphadduwd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x74,0x82,0x40]
vphadduwd 64(%rdx,%rax,4), %xmm6

// CHECK: vphadduwd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x74,0x82,0xc0]
vphadduwd -64(%rdx,%rax,4), %xmm6

// CHECK: vphadduwd 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd6,0x7c,0x02,0x40]
vphadduwd 64(%rdx,%rax), %xmm15

// CHECK: vphadduwd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x74,0x02,0x40]
vphadduwd 64(%rdx,%rax), %xmm6

// CHECK: vphadduwd 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd6,0x7a,0x40]
vphadduwd 64(%rdx), %xmm15

// CHECK: vphadduwd 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x72,0x40]
vphadduwd 64(%rdx), %xmm6

// CHECK: vphadduwd (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd6,0x3a]
vphadduwd (%rdx), %xmm15

// CHECK: vphadduwd (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0x32]
vphadduwd (%rdx), %xmm6

// CHECK: vphadduwd %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xd6,0xff]
vphadduwd %xmm15, %xmm15

// CHECK: vphadduwd %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd6,0xf6]
vphadduwd %xmm6, %xmm6

// CHECK: vphadduwq 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd7,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphadduwq 485498096, %xmm15

// CHECK: vphadduwq 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphadduwq 485498096, %xmm6

// CHECK: vphadduwq 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd7,0x7c,0x82,0x40]
vphadduwq 64(%rdx,%rax,4), %xmm15

// CHECK: vphadduwq -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd7,0x7c,0x82,0xc0]
vphadduwq -64(%rdx,%rax,4), %xmm15

// CHECK: vphadduwq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x74,0x82,0x40]
vphadduwq 64(%rdx,%rax,4), %xmm6

// CHECK: vphadduwq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x74,0x82,0xc0]
vphadduwq -64(%rdx,%rax,4), %xmm6

// CHECK: vphadduwq 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd7,0x7c,0x02,0x40]
vphadduwq 64(%rdx,%rax), %xmm15

// CHECK: vphadduwq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x74,0x02,0x40]
vphadduwq 64(%rdx,%rax), %xmm6

// CHECK: vphadduwq 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd7,0x7a,0x40]
vphadduwq 64(%rdx), %xmm15

// CHECK: vphadduwq 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x72,0x40]
vphadduwq 64(%rdx), %xmm6

// CHECK: vphadduwq (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xd7,0x3a]
vphadduwq (%rdx), %xmm15

// CHECK: vphadduwq (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0x32]
vphadduwq (%rdx), %xmm6

// CHECK: vphadduwq %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xd7,0xff]
vphadduwq %xmm15, %xmm15

// CHECK: vphadduwq %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xd7,0xf6]
vphadduwq %xmm6, %xmm6

// CHECK: vphaddwd 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddwd 485498096, %xmm15

// CHECK: vphaddwd 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddwd 485498096, %xmm6

// CHECK: vphaddwd 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc6,0x7c,0x82,0x40]
vphaddwd 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddwd -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc6,0x7c,0x82,0xc0]
vphaddwd -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddwd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x74,0x82,0x40]
vphaddwd 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddwd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x74,0x82,0xc0]
vphaddwd -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddwd 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc6,0x7c,0x02,0x40]
vphaddwd 64(%rdx,%rax), %xmm15

// CHECK: vphaddwd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x74,0x02,0x40]
vphaddwd 64(%rdx,%rax), %xmm6

// CHECK: vphaddwd 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc6,0x7a,0x40]
vphaddwd 64(%rdx), %xmm15

// CHECK: vphaddwd 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x72,0x40]
vphaddwd 64(%rdx), %xmm6

// CHECK: vphaddwd (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc6,0x3a]
vphaddwd (%rdx), %xmm15

// CHECK: vphaddwd (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0x32]
vphaddwd (%rdx), %xmm6

// CHECK: vphaddwd %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xc6,0xff]
vphaddwd %xmm15, %xmm15

// CHECK: vphaddwd %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc6,0xf6]
vphaddwd %xmm6, %xmm6

// CHECK: vphaddwq 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc7,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddwq 485498096, %xmm15

// CHECK: vphaddwq 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphaddwq 485498096, %xmm6

// CHECK: vphaddwq 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc7,0x7c,0x82,0x40]
vphaddwq 64(%rdx,%rax,4), %xmm15

// CHECK: vphaddwq -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc7,0x7c,0x82,0xc0]
vphaddwq -64(%rdx,%rax,4), %xmm15

// CHECK: vphaddwq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x74,0x82,0x40]
vphaddwq 64(%rdx,%rax,4), %xmm6

// CHECK: vphaddwq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x74,0x82,0xc0]
vphaddwq -64(%rdx,%rax,4), %xmm6

// CHECK: vphaddwq 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc7,0x7c,0x02,0x40]
vphaddwq 64(%rdx,%rax), %xmm15

// CHECK: vphaddwq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x74,0x02,0x40]
vphaddwq 64(%rdx,%rax), %xmm6

// CHECK: vphaddwq 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc7,0x7a,0x40]
vphaddwq 64(%rdx), %xmm15

// CHECK: vphaddwq 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x72,0x40]
vphaddwq 64(%rdx), %xmm6

// CHECK: vphaddwq (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xc7,0x3a]
vphaddwq (%rdx), %xmm15

// CHECK: vphaddwq (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0x32]
vphaddwq (%rdx), %xmm6

// CHECK: vphaddwq %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xc7,0xff]
vphaddwq %xmm15, %xmm15

// CHECK: vphaddwq %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xc7,0xf6]
vphaddwq %xmm6, %xmm6

// CHECK: vphsubbw 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe1,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphsubbw 485498096, %xmm15

// CHECK: vphsubbw 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphsubbw 485498096, %xmm6

// CHECK: vphsubbw 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe1,0x7c,0x82,0x40]
vphsubbw 64(%rdx,%rax,4), %xmm15

// CHECK: vphsubbw -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe1,0x7c,0x82,0xc0]
vphsubbw -64(%rdx,%rax,4), %xmm15

// CHECK: vphsubbw 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x74,0x82,0x40]
vphsubbw 64(%rdx,%rax,4), %xmm6

// CHECK: vphsubbw -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x74,0x82,0xc0]
vphsubbw -64(%rdx,%rax,4), %xmm6

// CHECK: vphsubbw 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe1,0x7c,0x02,0x40]
vphsubbw 64(%rdx,%rax), %xmm15

// CHECK: vphsubbw 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x74,0x02,0x40]
vphsubbw 64(%rdx,%rax), %xmm6

// CHECK: vphsubbw 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe1,0x7a,0x40]
vphsubbw 64(%rdx), %xmm15

// CHECK: vphsubbw 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x72,0x40]
vphsubbw 64(%rdx), %xmm6

// CHECK: vphsubbw (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe1,0x3a]
vphsubbw (%rdx), %xmm15

// CHECK: vphsubbw (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0x32]
vphsubbw (%rdx), %xmm6

// CHECK: vphsubbw %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xe1,0xff]
vphsubbw %xmm15, %xmm15

// CHECK: vphsubbw %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe1,0xf6]
vphsubbw %xmm6, %xmm6

// CHECK: vphsubdq 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe3,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphsubdq 485498096, %xmm15

// CHECK: vphsubdq 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphsubdq 485498096, %xmm6

// CHECK: vphsubdq 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe3,0x7c,0x82,0x40]
vphsubdq 64(%rdx,%rax,4), %xmm15

// CHECK: vphsubdq -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe3,0x7c,0x82,0xc0]
vphsubdq -64(%rdx,%rax,4), %xmm15

// CHECK: vphsubdq 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x74,0x82,0x40]
vphsubdq 64(%rdx,%rax,4), %xmm6

// CHECK: vphsubdq -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x74,0x82,0xc0]
vphsubdq -64(%rdx,%rax,4), %xmm6

// CHECK: vphsubdq 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe3,0x7c,0x02,0x40]
vphsubdq 64(%rdx,%rax), %xmm15

// CHECK: vphsubdq 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x74,0x02,0x40]
vphsubdq 64(%rdx,%rax), %xmm6

// CHECK: vphsubdq 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe3,0x7a,0x40]
vphsubdq 64(%rdx), %xmm15

// CHECK: vphsubdq 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x72,0x40]
vphsubdq 64(%rdx), %xmm6

// CHECK: vphsubdq (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe3,0x3a]
vphsubdq (%rdx), %xmm15

// CHECK: vphsubdq (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0x32]
vphsubdq (%rdx), %xmm6

// CHECK: vphsubdq %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xe3,0xff]
vphsubdq %xmm15, %xmm15

// CHECK: vphsubdq %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe3,0xf6]
vphsubdq %xmm6, %xmm6

// CHECK: vphsubwd 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe2,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vphsubwd 485498096, %xmm15

// CHECK: vphsubwd 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vphsubwd 485498096, %xmm6

// CHECK: vphsubwd 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe2,0x7c,0x82,0x40]
vphsubwd 64(%rdx,%rax,4), %xmm15

// CHECK: vphsubwd -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe2,0x7c,0x82,0xc0]
vphsubwd -64(%rdx,%rax,4), %xmm15

// CHECK: vphsubwd 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x74,0x82,0x40]
vphsubwd 64(%rdx,%rax,4), %xmm6

// CHECK: vphsubwd -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x74,0x82,0xc0]
vphsubwd -64(%rdx,%rax,4), %xmm6

// CHECK: vphsubwd 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe2,0x7c,0x02,0x40]
vphsubwd 64(%rdx,%rax), %xmm15

// CHECK: vphsubwd 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x74,0x02,0x40]
vphsubwd 64(%rdx,%rax), %xmm6

// CHECK: vphsubwd 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe2,0x7a,0x40]
vphsubwd 64(%rdx), %xmm15

// CHECK: vphsubwd 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x72,0x40]
vphsubwd 64(%rdx), %xmm6

// CHECK: vphsubwd (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x78,0xe2,0x3a]
vphsubwd (%rdx), %xmm15

// CHECK: vphsubwd (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0x32]
vphsubwd (%rdx), %xmm6

// CHECK: vphsubwd %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x78,0xe2,0xff]
vphsubwd %xmm15, %xmm15

// CHECK: vphsubwd %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x78,0xe2,0xf6]
vphsubwd %xmm6, %xmm6

// CHECK: vpmacsdd %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9e,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacsdd %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacsdd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x
vpmacsdd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsdd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9e,0x7c,0x82,0x40,0xf0]
vpmacsdd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsdd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9e,0x7c,0x82,0xc0,0xf0]
vpmacsdd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsdd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9e,0x7c,0x02,0x40,0xf0]
vpmacsdd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacsdd %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9e,0x7a,0x40,0xf0]
vpmacsdd %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacsdd %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9e,0x3a,0xf0]
vpmacsdd %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacsdd %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x9e,0xff,0xf0]
vpmacsdd %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacsdd %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9e,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacsdd %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacsdd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9e,0x74,0x82,0x40,0x60]
vpmacsdd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsdd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9e,0x74,0x82,0xc0,0x60]
vpmacsdd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsdd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9e,0x74,0x02,0x40,0x60]
vpmacsdd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacsdd %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9e,0x72,0x40,0x60]
vpmacsdd %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacsdd %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9e,0x32,0x60]
vpmacsdd %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacsdd %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9e,0xf6,0x60]
vpmacsdd %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacsdqh %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9f,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacsdqh %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacsdqh %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9f,0x7c,0x82,0x40,0xf0]
vpmacsdqh %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsdqh %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9f,0x7c,0x82,0xc0,0xf0]
vpmacsdqh %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsdqh %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9f,0x7c,0x02,0x40,0xf0]
vpmacsdqh %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacsdqh %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9f,0x7a,0x40,0xf0]
vpmacsdqh %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacsdqh %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x9f,0x3a,0xf0]
vpmacsdqh %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacsdqh %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x9f,0xff,0xf0]
vpmacsdqh %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacsdqh %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9f,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacsdqh %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacsdqh %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9f,0x74,0x82,0x40,0x60]
vpmacsdqh %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsdqh %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9f,0x74,0x82,0xc0,0x60]
vpmacsdqh %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsdqh %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9f,0x74,0x02,0x40,0x60]
vpmacsdqh %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacsdqh %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9f,0x72,0x40,0x60]
vpmacsdqh %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacsdqh %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9f,0x32,0x60]
vpmacsdqh %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacsdqh %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x9f,0xf6,0x60]
vpmacsdqh %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacsdql %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x97,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacsdql %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacsdql %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x97,0x7c,0x82,0x40,0xf0]
vpmacsdql %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsdql %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x97,0x7c,0x82,0xc0,0xf0]
vpmacsdql %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsdql %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x97,0x7c,0x02,0x40,0xf0]
vpmacsdql %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacsdql %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x97,0x7a,0x40,0xf0]
vpmacsdql %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacsdql %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x97,0x3a,0xf0]
vpmacsdql %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacsdql %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x97,0xff,0xf0]
vpmacsdql %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacsdql %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x97,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacsdql %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacsdql %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x97,0x74,0x82,0x40,0x60]
vpmacsdql %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsdql %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x97,0x74,0x82,0xc0,0x60]
vpmacsdql %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsdql %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x97,0x74,0x02,0x40,0x60]
vpmacsdql %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacsdql %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x97,0x72,0x40,0x60]
vpmacsdql %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacsdql %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x97,0x32,0x60]
vpmacsdql %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacsdql %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x97,0xf6,0x60]
vpmacsdql %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacssdd %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8e,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacssdd %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacssdd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8e,0x7c,0x82,0x40,0xf0]
vpmacssdd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacssdd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8e,0x7c,0x82,0xc0,0xf0]
vpmacssdd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacssdd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8e,0x7c,0x02,0x40,0xf0]
vpmacssdd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacssdd %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8e,0x7a,0x40,0xf0]
vpmacssdd %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacssdd %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8e,0x3a,0xf0]
vpmacssdd %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacssdd %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x8e,0xff,0xf0]
vpmacssdd %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacssdd %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8e,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacssdd %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacssdd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8e,0x74,0x82,0x40,0x60]
vpmacssdd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacssdd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8e,0x74,0x82,0xc0,0x60]
vpmacssdd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacssdd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8e,0x74,0x02,0x40,0x60]
vpmacssdd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacssdd %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8e,0x72,0x40,0x60]
vpmacssdd %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacssdd %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8e,0x32,0x60]
vpmacssdd %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacssdd %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8e,0xf6,0x60]
vpmacssdd %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacssdqh %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8f,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacssdqh %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacssdqh %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8f,0x7c,0x82,0x40,0xf0]
vpmacssdqh %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacssdqh %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8f,0x7c,0x82,0xc0,0xf0]
vpmacssdqh %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacssdqh %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8f,0x7c,0x02,0x40,0xf0]
vpmacssdqh %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacssdqh %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8f,0x7a,0x40,0xf0]
vpmacssdqh %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacssdqh %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x8f,0x3a,0xf0]
vpmacssdqh %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacssdqh %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x8f,0xff,0xf0]
vpmacssdqh %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacssdqh %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8f,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacssdqh %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacssdqh %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8f,0x74,0x82,0x40,0x60]
vpmacssdqh %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacssdqh %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8f,0x74,0x82,0xc0,0x60]
vpmacssdqh %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacssdqh %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8f,0x74,0x02,0x40,0x60]
vpmacssdqh %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacssdqh %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8f,0x72,0x40,0x60]
vpmacssdqh %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacssdqh %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8f,0x32,0x60]
vpmacssdqh %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacssdqh %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x8f,0xf6,0x60]
vpmacssdqh %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacssdql %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x87,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacssdql %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacssdql %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x87,0x7c,0x82,0x40,0xf0]
vpmacssdql %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacssdql %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x87,0x7c,0x82,0xc0,0xf0]
vpmacssdql %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacssdql %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x87,0x7c,0x02,0x40,0xf0]
vpmacssdql %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacssdql %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x87,0x7a,0x40,0xf0]
vpmacssdql %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacssdql %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x87,0x3a,0xf0]
vpmacssdql %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacssdql %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x87,0xff,0xf0]
vpmacssdql %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacssdql %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x87,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacssdql %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacssdql %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x87,0x74,0x82,0x40,0x60]
vpmacssdql %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacssdql %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x87,0x74,0x82,0xc0,0x60]
vpmacssdql %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacssdql %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x87,0x74,0x02,0x40,0x60]
vpmacssdql %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacssdql %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x87,0x72,0x40,0x60]
vpmacssdql %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacssdql %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x87,0x32,0x60]
vpmacssdql %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacssdql %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x87,0xf6,0x60]
vpmacssdql %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacsswd %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x86,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacsswd %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacsswd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x86,0x7c,0x82,0x40,0xf0]
vpmacsswd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsswd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x86,0x7c,0x82,0xc0,0xf0]
vpmacsswd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsswd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x86,0x7c,0x02,0x40,0xf0]
vpmacsswd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacsswd %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x86,0x7a,0x40,0xf0]
vpmacsswd %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacsswd %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x86,0x3a,0xf0]
vpmacsswd %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacsswd %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x86,0xff,0xf0]
vpmacsswd %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacsswd %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x86,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacsswd %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacsswd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x86,0x74,0x82,0x40,0x60]
vpmacsswd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsswd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x86,0x74,0x82,0xc0,0x60]
vpmacsswd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsswd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x86,0x74,0x02,0x40,0x60]
vpmacsswd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacsswd %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x86,0x72,0x40,0x60]
vpmacsswd %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacsswd %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x86,0x32,0x60]
vpmacsswd %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacsswd %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x86,0xf6,0x60]
vpmacsswd %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacssww %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x85,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacssww %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacssww %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x85,0x7c,0x82,0x40,0xf0]
vpmacssww %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacssww %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x85,0x7c,0x82,0xc0,0xf0]
vpmacssww %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacssww %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x85,0x7c,0x02,0x40,0xf0]
vpmacssww %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacssww %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x85,0x7a,0x40,0xf0]
vpmacssww %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacssww %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x85,0x3a,0xf0]
vpmacssww %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacssww %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x85,0xff,0xf0]
vpmacssww %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacssww %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x85,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacssww %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacssww %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x85,0x74,0x82,0x40,0x60]
vpmacssww %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacssww %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x85,0x74,0x82,0xc0,0x60]
vpmacssww %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacssww %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x85,0x74,0x02,0x40,0x60]
vpmacssww %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacssww %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x85,0x72,0x40,0x60]
vpmacssww %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacssww %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x85,0x32,0x60]
vpmacssww %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacssww %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x85,0xf6,0x60]
vpmacssww %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacswd %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x96,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacswd %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacswd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x96,0x7c,0x82,0x40,0xf0]
vpmacswd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacswd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x96,0x7c,0x82,0xc0,0xf0]
vpmacswd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacswd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x96,0x7c,0x02,0x40,0xf0]
vpmacswd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacswd %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x96,0x7a,0x40,0xf0]
vpmacswd %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacswd %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x96,0x3a,0xf0]
vpmacswd %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacswd %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x96,0xff,0xf0]
vpmacswd %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacswd %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x96,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacswd %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacswd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x96,0x74,0x82,0x40,0x60]
vpmacswd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacswd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x96,0x74,0x82,0xc0,0x60]
vpmacswd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacswd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x96,0x74,0x02,0x40,0x60]
vpmacswd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacswd %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x96,0x72,0x40,0x60]
vpmacswd %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacswd %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x96,0x32,0x60]
vpmacswd %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacswd %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x96,0xf6,0x60]
vpmacswd %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmacsww %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x95,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmacsww %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmacsww %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x95,0x7c,0x82,0x40,0xf0]
vpmacsww %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsww %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x95,0x7c,0x82,0xc0,0xf0]
vpmacsww %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmacsww %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x95,0x7c,0x02,0x40,0xf0]
vpmacsww %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmacsww %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x95,0x7a,0x40,0xf0]
vpmacsww %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmacsww %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0x95,0x3a,0xf0]
vpmacsww %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmacsww %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0x95,0xff,0xf0]
vpmacsww %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmacsww %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x95,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmacsww %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmacsww %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x95,0x74,0x82,0x40,0x60]
vpmacsww %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsww %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x95,0x74,0x82,0xc0,0x60]
vpmacsww %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmacsww %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x95,0x74,0x02,0x40,0x60]
vpmacsww %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmacsww %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x95,0x72,0x40,0x60]
vpmacsww %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmacsww %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x95,0x32,0x60]
vpmacsww %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmacsww %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0x95,0xf6,0x60]
vpmacsww %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmadcsswd %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmadcsswd %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmadcsswd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa6,0x7c,0x82,0x40,0xf0]
vpmadcsswd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmadcsswd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa6,0x7c,0x82,0xc0,0xf0]
vpmadcsswd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmadcsswd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa6,0x7c,0x02,0x40,0xf0]
vpmadcsswd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmadcsswd %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa6,0x7a,0x40,0xf0]
vpmadcsswd %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmadcsswd %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa6,0x3a,0xf0]
vpmadcsswd %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmadcsswd %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xa6,0xff,0xf0]
vpmadcsswd %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmadcsswd %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa6,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmadcsswd %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmadcsswd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa6,0x74,0x82,0x40,0x60]
vpmadcsswd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmadcsswd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa6,0x74,0x82,0xc0,0x60]
vpmadcsswd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmadcsswd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa6,0x74,0x02,0x40,0x60]
vpmadcsswd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmadcsswd %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa6,0x72,0x40,0x60]
vpmadcsswd %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmadcsswd %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa6,0x32,0x60]
vpmadcsswd %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmadcsswd %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa6,0xf6,0x60]
vpmadcsswd %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpmadcswd %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xb6,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpmadcswd %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpmadcswd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xb6,0x7c,0x82,0x40,0xf0]
vpmadcswd %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmadcswd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xb6,0x7c,0x82,0xc0,0xf0]
vpmadcswd %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpmadcswd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xb6,0x7c,0x02,0x40,0xf0]
vpmadcswd %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpmadcswd %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xb6,0x7a,0x40,0xf0]
vpmadcswd %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpmadcswd %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xb6,0x3a,0xf0]
vpmadcswd %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpmadcswd %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xb6,0xff,0xf0]
vpmadcswd %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpmadcswd %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xb6,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpmadcswd %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpmadcswd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xb6,0x74,0x82,0x40,0x60]
vpmadcswd %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmadcswd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xb6,0x74,0x82,0xc0,0x60]
vpmadcswd %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpmadcswd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xb6,0x74,0x02,0x40,0x60]
vpmadcswd %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpmadcswd %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xb6,0x72,0x40,0x60]
vpmadcswd %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpmadcswd %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xb6,0x32,0x60]
vpmadcswd %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpmadcswd %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xb6,0xf6,0x60]
vpmadcswd %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vpperm 485498096, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa3,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpperm 485498096, %xmm15, %xmm15, %xmm15

// CHECK: vpperm 485498096, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa3,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpperm 485498096, %xmm6, %xmm6, %xmm6

// CHECK: vpperm 64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa3,0x7c,0x82,0x40,0xf0]
vpperm 64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15

// CHECK: vpperm -64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa3,0x7c,0x82,0xc0,0xf0]
vpperm -64(%rdx,%rax,4), %xmm15, %xmm15, %xmm15

// CHECK: vpperm 64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa3,0x74,0x82,0x40,0x60]
vpperm 64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6

// CHECK: vpperm -64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa3,0x74,0x82,0xc0,0x60]
vpperm -64(%rdx,%rax,4), %xmm6, %xmm6, %xmm6

// CHECK: vpperm 64(%rdx,%rax), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa3,0x7c,0x02,0x40,0xf0]
vpperm 64(%rdx,%rax), %xmm15, %xmm15, %xmm15

// CHECK: vpperm 64(%rdx,%rax), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa3,0x74,0x02,0x40,0x60]
vpperm 64(%rdx,%rax), %xmm6, %xmm6, %xmm6

// CHECK: vpperm 64(%rdx), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa3,0x7a,0x40,0xf0]
vpperm 64(%rdx), %xmm15, %xmm15, %xmm15

// CHECK: vpperm 64(%rdx), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa3,0x72,0x40,0x60]
vpperm 64(%rdx), %xmm6, %xmm6, %xmm6

// CHECK: vpperm (%rdx), %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x80,0xa3,0x3a,0xf0]
vpperm (%rdx), %xmm15, %xmm15, %xmm15

// CHECK: vpperm (%rdx), %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0xc8,0xa3,0x32,0x60]
vpperm (%rdx), %xmm6, %xmm6, %xmm6

// CHECK: vpperm %xmm15, 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa3,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0xf0]
vpperm %xmm15, 485498096, %xmm15, %xmm15

// CHECK: vpperm %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa3,0x7c,0x82,0x40,0xf0]
vpperm %xmm15, 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpperm %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa3,0x7c,0x82,0xc0,0xf0]
vpperm %xmm15, -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpperm %xmm15, 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa3,0x7c,0x02,0x40,0xf0]
vpperm %xmm15, 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpperm %xmm15, 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa3,0x7a,0x40,0xf0]
vpperm %xmm15, 64(%rdx), %xmm15, %xmm15

// CHECK: vpperm %xmm15, (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x68,0x00,0xa3,0x3a,0xf0]
vpperm %xmm15, (%rdx), %xmm15, %xmm15

// CHECK: vpperm %xmm15, %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x00,0xa3,0xff,0xf0]
vpperm %xmm15, %xmm15, %xmm15, %xmm15

// CHECK: vpperm %xmm6, 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa3,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x60]
vpperm %xmm6, 485498096, %xmm6, %xmm6

// CHECK: vpperm %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa3,0x74,0x82,0x40,0x60]
vpperm %xmm6, 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpperm %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa3,0x74,0x82,0xc0,0x60]
vpperm %xmm6, -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpperm %xmm6, 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa3,0x74,0x02,0x40,0x60]
vpperm %xmm6, 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpperm %xmm6, 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa3,0x72,0x40,0x60]
vpperm %xmm6, 64(%rdx), %xmm6, %xmm6

// CHECK: vpperm %xmm6, (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa3,0x32,0x60]
vpperm %xmm6, (%rdx), %xmm6, %xmm6

// CHECK: vpperm %xmm6, %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x48,0xa3,0xf6,0x60]
vpperm %xmm6, %xmm6, %xmm6, %xmm6

// CHECK: vprotb $0, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc0,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vprotb $0, 485498096, %xmm15

// CHECK: vprotb $0, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vprotb $0, 485498096, %xmm6

// CHECK: vprotb $0, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc0,0x7c,0x82,0x40,0x00]
vprotb $0, 64(%rdx,%rax,4), %xmm15

// CHECK: vprotb $0, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc0,0x7c,0x82,0xc0,0x00]
vprotb $0, -64(%rdx,%rax,4), %xmm15

// CHECK: vprotb $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x74,0x82,0x40,0x00]
vprotb $0, 64(%rdx,%rax,4), %xmm6

// CHECK: vprotb $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x74,0x82,0xc0,0x00]
vprotb $0, -64(%rdx,%rax,4), %xmm6

// CHECK: vprotb $0, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc0,0x7c,0x02,0x40,0x00]
vprotb $0, 64(%rdx,%rax), %xmm15

// CHECK: vprotb $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x74,0x02,0x40,0x00]
vprotb $0, 64(%rdx,%rax), %xmm6

// CHECK: vprotb $0, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc0,0x7a,0x40,0x00]
vprotb $0, 64(%rdx), %xmm15

// CHECK: vprotb $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x72,0x40,0x00]
vprotb $0, 64(%rdx), %xmm6

// CHECK: vprotb $0, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc0,0x3a,0x00]
vprotb $0, (%rdx), %xmm15

// CHECK: vprotb $0, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0x32,0x00]
vprotb $0, (%rdx), %xmm6

// CHECK: vprotb $0, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x78,0xc0,0xff,0x00]
vprotb $0, %xmm15, %xmm15

// CHECK: vprotb $0, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc0,0xf6,0x00]
vprotb $0, %xmm6, %xmm6

// CHECK: vprotb 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x90,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vprotb 485498096, %xmm15, %xmm15

// CHECK: vprotb 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x90,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vprotb 485498096, %xmm6, %xmm6

// CHECK: vprotb 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x90,0x7c,0x82,0x40]
vprotb 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vprotb -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x90,0x7c,0x82,0xc0]
vprotb -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vprotb 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x90,0x74,0x82,0x40]
vprotb 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vprotb -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x90,0x74,0x82,0xc0]
vprotb -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vprotb 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x90,0x7c,0x02,0x40]
vprotb 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vprotb 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x90,0x74,0x02,0x40]
vprotb 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vprotb 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x90,0x7a,0x40]
vprotb 64(%rdx), %xmm15, %xmm15

// CHECK: vprotb 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x90,0x72,0x40]
vprotb 64(%rdx), %xmm6, %xmm6

// CHECK: vprotb (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x90,0x3a]
vprotb (%rdx), %xmm15, %xmm15

// CHECK: vprotb (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x90,0x32]
vprotb (%rdx), %xmm6, %xmm6

// CHECK: vprotb %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x90,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vprotb %xmm15, 485498096, %xmm15

// CHECK: vprotb %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x90,0x7c,0x82,0x40]
vprotb %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vprotb %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x90,0x7c,0x82,0xc0]
vprotb %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vprotb %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x90,0x7c,0x02,0x40]
vprotb %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vprotb %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x90,0x7a,0x40]
vprotb %xmm15, 64(%rdx), %xmm15

// CHECK: vprotb %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x90,0x3a]
vprotb %xmm15, (%rdx), %xmm15

// CHECK: vprotb %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x90,0xff]
vprotb %xmm15, %xmm15, %xmm15

// CHECK: vprotb %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x90,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vprotb %xmm6, 485498096, %xmm6

// CHECK: vprotb %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x90,0x74,0x82,0x40]
vprotb %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vprotb %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x90,0x74,0x82,0xc0]
vprotb %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vprotb %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x90,0x74,0x02,0x40]
vprotb %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vprotb %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x90,0x72,0x40]
vprotb %xmm6, 64(%rdx), %xmm6

// CHECK: vprotb %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x90,0x32]
vprotb %xmm6, (%rdx), %xmm6

// CHECK: vprotb %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x90,0xf6]
vprotb %xmm6, %xmm6, %xmm6

// CHECK: vprotd $0, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc2,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vprotd $0, 485498096, %xmm15

// CHECK: vprotd $0, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vprotd $0, 485498096, %xmm6

// CHECK: vprotd $0, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc2,0x7c,0x82,0x40,0x00]
vprotd $0, 64(%rdx,%rax,4), %xmm15

// CHECK: vprotd $0, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc2,0x7c,0x82,0xc0,0x00]
vprotd $0, -64(%rdx,%rax,4), %xmm15

// CHECK: vprotd $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x74,0x82,0x40,0x00]
vprotd $0, 64(%rdx,%rax,4), %xmm6

// CHECK: vprotd $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x74,0x82,0xc0,0x00]
vprotd $0, -64(%rdx,%rax,4), %xmm6

// CHECK: vprotd $0, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc2,0x7c,0x02,0x40,0x00]
vprotd $0, 64(%rdx,%rax), %xmm15

// CHECK: vprotd $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x74,0x02,0x40,0x00]
vprotd $0, 64(%rdx,%rax), %xmm6

// CHECK: vprotd $0, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc2,0x7a,0x40,0x00]
vprotd $0, 64(%rdx), %xmm15

// CHECK: vprotd $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x72,0x40,0x00]
vprotd $0, 64(%rdx), %xmm6

// CHECK: vprotd $0, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc2,0x3a,0x00]
vprotd $0, (%rdx), %xmm15

// CHECK: vprotd $0, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0x32,0x00]
vprotd $0, (%rdx), %xmm6

// CHECK: vprotd $0, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x78,0xc2,0xff,0x00]
vprotd $0, %xmm15, %xmm15

// CHECK: vprotd $0, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc2,0xf6,0x00]
vprotd $0, %xmm6, %xmm6

// CHECK: vprotd 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x92,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vprotd 485498096, %xmm15, %xmm15

// CHECK: vprotd 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x92,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vprotd 485498096, %xmm6, %xmm6

// CHECK: vprotd 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x92,0x7c,0x82,0x40]
vprotd 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vprotd -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x92,0x7c,0x82,0xc0]
vprotd -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vprotd 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x92,0x74,0x82,0x40]
vprotd 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vprotd -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x92,0x74,0x82,0xc0]
vprotd -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vprotd 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x92,0x7c,0x02,0x40]
vprotd 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vprotd 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x92,0x74,0x02,0x40]
vprotd 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vprotd 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x92,0x7a,0x40]
vprotd 64(%rdx), %xmm15, %xmm15

// CHECK: vprotd 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x92,0x72,0x40]
vprotd 64(%rdx), %xmm6, %xmm6

// CHECK: vprotd (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x92,0x3a]
vprotd (%rdx), %xmm15, %xmm15

// CHECK: vprotd (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x92,0x32]
vprotd (%rdx), %xmm6, %xmm6

// CHECK: vprotd %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x92,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vprotd %xmm15, 485498096, %xmm15

// CHECK: vprotd %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x92,0x7c,0x82,0x40]
vprotd %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vprotd %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x92,0x7c,0x82,0xc0]
vprotd %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vprotd %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x92,0x7c,0x02,0x40]
vprotd %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vprotd %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x92,0x7a,0x40]
vprotd %xmm15, 64(%rdx), %xmm15

// CHECK: vprotd %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x92,0x3a]
vprotd %xmm15, (%rdx), %xmm15

// CHECK: vprotd %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x92,0xff]
vprotd %xmm15, %xmm15, %xmm15

// CHECK: vprotd %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x92,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vprotd %xmm6, 485498096, %xmm6

// CHECK: vprotd %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x92,0x74,0x82,0x40]
vprotd %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vprotd %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x92,0x74,0x82,0xc0]
vprotd %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vprotd %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x92,0x74,0x02,0x40]
vprotd %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vprotd %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x92,0x72,0x40]
vprotd %xmm6, 64(%rdx), %xmm6

// CHECK: vprotd %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x92,0x32]
vprotd %xmm6, (%rdx), %xmm6

// CHECK: vprotd %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x92,0xf6]
vprotd %xmm6, %xmm6, %xmm6

// CHECK: vprotq $0, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc3,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vprotq $0, 485498096, %xmm15

// CHECK: vprotq $0, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vprotq $0, 485498096, %xmm6

// CHECK: vprotq $0, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc3,0x7c,0x82,0x40,0x00]
vprotq $0, 64(%rdx,%rax,4), %xmm15

// CHECK: vprotq $0, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc3,0x7c,0x82,0xc0,0x00]
vprotq $0, -64(%rdx,%rax,4), %xmm15

// CHECK: vprotq $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x74,0x82,0x40,0x00]
vprotq $0, 64(%rdx,%rax,4), %xmm6

// CHECK: vprotq $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x74,0x82,0xc0,0x00]
vprotq $0, -64(%rdx,%rax,4), %xmm6

// CHECK: vprotq $0, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc3,0x7c,0x02,0x40,0x00]
vprotq $0, 64(%rdx,%rax), %xmm15

// CHECK: vprotq $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x74,0x02,0x40,0x00]
vprotq $0, 64(%rdx,%rax), %xmm6

// CHECK: vprotq $0, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc3,0x7a,0x40,0x00]
vprotq $0, 64(%rdx), %xmm15

// CHECK: vprotq $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x72,0x40,0x00]
vprotq $0, 64(%rdx), %xmm6

// CHECK: vprotq $0, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc3,0x3a,0x00]
vprotq $0, (%rdx), %xmm15

// CHECK: vprotq $0, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0x32,0x00]
vprotq $0, (%rdx), %xmm6

// CHECK: vprotq $0, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x78,0xc3,0xff,0x00]
vprotq $0, %xmm15, %xmm15

// CHECK: vprotq $0, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc3,0xf6,0x00]
vprotq $0, %xmm6, %xmm6

// CHECK: vprotq 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x93,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vprotq 485498096, %xmm15, %xmm15

// CHECK: vprotq 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x93,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vprotq 485498096, %xmm6, %xmm6

// CHECK: vprotq 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x93,0x7c,0x82,0x40]
vprotq 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vprotq -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x93,0x7c,0x82,0xc0]
vprotq -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vprotq 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x93,0x74,0x82,0x40]
vprotq 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vprotq -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x93,0x74,0x82,0xc0]
vprotq -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vprotq 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x93,0x7c,0x02,0x40]
vprotq 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vprotq 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x93,0x74,0x02,0x40]
vprotq 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vprotq 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x93,0x7a,0x40]
vprotq 64(%rdx), %xmm15, %xmm15

// CHECK: vprotq 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x93,0x72,0x40]
vprotq 64(%rdx), %xmm6, %xmm6

// CHECK: vprotq (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x93,0x3a]
vprotq (%rdx), %xmm15, %xmm15

// CHECK: vprotq (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x93,0x32]
vprotq (%rdx), %xmm6, %xmm6

// CHECK: vprotq %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x93,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vprotq %xmm15, 485498096, %xmm15

// CHECK: vprotq %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x93,0x7c,0x82,0x40]
vprotq %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vprotq %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x93,0x7c,0x82,0xc0]
vprotq %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vprotq %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x93,0x7c,0x02,0x40]
vprotq %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vprotq %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x93,0x7a,0x40]
vprotq %xmm15, 64(%rdx), %xmm15

// CHECK: vprotq %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x93,0x3a]
vprotq %xmm15, (%rdx), %xmm15

// CHECK: vprotq %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x93,0xff]
vprotq %xmm15, %xmm15, %xmm15

// CHECK: vprotq %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x93,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vprotq %xmm6, 485498096, %xmm6

// CHECK: vprotq %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x93,0x74,0x82,0x40]
vprotq %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vprotq %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x93,0x74,0x82,0xc0]
vprotq %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vprotq %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x93,0x74,0x02,0x40]
vprotq %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vprotq %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x93,0x72,0x40]
vprotq %xmm6, 64(%rdx), %xmm6

// CHECK: vprotq %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x93,0x32]
vprotq %xmm6, (%rdx), %xmm6

// CHECK: vprotq %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x93,0xf6]
vprotq %xmm6, %xmm6, %xmm6

// CHECK: vprotw $0, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc1,0x3c,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vprotw $0, 485498096, %xmm15

// CHECK: vprotw $0, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x34,0x25,0xf0,0x1c,0xf0,0x1c,0x00]
vprotw $0, 485498096, %xmm6

// CHECK: vprotw $0, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc1,0x7c,0x82,0x40,0x00]
vprotw $0, 64(%rdx,%rax,4), %xmm15

// CHECK: vprotw $0, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc1,0x7c,0x82,0xc0,0x00]
vprotw $0, -64(%rdx,%rax,4), %xmm15

// CHECK: vprotw $0, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x74,0x82,0x40,0x00]
vprotw $0, 64(%rdx,%rax,4), %xmm6

// CHECK: vprotw $0, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x74,0x82,0xc0,0x00]
vprotw $0, -64(%rdx,%rax,4), %xmm6

// CHECK: vprotw $0, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc1,0x7c,0x02,0x40,0x00]
vprotw $0, 64(%rdx,%rax), %xmm15

// CHECK: vprotw $0, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x74,0x02,0x40,0x00]
vprotw $0, 64(%rdx,%rax), %xmm6

// CHECK: vprotw $0, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc1,0x7a,0x40,0x00]
vprotw $0, 64(%rdx), %xmm15

// CHECK: vprotw $0, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x72,0x40,0x00]
vprotw $0, 64(%rdx), %xmm6

// CHECK: vprotw $0, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x68,0x78,0xc1,0x3a,0x00]
vprotw $0, (%rdx), %xmm15

// CHECK: vprotw $0, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0x32,0x00]
vprotw $0, (%rdx), %xmm6

// CHECK: vprotw $0, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x48,0x78,0xc1,0xff,0x00]
vprotw $0, %xmm15, %xmm15

// CHECK: vprotw $0, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe8,0x78,0xc1,0xf6,0x00]
vprotw $0, %xmm6, %xmm6

// CHECK: vprotw 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x91,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vprotw 485498096, %xmm15, %xmm15

// CHECK: vprotw 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x91,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vprotw 485498096, %xmm6, %xmm6

// CHECK: vprotw 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x91,0x7c,0x82,0x40]
vprotw 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vprotw -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x91,0x7c,0x82,0xc0]
vprotw -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vprotw 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x91,0x74,0x82,0x40]
vprotw 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vprotw -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x91,0x74,0x82,0xc0]
vprotw -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vprotw 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x91,0x7c,0x02,0x40]
vprotw 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vprotw 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x91,0x74,0x02,0x40]
vprotw 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vprotw 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x91,0x7a,0x40]
vprotw 64(%rdx), %xmm15, %xmm15

// CHECK: vprotw 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x91,0x72,0x40]
vprotw 64(%rdx), %xmm6, %xmm6

// CHECK: vprotw (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x91,0x3a]
vprotw (%rdx), %xmm15, %xmm15

// CHECK: vprotw (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x91,0x32]
vprotw (%rdx), %xmm6, %xmm6

// CHECK: vprotw %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x91,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vprotw %xmm15, 485498096, %xmm15

// CHECK: vprotw %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x91,0x7c,0x82,0x40]
vprotw %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vprotw %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x91,0x7c,0x82,0xc0]
vprotw %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vprotw %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x91,0x7c,0x02,0x40]
vprotw %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vprotw %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x91,0x7a,0x40]
vprotw %xmm15, 64(%rdx), %xmm15

// CHECK: vprotw %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x91,0x3a]
vprotw %xmm15, (%rdx), %xmm15

// CHECK: vprotw %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x91,0xff]
vprotw %xmm15, %xmm15, %xmm15

// CHECK: vprotw %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x91,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vprotw %xmm6, 485498096, %xmm6

// CHECK: vprotw %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x91,0x74,0x82,0x40]
vprotw %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vprotw %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x91,0x74,0x82,0xc0]
vprotw %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vprotw %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x91,0x74,0x02,0x40]
vprotw %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vprotw %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x91,0x72,0x40]
vprotw %xmm6, 64(%rdx), %xmm6

// CHECK: vprotw %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x91,0x32]
vprotw %xmm6, (%rdx), %xmm6

// CHECK: vprotw %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x91,0xf6]
vprotw %xmm6, %xmm6, %xmm6

// CHECK: vpshab 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x98,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshab 485498096, %xmm15, %xmm15

// CHECK: vpshab 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x98,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshab 485498096, %xmm6, %xmm6

// CHECK: vpshab 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x98,0x7c,0x82,0x40]
vpshab 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshab -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x98,0x7c,0x82,0xc0]
vpshab -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshab 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x98,0x74,0x82,0x40]
vpshab 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshab -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x98,0x74,0x82,0xc0]
vpshab -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshab 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x98,0x7c,0x02,0x40]
vpshab 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpshab 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x98,0x74,0x02,0x40]
vpshab 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpshab 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x98,0x7a,0x40]
vpshab 64(%rdx), %xmm15, %xmm15

// CHECK: vpshab 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x98,0x72,0x40]
vpshab 64(%rdx), %xmm6, %xmm6

// CHECK: vpshab (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x98,0x3a]
vpshab (%rdx), %xmm15, %xmm15

// CHECK: vpshab (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x98,0x32]
vpshab (%rdx), %xmm6, %xmm6

// CHECK: vpshab %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x98,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshab %xmm15, 485498096, %xmm15

// CHECK: vpshab %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x98,0x7c,0x82,0x40]
vpshab %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vpshab %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x98,0x7c,0x82,0xc0]
vpshab %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vpshab %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x98,0x7c,0x02,0x40]
vpshab %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vpshab %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x98,0x7a,0x40]
vpshab %xmm15, 64(%rdx), %xmm15

// CHECK: vpshab %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x98,0x3a]
vpshab %xmm15, (%rdx), %xmm15

// CHECK: vpshab %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x98,0xff]
vpshab %xmm15, %xmm15, %xmm15

// CHECK: vpshab %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x98,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshab %xmm6, 485498096, %xmm6

// CHECK: vpshab %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x98,0x74,0x82,0x40]
vpshab %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vpshab %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x98,0x74,0x82,0xc0]
vpshab %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vpshab %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x98,0x74,0x02,0x40]
vpshab %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vpshab %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x98,0x72,0x40]
vpshab %xmm6, 64(%rdx), %xmm6

// CHECK: vpshab %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x98,0x32]
vpshab %xmm6, (%rdx), %xmm6

// CHECK: vpshab %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x98,0xf6]
vpshab %xmm6, %xmm6, %xmm6

// CHECK: vpshad 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9a,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshad 485498096, %xmm15, %xmm15

// CHECK: vpshad 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshad 485498096, %xmm6, %xmm6

// CHECK: vpshad 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9a,0x7c,0x82,0x40]
vpshad 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshad -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9a,0x7c,0x82,0xc0]
vpshad -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshad 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9a,0x74,0x82,0x40]
vpshad 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshad -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9a,0x74,0x82,0xc0]
vpshad -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshad 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9a,0x7c,0x02,0x40]
vpshad 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpshad 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9a,0x74,0x02,0x40]
vpshad 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpshad 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9a,0x7a,0x40]
vpshad 64(%rdx), %xmm15, %xmm15

// CHECK: vpshad 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9a,0x72,0x40]
vpshad 64(%rdx), %xmm6, %xmm6

// CHECK: vpshad (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9a,0x3a]
vpshad (%rdx), %xmm15, %xmm15

// CHECK: vpshad (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9a,0x32]
vpshad (%rdx), %xmm6, %xmm6

// CHECK: vpshad %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9a,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshad %xmm15, 485498096, %xmm15

// CHECK: vpshad %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9a,0x7c,0x82,0x40]
vpshad %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vpshad %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9a,0x7c,0x82,0xc0]
vpshad %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vpshad %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9a,0x7c,0x02,0x40]
vpshad %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vpshad %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9a,0x7a,0x40]
vpshad %xmm15, 64(%rdx), %xmm15

// CHECK: vpshad %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9a,0x3a]
vpshad %xmm15, (%rdx), %xmm15

// CHECK: vpshad %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x9a,0xff]
vpshad %xmm15, %xmm15, %xmm15

// CHECK: vpshad %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9a,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshad %xmm6, 485498096, %xmm6

// CHECK: vpshad %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9a,0x74,0x82,0x40]
vpshad %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vpshad %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9a,0x74,0x82,0xc0]
vpshad %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vpshad %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9a,0x74,0x02,0x40]
vpshad %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vpshad %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9a,0x72,0x40]
vpshad %xmm6, 64(%rdx), %xmm6

// CHECK: vpshad %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9a,0x32]
vpshad %xmm6, (%rdx), %xmm6

// CHECK: vpshad %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9a,0xf6]
vpshad %xmm6, %xmm6, %xmm6

// CHECK: vpshaq 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9b,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshaq 485498096, %xmm15, %xmm15

// CHECK: vpshaq 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshaq 485498096, %xmm6, %xmm6

// CHECK: vpshaq 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9b,0x7c,0x82,0x40]
vpshaq 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshaq -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9b,0x7c,0x82,0xc0]
vpshaq -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshaq 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9b,0x74,0x82,0x40]
vpshaq 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshaq -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9b,0x74,0x82,0xc0]
vpshaq -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshaq 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9b,0x7c,0x02,0x40]
vpshaq 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpshaq 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9b,0x74,0x02,0x40]
vpshaq 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpshaq 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9b,0x7a,0x40]
vpshaq 64(%rdx), %xmm15, %xmm15

// CHECK: vpshaq 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9b,0x72,0x40]
vpshaq 64(%rdx), %xmm6, %xmm6

// CHECK: vpshaq (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x9b,0x3a]
vpshaq (%rdx), %xmm15, %xmm15

// CHECK: vpshaq (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x9b,0x32]
vpshaq (%rdx), %xmm6, %xmm6

// CHECK: vpshaq %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9b,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshaq %xmm15, 485498096, %xmm15

// CHECK: vpshaq %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9b,0x7c,0x82,0x40]
vpshaq %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vpshaq %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9b,0x7c,0x82,0xc0]
vpshaq %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vpshaq %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9b,0x7c,0x02,0x40]
vpshaq %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vpshaq %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9b,0x7a,0x40]
vpshaq %xmm15, 64(%rdx), %xmm15

// CHECK: vpshaq %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x9b,0x3a]
vpshaq %xmm15, (%rdx), %xmm15

// CHECK: vpshaq %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x9b,0xff]
vpshaq %xmm15, %xmm15, %xmm15

// CHECK: vpshaq %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9b,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshaq %xmm6, 485498096, %xmm6

// CHECK: vpshaq %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9b,0x74,0x82,0x40]
vpshaq %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vpshaq %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9b,0x74,0x82,0xc0]
vpshaq %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vpshaq %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9b,0x74,0x02,0x40]
vpshaq %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vpshaq %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9b,0x72,0x40]
vpshaq %xmm6, 64(%rdx), %xmm6

// CHECK: vpshaq %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9b,0x32]
vpshaq %xmm6, (%rdx), %xmm6

// CHECK: vpshaq %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x9b,0xf6]
vpshaq %xmm6, %xmm6, %xmm6

// CHECK: vpshaw 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x99,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshaw 485498096, %xmm15, %xmm15

// CHECK: vpshaw 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x99,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshaw 485498096, %xmm6, %xmm6

// CHECK: vpshaw 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x99,0x7c,0x82,0x40]
vpshaw 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshaw -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x99,0x7c,0x82,0xc0]
vpshaw -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshaw 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x99,0x74,0x82,0x40]
vpshaw 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshaw -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x99,0x74,0x82,0xc0]
vpshaw -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshaw 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x99,0x7c,0x02,0x40]
vpshaw 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpshaw 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x99,0x74,0x02,0x40]
vpshaw 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpshaw 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x99,0x7a,0x40]
vpshaw 64(%rdx), %xmm15, %xmm15

// CHECK: vpshaw 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x99,0x72,0x40]
vpshaw 64(%rdx), %xmm6, %xmm6

// CHECK: vpshaw (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x99,0x3a]
vpshaw (%rdx), %xmm15, %xmm15

// CHECK: vpshaw (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x99,0x32]
vpshaw (%rdx), %xmm6, %xmm6

// CHECK: vpshaw %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x99,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshaw %xmm15, 485498096, %xmm15

// CHECK: vpshaw %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x99,0x7c,0x82,0x40]
vpshaw %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vpshaw %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x99,0x7c,0x82,0xc0]
vpshaw %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vpshaw %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x99,0x7c,0x02,0x40]
vpshaw %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vpshaw %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x99,0x7a,0x40]
vpshaw %xmm15, 64(%rdx), %xmm15

// CHECK: vpshaw %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x99,0x3a]
vpshaw %xmm15, (%rdx), %xmm15

// CHECK: vpshaw %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x99,0xff]
vpshaw %xmm15, %xmm15, %xmm15

// CHECK: vpshaw %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x99,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshaw %xmm6, 485498096, %xmm6

// CHECK: vpshaw %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x99,0x74,0x82,0x40]
vpshaw %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vpshaw %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x99,0x74,0x82,0xc0]
vpshaw %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vpshaw %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x99,0x74,0x02,0x40]
vpshaw %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vpshaw %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x99,0x72,0x40]
vpshaw %xmm6, 64(%rdx), %xmm6

// CHECK: vpshaw %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x99,0x32]
vpshaw %xmm6, (%rdx), %xmm6

// CHECK: vpshaw %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x99,0xf6]
vpshaw %xmm6, %xmm6, %xmm6

// CHECK: vpshlb 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x94,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlb 485498096, %xmm15, %xmm15

// CHECK: vpshlb 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x94,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlb 485498096, %xmm6, %xmm6

// CHECK: vpshlb 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x94,0x7c,0x82,0x40]
vpshlb 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshlb -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x94,0x7c,0x82,0xc0]
vpshlb -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshlb 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x94,0x74,0x82,0x40]
vpshlb 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshlb -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x94,0x74,0x82,0xc0]
vpshlb -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshlb 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x94,0x7c,0x02,0x40]
vpshlb 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpshlb 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x94,0x74,0x02,0x40]
vpshlb 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpshlb 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x94,0x7a,0x40]
vpshlb 64(%rdx), %xmm15, %xmm15

// CHECK: vpshlb 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x94,0x72,0x40]
vpshlb 64(%rdx), %xmm6, %xmm6

// CHECK: vpshlb (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x94,0x3a]
vpshlb (%rdx), %xmm15, %xmm15

// CHECK: vpshlb (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x94,0x32]
vpshlb (%rdx), %xmm6, %xmm6

// CHECK: vpshlb %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x94,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlb %xmm15, 485498096, %xmm15

// CHECK: vpshlb %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x94,0x7c,0x82,0x40]
vpshlb %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vpshlb %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x94,0x7c,0x82,0xc0]
vpshlb %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vpshlb %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x94,0x7c,0x02,0x40]
vpshlb %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vpshlb %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x94,0x7a,0x40]
vpshlb %xmm15, 64(%rdx), %xmm15

// CHECK: vpshlb %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x94,0x3a]
vpshlb %xmm15, (%rdx), %xmm15

// CHECK: vpshlb %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x94,0xff]
vpshlb %xmm15, %xmm15, %xmm15

// CHECK: vpshlb %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x94,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlb %xmm6, 485498096, %xmm6

// CHECK: vpshlb %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x94,0x74,0x82,0x40]
vpshlb %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vpshlb %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x94,0x74,0x82,0xc0]
vpshlb %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vpshlb %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x94,0x74,0x02,0x40]
vpshlb %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vpshlb %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x94,0x72,0x40]
vpshlb %xmm6, 64(%rdx), %xmm6

// CHECK: vpshlb %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x94,0x32]
vpshlb %xmm6, (%rdx), %xmm6

// CHECK: vpshlb %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x94,0xf6]
vpshlb %xmm6, %xmm6, %xmm6

// CHECK: vpshld 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x96,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshld 485498096, %xmm15, %xmm15

// CHECK: vpshld 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x96,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshld 485498096, %xmm6, %xmm6

// CHECK: vpshld 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x96,0x7c,0x82,0x40]
vpshld 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshld -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x96,0x7c,0x82,0xc0]
vpshld -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshld 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x96,0x74,0x82,0x40]
vpshld 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshld -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x96,0x74,0x82,0xc0]
vpshld -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshld 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x96,0x7c,0x02,0x40]
vpshld 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpshld 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x96,0x74,0x02,0x40]
vpshld 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpshld 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x96,0x7a,0x40]
vpshld 64(%rdx), %xmm15, %xmm15

// CHECK: vpshld 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x96,0x72,0x40]
vpshld 64(%rdx), %xmm6, %xmm6

// CHECK: vpshld (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x96,0x3a]
vpshld (%rdx), %xmm15, %xmm15

// CHECK: vpshld (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x96,0x32]
vpshld (%rdx), %xmm6, %xmm6

// CHECK: vpshld %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x96,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshld %xmm15, 485498096, %xmm15

// CHECK: vpshld %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x96,0x7c,0x82,0x40]
vpshld %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vpshld %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x96,0x7c,0x82,0xc0]
vpshld %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vpshld %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x96,0x7c,0x02,0x40]
vpshld %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vpshld %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x96,0x7a,0x40]
vpshld %xmm15, 64(%rdx), %xmm15

// CHECK: vpshld %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x96,0x3a]
vpshld %xmm15, (%rdx), %xmm15

// CHECK: vpshld %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x96,0xff]
vpshld %xmm15, %xmm15, %xmm15

// CHECK: vpshld %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x96,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshld %xmm6, 485498096, %xmm6

// CHECK: vpshld %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x96,0x74,0x82,0x40]
vpshld %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vpshld %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x96,0x74,0x82,0xc0]
vpshld %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vpshld %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x96,0x74,0x02,0x40]
vpshld %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vpshld %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x96,0x72,0x40]
vpshld %xmm6, 64(%rdx), %xmm6

// CHECK: vpshld %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x96,0x32]
vpshld %xmm6, (%rdx), %xmm6

// CHECK: vpshld %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x96,0xf6]
vpshld %xmm6, %xmm6, %xmm6

// CHECK: vpshlq 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x97,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlq 485498096, %xmm15, %xmm15

// CHECK: vpshlq 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x97,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlq 485498096, %xmm6, %xmm6

// CHECK: vpshlq 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x97,0x7c,0x82,0x40]
vpshlq 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshlq -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x97,0x7c,0x82,0xc0]
vpshlq -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshlq 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x97,0x74,0x82,0x40]
vpshlq 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshlq -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x97,0x74,0x82,0xc0]
vpshlq -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshlq 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x97,0x7c,0x02,0x40]
vpshlq 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpshlq 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x97,0x74,0x02,0x40]
vpshlq 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpshlq 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x97,0x7a,0x40]
vpshlq 64(%rdx), %xmm15, %xmm15

// CHECK: vpshlq 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x97,0x72,0x40]
vpshlq 64(%rdx), %xmm6, %xmm6

// CHECK: vpshlq (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x97,0x3a]
vpshlq (%rdx), %xmm15, %xmm15

// CHECK: vpshlq (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x97,0x32]
vpshlq (%rdx), %xmm6, %xmm6

// CHECK: vpshlq %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x97,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlq %xmm15, 485498096, %xmm15

// CHECK: vpshlq %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x97,0x7c,0x82,0x40]
vpshlq %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vpshlq %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x97,0x7c,0x82,0xc0]
vpshlq %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vpshlq %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x97,0x7c,0x02,0x40]
vpshlq %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vpshlq %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x97,0x7a,0x40]
vpshlq %xmm15, 64(%rdx), %xmm15

// CHECK: vpshlq %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x97,0x3a]
vpshlq %xmm15, (%rdx), %xmm15

// CHECK: vpshlq %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x97,0xff]
vpshlq %xmm15, %xmm15, %xmm15

// CHECK: vpshlq %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x97,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlq %xmm6, 485498096, %xmm6

// CHECK: vpshlq %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x97,0x74,0x82,0x40]
vpshlq %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vpshlq %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x97,0x74,0x82,0xc0]
vpshlq %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vpshlq %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x97,0x74,0x02,0x40]
vpshlq %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vpshlq %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x97,0x72,0x40]
vpshlq %xmm6, 64(%rdx), %xmm6

// CHECK: vpshlq %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x97,0x32]
vpshlq %xmm6, (%rdx), %xmm6

// CHECK: vpshlq %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x97,0xf6]
vpshlq %xmm6, %xmm6, %xmm6

// CHECK: vpshlw 485498096, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x95,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlw 485498096, %xmm15, %xmm15

// CHECK: vpshlw 485498096, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x95,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlw 485498096, %xmm6, %xmm6

// CHECK: vpshlw 64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x95,0x7c,0x82,0x40]
vpshlw 64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshlw -64(%rdx,%rax,4), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x95,0x7c,0x82,0xc0]
vpshlw -64(%rdx,%rax,4), %xmm15, %xmm15

// CHECK: vpshlw 64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x95,0x74,0x82,0x40]
vpshlw 64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshlw -64(%rdx,%rax,4), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x95,0x74,0x82,0xc0]
vpshlw -64(%rdx,%rax,4), %xmm6, %xmm6

// CHECK: vpshlw 64(%rdx,%rax), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x95,0x7c,0x02,0x40]
vpshlw 64(%rdx,%rax), %xmm15, %xmm15

// CHECK: vpshlw 64(%rdx,%rax), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x95,0x74,0x02,0x40]
vpshlw 64(%rdx,%rax), %xmm6, %xmm6

// CHECK: vpshlw 64(%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x95,0x7a,0x40]
vpshlw 64(%rdx), %xmm15, %xmm15

// CHECK: vpshlw 64(%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x95,0x72,0x40]
vpshlw 64(%rdx), %xmm6, %xmm6

// CHECK: vpshlw (%rdx), %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x69,0x80,0x95,0x3a]
vpshlw (%rdx), %xmm15, %xmm15

// CHECK: vpshlw (%rdx), %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0xc8,0x95,0x32]
vpshlw (%rdx), %xmm6, %xmm6

// CHECK: vpshlw %xmm15, 485498096, %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x95,0x3c,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlw %xmm15, 485498096, %xmm15

// CHECK: vpshlw %xmm15, 64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x95,0x7c,0x82,0x40]
vpshlw %xmm15, 64(%rdx,%rax,4), %xmm15

// CHECK: vpshlw %xmm15, -64(%rdx,%rax,4), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x95,0x7c,0x82,0xc0]
vpshlw %xmm15, -64(%rdx,%rax,4), %xmm15

// CHECK: vpshlw %xmm15, 64(%rdx,%rax), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x95,0x7c,0x02,0x40]
vpshlw %xmm15, 64(%rdx,%rax), %xmm15

// CHECK: vpshlw %xmm15, 64(%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x95,0x7a,0x40]
vpshlw %xmm15, 64(%rdx), %xmm15

// CHECK: vpshlw %xmm15, (%rdx), %xmm15
// CHECK: encoding: [0x8f,0x69,0x00,0x95,0x3a]
vpshlw %xmm15, (%rdx), %xmm15

// CHECK: vpshlw %xmm15, %xmm15, %xmm15
// CHECK: encoding: [0x8f,0x49,0x00,0x95,0xff]
vpshlw %xmm15, %xmm15, %xmm15

// CHECK: vpshlw %xmm6, 485498096, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x95,0x34,0x25,0xf0,0x1c,0xf0,0x1c]
vpshlw %xmm6, 485498096, %xmm6

// CHECK: vpshlw %xmm6, 64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x95,0x74,0x82,0x40]
vpshlw %xmm6, 64(%rdx,%rax,4), %xmm6

// CHECK: vpshlw %xmm6, -64(%rdx,%rax,4), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x95,0x74,0x82,0xc0]
vpshlw %xmm6, -64(%rdx,%rax,4), %xmm6

// CHECK: vpshlw %xmm6, 64(%rdx,%rax), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x95,0x74,0x02,0x40]
vpshlw %xmm6, 64(%rdx,%rax), %xmm6

// CHECK: vpshlw %xmm6, 64(%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x95,0x72,0x40]
vpshlw %xmm6, 64(%rdx), %xmm6

// CHECK: vpshlw %xmm6, (%rdx), %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x95,0x32]
vpshlw %xmm6, (%rdx), %xmm6

// CHECK: vpshlw %xmm6, %xmm6, %xmm6
// CHECK: encoding: [0x8f,0xe9,0x48,0x95,0xf6]
vpshlw %xmm6, %xmm6, %xmm6

