; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=instcombine -S < %s | FileCheck %s

define i1 @test1(i32 %n, i32 %d) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 %d, %n
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 %n, %d
  %cmp1 = icmp eq i32 %div, 0
  ret i1 %cmp1
}

define <2 x i1> @test1vec(<2 x i32> %n, <2 x i32> %d) {
; CHECK-LABEL: @test1vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt <2 x i32> %d, %n
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> %n, %d
  %cmp1 = icmp eq <2 x i32> %div, zeroinitializer
  ret <2 x i1> %cmp1
}

define i1 @test2(i32 %d) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 %d, 64
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 64, %d
  %cmp1 = icmp eq i32 %div, 0
  ret i1 %cmp1
}

define <2 x i1> @test2vec(<2 x i32> %d) {
; CHECK-LABEL: @test2vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt <2 x i32> %d, <i32 64, i32 63>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 64, i32 63>, %d
  %cmp1 = icmp eq <2 x i32> %div, zeroinitializer
  ret <2 x i1> %cmp1
}

define i1 @test3(i32 %n, i32 %d) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ule i32 %d, %n
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 %n, %d
  %cmp1 = icmp ne i32 %div, 0
  ret i1 %cmp1
}

define <2 x i1> @test3vec(<2 x i32> %n, <2 x i32> %d) {
; CHECK-LABEL: @test3vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ule <2 x i32> %d, %n
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> %n, %d
  %cmp1 = icmp ne <2 x i32> %div, zeroinitializer
  ret <2 x i1> %cmp1
}

define i1 @test4(i32 %d) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i32 %d, 65
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 64, %d
  %cmp1 = icmp ne i32 %div, 0
  ret i1 %cmp1
}

define <2 x i1> @test4vec(<2 x i32> %d) {
; CHECK-LABEL: @test4vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult <2 x i32> %d, <i32 65, i32 66>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 64, i32 65>, %d
  %cmp1 = icmp ne <2 x i32> %div, zeroinitializer
  ret <2 x i1> %cmp1
}

define i1 @test5(i32 %d) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret i1 true
;
  %div = udiv i32 -1, %d
  %cmp1 = icmp ne i32 %div, 0
  ret i1 %cmp1
}

define <2 x i1> @test5vec(<2 x i32> %d) {
; CHECK-LABEL: @test5vec(
; CHECK-NEXT:    ret <2 x i1> <i1 true, i1 true>
;
  %div = udiv <2 x i32> <i32 -1, i32 -1>, %d
  %cmp1 = icmp ne <2 x i32> %div, zeroinitializer
  ret <2 x i1> %cmp1
}

define i1 @test6(i32 %d) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i32 %d, 6
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 5, %d
  %cmp1 = icmp ugt i32 %div, 0
  ret i1 %cmp1
}

define <2 x i1> @test6vec(<2 x i32> %d) {
; CHECK-LABEL: @test6vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult <2 x i32> %d, <i32 6, i32 6>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 5, i32 5>, %d
  %cmp1 = icmp ugt <2 x i32> %div, zeroinitializer
  ret <2 x i1> %cmp1
}

; (icmp ugt (udiv C1, X), C1) -> false.
define i1 @test7(i32 %d) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:    ret i1 false
;
  %div = udiv i32 8, %d
  %cmp1 = icmp ugt i32 %div, 8
  ret i1 %cmp1
}

define <2 x i1> @test7vec(<2 x i32> %d) {
; CHECK-LABEL: @test7vec(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %div = udiv <2 x i32> <i32 8, i32 8>, %d
  %cmp1 = icmp ugt <2 x i32> %div, <i32 8, i32 8>
  ret <2 x i1> %cmp1
}

define i1 @test8(i32 %d) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i32 %d, 2
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ugt i32 %div, 3
  ret i1 %cmp1
}

define <2 x i1> @test8vec(<2 x i32> %d) {
; CHECK-LABEL: @test8vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult <2 x i32> %d, <i32 2, i32 2>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ugt <2 x i32> %div, <i32 3, i32 3>
  ret <2 x i1> %cmp1
}

define i1 @test9(i32 %d) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i32 %d, 2
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ugt i32 %div, 2
  ret i1 %cmp1
}

define <2 x i1> @test9vec(<2 x i32> %d) {
; CHECK-LABEL: @test9vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult <2 x i32> %d, <i32 2, i32 2>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ugt <2 x i32> %div, <i32 2, i32 2>
  ret <2 x i1> %cmp1
}

define i1 @test10(i32 %d) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult i32 %d, 3
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ugt i32 %div, 1
  ret i1 %cmp1
}

define <2 x i1> @test10vec(<2 x i32> %d) {
; CHECK-LABEL: @test10vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ult <2 x i32> %d, <i32 3, i32 3>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ugt <2 x i32> %div, <i32 1, i32 1>
  ret <2 x i1> %cmp1
}

define i1 @test11(i32 %d) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 %d, 4
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ult i32 %div, 1
  ret i1 %cmp1
}

define <2 x i1> @test11vec(<2 x i32> %d) {
; CHECK-LABEL: @test11vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt <2 x i32> %d, <i32 4, i32 4>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ult <2 x i32> %div, <i32 1, i32 1>
  ret <2 x i1> %cmp1
}

define i1 @test12(i32 %d) {
; CHECK-LABEL: @test12(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 %d, 2
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ult i32 %div, 2
  ret i1 %cmp1
}

define <2 x i1> @test12vec(<2 x i32> %d) {
; CHECK-LABEL: @test12vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt <2 x i32> %d, <i32 2, i32 2>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ult <2 x i32> %div, <i32 2, i32 2>
  ret <2 x i1> %cmp1
}

define i1 @test13(i32 %d) {
; CHECK-LABEL: @test13(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 %d, 1
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ult i32 %div, 3
  ret i1 %cmp1
}

define <2 x i1> @test13vec(<2 x i32> %d) {
; CHECK-LABEL: @test13vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt <2 x i32> %d, <i32 1, i32 1>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ult <2 x i32> %div, <i32 3, i32 3>
  ret <2 x i1> %cmp1
}

define i1 @test14(i32 %d) {
; CHECK-LABEL: @test14(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt i32 %d, 1
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ult i32 %div, 4
  ret i1 %cmp1
}

define <2 x i1> @test14vec(<2 x i32> %d) {
; CHECK-LABEL: @test14vec(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ugt <2 x i32> %d, <i32 1, i32 1>
; CHECK-NEXT:    ret <2 x i1> [[CMP1]]
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ult <2 x i32> %div, <i32 4, i32 4>
  ret <2 x i1> %cmp1
}

; icmp ugt X, UINT_MAX -> false.
define i1 @test15(i32 %d) {
; CHECK-LABEL: @test15(
; CHECK-NEXT:    ret i1 false
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ugt i32 %div, -1
  ret i1 %cmp1
}

define <2 x i1> @test15vec(<2 x i32> %d) {
; CHECK-LABEL: @test15vec(
; CHECK-NEXT:    ret <2 x i1> zeroinitializer
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ugt <2 x i32> %div, <i32 -1, i32 -1>
  ret <2 x i1> %cmp1
}

; icmp ult X, UINT_MAX -> true.
define i1 @test16(i32 %d) {
; CHECK-LABEL: @test16(
; CHECK-NEXT:    ret i1 true
;
  %div = udiv i32 4, %d
  %cmp1 = icmp ult i32 %div, -1
  ret i1 %cmp1
}

define <2 x i1> @test16vec(<2 x i32> %d) {
; CHECK-LABEL: @test16vec(
; CHECK-NEXT:    ret <2 x i1> <i1 true, i1 true>
;
  %div = udiv <2 x i32> <i32 4, i32 4>, %d
  %cmp1 = icmp ult <2 x i32> %div, <i32 -1, i32 -1>
  ret <2 x i1> %cmp1
}

