; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -S -loop-flatten -verify-loop-info -verify-dom-info -verify-scev -verify | FileCheck %s

; Testcase of PR49571
; Previously we had an assertion that the incoming value from the
; loop latch (%inc) is the same as the operator in the compare
; statement (%0). This does not necessarily hold as demonstrated
; in the following case.

define dso_local void @main() {
; CHECK-LABEL: @main(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br label [[FOR_COND:%.*]]
; CHECK:       for.cond:
; CHECK-NEXT:    br label [[FOR_BODY:%.*]]
; CHECK:       for.body:
; CHECK-NEXT:    [[A_03:%.*]] = phi i32 [ 0, [[FOR_COND]] ], [ [[INC:%.*]], [[FOR_INC:%.*]] ]
; CHECK-NEXT:    br label [[FOR_INC]]
; CHECK:       for.inc:
; CHECK-NEXT:    [[TMP0:%.*]] = add i32 [[A_03]], 1
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i32 [[TMP0]], 10
; CHECK-NEXT:    [[INC]] = add nsw i32 [[A_03]], 1
; CHECK-NEXT:    br i1 [[CMP]], label [[FOR_BODY]], label [[FOR_END:%.*]]
; CHECK:       for.end:
; CHECK-NEXT:    br label [[FOR_COND]]
;
entry:
  br label %for.cond

for.cond:                                         ; preds = %for.end, %entry
  br label %for.body

for.body:                                         ; preds = %for.inc, %for.cond
  %a.03 = phi i32 [ 0, %for.cond ], [ %inc, %for.inc ]
  br label %for.inc

for.inc:                                          ; preds = %for.body
  %0 = add i32 %a.03, 1
  %cmp = icmp slt i32 %0, 10
  %inc = add nsw i32 %a.03, 1
  br i1 %cmp, label %for.body, label %for.end

for.end:                                          ; preds = %for.inc
  br label %for.cond
}
