; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -slp-vectorizer -S | FileCheck %s

target triple = "aarch64--linux-gnu"

; This checks that we we prefer splats rather than load vectors + shuffles.
; A load + broadcast can be done efficiently with a single `ld1r` instruction.
define void @splat_loads_double(double *%array1, double *%array2, double *%ptrA, double *%ptrB) {
; CHECK-LABEL: @splat_loads_double(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_1_0:%.*]] = getelementptr inbounds double, double* [[ARRAY1:%.*]], i64 0
; CHECK-NEXT:    [[GEP_2_0:%.*]] = getelementptr inbounds double, double* [[ARRAY2:%.*]], i64 0
; CHECK-NEXT:    [[GEP_2_1:%.*]] = getelementptr inbounds double, double* [[ARRAY2]], i64 1
; CHECK-NEXT:    [[LD_2_0:%.*]] = load double, double* [[GEP_2_0]], align 8
; CHECK-NEXT:    [[LD_2_1:%.*]] = load double, double* [[GEP_2_1]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast double* [[GEP_1_0]] to <2 x double>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x double>, <2 x double>* [[TMP0]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = insertelement <2 x double> poison, double [[LD_2_0]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = insertelement <2 x double> [[TMP2]], double [[LD_2_0]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = fmul <2 x double> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = insertelement <2 x double> poison, double [[LD_2_1]], i32 0
; CHECK-NEXT:    [[TMP6:%.*]] = insertelement <2 x double> [[TMP5]], double [[LD_2_1]], i32 1
; CHECK-NEXT:    [[TMP7:%.*]] = fmul <2 x double> [[TMP1]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = fadd <2 x double> [[TMP4]], [[TMP7]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast double* [[GEP_1_0]] to <2 x double>*
; CHECK-NEXT:    store <2 x double> [[TMP8]], <2 x double>* [[TMP9]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %gep_1_0 = getelementptr inbounds double, double* %array1, i64 0
  %gep_1_1 = getelementptr inbounds double, double* %array1, i64 1
  %ld_1_0 = load double, double* %gep_1_0, align 8
  %ld_1_1 = load double, double* %gep_1_1, align 8

  %gep_2_0 = getelementptr inbounds double, double* %array2, i64 0
  %gep_2_1 = getelementptr inbounds double, double* %array2, i64 1
  %ld_2_0 = load double, double* %gep_2_0, align 8
  %ld_2_1 = load double, double* %gep_2_1, align 8

  %mul0 = fmul double %ld_1_0, %ld_2_0
  %mul1 = fmul double %ld_1_1, %ld_2_0

  %mul2 = fmul double %ld_1_0, %ld_2_1
  %mul3 = fmul double %ld_1_1, %ld_2_1

  %add0 = fadd double %mul0, %mul2
  %add1 = fadd double %mul1, %mul3

  store double %add0, double *%gep_1_0
  store double %add1, double *%gep_1_1
  ret void
}

; Same but with float instead of double
define void @splat_loads_float(float *%array1, float *%array2, float *%ptrA, float *%ptrB) {
; CHECK-LABEL: @splat_loads_float(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_1_0:%.*]] = getelementptr inbounds float, float* [[ARRAY1:%.*]], i64 0
; CHECK-NEXT:    [[GEP_2_0:%.*]] = getelementptr inbounds float, float* [[ARRAY2:%.*]], i64 0
; CHECK-NEXT:    [[GEP_2_1:%.*]] = getelementptr inbounds float, float* [[ARRAY2]], i64 1
; CHECK-NEXT:    [[LD_2_0:%.*]] = load float, float* [[GEP_2_0]], align 8
; CHECK-NEXT:    [[LD_2_1:%.*]] = load float, float* [[GEP_2_1]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast float* [[GEP_1_0]] to <2 x float>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x float>, <2 x float>* [[TMP0]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = insertelement <2 x float> poison, float [[LD_2_0]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = insertelement <2 x float> [[TMP2]], float [[LD_2_0]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = fmul <2 x float> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = insertelement <2 x float> poison, float [[LD_2_1]], i32 0
; CHECK-NEXT:    [[TMP6:%.*]] = insertelement <2 x float> [[TMP5]], float [[LD_2_1]], i32 1
; CHECK-NEXT:    [[TMP7:%.*]] = fmul <2 x float> [[TMP1]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = fadd <2 x float> [[TMP4]], [[TMP7]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast float* [[GEP_1_0]] to <2 x float>*
; CHECK-NEXT:    store <2 x float> [[TMP8]], <2 x float>* [[TMP9]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %gep_1_0 = getelementptr inbounds float, float* %array1, i64 0
  %gep_1_1 = getelementptr inbounds float, float* %array1, i64 1
  %ld_1_0 = load float, float* %gep_1_0, align 8
  %ld_1_1 = load float, float* %gep_1_1, align 8

  %gep_2_0 = getelementptr inbounds float, float* %array2, i64 0
  %gep_2_1 = getelementptr inbounds float, float* %array2, i64 1
  %ld_2_0 = load float, float* %gep_2_0, align 8
  %ld_2_1 = load float, float* %gep_2_1, align 8

  %mul0 = fmul float %ld_1_0, %ld_2_0
  %mul1 = fmul float %ld_1_1, %ld_2_0

  %mul2 = fmul float %ld_1_0, %ld_2_1
  %mul3 = fmul float %ld_1_1, %ld_2_1

  %add0 = fadd float %mul0, %mul2
  %add1 = fadd float %mul1, %mul3

  store float %add0, float *%gep_1_0
  store float %add1, float *%gep_1_1
  ret void
}

; Same but with i64
define void @splat_loads_i64(i64 *%array1, i64 *%array2, i64 *%ptrA, i64 *%ptrB) {
; CHECK-LABEL: @splat_loads_i64(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_1_0:%.*]] = getelementptr inbounds i64, i64* [[ARRAY1:%.*]], i64 0
; CHECK-NEXT:    [[GEP_2_0:%.*]] = getelementptr inbounds i64, i64* [[ARRAY2:%.*]], i64 0
; CHECK-NEXT:    [[GEP_2_1:%.*]] = getelementptr inbounds i64, i64* [[ARRAY2]], i64 1
; CHECK-NEXT:    [[LD_2_0:%.*]] = load i64, i64* [[GEP_2_0]], align 8
; CHECK-NEXT:    [[LD_2_1:%.*]] = load i64, i64* [[GEP_2_1]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i64* [[GEP_1_0]] to <2 x i64>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i64>, <2 x i64>* [[TMP0]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = insertelement <2 x i64> poison, i64 [[LD_2_0]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = insertelement <2 x i64> [[TMP2]], i64 [[LD_2_0]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = or <2 x i64> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = insertelement <2 x i64> poison, i64 [[LD_2_1]], i32 0
; CHECK-NEXT:    [[TMP6:%.*]] = insertelement <2 x i64> [[TMP5]], i64 [[LD_2_1]], i32 1
; CHECK-NEXT:    [[TMP7:%.*]] = or <2 x i64> [[TMP1]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = add <2 x i64> [[TMP4]], [[TMP7]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast i64* [[GEP_1_0]] to <2 x i64>*
; CHECK-NEXT:    store <2 x i64> [[TMP8]], <2 x i64>* [[TMP9]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %gep_1_0 = getelementptr inbounds i64, i64* %array1, i64 0
  %gep_1_1 = getelementptr inbounds i64, i64* %array1, i64 1
  %ld_1_0 = load i64, i64* %gep_1_0, align 8
  %ld_1_1 = load i64, i64* %gep_1_1, align 8

  %gep_2_0 = getelementptr inbounds i64, i64* %array2, i64 0
  %gep_2_1 = getelementptr inbounds i64, i64* %array2, i64 1
  %ld_2_0 = load i64, i64* %gep_2_0, align 8
  %ld_2_1 = load i64, i64* %gep_2_1, align 8

  %or0 = or i64 %ld_1_0, %ld_2_0
  %or1 = or i64 %ld_1_1, %ld_2_0

  %or2 = or i64 %ld_1_0, %ld_2_1
  %or3 = or i64 %ld_1_1, %ld_2_1

  %add0 = add i64 %or0, %or2
  %add1 = add i64 %or1, %or3

  store i64 %add0, i64 *%gep_1_0
  store i64 %add1, i64 *%gep_1_1
  ret void
}

; Same but with i32
define void @splat_loads_i32(i32 *%array1, i32 *%array2, i32 *%ptrA, i32 *%ptrB) {
; CHECK-LABEL: @splat_loads_i32(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[GEP_1_0:%.*]] = getelementptr inbounds i32, i32* [[ARRAY1:%.*]], i64 0
; CHECK-NEXT:    [[GEP_2_0:%.*]] = getelementptr inbounds i32, i32* [[ARRAY2:%.*]], i64 0
; CHECK-NEXT:    [[GEP_2_1:%.*]] = getelementptr inbounds i32, i32* [[ARRAY2]], i64 1
; CHECK-NEXT:    [[LD_2_0:%.*]] = load i32, i32* [[GEP_2_0]], align 8
; CHECK-NEXT:    [[LD_2_1:%.*]] = load i32, i32* [[GEP_2_1]], align 8
; CHECK-NEXT:    [[TMP0:%.*]] = bitcast i32* [[GEP_1_0]] to <2 x i32>*
; CHECK-NEXT:    [[TMP1:%.*]] = load <2 x i32>, <2 x i32>* [[TMP0]], align 8
; CHECK-NEXT:    [[TMP2:%.*]] = insertelement <2 x i32> poison, i32 [[LD_2_0]], i32 0
; CHECK-NEXT:    [[TMP3:%.*]] = insertelement <2 x i32> [[TMP2]], i32 [[LD_2_0]], i32 1
; CHECK-NEXT:    [[TMP4:%.*]] = or <2 x i32> [[TMP1]], [[TMP3]]
; CHECK-NEXT:    [[TMP5:%.*]] = insertelement <2 x i32> poison, i32 [[LD_2_1]], i32 0
; CHECK-NEXT:    [[TMP6:%.*]] = insertelement <2 x i32> [[TMP5]], i32 [[LD_2_1]], i32 1
; CHECK-NEXT:    [[TMP7:%.*]] = or <2 x i32> [[TMP1]], [[TMP6]]
; CHECK-NEXT:    [[TMP8:%.*]] = add <2 x i32> [[TMP4]], [[TMP7]]
; CHECK-NEXT:    [[TMP9:%.*]] = bitcast i32* [[GEP_1_0]] to <2 x i32>*
; CHECK-NEXT:    store <2 x i32> [[TMP8]], <2 x i32>* [[TMP9]], align 4
; CHECK-NEXT:    ret void
;
entry:
  %gep_1_0 = getelementptr inbounds i32, i32* %array1, i64 0
  %gep_1_1 = getelementptr inbounds i32, i32* %array1, i64 1
  %ld_1_0 = load i32, i32* %gep_1_0, align 8
  %ld_1_1 = load i32, i32* %gep_1_1, align 8

  %gep_2_0 = getelementptr inbounds i32, i32* %array2, i64 0
  %gep_2_1 = getelementptr inbounds i32, i32* %array2, i64 1
  %ld_2_0 = load i32, i32* %gep_2_0, align 8
  %ld_2_1 = load i32, i32* %gep_2_1, align 8

  %or0 = or i32 %ld_1_0, %ld_2_0
  %or1 = or i32 %ld_1_1, %ld_2_0

  %or2 = or i32 %ld_1_0, %ld_2_1
  %or3 = or i32 %ld_1_1, %ld_2_1

  %add0 = add i32 %or0, %or2
  %add1 = add i32 %or1, %or3

  store i32 %add0, i32 *%gep_1_0
  store i32 %add1, i32 *%gep_1_1
  ret void
}
