; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -mtriple=x86_64-linux-gnu -mcpu=x86-64 -basic-aa -slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-linux-gnu -mcpu=x86-64-v2 -basic-aa -slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-linux-gnu -mcpu=x86-64-v3 -basic-aa -slp-vectorizer -S | FileCheck %s
; RUN: opt < %s -mtriple=x86_64-linux-gnu -mcpu=x86-64-v4 -basic-aa -slp-vectorizer -S | FileCheck %s

define <2 x double> @buildvector_powi_2f64_6(<2 x double> %a) {
; CHECK-LABEL: @buildvector_powi_2f64_6(
; CHECK-NEXT:    [[TMP1:%.*]] = call <2 x double> @llvm.powi.v2f64.i32(<2 x double> [[A:%.*]], i32 6)
; CHECK-NEXT:    ret <2 x double> [[TMP1]]
;
  %a0 = extractelement <2 x double> %a, i32 0
  %a1 = extractelement <2 x double> %a, i32 1
  %c0  = call double @llvm.powi.f64(double %a0 , i32 6)
  %c1  = call double @llvm.powi.f64(double %a1 , i32 6)
  %r0 = insertelement <2 x double> poison, double %c0, i32 0
  %r1 = insertelement <2 x double> %r0,   double %c1, i32 1
  ret <2 x double> %r1
}

define <2 x double> @buildvector_powi_2f64_var(<2 x double> %a, i32 %b) {
; CHECK-LABEL: @buildvector_powi_2f64_var(
; CHECK-NEXT:    [[A0:%.*]] = extractelement <2 x double> [[A:%.*]], i32 0
; CHECK-NEXT:    [[A1:%.*]] = extractelement <2 x double> [[A]], i32 1
; CHECK-NEXT:    [[C0:%.*]] = call double @llvm.powi.f64.i32(double [[A0]], i32 [[B:%.*]])
; CHECK-NEXT:    [[C1:%.*]] = call double @llvm.powi.f64.i32(double [[A1]], i32 [[B]])
; CHECK-NEXT:    [[R0:%.*]] = insertelement <2 x double> poison, double [[C0]], i32 0
; CHECK-NEXT:    [[R1:%.*]] = insertelement <2 x double> [[R0]], double [[C1]], i32 1
; CHECK-NEXT:    ret <2 x double> [[R1]]
;
  %a0 = extractelement <2 x double> %a, i32 0
  %a1 = extractelement <2 x double> %a, i32 1
  %c0  = call double @llvm.powi.f64(double %a0 , i32 %b)
  %c1  = call double @llvm.powi.f64(double %a1 , i32 %b)
  %r0 = insertelement <2 x double> poison, double %c0, i32 0
  %r1 = insertelement <2 x double> %r0,   double %c1, i32 1
  ret <2 x double> %r1
}

define <4 x float> @buildvector_powi_4f32_3(<4 x float> %a) {
; CHECK-LABEL: @buildvector_powi_4f32_3(
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x float> @llvm.powi.v4f32.i32(<4 x float> [[A:%.*]], i32 3)
; CHECK-NEXT:    ret <4 x float> [[TMP1]]
;
  %a0 = extractelement <4 x float> %a, i32 0
  %a1 = extractelement <4 x float> %a, i32 1
  %a2 = extractelement <4 x float> %a, i32 2
  %a3 = extractelement <4 x float> %a, i32 3
  %c0  = call float @llvm.powi.f32(float %a0 , i32 3)
  %c1  = call float @llvm.powi.f32(float %a1 , i32 3)
  %c2  = call float @llvm.powi.f32(float %a2 , i32 3)
  %c3  = call float @llvm.powi.f32(float %a3 , i32 3)
  %r0 = insertelement <4 x float> poison, float %c0, i32 0
  %r1 = insertelement <4 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <4 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <4 x float> %r2,   float %c3, i32 3
  ret <4 x float> %r3
}

;
; 256-bit Vectors
;

define <4 x double> @buildvector_powi_4f64_16(<4 x double> %a) {
; CHECK-LABEL: @buildvector_powi_4f64_16(
; CHECK-NEXT:    [[TMP1:%.*]] = call <4 x double> @llvm.powi.v4f64.i32(<4 x double> [[A:%.*]], i32 16)
; CHECK-NEXT:    ret <4 x double> [[TMP1]]
;
  %a0 = extractelement <4 x double> %a, i32 0
  %a1 = extractelement <4 x double> %a, i32 1
  %a2 = extractelement <4 x double> %a, i32 2
  %a3 = extractelement <4 x double> %a, i32 3
  %c0  = call double @llvm.powi.f64(double %a0 , i32 16)
  %c1  = call double @llvm.powi.f64(double %a1 , i32 16)
  %c2  = call double @llvm.powi.f64(double %a2 , i32 16)
  %c3  = call double @llvm.powi.f64(double %a3 , i32 16)
  %r0 = insertelement <4 x double> poison, double %c0, i32 0
  %r1 = insertelement <4 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <4 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <4 x double> %r2,   double %c3, i32 3
  ret <4 x double> %r3
}

define <8 x float> @buildvector_powi_8f32_4(<8 x float> %a) {
; CHECK-LABEL: @buildvector_powi_8f32_4(
; CHECK-NEXT:    [[TMP1:%.*]] = call <8 x float> @llvm.powi.v8f32.i32(<8 x float> [[A:%.*]], i32 4)
; CHECK-NEXT:    ret <8 x float> [[TMP1]]
;
  %a0 = extractelement <8 x float> %a, i32 0
  %a1 = extractelement <8 x float> %a, i32 1
  %a2 = extractelement <8 x float> %a, i32 2
  %a3 = extractelement <8 x float> %a, i32 3
  %a4 = extractelement <8 x float> %a, i32 4
  %a5 = extractelement <8 x float> %a, i32 5
  %a6 = extractelement <8 x float> %a, i32 6
  %a7 = extractelement <8 x float> %a, i32 7
  %c0  = call float @llvm.powi.f32(float %a0 , i32 4)
  %c1  = call float @llvm.powi.f32(float %a1 , i32 4)
  %c2  = call float @llvm.powi.f32(float %a2 , i32 4)
  %c3  = call float @llvm.powi.f32(float %a3 , i32 4)
  %c4  = call float @llvm.powi.f32(float %a4 , i32 4)
  %c5  = call float @llvm.powi.f32(float %a5 , i32 4)
  %c6  = call float @llvm.powi.f32(float %a6 , i32 4)
  %c7  = call float @llvm.powi.f32(float %a7 , i32 4)
  %r0 = insertelement <8 x float> poison, float %c0, i32 0
  %r1 = insertelement <8 x float> %r0,   float %c1, i32 1
  %r2 = insertelement <8 x float> %r1,   float %c2, i32 2
  %r3 = insertelement <8 x float> %r2,   float %c3, i32 3
  %r4 = insertelement <8 x float> %r3,   float %c4, i32 4
  %r5 = insertelement <8 x float> %r4,   float %c5, i32 5
  %r6 = insertelement <8 x float> %r5,   float %c6, i32 6
  %r7 = insertelement <8 x float> %r6,   float %c7, i32 7
  ret <8 x float> %r7
}

;
; 512-bit Vectors
;

define <8 x double> @buildvector_powi_8f64_5(<8 x double> %a) {
; CHECK-LABEL: @buildvector_powi_8f64_5(
; CHECK-NEXT:    [[TMP1:%.*]] = call <8 x double> @llvm.powi.v8f64.i32(<8 x double> [[A:%.*]], i32 5)
; CHECK-NEXT:    ret <8 x double> [[TMP1]]
;
  %a0 = extractelement <8 x double> %a, i32 0
  %a1 = extractelement <8 x double> %a, i32 1
  %a2 = extractelement <8 x double> %a, i32 2
  %a3 = extractelement <8 x double> %a, i32 3
  %a4 = extractelement <8 x double> %a, i32 4
  %a5 = extractelement <8 x double> %a, i32 5
  %a6 = extractelement <8 x double> %a, i32 6
  %a7 = extractelement <8 x double> %a, i32 7
  %c0  = call double @llvm.powi.f64(double %a0 , i32 5)
  %c1  = call double @llvm.powi.f64(double %a1 , i32 5)
  %c2  = call double @llvm.powi.f64(double %a2 , i32 5)
  %c3  = call double @llvm.powi.f64(double %a3 , i32 5)
  %c4  = call double @llvm.powi.f64(double %a4 , i32 5)
  %c5  = call double @llvm.powi.f64(double %a5 , i32 5)
  %c6  = call double @llvm.powi.f64(double %a6 , i32 5)
  %c7  = call double @llvm.powi.f64(double %a7 , i32 5)
  %r0 = insertelement <8 x double> poison, double %c0, i32 0
  %r1 = insertelement <8 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <8 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <8 x double> %r2,   double %c3, i32 3
  %r4 = insertelement <8 x double> %r3,   double %c4, i32 4
  %r5 = insertelement <8 x double> %r4,   double %c5, i32 5
  %r6 = insertelement <8 x double> %r5,   double %c6, i32 6
  %r7 = insertelement <8 x double> %r6,   double %c7, i32 7
  ret <8 x double> %r7
}

define <8 x double> @buildvector_powi_8f64_mismatch(<8 x double> %a) {
; CHECK-LABEL: @buildvector_powi_8f64_mismatch(
; CHECK-NEXT:    [[A0:%.*]] = extractelement <8 x double> [[A:%.*]], i32 0
; CHECK-NEXT:    [[A1:%.*]] = extractelement <8 x double> [[A]], i32 1
; CHECK-NEXT:    [[A2:%.*]] = extractelement <8 x double> [[A]], i32 2
; CHECK-NEXT:    [[A3:%.*]] = extractelement <8 x double> [[A]], i32 3
; CHECK-NEXT:    [[A4:%.*]] = extractelement <8 x double> [[A]], i32 4
; CHECK-NEXT:    [[A5:%.*]] = extractelement <8 x double> [[A]], i32 5
; CHECK-NEXT:    [[A6:%.*]] = extractelement <8 x double> [[A]], i32 6
; CHECK-NEXT:    [[A7:%.*]] = extractelement <8 x double> [[A]], i32 7
; CHECK-NEXT:    [[C0:%.*]] = call double @llvm.powi.f64.i32(double [[A0]], i32 1)
; CHECK-NEXT:    [[C1:%.*]] = call double @llvm.powi.f64.i32(double [[A1]], i32 2)
; CHECK-NEXT:    [[C2:%.*]] = call double @llvm.powi.f64.i32(double [[A2]], i32 3)
; CHECK-NEXT:    [[C3:%.*]] = call double @llvm.powi.f64.i32(double [[A3]], i32 4)
; CHECK-NEXT:    [[C4:%.*]] = call double @llvm.powi.f64.i32(double [[A4]], i32 5)
; CHECK-NEXT:    [[C5:%.*]] = call double @llvm.powi.f64.i32(double [[A5]], i32 6)
; CHECK-NEXT:    [[C6:%.*]] = call double @llvm.powi.f64.i32(double [[A6]], i32 7)
; CHECK-NEXT:    [[C7:%.*]] = call double @llvm.powi.f64.i32(double [[A7]], i32 -8)
; CHECK-NEXT:    [[R0:%.*]] = insertelement <8 x double> poison, double [[C0]], i32 0
; CHECK-NEXT:    [[R1:%.*]] = insertelement <8 x double> [[R0]], double [[C1]], i32 1
; CHECK-NEXT:    [[R2:%.*]] = insertelement <8 x double> [[R1]], double [[C2]], i32 2
; CHECK-NEXT:    [[R3:%.*]] = insertelement <8 x double> [[R2]], double [[C3]], i32 3
; CHECK-NEXT:    [[R4:%.*]] = insertelement <8 x double> [[R3]], double [[C4]], i32 4
; CHECK-NEXT:    [[R5:%.*]] = insertelement <8 x double> [[R4]], double [[C5]], i32 5
; CHECK-NEXT:    [[R6:%.*]] = insertelement <8 x double> [[R5]], double [[C6]], i32 6
; CHECK-NEXT:    [[R7:%.*]] = insertelement <8 x double> [[R6]], double [[C7]], i32 7
; CHECK-NEXT:    ret <8 x double> [[R7]]
;
  %a0 = extractelement <8 x double> %a, i32 0
  %a1 = extractelement <8 x double> %a, i32 1
  %a2 = extractelement <8 x double> %a, i32 2
  %a3 = extractelement <8 x double> %a, i32 3
  %a4 = extractelement <8 x double> %a, i32 4
  %a5 = extractelement <8 x double> %a, i32 5
  %a6 = extractelement <8 x double> %a, i32 6
  %a7 = extractelement <8 x double> %a, i32 7
  %c0  = call double @llvm.powi.f64(double %a0 , i32 1)
  %c1  = call double @llvm.powi.f64(double %a1 , i32 2)
  %c2  = call double @llvm.powi.f64(double %a2 , i32 3)
  %c3  = call double @llvm.powi.f64(double %a3 , i32 4)
  %c4  = call double @llvm.powi.f64(double %a4 , i32 5)
  %c5  = call double @llvm.powi.f64(double %a5 , i32 6)
  %c6  = call double @llvm.powi.f64(double %a6 , i32 7)
  %c7  = call double @llvm.powi.f64(double %a7 , i32 -8)
  %r0 = insertelement <8 x double> poison, double %c0, i32 0
  %r1 = insertelement <8 x double> %r0,   double %c1, i32 1
  %r2 = insertelement <8 x double> %r1,   double %c2, i32 2
  %r3 = insertelement <8 x double> %r2,   double %c3, i32 3
  %r4 = insertelement <8 x double> %r3,   double %c4, i32 4
  %r5 = insertelement <8 x double> %r4,   double %c5, i32 5
  %r6 = insertelement <8 x double> %r5,   double %c6, i32 6
  %r7 = insertelement <8 x double> %r6,   double %c7, i32 7
  ret <8 x double> %r7
}

define <16 x float> @buildvector_powi_16f32_n13(<16 x float> %a) {
; CHECK-LABEL: @buildvector_powi_16f32_n13(
; CHECK-NEXT:    [[TMP1:%.*]] = call <16 x float> @llvm.powi.v16f32.i32(<16 x float> [[A:%.*]], i32 -13)
; CHECK-NEXT:    ret <16 x float> [[TMP1]]
;
  %a0  = extractelement <16 x float> %a, i32 0
  %a1  = extractelement <16 x float> %a, i32 1
  %a2  = extractelement <16 x float> %a, i32 2
  %a3  = extractelement <16 x float> %a, i32 3
  %a4  = extractelement <16 x float> %a, i32 4
  %a5  = extractelement <16 x float> %a, i32 5
  %a6  = extractelement <16 x float> %a, i32 6
  %a7  = extractelement <16 x float> %a, i32 7
  %a8  = extractelement <16 x float> %a, i32 8
  %a9  = extractelement <16 x float> %a, i32 9
  %a10 = extractelement <16 x float> %a, i32 10
  %a11 = extractelement <16 x float> %a, i32 11
  %a12 = extractelement <16 x float> %a, i32 12
  %a13 = extractelement <16 x float> %a, i32 13
  %a14 = extractelement <16 x float> %a, i32 14
  %a15 = extractelement <16 x float> %a, i32 15
  %c0  = call float @llvm.powi.f32(float %a0 , i32 -13)
  %c1  = call float @llvm.powi.f32(float %a1 , i32 -13)
  %c2  = call float @llvm.powi.f32(float %a2 , i32 -13)
  %c3  = call float @llvm.powi.f32(float %a3 , i32 -13)
  %c4  = call float @llvm.powi.f32(float %a4 , i32 -13)
  %c5  = call float @llvm.powi.f32(float %a5 , i32 -13)
  %c6  = call float @llvm.powi.f32(float %a6 , i32 -13)
  %c7  = call float @llvm.powi.f32(float %a7 , i32 -13)
  %c8  = call float @llvm.powi.f32(float %a8 , i32 -13)
  %c9  = call float @llvm.powi.f32(float %a9 , i32 -13)
  %c10 = call float @llvm.powi.f32(float %a10 , i32 -13)
  %c11 = call float @llvm.powi.f32(float %a11 , i32 -13)
  %c12 = call float @llvm.powi.f32(float %a12 , i32 -13)
  %c13 = call float @llvm.powi.f32(float %a13 , i32 -13)
  %c14 = call float @llvm.powi.f32(float %a14 , i32 -13)
  %c15 = call float @llvm.powi.f32(float %a15 , i32 -13)
  %r0  = insertelement <16 x float> poison, float %c0 , i32 0
  %r1  = insertelement <16 x float> %r0 ,  float %c1 , i32 1
  %r2  = insertelement <16 x float> %r1 ,  float %c2 , i32 2
  %r3  = insertelement <16 x float> %r2 ,  float %c3 , i32 3
  %r4  = insertelement <16 x float> %r3 ,  float %c4 , i32 4
  %r5  = insertelement <16 x float> %r4 ,  float %c5 , i32 5
  %r6  = insertelement <16 x float> %r5 ,  float %c6 , i32 6
  %r7  = insertelement <16 x float> %r6 ,  float %c7 , i32 7
  %r8  = insertelement <16 x float> %r7 ,  float %c8 , i32 8
  %r9  = insertelement <16 x float> %r8 ,  float %c9 , i32 9
  %r10 = insertelement <16 x float> %r9 ,  float %c10, i32 10
  %r11 = insertelement <16 x float> %r10,  float %c11, i32 11
  %r12 = insertelement <16 x float> %r11,  float %c12, i32 12
  %r13 = insertelement <16 x float> %r12,  float %c13, i32 13
  %r14 = insertelement <16 x float> %r13,  float %c14, i32 14
  %r15 = insertelement <16 x float> %r14,  float %c15, i32 15
  ret <16 x float> %r15
}

declare float @llvm.powi.f32(float, i32)
declare double @llvm.powi.f64(double, i32)
