/* ----- core/invsntrup857, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_invsntrup857_checksums[] = {
  "884d58c031b7f0ea5e9cbbc8274a3fa8b462f381f43d63d18fd1a2056d2c6742",
  "a5ad90978659be45ef3d4ce0ab6a151d4dfeaca2da7de476eb9b61d31b058f67",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_invsntrup857_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_invsntrup857_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_invsntrup857_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_invsntrup857_CONSTBYTES

static void *storage_core_invsntrup857_h;
static unsigned char *test_core_invsntrup857_h;
static void *storage_core_invsntrup857_n;
static unsigned char *test_core_invsntrup857_n;
static void *storage_core_invsntrup857_k;
static unsigned char *test_core_invsntrup857_k;
static void *storage_core_invsntrup857_c;
static unsigned char *test_core_invsntrup857_c;
static void *storage_core_invsntrup857_h2;
static unsigned char *test_core_invsntrup857_h2;
static void *storage_core_invsntrup857_n2;
static unsigned char *test_core_invsntrup857_n2;
static void *storage_core_invsntrup857_k2;
static unsigned char *test_core_invsntrup857_k2;
static void *storage_core_invsntrup857_c2;
static unsigned char *test_core_invsntrup857_c2;

#define precomputed_core_invsntrup857_NUM 4

static const unsigned char precomputed_core_invsntrup857_h[precomputed_core_invsntrup857_NUM][crypto_core_OUTPUTBYTES] = {
  {131,255,51,250,78,247,42,1,165,4,45,1,171,247,253,5,86,248,125,250,213,9,146,0,96,249,148,251,99,1,119,253,142,252,152,255,228,255,4,10,116,1,180,247,238,255,101,251,145,250,35,254,21,248,26,3,97,0,11,250,243,1,26,6,114,250,179,7,119,3,112,5,180,5,199,8,139,249,99,6,124,4,213,6,171,252,203,5,181,4,230,250,37,249,192,3,227,6,104,248,127,6,251,248,81,2,155,0,213,7,231,252,74,8,212,247,202,254,234,6,10,2,112,248,190,254,124,255,53,3,204,254,210,6,8,5,228,3,46,249,194,5,103,7,20,3,81,9,46,5,250,9,92,1,222,248,58,255,206,255,188,248,11,9,69,251,150,8,34,7,102,248,199,252,36,246,188,253,235,246,61,5,120,9,65,247,93,7,95,9,45,249,186,1,71,1,88,252,79,252,38,249,166,2,153,7,42,7,2,254,83,5,2,2,72,251,54,2,148,7,96,255,246,250,248,253,241,252,13,4,219,253,150,9,139,251,49,2,91,252,187,7,243,251,128,4,172,255,114,6,196,246,244,7,102,3,36,252,193,9,113,7,201,8,207,1,139,247,234,245,127,5,212,255,201,8,246,249,20,0,36,3,170,249,101,5,54,252,67,249,10,250,5,252,165,3,138,250,96,2,209,247,73,253,40,248,5,2,65,1,210,7,48,253,248,7,25,4,33,252,174,255,160,254,41,248,84,0,30,254,77,5,144,255,71,2,46,5,226,249,64,249,68,254,167,0,138,5,142,9,123,254,158,252,76,2,156,252,85,247,211,251,105,247,111,252,161,5,95,8,106,253,150,4,220,4,118,251,170,249,59,4,103,1,215,255,244,2,36,8,207,249,38,5,153,0,229,6,102,248,84,4,224,254,27,252,2,253,229,255,208,249,92,247,21,8,61,254,84,255,68,254,13,246,156,253,41,1,207,3,22,4,47,5,116,252,104,252,100,9,115,248,206,255,174,3,167,250,103,5,17,3,108,9,240,3,48,247,168,3,29,7,67,7,103,247,185,9,158,247,146,253,117,250,206,255,241,246,238,248,155,5,222,249,108,246,145,4,219,251,120,250,244,247,231,0,99,7,204,253,58,246,78,7,254,254,40,9,44,8,51,250,160,254,248,248,95,5,62,0,96,252,75,9,48,4,201,251,154,252,14,252,44,250,153,252,252,247,69,254,248,255,118,250,27,3,221,255,226,247,206,251,53,250,245,1,196,8,126,255,4,250,188,247,93,248,252,1,121,254,204,252,3,254,78,255,130,254,238,247,214,247,174,9,190,7,147,248,189,255,60,254,74,255,94,249,70,249,129,2,9,9,15,0,242,250,102,6,126,250,33,248,112,6,22,248,241,247,130,255,82,250,97,249,242,253,139,250,172,250,60,251,240,245,157,4,20,5,39,7,155,248,217,7,253,6,105,8,45,254,92,8,247,0,149,248,117,249,250,3,118,249,151,247,36,9,235,1,233,3,21,248,168,254,164,252,253,252,99,246,176,7,164,9,85,249,230,255,242,255,190,254,185,3,122,247,178,1,249,247,251,1,157,1,192,253,122,252,172,253,122,251,146,248,88,255,96,251,27,0,86,3,158,255,199,251,45,7,181,248,227,6,30,249,180,253,149,250,101,4,71,252,8,10,121,3,16,247,167,252,101,9,26,251,230,247,165,4,107,2,189,254,113,251,88,9,3,10,215,252,36,9,240,245,151,2,108,2,79,251,184,0,22,251,138,5,178,253,228,249,210,0,142,3,125,7,185,254,7,4,98,3,247,247,156,9,250,1,92,247,20,3,16,3,104,246,140,254,115,5,0,10,12,246,102,255,55,254,11,0,91,2,112,3,150,7,87,251,152,254,143,248,102,1,104,247,247,7,197,251,178,3,118,8,106,247,195,3,58,0,183,5,31,248,243,2,135,251,179,253,221,255,137,0,198,1,247,250,28,3,117,249,199,247,220,9,52,4,254,8,16,249,111,7,78,0,210,252,35,252,134,1,154,8,117,248,197,254,53,246,209,252,21,251,167,2,158,1,250,251,15,254,205,8,1,250,86,248,126,7,123,255,236,246,142,252,38,250,213,8,2,2,10,9,128,2,119,246,246,247,69,252,181,255,3,255,26,251,100,250,206,253,148,0,226,251,255,247,59,8,124,1,91,7,231,248,105,255,128,254,64,249,130,249,245,3,229,252,161,7,122,251,54,251,16,1,216,5,59,247,250,253,191,6,37,250,41,7,201,0,197,5,199,6,109,0,239,4,74,252,213,255,169,6,255,255,42,3,40,8,82,9,25,247,101,4,59,8,7,252,222,4,97,255,117,6,232,3,177,252,142,4,10,9,57,255,201,3,130,5,83,4,34,4,169,248,125,6,52,1,108,9,105,252,50,252,131,252,114,252,154,251,67,247,197,9,222,3,162,7,170,248,38,255,137,253,134,254,156,252,90,8,216,4,23,10,110,252,148,6,31,255,85,255,214,250,169,255,225,248,253,255,150,0,124,251,56,251,95,253,185,3,72,246,157,253,209,9,73,255,131,9,128,248,251,0,139,254,242,9,248,7,66,252,252,3,218,0,46,249,104,255,51,251,83,3,41,7,163,4,142,254,157,255,42,1,215,246,102,248,68,248,254,250,155,0,100,246,122,7,19,246,168,252,15,249,77,7,74,6,140,6,57,251,199,5,8,255,101,250,215,6,183,5,58,7,61,4,229,250,29,252,177,250,194,246,6,7,54,253,41,2,68,250,29,3,100,246,248,255,219,1,238,7,228,255,32,9,145,255,207,255,45,247,167,247,1,8,83,252,203,253,31,4,35,2,79,254,189,248,76,252,165,8,37,6,51,255,137,2,252,2,118,1,184,2,71,254,47,1,55,251,10,253,219,246,242,8,141,246,20,3,140,7,240,254,89,249,42,252,125,2,0,251,113,255,233,253,223,252,114,250,22,254,221,5,3,7,73,6,71,255,238,9,56,250,156,252,150,255,120,9,210,4,176,0,39,247,67,2,3,6,211,6,15,254,101,255,142,0,133,4,87,249,148,4,35,8,205,7,251,250,64,249,179,2,98,249,3,7,5,6,223,249,15,6,55,254,100,253,69,3,236,4,245,248,106,0,147,7,236,248,1,2,1,8,197,3,237,6,7,10,99,7,99,2,135,6,93,247,93,6,129,3,140,7,96,247,85,254,109,251,188,0,11,4,38,7,145,5,14,251,94,2,187,247,40,250,178,7,37,247,208,253,8,252,164,1,151,7,46,250,129,3,8,248,33,9,63,247,103,9,216,251,106,253,105,247,147,254,142,246,24,0,54,251,243,4,176,8,249,248,72,249,143,255,122,7,150,249,171,0,92,9,41,252,168,254,254,245,95,253,119,2,8,255,90,4,236,6,181,249,247,253,200,248,106,250,110,254,234,251,76,8,213,9,140,248,66,246,127,5,145,251,47,247,18,253,236,253,221,248,191,247,189,251,85,7,151,251,140,247,56,246,197,254,186,1,179,9,220,8,102,246,96,248,78,255,206,7,59,9,184,255,249,249,134,7,249,7,212,1,213,250,215,0,62,254,201,255,247,253,189,248,176,0,30,254,216,251,108,254,34,247,69,248,234,249,38,6,138,9,81,6,82,249,212,255,75,4,184,2,207,5,207,253,210,253,140,249,29,8,120,7,233,246,230,2,224,251,87,7,153,5,55,8,156,9,99,255,248,246,160,254,234,2,69,7,245,1,109,4,136,3,192,2,84,0,38,8,36,7,252,254,145,2,144,6,114,4,14,252,86,5,248,246,225,252,98,247,99,2,109,6,87,5,83,250,227,0,151,250,145,249,0},
  {120,1,126,5,195,247,55,249,198,249,151,250,150,4,243,245,136,251,46,255,250,4,82,3,199,2,204,3,160,3,86,3,109,249,113,6,170,248,219,248,22,252,113,250,211,254,7,254,86,3,168,2,88,250,15,253,242,6,5,2,160,248,8,2,109,246,107,1,43,4,53,247,184,5,66,248,92,5,64,1,138,3,84,254,202,255,206,250,246,247,28,9,114,255,113,0,69,9,99,1,144,9,210,9,103,5,65,248,7,2,0,246,40,7,251,245,97,0,215,249,47,251,95,251,163,255,45,8,27,248,49,8,32,249,36,254,76,247,157,254,68,8,188,3,19,247,17,10,195,253,207,9,205,0,6,0,6,246,205,246,238,253,233,254,81,0,183,248,128,249,69,5,72,247,160,1,168,248,16,0,194,252,105,248,109,2,177,4,111,254,206,251,109,249,204,252,116,247,221,255,193,253,147,8,22,248,252,4,34,5,32,246,157,2,77,253,138,249,217,6,253,250,173,249,172,249,9,247,127,7,146,0,238,9,247,1,160,249,198,250,158,250,216,246,207,3,14,248,240,2,163,4,57,8,218,248,46,255,21,10,32,7,235,5,254,251,233,8,115,8,54,252,176,248,173,252,248,251,40,0,174,0,190,246,5,246,11,248,228,8,144,254,255,9,175,7,203,9,112,246,22,251,175,2,171,9,173,254,249,246,242,1,63,246,61,252,239,6,216,2,23,1,91,8,78,0,165,6,26,8,18,7,240,253,230,7,237,252,52,250,119,252,178,2,245,9,226,248,195,5,135,3,226,6,85,5,55,254,42,249,254,255,74,249,49,255,190,249,156,252,210,251,16,7,13,255,70,8,194,249,90,255,31,250,117,248,33,3,3,1,145,5,252,251,48,3,1,248,82,248,29,8,160,250,145,0,114,254,21,2,18,251,145,9,27,5,4,1,12,0,63,248,200,251,116,250,141,6,125,8,152,253,8,253,63,248,193,246,12,8,80,7,177,250,120,249,55,253,212,9,237,8,76,250,57,9,206,3,108,4,70,252,238,250,110,5,6,5,14,7,65,254,49,250,3,0,213,246,159,1,89,251,162,5,43,255,222,253,0,254,15,8,141,6,249,252,212,0,216,254,244,5,86,251,91,9,147,1,97,2,32,255,102,8,24,247,160,248,105,249,14,249,98,255,145,2,84,246,35,1,94,250,246,1,19,5,208,5,215,7,82,248,169,1,105,252,16,249,187,8,243,4,170,255,170,255,58,252,66,9,219,246,61,8,45,9,220,0,218,6,198,5,98,9,110,255,78,248,196,1,52,4,249,4,181,253,223,2,200,253,66,253,185,255,85,8,88,250,208,255,171,7,236,255,116,248,232,254,85,6,150,254,61,7,40,253,242,4,40,0,212,255,115,7,71,254,152,252,44,247,166,250,82,246,59,250,0,5,26,7,206,253,36,246,192,254,232,254,65,254,137,5,5,252,231,8,84,248,131,248,220,5,209,250,36,1,133,254,105,249,220,6,246,8,4,251,242,3,197,251,153,0,179,246,237,253,103,4,30,3,44,248,235,248,91,9,182,249,139,0,242,5,253,253,82,253,103,0,238,245,209,252,47,249,1,2,166,8,68,251,180,253,90,4,195,8,1,3,13,253,19,7,101,9,204,247,246,3,27,246,22,246,93,255,81,0,156,246,204,5,244,253,239,250,88,9,101,255,227,6,12,250,241,251,240,245,170,1,57,250,139,254,217,3,168,2,53,7,40,6,57,6,199,249,182,8,68,251,105,250,59,7,4,254,171,9,62,1,239,249,255,4,103,250,248,0,151,8,206,8,250,5,251,247,111,247,24,6,54,2,207,254,87,9,182,7,29,5,87,253,18,8,175,246,97,5,138,0,131,1,202,252,104,252,130,251,226,251,195,248,123,247,177,1,47,248,14,7,3,249,244,255,11,5,140,9,178,252,123,253,52,5,178,0,152,250,137,251,157,254,141,8,28,1,156,248,176,8,251,254,136,248,185,253,241,247,118,247,24,6,161,250,69,254,147,250,151,249,145,6,6,2,91,254,70,8,143,251,86,247,245,0,63,1,98,255,181,5,21,7,213,5,7,8,45,248,60,7,241,8,228,249,196,248,214,9,225,6,210,246,19,246,221,255,114,8,216,4,28,2,175,5,51,252,252,9,172,5,211,255,251,249,211,255,165,7,106,250,254,8,167,6,181,5,177,248,191,249,116,2,162,254,149,5,221,249,248,9,150,255,33,4,64,2,77,5,70,254,200,253,134,251,57,254,182,251,136,246,189,254,159,246,222,255,0,255,217,6,110,3,172,251,137,8,220,7,146,9,225,255,14,254,25,9,60,8,123,3,89,247,141,3,124,249,38,246,18,249,17,5,211,248,204,5,117,3,3,9,10,248,53,6,27,251,17,246,170,246,80,9,244,2,183,5,204,8,16,1,96,255,53,248,47,252,253,250,118,4,4,246,226,247,249,3,105,247,62,2,201,250,108,250,138,4,152,252,161,251,220,254,142,250,45,254,58,0,173,253,65,250,147,254,8,7,30,248,22,0,228,4,78,7,113,2,30,246,122,247,216,6,96,1,216,5,19,248,106,246,254,3,255,249,226,252,142,254,66,247,188,0,18,6,89,7,245,249,151,254,23,1,145,249,9,1,50,253,141,247,160,6,187,9,144,248,17,2,59,9,109,5,186,6,109,9,142,5,163,9,67,8,44,8,190,249,106,246,198,7,233,9,21,0,74,251,236,5,85,6,62,250,163,2,166,9,223,8,102,4,137,254,90,3,79,247,1,252,79,249,25,6,89,4,133,248,14,4,228,7,124,246,139,252,192,251,205,253,175,248,155,253,34,251,131,7,217,0,54,251,185,248,197,4,250,255,130,4,86,250,134,4,152,0,131,254,117,249,80,8,250,250,44,254,114,252,36,6,121,9,113,254,234,2,209,249,215,6,219,255,13,255,53,254,162,8,105,0,189,246,53,5,115,253,194,1,122,3,75,5,1,249,2,3,8,251,122,254,99,248,188,9,240,8,63,9,123,3,240,9,26,246,226,247,151,5,11,254,184,3,121,5,62,254,132,252,247,255,176,7,76,4,203,8,103,9,116,1,46,249,154,248,98,2,36,248,249,8,42,255,218,3,48,3,85,1,141,4,188,4,104,2,32,9,172,8,164,248,218,0,83,246,142,254,7,250,32,2,99,7,146,8,123,2,84,252,93,6,23,250,86,6,22,3,135,247,99,3,4,6,129,254,147,0,211,0,103,255,52,5,22,250,45,246,165,3,20,1,90,255,116,251,103,7,154,255,125,5,186,6,79,249,120,252,199,3,121,252,108,9,1,250,65,255,104,2,23,2,234,7,80,5,27,246,121,0,76,2,79,1,249,252,14,246,17,9,40,3,137,255,209,7,42,254,91,4,173,252,253,254,198,6,164,255,20,7,179,7,248,4,155,7,138,251,215,252,252,250,185,248,49,0,180,255,34,7,246,6,190,8,203,3,31,250,186,3,209,1,42,253,214,255,132,249,26,255,227,1,237,9,11,10,97,9,252,254,254,252,208,0,142,2,88,247,97,9,195,0,230,250,126,253,163,252,249,0,219,2,191,253,210,252,180,249,14,8,194,0,201,8,86,252,127,5,28,0,246,7,13,7,134,252,86,3,206,254,100,249,184,6,120,3,150,8,30,250,31,7,96,250,237,249,250,2,223,248,158,251,117,254,151,4,35,4,198,6,58,255,101,252,133,6,172,248,68,252,242,9,231,251,38,246,127,249,29,246,21,255,209,249,122,253,80,254,86,5,216,247,117,246,150,251,74,8,0,249,210,255,65,3,107,6,7,252,168,9,0},
  {55,249,88,253,205,8,255,9,246,253,137,1,46,5,54,252,178,246,63,1,118,8,139,7,197,2,163,248,4,247,189,5,133,255,195,5,130,254,52,253,13,5,37,0,161,252,198,248,140,0,246,254,105,1,68,3,149,7,5,0,125,252,152,9,3,2,218,1,245,9,203,253,129,248,33,254,80,246,191,255,94,250,114,6,98,9,46,251,143,252,43,253,228,8,164,5,166,252,123,8,230,3,216,254,106,246,49,3,235,6,222,252,40,3,225,8,151,250,201,247,6,251,241,6,69,248,38,253,245,8,245,9,3,250,117,247,207,9,242,247,152,5,42,253,63,250,49,1,228,3,5,251,54,254,10,9,127,247,164,5,223,2,197,251,56,0,104,7,55,4,212,2,206,248,18,250,32,246,2,255,226,250,167,3,123,252,134,8,90,6,53,4,162,8,95,2,33,2,225,1,82,0,238,248,71,9,80,253,27,246,32,8,243,7,110,8,131,247,29,249,152,249,52,7,213,250,223,251,238,249,33,252,215,252,185,247,34,250,13,0,187,0,46,0,16,255,253,253,198,9,211,255,53,7,154,1,35,247,30,2,144,246,203,4,217,249,151,247,93,250,28,6,46,0,28,7,77,0,151,246,71,246,142,250,80,5,185,0,3,255,34,251,216,8,8,255,243,254,137,7,125,1,158,253,30,9,61,0,61,248,245,247,169,3,65,255,200,6,208,252,170,6,82,8,177,6,52,252,147,250,51,0,161,255,191,255,35,0,2,247,227,250,186,247,112,248,226,246,191,7,233,247,200,0,40,0,14,0,253,254,225,4,122,249,105,246,35,249,163,251,207,255,229,253,224,2,220,1,243,6,43,0,219,9,202,254,143,5,109,0,41,6,26,252,110,7,226,1,203,255,12,1,169,254,233,251,146,9,163,2,109,6,198,2,105,249,70,252,22,9,48,247,197,251,235,7,246,4,148,0,226,250,13,247,7,0,253,245,6,0,186,3,204,5,228,9,233,252,185,8,196,248,94,250,154,4,59,253,235,5,60,5,73,6,126,253,77,8,224,247,63,249,113,4,61,251,50,1,82,254,245,7,183,254,222,248,125,5,47,249,117,246,135,252,240,251,72,1,243,255,138,246,220,0,166,248,165,5,93,6,112,8,232,255,25,249,28,250,135,6,114,251,81,246,243,8,74,253,251,7,68,6,86,7,50,0,33,7,40,4,10,248,91,4,143,246,53,247,255,1,145,254,144,249,6,8,76,7,1,9,30,254,38,1,194,9,51,9,75,255,128,5,39,3,5,247,77,252,38,3,45,4,142,1,90,255,35,247,228,253,48,251,120,0,222,248,132,4,227,249,185,254,147,255,54,253,225,255,240,9,52,248,230,248,176,251,209,253,184,252,142,5,9,3,81,249,17,4,168,8,219,9,51,9,143,254,19,247,136,250,103,6,127,246,102,247,162,4,92,246,115,1,21,4,168,249,186,5,66,9,3,249,70,8,145,9,224,249,33,246,219,249,61,4,128,0,131,5,114,0,232,253,195,249,187,7,64,252,89,254,52,8,132,247,136,8,232,2,161,252,227,6,240,9,68,7,24,248,210,254,101,5,159,254,48,4,13,6,190,254,132,9,231,2,1,248,95,252,187,254,75,5,158,3,111,253,198,250,129,247,192,2,222,9,188,253,101,3,198,248,125,255,26,251,217,1,191,254,247,6,146,249,33,255,63,255,59,252,244,248,200,5,253,3,87,250,215,4,105,248,93,3,55,248,59,253,29,247,9,253,80,251,188,4,241,252,157,2,71,249,215,254,165,250,165,246,76,2,150,255,139,9,237,248,147,248,7,246,35,246,44,247,22,253,253,0,122,249,247,248,225,254,179,251,170,255,56,4,232,255,61,255,156,250,27,2,184,8,51,7,14,248,86,5,142,247,202,254,18,248,80,2,213,253,231,0,200,5,57,5,145,249,149,249,17,6,218,249,91,1,214,0,25,7,199,246,172,4,81,4,161,7,49,249,169,1,27,255,126,255,108,2,143,8,64,4,101,5,42,255,71,0,211,3,52,246,176,1,143,246,0,247,205,2,157,246,131,2,150,8,46,3,123,4,228,250,73,0,190,0,14,254,177,250,211,2,129,255,36,5,68,7,169,7,100,248,251,3,195,252,144,249,110,0,195,247,193,7,7,7,67,247,26,246,99,246,209,5,62,4,245,2,211,5,120,6,27,7,9,249,99,246,196,248,148,3,22,250,208,5,74,248,79,1,191,252,46,252,43,246,147,7,187,250,5,246,89,5,161,247,72,246,214,246,247,2,182,1,210,9,247,3,140,249,198,253,225,251,41,9,138,4,3,7,202,252,110,247,104,2,169,5,138,6,180,246,34,251,69,248,71,248,26,251,152,248,15,2,232,250,137,6,57,6,82,9,59,246,208,4,200,248,132,249,167,8,79,5,195,248,47,251,202,1,132,248,5,249,128,247,174,8,184,8,87,6,27,1,204,8,53,251,64,254,183,253,254,4,170,255,212,6,26,254,53,246,132,252,18,1,11,4,247,247,228,252,250,255,168,254,187,248,27,0,127,6,65,252,29,6,182,249,114,6,100,8,123,4,188,254,15,254,127,246,78,3,240,250,131,4,120,255,250,247,127,253,188,4,115,1,143,8,159,3,109,246,238,3,63,4,180,247,173,9,140,3,38,248,213,252,184,253,120,248,117,5,220,4,69,252,130,2,183,0,251,4,82,246,78,8,185,246,143,9,76,7,236,2,186,246,252,7,49,250,62,5,67,7,156,1,249,255,46,250,47,8,198,2,51,9,128,3,214,246,65,0,30,8,20,8,49,9,180,254,88,254,233,253,164,252,32,0,218,6,193,251,187,0,134,253,49,247,63,253,196,9,29,6,9,252,31,251,150,2,182,246,240,249,186,246,142,252,176,9,109,1,134,9,130,5,179,252,165,3,176,7,81,3,105,2,93,9,184,251,112,252,150,1,34,248,243,5,13,6,107,247,56,250,8,10,70,254,243,7,94,1,241,5,201,251,221,248,202,249,185,4,117,5,193,246,252,253,103,250,71,6,214,3,62,8,5,254,62,249,22,7,52,3,207,0,70,6,246,0,239,252,126,248,206,2,24,6,200,251,60,249,253,255,142,253,10,254,77,8,71,3,209,9,179,0,100,1,244,9,182,9,118,246,151,0,237,5,142,2,105,247,36,251,225,255,0,6,52,4,249,9,171,3,189,252,64,250,195,1,252,253,143,252,42,255,185,3,117,250,10,254,97,1,191,250,116,8,46,4,164,252,124,4,107,251,200,4,242,250,127,250,52,0,25,9,72,252,3,253,108,248,60,255,59,6,12,2,116,3,235,9,10,4,186,1,147,0,27,5,240,7,238,247,189,3,247,2,165,9,89,5,11,6,117,250,230,250,85,253,109,249,198,2,159,247,98,7,233,8,189,247,88,251,115,4,76,9,57,9,70,251,180,1,186,254,114,9,108,246,231,248,13,254,53,254,169,255,47,2,236,0,33,7,253,1,120,246,130,252,51,248,20,248,61,4,251,3,23,247,176,8,220,251,32,249,80,250,138,250,171,0,171,8,221,251,94,8,41,2,50,2,71,252,95,1,137,249,85,6,148,253,97,4,103,252,192,247,134,246,62,6,45,252,98,248,238,253,191,4,53,8,112,0,236,6,239,255,29,249,133,3,130,7,84,2,21,0,10,8,140,247,26,5,148,246,89,1,217,5,7,251,18,252,209,248,237,0,201,252,152,9,154,3,110,7,236,3,189,254,228,248,149,247,23,2,36,9,208,7,244,7,107,250,141,248,94,249,223,4,239,254,0,2,55,7,208,254,247,250,0},
  {218,8,114,250,60,247,57,5,217,7,141,3,151,248,93,8,230,2,229,253,7,253,45,248,58,251,186,2,13,246,246,9,82,0,96,248,185,248,78,8,95,246,108,5,163,250,27,0,134,254,131,252,179,252,137,253,33,249,105,7,132,253,103,5,198,8,94,5,194,254,149,247,213,4,34,250,63,9,109,255,47,253,202,249,169,249,136,1,216,7,37,253,86,3,133,7,225,249,171,253,239,249,238,249,111,9,59,250,77,0,132,9,59,252,98,9,141,2,249,9,49,7,49,253,209,6,81,247,186,1,8,254,19,1,102,252,141,252,108,254,189,1,151,254,138,5,135,3,160,9,129,253,201,249,63,246,219,4,152,250,105,5,192,5,151,251,141,255,158,252,19,254,243,1,60,254,27,250,23,6,105,250,252,247,213,248,142,9,195,246,229,3,253,245,143,8,91,9,178,248,13,4,97,4,38,252,229,4,13,3,165,250,96,253,74,6,122,250,185,253,180,1,45,251,219,5,4,248,128,251,122,8,251,255,75,9,195,250,218,249,57,251,103,253,114,5,195,249,90,254,58,5,103,2,46,249,19,254,24,4,48,8,104,254,65,6,46,4,114,2,188,255,153,252,142,9,88,247,172,255,235,4,162,9,253,9,147,2,95,2,59,247,78,9,251,1,184,9,206,7,222,249,96,2,155,0,141,254,188,3,55,9,245,7,212,9,159,5,46,1,173,249,9,0,34,251,117,255,29,246,39,246,44,254,84,248,153,9,71,3,222,249,14,8,192,1,186,3,30,0,131,3,28,249,129,4,177,0,93,255,49,2,83,255,17,247,206,246,99,254,50,7,185,7,28,0,181,9,62,255,97,253,80,254,89,248,214,247,201,247,87,4,170,255,45,2,10,252,190,251,248,253,185,5,121,246,1,7,181,246,52,252,184,5,86,1,173,254,188,4,72,5,210,249,194,250,109,247,77,253,39,253,95,254,115,249,77,2,19,3,113,5,64,255,38,247,37,253,137,2,204,250,15,253,186,253,176,250,12,247,56,252,249,254,197,248,37,252,139,255,117,7,5,0,65,4,115,254,199,246,188,255,44,250,28,9,119,4,234,9,2,248,155,9,13,3,109,4,166,6,31,2,135,247,46,9,57,3,167,8,234,1,161,253,4,6,50,2,244,252,27,8,132,8,212,5,99,9,250,4,101,252,78,2,114,0,133,6,200,247,166,253,247,249,116,254,44,252,13,254,96,6,157,248,253,253,190,249,196,5,3,249,101,6,94,3,8,247,155,2,68,6,225,255,65,3,145,249,113,249,222,4,123,4,65,7,136,251,117,253,163,252,159,252,50,6,238,255,156,0,23,0,28,253,80,246,203,8,212,246,69,8,55,5,111,255,109,4,208,1,30,252,246,249,149,0,106,8,248,245,72,255,20,251,40,252,158,254,126,255,226,4,200,2,233,246,10,5,235,5,207,251,19,2,103,6,237,247,103,255,211,0,55,251,201,248,218,247,131,248,96,254,231,8,129,3,196,251,8,5,77,0,57,255,6,250,12,249,216,0,182,251,147,4,134,254,65,255,20,2,197,249,174,1,70,7,107,250,0,247,9,9,155,253,188,2,28,4,145,247,192,249,209,0,212,4,33,3,31,248,178,253,39,255,20,0,226,247,210,5,122,2,54,254,71,8,94,249,63,1,177,249,242,250,230,9,248,255,44,5,204,246,40,254,61,254,19,0,71,9,156,247,167,5,239,246,168,4,197,2,50,6,156,253,185,254,223,249,96,248,95,246,110,247,163,3,48,254,246,254,144,247,127,254,90,246,51,4,172,247,203,7,218,9,18,247,146,6,74,250,241,8,98,2,62,1,142,2,113,249,181,2,23,247,175,4,16,250,21,251,114,8,57,1,166,8,57,250,251,248,50,6,247,247,190,4,109,246,149,0,127,249,6,8,202,255,60,249,211,9,8,1,86,247,44,247,231,247,123,253,37,0,39,249,189,5,158,5,111,253,232,246,196,2,51,4,158,0,149,8,242,7,178,4,32,249,160,2,159,254,206,254,20,5,217,247,127,1,233,9,70,253,59,247,72,254,250,250,222,251,124,250,52,247,251,4,175,4,143,252,70,247,248,7,25,9,189,248,251,250,12,3,157,249,1,3,53,9,103,5,253,6,78,7,234,253,227,0,7,252,115,8,229,252,23,9,182,252,212,6,75,254,181,7,63,5,159,253,171,250,70,249,109,247,72,247,249,3,85,9,14,252,123,246,247,4,9,3,73,0,209,6,79,253,232,253,141,252,66,4,78,4,131,253,32,246,242,248,44,0,51,252,25,4,122,4,140,0,177,5,74,252,114,252,103,251,243,8,33,9,135,247,71,8,241,255,7,255,180,252,96,250,125,252,150,7,94,0,195,250,45,7,35,5,250,253,114,6,82,248,45,1,224,1,72,3,212,5,27,8,3,251,86,3,77,246,250,8,92,3,216,246,48,6,71,3,255,253,14,1,205,254,209,8,208,3,41,9,82,1,150,8,70,253,88,246,215,3,22,249,41,248,86,7,196,0,71,7,223,6,18,10,82,252,201,9,2,252,39,253,134,9,105,247,165,9,123,253,110,5,79,252,197,1,130,5,128,0,241,252,185,7,169,255,246,245,117,8,232,9,25,2,111,250,55,250,67,5,233,9,46,251,214,6,59,2,196,6,228,255,118,248,242,248,193,4,68,3,180,1,107,6,245,2,107,249,218,6,249,3,35,246,209,254,130,8,94,249,205,255,39,6,120,249,29,250,164,6,220,247,135,1,167,3,126,249,83,8,113,2,245,3,174,3,194,249,218,255,95,255,9,250,98,246,13,8,188,246,226,248,25,4,151,246,215,4,236,250,221,4,20,247,92,255,252,247,169,246,128,2,115,7,119,0,225,0,145,247,34,255,203,3,96,247,205,9,9,2,5,2,53,254,43,4,100,1,105,252,24,1,125,248,149,1,173,3,172,247,37,252,72,252,1,5,151,250,161,254,229,3,175,247,197,3,199,1,129,254,52,0,0,5,219,247,99,7,150,255,242,246,127,2,152,7,239,249,51,7,47,7,239,5,174,248,61,5,122,4,162,254,49,2,88,250,69,247,52,255,18,3,239,0,107,6,192,6,40,6,27,4,204,247,92,9,109,246,176,3,121,9,103,253,204,248,189,248,51,8,55,246,8,10,187,5,187,250,202,252,216,7,212,0,127,254,207,5,6,2,89,253,195,7,222,249,128,253,20,253,116,249,135,6,116,251,7,251,141,1,72,246,61,249,100,255,67,248,123,253,72,9,171,246,232,246,228,249,224,251,126,8,198,6,243,245,193,2,188,255,238,2,99,7,244,251,188,255,182,247,24,0,217,249,249,8,13,6,8,0,10,3,143,254,159,254,139,3,62,7,98,252,20,5,196,246,158,247,9,8,114,6,191,2,97,249,128,4,184,6,176,1,42,0,27,253,94,5,20,251,79,8,131,249,13,250,246,7,242,7,86,253,65,252,198,9,114,252,61,246,119,247,76,246,118,6,255,1,83,248,60,5,143,5,66,5,141,255,43,8,23,8,119,255,63,246,244,251,182,8,246,0,28,252,129,5,108,7,130,247,204,254,249,0,232,9,148,249,139,253,93,249,237,4,231,249,78,9,133,7,110,249,129,5,186,253,77,6,132,255,151,247,42,249,120,250,167,253,91,254,107,0,130,9,234,9,202,250,64,4,202,1,43,5,50,249,61,246,184,5,90,7,65,250,132,8,228,251,86,1,146,0,185,255,52,5,33,248,131,4,232,2,127,247,250,0,180,8,70,9,35,1,242,0,95,248,27,7,151,252,108,1,14,5,162,3,0},
} ;

static const unsigned char precomputed_core_invsntrup857_n[precomputed_core_invsntrup857_NUM][crypto_core_INPUTBYTES] = {
  {200,179,34,113,134,217,96,222,13,32,96,87,31,240,145,221,250,71,69,145,75,186,168,193,135,115,39,128,243,144,60,206,157,23,13,224,86,74,110,229,2,88,238,41,160,189,24,80,179,60,217,235,197,38,165,36,75,212,18,211,130,97,48,51,157,57,228,71,199,76,95,16,250,33,236,14,74,58,244,9,19,253,64,181,176,44,122,151,212,97,60,47,135,122,90,190,206,98,127,92,58,194,183,214,223,132,102,192,55,1,144,88,217,16,38,126,221,62,223,228,144,138,247,180,3,107,244,84,54,36,3,2,65,238,217,13,212,228,34,188,7,28,107,147,229,97,105,253,221,136,67,79,232,173,24,183,77,136,108,111,255,196,77,67,127,85,242,223,161,133,170,113,206,142,149,86,146,160,8,149,104,247,53,40,208,89,82,179,135,31,93,164,242,24,128,37,108,179,136,38,134,227,30,47,111,91,62,85,0,192,169,126,173,3,16,221,169,22,81,186,143,8,77,152,55,17,114,179,247,58,129,198,228,105,118,69,152,251,48,203,120,14,220,94,2,80,183,44,14,79,61,60,68,225,99,1,64,238,18,241,89,242,98,159,195,140,51,166,41,83,114,249,237,30,105,149,12,203,14,36,9,88,17,237,104,149,14,4,235,143,32,172,113,47,255,46,177,55,195,57,207,13,75,137,56,195,240,104,176,182,122,63,201,101,57,183,169,205,161,124,117,54,5,155,29,200,91,240,54,184,75,82,97,22,203,224,74,138,26,113,61,110,146,108,73,207,116,104,89,132,251,187,116,64,5,95,11,42,113,139,32,51,180,156,245,229,43,187,28,57,55,225,49,139,3,207,86,117,149,111,205,55,193,177,161,19,162,5,118,22,123,202,127,103,225,105,138,44,81,63,47,25,207,156,31,185,93,1,226,188,67,158,64,103,69,234,80,149,63,187,65,241,165,171,51,223,109,186,206,59,198,173,62,144,50,238,222,14,101,125,187,160,223,114,142,181,111,92,65,190,38,72,96,165,14,67,39,88,94,30,96,41,63,78,250,144,139,59,100,139,225,113,233,139,174,77,85,8,90,175,220,122,107,7,123,183,123,205,149,216,22,43,225,124,14,56,73,30,155,4,69,206,26,137,141,59,3,234,224,53,227,153,36,123,61,153,48,66,181,177,241,188,145,203,61,97,111,3,57,31,228,188,118,103,38,57,195,182,42,194,190,91,134,239,58,169,228,225,235,90,165,216,214,150,53,220,134,225,151,177,189,44,12,5,251,156,131,42,38,51,101,58,139,191,212,206,202,167,162,206,42,94,56,125,71,119,131,95,114,139,71,98,165,161,235,99,89,56,239,120,103,112,201,8,173,172,74,137,114,198,100,118,61,222,67,109,231,11,34,243,3,164,132,177,234,167,15,230,13,43,24,197,248,173,45,16,63,121,4,170,212,17,170,207,149,143,121,189,155,75,42,225,119,188,3,175,6,151,5,51,191,167,192,206,193,136,204,146,101,17,124,165,97,67,86,123,12,143,42,106,58,55,192,136,210,42,254,248,223,77,92,166,80,80,160,110,54,176,78,111,179,170,252,120,215,70,133,135,83,35,129,81,188,19,99,52,243,116,54,28,152,58,141,24,116,129,211,124,146,214,40,235,141,137,56,139,242,244,81,49,105,182,146,233,242,115,61,140,167,18,4,177,65,239,1,240,85,147,60,55,161,252,16,6,104,135,227,149,222,49,23,65,94,200,142,207,193,56,40,175,191,50,207,219,205,26,91,139,234,42,122,248,182,66,131,63,187,81,134,83,41,193,234,23,215,64,215,69,221,141,139,69,64,222,250,40,137,103,68,92,76,198,166,178,98,160,195,39,90,244,225,251,130,62,252,132,99,89,202,136,202,25,232,169,140,100,48,164,68,217,101,84,179,131,3,163,202},
  {49,104,39,123,15,40,164,115,150,152,246,205,52,83,144,55,57,168,157,235,86,131,154,215,153,166,67,104,14,11,19,149,82,216,86,138,121,1,0,39,232,69,217,64,242,63,225,51,153,56,38,108,14,49,226,70,204,141,163,116,132,222,234,197,203,187,188,223,25,142,245,32,55,92,127,124,163,21,77,169,47,158,126,13,79,76,215,40,134,23,122,255,18,1,52,187,113,248,153,192,223,3,50,176,69,26,178,148,198,133,203,68,45,163,54,60,61,63,203,70,1,16,10,225,223,42,174,71,112,213,159,112,207,164,46,5,97,82,128,76,154,223,228,39,183,218,85,108,37,207,198,194,47,133,160,43,200,18,145,245,227,72,213,6,8,27,49,171,193,104,59,226,16,4,32,196,27,142,228,125,177,131,76,118,68,237,44,104,23,187,23,98,69,239,70,255,236,236,189,203,82,76,2,13,169,251,12,107,21,198,113,112,238,197,216,38,33,40,86,234,115,196,226,106,233,184,233,99,224,136,228,7,64,83,147,119,94,60,246,20,223,142,127,117,163,1,143,142,182,216,58,84,235,246,224,44,143,62,75,56,84,214,126,189,240,78,148,87,38,5,230,208,118,133,98,162,245,142,55,151,37,253,143,55,56,244,242,62,206,75,157,91,126,224,72,192,65,45,103,203,254,128,141,156,30,250,13,121,49,88,197,107,53,246,74,182,213,223,155,114,49,56,214,190,31,237,147,26,123,48,217,247,147,65,36,52,125,215,179,210,105,13,133,171,207,248,105,64,121,53,52,100,153,5,211,226,183,11,143,112,187,44,11,201,235,234,16,201,65,61,226,124,249,47,112,149,217,5,121,204,168,249,200,144,118,127,165,118,169,231,74,203,68,121,186,204,121,173,247,185,126,41,42,239,6,122,158,30,112,120,210,199,237,181,36,134,221,47,49,173,118,16,51,154,172,79,110,16,128,82,43,43,74,214,54,85,224,149,241,63,87,52,18,133,186,206,146,67,228,13,164,147,60,174,27,192,194,115,19,169,13,123,147,143,55,64,19,34,28,116,70,113,171,71,191,38,199,147,140,194,11,174,176,11,118,225,64,18,241,102,182,150,156,119,82,57,44,252,47,213,162,154,142,55,143,218,157,88,99,186,36,129,188,48,152,123,244,11,79,196,253,100,84,86,253,45,194,103,249,81,51,140,10,23,17,32,76,53,83,5,162,136,80,184,122,78,240,28,169,63,204,38,137,75,79,6,233,196,115,165,214,204,26,215,64,206,177,160,225,48,82,244,157,196,51,184,113,11,0,5,80,187,161,68,105,200,134,205,243,102,84,194,46,152,252,218,248,244,220,91,62,255,250,206,165,107,104,158,40,187,245,194,109,105,188,44,229,58,67,47,165,48,244,61,238,205,129,9,101,44,39,104,107,100,78,99,199,53,161,244,24,172,249,157,232,169,234,238,35,45,24,186,14,76,251,165,151,106,175,163,182,28,27,241,164,86,191,48,2,169,178,100,106,240,140,22,67,76,242,252,153,234,104,50,148,108,120,94,83,27,68,51,239,134,13,52,31,136,192,106,95,7,43,83,206,61,98,118,116,222,233,94,2,205,71,167,147,157,11,197,146,128,22,250,242,126,242,123,127,73,5,45,122,31,165,45,200,70,7,12,193,21,200,191,151,218,189,38,251,27,100,172,76,174,126,161,222,67,211,124,22,34,253,28,186,118,152,218,112,67,157,44,35,82,156,133,213,90,248,40,156,242,13,186,175,247,122,120,30,207,182,235,124,181,9,114,162,170,225,33,206,163,227,180,205,210,234,92,70,68,244,231,29,123,1,144,111,92,149,71,89,190,126,252,111,63,200,163,197,42,53,106,172,157,181,255,185,132,227,78,143,193,56,50,238,28,127,152,171,181,90,204,38,9,239,104,163},
  {76,179,30,69,175,228,49,149,159,55,226,209,243,239,17,213,188,149,183,111,178,35,28,150,104,207,218,144,113,50,147,144,8,12,245,122,75,154,137,225,161,137,64,163,116,88,20,240,182,222,120,217,227,168,72,188,189,147,9,64,112,34,62,188,175,254,203,244,223,69,193,17,129,223,233,247,119,127,118,243,186,141,59,66,222,126,19,90,253,14,44,53,81,155,124,247,228,244,165,50,198,14,194,128,43,128,184,138,211,34,178,151,113,103,175,207,147,102,6,21,128,82,159,17,156,233,15,34,103,118,45,239,64,72,22,23,29,136,64,242,100,244,149,45,157,97,186,86,67,151,205,204,167,125,251,156,79,228,226,124,151,178,111,116,143,18,155,47,181,86,167,213,126,217,34,222,86,254,133,126,228,242,157,173,9,83,27,252,121,116,109,33,42,212,236,18,73,168,48,138,229,221,41,144,116,65,24,239,95,82,45,170,2,134,100,20,169,93,90,248,40,123,145,64,43,158,126,246,17,141,177,245,69,219,99,120,215,196,30,134,123,167,90,172,68,35,177,157,140,148,129,110,101,105,184,207,101,57,45,141,175,129,20,13,248,91,202,192,68,92,233,66,76,60,237,194,113,81,127,96,161,182,241,13,245,31,252,20,69,86,141,153,50,238,53,57,14,162,108,93,199,174,225,18,203,27,211,47,154,102,94,131,55,142,213,253,151,183,94,33,85,105,112,102,27,182,232,171,200,28,101,144,0,88,50,152,6,57,246,3,120,99,64,27,10,57,117,242,165,212,225,100,234,56,158,140,233,70,233,191,126,222,113,45,132,57,136,38,56,48,138,50,80,123,243,30,107,42,142,209,45,117,153,214,127,67,249,164,89,92,73,30,8,138,178,153,112,91,133,206,229,198,159,98,129,244,6,231,107,107,176,128,143,60,24,120,137,231,2,222,8,245,106,68,150,101,214,204,127,139,182,243,23,101,128,14,241,230,183,38,116,209,132,167,180,156,140,116,222,227,140,0,96,198,101,141,103,217,90,242,58,196,43,215,235,45,191,32,131,226,137,71,192,40,253,156,176,25,53,134,196,99,135,40,230,177,19,190,193,247,23,115,12,215,83,118,239,11,142,211,204,172,130,118,125,132,211,176,50,183,82,55,128,3,48,15,78,203,136,97,226,44,157,215,203,180,35,26,181,21,175,255,10,190,20,60,175,71,103,133,32,232,199,101,193,101,186,103,180,13,61,167,202,76,239,140,15,68,234,167,127,183,41,38,202,75,184,241,120,176,120,254,61,156,182,74,170,78,144,185,86,46,186,219,129,53,253,248,158,148,235,188,116,125,186,89,93,132,2,46,72,23,120,109,221,226,202,91,155,115,78,223,119,151,197,80,43,81,184,251,12,190,118,31,243,199,184,164,164,189,73,66,99,188,52,111,28,193,255,242,55,49,156,173,102,233,191,228,57,246,162,81,120,14,234,242,55,173,250,224,163,249,82,25,66,228,190,132,247,116,112,208,0,103,115,212,107,175,140,182,104,240,219,240,99,113,115,103,27,0,232,232,180,125,175,106,17,221,8,28,150,104,160,138,25,96,127,88,235,29,231,19,177,116,201,237,70,103,49,216,107,89,155,230,45,124,37,7,209,23,164,43,30,36,190,106,201,49,248,166,6,25,185,41,190,244,39,154,167,84,159,211,122,157,238,163,57,13,107,210,142,238,155,115,101,47,13,242,71,90,139,70,129,39,200,108,132,182,218,71,106,99,195,93,242,177,102,159,136,150,27,218,127,199,43,147,7,84,114,110,6,138,114,134,252,110,84,251,0,33,77,239,26,13,38,36,187,44,26,192,119,130,17,234,129,27,15,218,109,80,173,80,138,183,37,190,19,210,211,129,183,49,179,194,101,203,88,213,138,37,116,227,25,219,154,119,102},
  {43,141,12,27,70,230,208,8,88,182,178,241,92,233,79,212,113,251,146,157,129,250,252,94,133,160,249,98,199,231,46,162,45,190,38,124,219,164,208,166,103,22,167,103,235,241,172,196,188,172,100,248,174,21,74,243,235,88,126,147,190,25,170,7,179,115,12,72,36,8,220,142,70,252,159,233,201,27,56,55,128,222,222,47,126,127,113,111,223,93,14,105,114,5,45,231,151,143,135,248,238,210,72,3,46,85,198,160,121,155,39,97,246,199,84,48,227,176,96,190,218,88,189,251,190,17,29,197,58,70,56,239,23,206,180,4,166,167,95,228,15,52,198,4,177,253,118,13,20,62,138,25,202,172,103,26,37,213,14,175,244,162,246,143,245,205,10,225,146,72,90,28,162,53,104,81,133,99,120,3,175,176,167,23,204,92,125,215,103,127,154,89,136,242,186,217,1,64,81,116,157,237,105,85,195,102,163,237,181,88,15,178,239,183,6,253,249,106,26,179,156,127,105,137,56,215,11,57,136,250,246,253,36,183,140,38,222,150,207,136,73,115,124,16,32,52,140,138,228,88,24,226,151,46,102,224,72,12,133,161,14,198,10,244,220,251,18,187,211,4,188,36,138,198,0,54,60,14,241,31,102,192,80,35,0,89,92,121,80,208,183,220,34,35,14,99,19,43,158,72,174,231,198,133,244,167,25,78,194,22,199,18,73,6,23,12,123,106,29,130,11,106,226,208,244,223,220,174,237,180,212,126,56,123,14,128,74,72,46,145,231,13,250,89,97,120,2,53,22,139,225,120,12,97,184,83,129,95,147,87,252,153,182,66,212,152,227,76,226,212,130,185,63,5,105,48,114,134,150,143,247,255,2,92,99,52,130,112,15,226,106,58,216,75,28,138,61,138,135,53,14,163,145,12,237,151,209,163,33,8,212,80,76,216,186,51,148,187,252,46,174,33,21,119,82,204,61,114,232,37,125,197,134,165,212,53,175,21,208,229,48,232,81,185,64,239,155,23,244,112,85,8,172,138,79,231,87,64,159,147,104,187,144,182,179,23,21,239,178,229,245,219,157,84,252,3,89,160,147,37,25,155,116,68,97,210,147,93,38,24,3,222,136,107,250,224,93,101,137,1,61,27,211,117,16,13,215,135,209,129,152,1,255,176,59,85,254,24,100,179,92,95,29,195,119,241,137,75,142,206,148,200,194,55,115,83,165,125,14,221,135,20,104,238,41,8,15,16,169,47,32,73,250,2,154,53,41,52,165,44,120,75,254,157,221,206,119,73,89,38,89,173,19,204,173,10,251,152,164,145,176,10,34,50,64,194,171,128,178,113,237,205,3,174,69,159,152,235,62,183,41,237,217,26,170,178,45,218,118,134,113,35,193,182,163,236,128,3,160,221,239,82,148,88,243,70,92,111,52,40,204,49,173,233,216,142,76,254,134,224,250,63,211,31,253,114,7,174,135,135,221,25,33,242,253,94,139,5,104,186,201,203,104,80,21,193,109,205,67,32,46,137,139,156,44,101,21,171,150,17,122,173,157,5,218,202,223,212,10,125,196,104,104,231,214,250,130,49,170,1,67,27,218,75,43,93,128,177,78,205,124,67,144,129,103,33,162,35,207,171,137,242,193,70,132,222,251,0,48,89,53,233,85,0,88,232,249,70,140,32,46,160,144,96,34,143,27,91,117,18,88,47,195,37,77,12,71,238,62,27,253,141,134,33,141,0,247,194,236,153,133,195,204,6,91,14,235,69,140,107,126,19,79,236,68,161,182,168,200,2,74,147,60,11,184,46,185,163,200,75,34,198,131,162,111,111,196,223,86,120,230,117,124,253,227,83,144,157,216,232,119,43,218,66,145,103,62,144,0,79,145,143,53,27,66,128,216,195,4,248,63,47,82,16,146,65,54,224,6,18,218,150,108,16,184,238,156},
} ;

static const unsigned char precomputed_core_invsntrup857_k[precomputed_core_invsntrup857_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_invsntrup857_c[precomputed_core_invsntrup857_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_invsntrup857_impl(long long impl)
{
  unsigned char *h = test_core_invsntrup857_h;
  unsigned char *n = test_core_invsntrup857_n;
  unsigned char *k = test_core_invsntrup857_k;
  unsigned char *c = test_core_invsntrup857_c;
  unsigned char *h2 = test_core_invsntrup857_h2;
  unsigned char *n2 = test_core_invsntrup857_n2;
  unsigned char *k2 = test_core_invsntrup857_k2;
  unsigned char *c2 = test_core_invsntrup857_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_invsntrup857_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_invsntrup857(impl);
    printf("core_invsntrup857 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup857_implementation(impl),ntruprime_dispatch_core_invsntrup857_compiler(impl));
  } else {
    crypto_core = ntruprime_core_invsntrup857;
    printf("core_invsntrup857 selected implementation %s compiler %s\n",ntruprime_core_invsntrup857_implementation(),ntruprime_core_invsntrup857_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_invsntrup857_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_invsntrup857_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_invsntrup857_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_invsntrup857_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_invsntrup857_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_invsntrup857_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_invsntrup857_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_invsntrup857_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_invsntrup857_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_invsntrup857_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_invsntrup857(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup857")) return;
  storage_core_invsntrup857_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_invsntrup857_h = aligned(storage_core_invsntrup857_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_invsntrup857_n = callocplus(crypto_core_INPUTBYTES);
  test_core_invsntrup857_n = aligned(storage_core_invsntrup857_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_invsntrup857_k = callocplus(crypto_core_KEYBYTES);
  test_core_invsntrup857_k = aligned(storage_core_invsntrup857_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_invsntrup857_c = callocplus(crypto_core_CONSTBYTES);
  test_core_invsntrup857_c = aligned(storage_core_invsntrup857_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_invsntrup857_h2 = callocplus(maxalloc);
  test_core_invsntrup857_h2 = aligned(storage_core_invsntrup857_h2,crypto_core_OUTPUTBYTES);
  storage_core_invsntrup857_n2 = callocplus(maxalloc);
  test_core_invsntrup857_n2 = aligned(storage_core_invsntrup857_n2,crypto_core_INPUTBYTES);
  storage_core_invsntrup857_k2 = callocplus(maxalloc);
  test_core_invsntrup857_k2 = aligned(storage_core_invsntrup857_k2,crypto_core_KEYBYTES);
  storage_core_invsntrup857_c2 = callocplus(maxalloc);
  test_core_invsntrup857_c2 = aligned(storage_core_invsntrup857_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_invsntrup857 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup857();++impl)
      forked(test_core_invsntrup857_impl,impl);
    ++test_core_invsntrup857_h;
    ++test_core_invsntrup857_n;
    ++test_core_invsntrup857_k;
    ++test_core_invsntrup857_c;
    ++test_core_invsntrup857_h2;
    ++test_core_invsntrup857_n2;
    ++test_core_invsntrup857_k2;
    ++test_core_invsntrup857_c2;
  }
  free(storage_core_invsntrup857_c2);
  free(storage_core_invsntrup857_k2);
  free(storage_core_invsntrup857_n2);
  free(storage_core_invsntrup857_h2);
  free(storage_core_invsntrup857_c);
  free(storage_core_invsntrup857_k);
  free(storage_core_invsntrup857_n);
  free(storage_core_invsntrup857_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

