--- status: Draft
--- author(s): DPS 
--- notes: 

document { 
     Key => {pfaffians, (pfaffians,ZZ,Matrix)},
     Headline => "ideal generated by Pfaffians",
     Usage => "pfaffians(n,M)",
     Inputs => {"n" => ZZ => "the size of the Pfaffians",
	  "M" => Matrix => "which is skew-symmetric, and whose ring is an integral domain"
	  },
     Outputs => {Ideal=>{"the ideal generated by the Pfaffians of the ", TT "n", " by ", 
	  TT "n", " principal submatrices of ", TT "M"}
	  },
     "The determinant of a skew-symmetric matrix ", TT "N", ", i.e., a matrix for which ", 
     TT "transpose N + N == 0", ", is always a perfect square whose 
     square root is called the Pfaffian of ", TT "N", ".",
     EXAMPLE {
	  "R = QQ[a..f];",
      	  "M = genericSkewMatrix(R,a,4)",
      	  "pfaffians(2,M)",
      	  "pfaffians(4,M)"
	  },
     "The Pluecker embedding of ", TT "Gr(2,6)", " and its secant variety:",  
     EXAMPLE {
	  "S = QQ[y_0..y_14];",
	  "M = genericSkewMatrix(S,y_0,6)",
	  "pluecker = pfaffians(4,M);",
	  "betti res pluecker",
	  "secantvariety = pfaffians(6,M)"
	  },
     "Pfaffians of a Moore matrix generate the ideal of a Heisenberg 
     invariant elliptic normal curve in projective Fourspace:",
     EXAMPLE {
	  "R = QQ[x_0..x_4]",
	  "y = {0,1,13,-13,-1}",
	  "M = matrix table(5,5, (i,j)-> x_((i+j)%5)*y_((i-j)%5))",
          "I = pfaffians(4,M);",
	  "betti res I"
	  },    
     Caveat => {"The algorithm used is a modified Gaussian reduction/Bareiss algorithm, 
	  which uses division and therefore we must assume that the ring of ", TT "M", "
	  is an integral domain.",
	  PARA{},
          "The skew symmetry of ", TT "M", " is not checked, but the algorithm 
	  proceeds as if it were, with somewhat unpredictable results!"
	  },
     SeeAlso => {det, "matrices"}
     }
