-- This reservoir simulation deck is made available under the Open Database
-- License: http://opendatacommons.org/licenses/odbl/1.0/. Any rights in
-- individual contents of the database are licensed under the Database Contents
-- License: http://opendatacommons.org/licenses/dbcl/1.0/

-- Copyright (C) 2015 Statoil

--
--         Generated by : Prosper 9.3 - License#:4474 - Sep 17 2006 14:05:16
--         Generated on : 09 Jan 07  14:20
--           Input File : C:\GAP\D2H.OUT
--          Output File : Z:\res\sim\ior\linn\gap\D2H.Ecl
--
--
--                Fluid : Oil
--           PVT Method : Black Oil
--    Equation Of State : 
--            Separator : Single-Stage
--            Emulsions : No
--             Hydrates : Disable Warning
--      Water Viscosity : Use Default Correlation
--         Water Vapour : No Calculations
--      Viscosity Model : Newtonian Fluid
--
--            Flow Type : Tubing
--            Well Type : Producer
--
--      Artificial Lift : None
--            Lift Type : 
--
--           Predicting : Pressure and Temperature (offshore)
--    Temperature Model : Rough Approximation
--                Range : Full System
--
--           Completion : Cased Hole
--          Gravel Pack : No
--
--          Inflow Type : Single Branch
--           Gas Coning : No
--
--              Company : Statoil
--                Field : Norne
--             Location : Nordland II
--                 Well : D-2T2H
--             Platform : Treasure Prospect
--              Analyst : amoe og Arild Stokkenes
--                 Date : 30 May 06  11:49
--
--
--
--  Surface Equipment Correlation :  Fancher Brown
--      Vertical Lift Correlation :  Petroleum Experts 3
--
--                    Rate Method :  User Selected
--                      Rate Type :  Liquid Rates
--
--                     First Node :    1            Xmas Tree        396 (m)
--                      Last Node :   10               Tubing       3018 (m)
--
--         Sensitivity Variable 1 :  First Node Pressure
--         Sensitivity Variable 2 :  Gas Oil Ratio
--         Sensitivity Variable 3 :  Water Cut
--
--
-- PROSPER Lift Curves For ECLIPSE Simulator    (Liquid - Producer Well)  (Units System  - METRIC)


VFPPROD

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
--    42       2623.39       'LIQ'      'WCT'      'GOR'            /

-- Prosper files are corrected from RKB to MSL depth. Correlations are not matched due to no BHP gauge in well. lmarr       

-- Table   Datum Depth   Rate Type   WFR Type   GFR Type   TAB Type
-- -----   -----------   ---------   --------   --------   --------
      42       2598.39       'LIQ'      'WCT'      'GOR'            /



-- 'LIQ' units - SM3/DAY
  200.0   500.0  1000.0  1500.0  2000.0 
 2500.0  3000.0  3500.0  4000.0  4500.0 
 5000.0  5500.0  6000.0  6500.0  7000.0 
 7500.0  8000.0 10000.0 14000.0 /

-- 'THP' units - BARSA
  21.01   51.01   61.01   81.01  101.01 
 121.01  141.01  161.01  181.01  201.01 /

-- 'WCT' units - FRACTION
      0     0.1     0.2     0.3     0.4 
    0.5     0.6     0.7     0.8       1 /

-- 'GOR' units - SM3/SM3
     90     100     150     200     500 
   1000    5000 /

-- 'ALQ' units - 
      0 /

 1  1  1  1  132.82  105.63  102.70  103.39  106.03 
             109.95  114.77  120.39  126.56  132.92 
             139.79  146.93  153.96  161.48  169.23 
             176.62  184.56  215.25  280.42 
/
 1  1  2  1  118.55   96.18   94.03   95.38   98.63 
             103.24  108.76  114.79  121.40  128.39 
             135.68  143.21  150.94  158.85  166.52 
             174.69  183.07  216.16  284.08 
/
 1  1  3  1   69.23   67.44   69.52   73.70   79.21 
              85.76   93.02  100.83  109.13  117.70 
             126.57  135.49  144.84  154.11  163.50 
             173.02  183.09  222.30  303.86 
/
 1  1  4  1   55.46   56.77   60.82   66.45   73.08 
              80.47   88.46   96.95  105.85  115.65 
             125.60  135.83  146.16  156.69  167.42 
             178.35  189.09  233.71  326.38 
/
 1  1  5  1   42.81   48.42   55.83   64.75   75.21 
              86.85   99.41  112.73  126.57  140.87 
             155.59  170.67  186.06  201.72  217.62 
             233.68  250.73  322.04  474.59 
/
 1  1  6  1   38.72   45.99   60.18   76.73   94.90 
             113.66  134.52  156.32  177.82  201.16 
             224.95  249.17  273.87  299.06  324.76 
             349.02  377.16  493.48  757.37 
/
 1  1  7  1   47.68   92.84  164.87  239.54  320.52 
             408.98  505.55  610.14  723.61  844.57 
             973.66 1110.11 1255.43 1410.49 1572.85 
            1744.25 1924.76 2728.04 4758.80 
/
 1  2  1  1  146.26  115.41  111.58  111.80  114.01 
             117.49  121.88  127.09  132.68  138.87 
             145.43  151.98  159.06  166.00  173.45 
             180.58  188.29  218.24  282.53 
/
 1  2  2  1  133.71  105.54  102.52  103.33  106.12 
             110.16  115.21  120.98  127.10  133.77 
             140.77  148.05  155.21  162.87  170.29 
             178.29  186.41  217.99  284.54 
/
 1  2  3  1   77.32   73.59   74.50   78.24   83.52 
              89.78   96.76  104.30  112.29  120.63 
             129.30  138.01  146.89  156.24  165.43 
             174.76  184.22  222.60  301.73 
/
 1  2  4  1   59.61   60.16   63.57   68.90   75.31 
              82.50   90.30   98.59  107.73  117.12 
             126.83  136.68  146.77  157.06  167.57 
             177.92  188.79  231.99  322.72 
/
 1  2  5  1   43.41   48.89   56.00   64.51   74.47 
              85.55   97.51  110.12  123.26  136.87 
             150.90  165.28  179.95  194.87  210.02 
             225.39  242.29  310.19  454.46 
/
 1  2  6  1   39.11   46.10   58.58   73.69   90.42 
             108.67  127.81  147.43  168.59  190.35 
             212.49  235.04  258.02  279.94  304.85 
             329.19  352.48  457.72  701.96 
/
 1  2  7  1   45.16   86.02  151.49  218.52  290.82 
             368.74  453.71  545.20  644.33  749.83 
             861.56  980.18 1105.21 1238.22 1378.36 
            1525.31 1680.41 2369.39 4088.39 
/
 1  3  1  1  158.38  126.14  121.76  121.50  123.18 
             126.20  130.26  134.87  140.01  145.79 
             151.68  158.16  164.56  171.12  178.24 
             185.03  192.46  221.54  283.57 
/
 1  3  2  1  148.15  116.27  112.39  112.67  114.96 
             118.51  122.97  128.24  133.89  140.15 
             146.52  153.40  160.55  167.53  175.12 
             182.37  190.20  220.82  286.24 
/
 1  3  3  1   92.19   81.85   81.45   84.38   89.13 
              95.04  101.64  108.90  116.49  124.59 
             132.81  141.24  149.86  158.64  167.56 
             176.61  185.79  223.24  300.77 
/
 1  3  4  1   65.86   64.95   67.53   72.40   78.49 
              85.41   92.96  101.42  110.17  119.31 
             128.66  138.26  148.11  157.90  168.15 
             178.22  188.42  230.45  317.98 
/
 1  3  5  1   44.12   49.43   56.27   64.36   73.84 
              84.37   95.67  107.61  120.09  133.04 
             146.38  160.04  173.98  188.16  202.56 
             217.65  233.92  298.35  434.34 
/
 1  3  6  1   39.59   46.33   57.91   71.04   86.56 
             103.24  121.09  139.86  159.40  179.49 
             199.70  220.54  241.13  262.31  283.92 
             306.04  328.61  426.11  649.50 
/
 1  3  7  1   42.78   79.22  138.00  197.85  261.63 
             329.84  403.85  483.06  568.86  659.64 
             755.15  856.98  963.94 1075.92 1195.32 
            1320.31 1451.40 2033.19 3476.70 
/
 1  4  1  1  172.79  139.20  133.07  132.39  133.73 
             136.29  139.73  143.84  148.48  153.56 
             159.24  164.96  170.88  177.42  183.71 
             190.14  196.69  224.48  285.91 
/
 1  4  2  1  163.52  128.21  123.75  123.50  125.28 
             128.32  132.24  136.84  141.96  147.71 
             153.59  160.04  166.46  173.05  180.21 
             187.07  194.58  224.03  286.90 
/
 1  4  3  1  111.66   92.17   90.63   92.71   96.67 
             101.94  108.06  114.78  121.98  129.53 
             137.36  145.43  153.71  162.15  170.76 
             179.53  187.96  224.23  298.81 
/
 1  4  4  1   75.46   71.89   73.28   77.46   83.07 
              89.84   97.28  105.20  113.56  122.29 
             131.32  140.63  149.92  159.38  169.31 
             179.07  188.96  229.19  314.16 
/
 1  4  5  1   45.09   50.10   56.66   64.37   73.37 
              83.30   94.00  105.32  117.16  129.44 
             142.08  155.03  168.23  181.66  195.28 
             210.55  225.56  286.39  415.15 
/
 1  4  6  1   40.20   46.75   57.42   69.38   83.05 
              98.16  114.43  131.62  149.58  168.01 
             186.83  205.98  225.42  245.20  265.32 
             285.77  306.56  395.36  599.63 
/
 1  4  7  1   40.56   72.45  124.77  177.46  232.73 
             292.04  355.81  423.65  497.14  573.96 
             654.78  740.75  830.95  925.08 1023.49 
            1128.01 1236.50 1721.13 2914.91 
/
 1  5  1  1  184.53  153.76  145.64  144.61  145.52 
             147.62  150.58  154.16  158.27  162.78 
             167.65  173.18  178.58  184.24  190.08 
             196.08  202.79  228.74  287.34 
/
 1  5  2  1  177.66  143.19  136.65  135.94  137.12 
             139.60  142.94  146.94  151.46  156.65 
             162.00  167.62  173.87  179.95  186.23 
             192.64  199.72  227.82  288.86 
/
 1  5  3  1  134.20  105.11  102.40  103.61  106.71 
             111.21  116.61  122.59  129.20  136.21 
             143.56  151.18  158.72  166.75  174.96 
             182.90  191.41  225.82  297.97 
/
 1  5  4  1   92.27   82.21   81.96   85.12   90.11 
              96.18  103.10  110.59  118.42  126.75 
             135.20  143.88  153.02  162.09  171.31 
             180.68  189.75  228.41  310.64 
/
 1  5  5  1   46.97   51.05   57.26   64.64   73.20 
              82.63   92.75  103.46  114.64  126.22 
             138.14  150.34  162.78  175.43  189.53 
             203.44  217.58  274.73  395.82 
/
 1  5  6  1   40.99   47.43   57.16   67.98   80.36 
              94.10  108.93  124.63  140.96  157.74 
             174.94  192.54  210.49  228.64  247.05 
             265.76  284.74  366.24  550.57 
/
 1  5  7  1   38.45   65.51  111.24  156.91  204.94 
             255.63  309.87  367.04  428.98  492.42 
             560.43  631.80  705.81  783.73  865.10 
             949.75 1037.40 1432.17 2399.59 
/
 1  6  1  1  198.04  168.81  159.95  158.51  158.87 
             160.45  162.88  165.87  169.41  173.33 
             177.63  182.25  187.09  192.21  197.54 
             203.56  209.28  233.72  290.21 
/
 1  6  2  1  192.04  159.67  151.06  149.92  150.76 
             152.71  155.51  158.94  162.87  167.23 
             171.94  176.95  182.23  187.74  193.92 
             199.84  205.88  232.32  290.06 
/
 1  6  3  1  157.60  121.09  117.05  117.41  119.76 
             123.35  127.83  133.11  138.79  145.07 
             151.75  158.45  165.71  172.83  180.52 
             187.94  196.01  228.18  297.40 
/
 1  6  4  1  119.06   96.28   94.47   96.44  100.37 
             105.51  111.58  118.30  125.49  133.05 
             141.13  149.03  157.36  165.89  174.59 
             183.47  192.04  229.00  306.19 
/
 1  6  5  1   50.49   53.25   58.82   65.78   73.89 
              82.80   92.34  102.40  112.90  123.76 
             134.93  146.35  158.62  171.11  184.15 
             196.94  209.94  263.19  376.12 
/
 1  6  6  1   42.04   48.42   57.16   66.87   78.00 
              90.40  103.78  117.92  132.58  147.74 
             163.33  179.29  195.57  212.14  228.98 
             246.04  263.23  337.99  503.37 
/
 1  6  7  1   36.43   58.58   98.11  137.17  177.74 
             220.34  265.63  313.06  364.14  415.58 
             471.61  529.91  589.57  652.41  717.74 
             784.91  855.43 1166.48 1927.50 
/
 1  7  1  1  209.50  183.88  175.10  173.46  173.57 
             174.65  176.53  178.99  181.96  185.30 
             189.04  193.05  197.38  201.92  206.74 
             211.72  216.96  239.60  292.90 
/
 1  7  2  1  206.21  176.94  167.49  166.03  166.24 
             167.63  169.84  172.59  175.83  179.53 
             183.59  187.92  192.57  197.44  202.57 
             207.91  213.39  237.95  292.93 
/
 1  7  3  1  179.92  140.41  135.25  134.79  136.21 
             138.92  142.48  146.85  151.63  156.83 
             162.39  168.55  174.69  181.05  188.04 
             194.81  201.78  231.57  297.31 
/
 1  7  4  1  150.80  115.12  111.62  112.42  115.21 
             119.23  124.25  129.83  136.09  142.80 
             149.65  157.01  164.33  172.17  180.23 
             188.04  196.47  229.97  303.12 
/
 1  7  5  1   57.24   58.21   62.66   68.97   76.46 
              84.72   93.58  102.92  112.66  122.74 
             133.52  144.78  156.16  167.62  179.31 
             191.22  203.36  252.61  356.99 
/
 1  7  6  1   43.63   49.83   57.51   66.14   76.10 
              87.18   99.06  111.60  124.70  138.28 
             152.26  166.57  181.18  196.04  211.14 
             226.46  241.99  310.92  457.55 
/
 1  7  7  1   36.42   52.54   85.00  116.89  150.48 
             185.20  223.12  261.30  302.68  343.60 
             388.38  434.60  481.65  531.09  581.89 
             634.05  688.61  925.50 1504.92 
/
 1  8  1  1  218.83  199.86  190.98  189.34  189.20 
             189.96  191.38  193.32  195.69  198.45 
             201.59  204.99  208.67  212.66  216.85 
             221.32  225.96  246.55  296.35 
/
 1  8  2  1  216.43  194.28  184.97  183.36  183.32 
             184.23  185.85  188.00  190.67  193.67 
             197.03  200.75  204.71  208.98  213.21 
             217.89  222.83  244.44  296.45 
/
 1  8  3  1  202.12  166.27  156.98  155.91  156.70 
             158.44  161.08  164.33  168.10  172.29 
             176.88  182.13  187.36  192.84  198.58 
             204.50  210.62  237.47  298.04 
/
 1  8  4  1  181.30  139.33  134.68  134.24  135.88 
             138.69  142.36  146.69  151.56  157.08 
             162.77  169.07  175.35  181.86  189.02 
             195.93  203.01  233.59  301.94 
/
 1  8  5  1   71.99   69.57   71.78   76.81   83.25 
              90.54   98.46  107.21  116.34  125.86 
             135.60  145.63  155.93  166.19  176.94 
             187.57  198.34  243.00  338.00 
/
 1  8  6  1   47.01   51.76   58.42   66.11   75.00 
              84.79   95.30  106.40  117.99  129.99 
             142.34  154.98  167.87  180.99  194.31 
             208.96  223.72  284.20  411.81 
/
 1  8  7  1   37.11   48.10   72.85   97.84  124.36 
             152.18  180.76  212.00  242.25  275.69 
             310.14  344.90  381.34  418.08  456.27 
             495.87  536.59  710.99 1126.65 
/
 1  9  1  1  227.43  215.26  207.64  206.13  205.77 
             206.30  207.37  208.89  210.78  213.05 
             215.58  218.39  221.47  224.80  228.43 
             232.24  236.27  254.57  300.48 
/
 1  9  2  1  225.88  211.76  203.49  201.91  201.56 
             202.14  203.30  204.92  206.99  209.35 
             212.02  214.99  218.24  221.79  225.54 
             229.53  233.74  252.84  300.11 
/
 1  9  3  1  217.87  193.40  183.02  181.52  181.61 
             182.66  184.40  186.75  189.40  192.55 
             196.09  199.92  204.09  208.50  213.20 
             218.09  223.26  245.89  299.62 
/
 1  9  4  1  208.53  174.11  164.16  163.01  163.66 
             165.21  167.63  170.63  174.14  178.08 
             182.39  187.06  192.42  197.70  203.22 
             208.99  214.95  240.67  301.05 
/
 1  9  5  1  119.19   96.56   94.98   97.34  101.53 
             107.04  113.42  120.44  127.93  135.82 
             144.02  152.49  161.20  170.12  179.25 
             188.57  198.08  236.63  319.74 
/
 1  9  6  1   57.87   58.96   63.67   70.14   77.81 
              86.26   95.31  104.86  114.82  125.12 
             135.70  147.34  159.03  170.99  183.00 
             195.25  207.38  258.64  367.12 
/
 1  9  7  1   38.12   46.63   62.28   80.04   99.48 
             119.46  140.95  163.83  187.22  210.96 
             236.14  261.84  288.07  314.85  342.22 
             369.75  398.35  518.79  791.32 
/
 1 10  1  1  241.77  240.77  240.04  239.99  240.37 
             241.05  242.01  243.19  244.60  246.22 
             248.05  250.08  252.31  254.74  257.36 
             260.18  263.19  277.15  314.24 
/
 1 10  2  1  241.77  240.77  240.04  239.99  240.37 
             241.05  242.01  243.19  244.60  246.22 
             248.05  250.08  252.31  254.74  257.36 
             260.18  263.19  277.15  314.24 
/
 1 10  3  1  241.77  240.77  240.04  239.99  240.37 
             241.05  242.01  243.19  244.60  246.22 
             248.05  250.08  252.31  254.74  257.36 
             260.18  263.19  277.15  314.24 
/
 1 10  4  1  241.77  240.77  240.04  239.99  240.37 
             241.05  242.01  243.19  244.60  246.22 
             248.05  250.08  252.31  254.74  257.36 
             260.18  263.19  277.15  314.24 
/
 1 10  5  1  241.77  240.77  240.04  239.99  240.37 
             241.05  242.01  243.19  244.60  246.22 
             248.05  250.08  252.31  254.74  257.36 
             260.18  263.19  277.15  314.24 
/
 1 10  6  1  241.77  240.77  240.04  239.99  240.37 
             241.05  242.01  243.19  244.60  246.22 
             248.05  250.08  252.31  254.74  257.36 
             260.18  263.19  277.15  314.24 
/
 1 10  7  1  241.77  240.77  240.04  239.99  240.37 
             241.05  242.01  243.19  244.60  246.22 
             248.05  250.08  252.31  254.74  257.36 
             260.18  263.19  277.15  314.24 
/
 2  1  1  1  208.86  186.14  179.96  178.20  178.17 
             179.24  181.15  183.69  186.78  190.35 
             194.29  198.60  203.22  208.12  213.24 
             218.64  224.25  248.24  304.46 
/
 2  1  2  1  204.74  177.03  171.48  169.98  170.23 
             171.64  173.85  176.71  180.21  184.20 
             188.32  193.04  198.06  203.39  208.95 
             214.74  220.73  247.09  306.48 
/
 2  1  3  1  175.71  144.57  140.28  139.97  141.47 
             144.30  148.05  152.55  157.80  163.44 
             169.72  176.19  183.25  190.34  198.03 
             205.61  213.83  247.29  321.00 
/
 2  1  4  1  137.69  123.15  121.13  122.31  125.24 
             129.39  134.57  140.65  147.31  154.53 
             162.22  170.52  179.00  187.77  196.82 
             206.13  215.68  255.48  341.65 
/
 2  1  5  1   85.56   87.06   92.26   99.58  108.12 
             117.71  128.24  139.59  151.63  164.29 
             177.47  191.11  205.15  219.55  234.29 
             250.08  266.68  334.73  484.22 
/
 2  1  6  1   78.82   84.30   93.55  105.62  120.08 
             136.48  154.41  173.64  194.03  215.30 
             237.33  260.08  283.52  307.62  332.36 
             357.75  383.76  498.67  764.43 
/
 2  1  7  1   74.79  108.21  174.17  245.97  325.24 
             412.56  508.44  612.73  725.82  846.68 
             975.68 1112.05 1257.89 1412.61 1575.33 
            1747.84 1927.72 2731.03 4758.69 
/
 2  2  1  1  214.45  193.73  187.23  185.38  185.26 
             186.20  187.92  190.28  193.14  196.46 
             200.14  204.19  208.56  213.16  218.07 
             223.22  228.55  251.98  306.99 
/
 2  2  2  1  210.71  185.17  178.97  177.31  177.44 
             178.68  180.76  183.48  186.75  190.48 
             194.61  198.96  203.75  208.80  214.13 
             219.70  225.47  250.45  308.37 
/
 2  2  3  1  187.31  152.65  147.82  147.18  148.38 
             150.93  154.38  158.56  163.34  168.63 
             174.57  180.70  187.15  194.22  201.24 
             208.92  216.41  248.84  320.59 
/
 2  2  4  1  152.99  130.57  127.68  128.40  130.91 
             134.75  139.48  145.07  151.33  158.14 
             165.44  173.16  181.24  189.66  198.37 
             206.98  216.18  254.70  338.59 
/
 2  2  5  1   88.43   88.84   93.26  100.06  108.13 
             117.23  127.23  138.00  149.44  161.44 
             173.93  186.86  200.17  213.82  227.79 
             243.55  259.17  323.46  464.35 
/
 2  2  6  1   79.40   84.63   93.23  104.34  117.66 
             132.81  149.38  167.18  186.04  205.67 
             226.04  247.09  268.77  291.06  313.93 
             337.36  361.36  466.98  711.21 
/
 2  2  7  1   75.41  102.59  161.57  225.64  296.11 
             373.09  457.17  548.20  646.84  751.50 
             863.73  982.23 1107.33 1240.28 1380.49 
            1528.45 1683.40 2372.35 4089.02 
/
 2  3  1  1  220.17  202.02  194.86  193.09  192.84 
             193.66  195.26  197.39  200.02  203.10 
             206.52  210.31  214.37  218.75  223.36 
             228.24  233.31  255.79  309.31 
/
 2  3  2  1  216.81  194.09  187.10  185.37  185.36 
             186.42  188.28  190.72  193.71  197.16 
             200.96  205.15  209.65  214.40  219.44 
             224.73  230.19  254.21  310.61 
/
 2  3  3  1  198.77  161.38  156.43  155.45  156.35 
             158.60  161.73  165.43  170.01  174.95 
             180.33  186.08  192.16  198.90  205.58 
             212.50  219.64  250.81  319.57 
/
 2  3  4  1  168.68  139.25  135.45  135.71  137.82 
             141.20  145.50  150.67  156.36  162.73 
             169.59  176.66  184.30  192.30  200.61 
             208.82  217.65  254.26  334.62 
/
 2  3  5  1   92.35   91.75   95.08  101.18  108.68 
             117.24  126.67  136.83  147.62  158.95 
             170.75  182.95  195.51  208.40  222.63 
             237.06  251.79  312.31  445.53 
/
 2  3  6  1   80.07   85.06   93.02  103.21  115.45 
             129.37  144.62  161.01  178.29  196.33 
             215.07  234.46  254.42  274.92  295.94 
             317.47  339.50  435.90  658.46 
/
 2  3  7  1   74.81   97.55  149.34  205.87  267.38 
             334.96  408.03  486.70  571.70  661.30 
             757.58  859.21  966.05 1078.00 1197.40 
            1322.66 1453.74 2036.15 3478.50 
/
 2  4  1  1  226.98  210.60  203.10  201.25  201.01 
             201.71  203.11  205.06  207.49  210.30 
             213.47  217.00  220.79  224.90  229.22 
             233.80  238.64  260.06  311.80 
/
 2  4  2  1  223.99  203.48  195.81  194.08  193.96 
             194.84  196.46  198.66  201.39  204.50 
             208.03  211.86  216.04  220.47  225.19 
             230.16  235.32  258.16  312.71 
/
 2  4  3  1  208.64  171.11  166.10  164.83  165.52 
             167.46  170.13  173.60  177.64  182.17 
             187.14  192.48  198.17  204.15  210.42 
             217.38  224.16  253.40  319.81 
/
 2  4  4  1  184.30  149.36  144.73  144.45  146.12 
             149.06  152.91  157.49  162.83  168.56 
             174.93  181.51  188.71  195.94  203.80 
             211.55  219.97  254.41  331.84 
/
 2  4  5  1   97.39   96.22   98.17  103.32  110.11 
             118.02  126.80  136.29  146.40  157.02 
             168.08  179.53  191.32  204.31  217.54 
             231.08  244.69  301.87  425.87 
/
 2  4  6  1   80.98   85.59   92.95  102.26  113.46 
             126.20  140.15  155.08  170.84  187.34 
             204.49  222.23  240.50  259.25  278.47 
             298.13  318.23  406.20  608.42 
/
 2  4  7  1   74.18   92.98  137.33  186.38  240.01 
             297.51  360.95  428.16  500.41  576.14 
             657.59  743.27  832.64  927.15 1025.55 
            1129.99 1239.37 1724.18 2917.64 
/
 2  5  1  1  234.25  219.70  211.72  210.01  209.64 
             210.26  211.51  213.32  215.51  218.09 
             221.00  224.27  227.79  231.58  235.67 
             239.96  244.54  264.85  314.80 
/
 2  5  2  1  231.63  213.54  205.15  203.41  203.20 
             203.93  205.35  207.32  209.74  212.60 
             215.79  219.34  223.16  227.29  231.65 
             236.26  241.15  262.77  315.21 
/
 2  5  3  1  218.33  181.92  176.82  175.51  176.01 
             177.59  179.98  183.09  186.55  190.66 
             195.19  200.09  205.34  210.89  216.73 
             222.86  229.24  257.46  320.49 
/
 2  5  4  1  201.52  160.87  155.73  155.02  156.25 
             158.66  162.02  166.09  170.76  175.94 
             181.78  187.82  194.20  201.22  208.21 
             215.46  223.40  256.05  329.55 
/
 2  5  5  1  104.05  102.33  103.24  107.13  112.97 
             120.06  128.06  136.79  146.12  155.95 
             166.21  176.97  188.95  200.95  213.06 
             225.52  238.30  291.60  407.11 
/
 2  5  6  1   82.88   86.31   93.09  101.56  111.79 
             123.34  135.95  149.46  163.76  178.75 
             194.33  210.45  227.04  244.06  261.50 
             279.33  297.54  377.18  559.62 
/
 2  5  7  1   73.79   89.12  125.70  167.59  212.96 
             262.36  315.02  372.39  431.63  496.02 
             563.84  634.80  708.17  785.98  867.25 
             951.86 1039.86 1434.55 2402.01 
/
 2  6  1  1  241.58  229.20  220.91  219.26  218.86 
             219.38  220.50  222.09  224.09  226.48 
             229.15  232.13  235.38  238.95  242.72 
             246.74  251.04  270.28  318.24 
/
 2  6  2  1  239.35  223.67  215.21  213.36  213.09 
             213.70  214.94  216.68  218.85  221.44 
             224.34  227.54  231.08  234.85  238.88 
             243.20  247.72  268.08  318.21 
/
 2  6  3  1  228.14  196.34  188.84  187.41  187.67 
             188.97  191.04  193.72  196.92  200.57 
             204.64  209.08  213.87  218.98  224.37 
             230.02  235.92  261.67  321.64 
/
 2  6  4  1  216.48  173.89  168.80  167.63  168.42 
             170.35  173.20  176.74  180.86  185.47 
             190.52  195.96  201.75  207.85  214.24 
             221.35  228.28  258.16  327.72 
/
 2  6  5  1  114.79  110.75  110.78  113.65  118.29 
             124.27  131.27  139.04  147.44  156.70 
             166.63  176.92  187.48  198.41  209.41 
             221.00  232.95  281.73  389.43 
/
 2  6  6  1   86.64   87.94   93.66  101.33  110.61 
             120.99  132.31  144.45  157.30  170.77 
             184.78  199.27  214.18  229.48  245.15 
             261.17  277.52  350.41  512.75 
/
 2  6  7  1   74.01   86.39  114.81  148.86  187.05 
             227.72  272.43  318.29  368.37  420.80 
             475.25  532.58  592.61  655.12  720.23 
             787.96  858.29 1168.77 1926.81 
/
 2  7  1  1  248.77  238.44  230.52  228.95  228.54 
             229.00  230.00  231.44  233.26  235.40 
             237.90  240.63  243.64  246.91  250.42 
             254.21  258.19  276.34  322.32 
/
 2  7  2  1  246.96  234.68  225.68  224.03  223.71 
             224.13  225.22  226.82  228.76  231.05 
             233.66  236.57  239.81  243.26  246.97 
             250.92  255.15  274.16  321.82 
/
 2  7  3  1  237.90  212.04  202.43  200.94  200.99 
             202.00  203.69  205.96  208.70  211.84 
             215.38  219.26  223.47  227.98  232.75 
             237.82  243.14  266.60  322.76 
/
 2  7  4  1  228.54  189.36  183.78  182.49  182.96 
             184.51  186.87  189.79  193.31  197.32 
             201.62  206.41  211.55  217.01  222.77 
             228.80  235.09  262.69  327.43 
/
 2  7  5  1  132.76  123.40  121.95  123.81  127.43 
             132.36  138.31  145.09  152.61  160.63 
             169.30  178.26  187.83  197.54  207.55 
             218.21  228.82  273.22  371.97 
/
 2  7  6  1   93.54   92.69   96.28  102.78  110.84 
             119.95  129.93  140.66  152.02  163.94 
             176.34  189.17  202.39  215.95  229.83 
             244.02  259.29  324.78  467.65 
/
 2  7  7  1   74.73   84.64  105.81  131.84  161.80 
             195.12  230.05  267.90  307.75  349.69 
             393.41  438.84  485.94  534.42  584.19 
             636.23  690.28  925.43 1502.77 
/
 2  8  1  1  255.61  248.22  240.63  239.04  238.75 
             239.15  240.06  241.37  243.02  244.98 
             247.23  249.75  252.52  255.54  258.80 
             262.35  266.06  283.07  326.98 
/
 2  8  2  1  254.24  245.33  236.96  235.25  234.93 
             235.34  236.29  237.66  239.40  241.45 
             243.81  246.45  249.35  252.51  255.90 
             259.59  263.45  281.17  326.41 
/
 2  8  3  1  247.40  228.97  218.21  216.57  216.38 
             217.06  218.37  220.19  222.44  225.11 
             228.09  231.40  235.04  238.94  243.14 
             247.57  252.29  273.34  325.26 
/
 2  8  4  1  240.37  211.15  201.27  199.88  200.05 
             201.16  202.97  205.33  208.18  211.46 
             215.13  219.16  223.53  228.24  233.23 
             238.50  244.04  268.56  327.32 
/
 2  8  5  1  177.44  143.49  139.76  140.29  142.76 
             146.43  151.01  156.46  162.59  169.14 
             176.35  184.02  192.11  200.29  209.07 
             218.18  227.61  266.91  354.99 
/
 2  8  6  1  105.02  103.11  104.24  108.45  114.67 
             122.13  130.49  139.59  149.29  159.52 
             170.18  181.24  192.65  205.26  218.15 
             231.38  244.72  300.50  424.05 
/
 2  8  7  1   76.12   84.06   99.92  119.01  141.15 
             165.92  192.87  221.56  251.83  283.56 
             316.70  351.03  386.49  423.11  460.90 
             499.89  540.08  712.99 1126.66 
/
 2  9  1  1  261.86  256.16  250.94  249.68  249.32 
             249.72  250.56  251.77  253.29  255.09 
             257.16  259.49  262.05  264.85  267.88 
             271.13  274.59  290.64  332.38 
/
 2  9  2  1  260.95  254.59  248.54  247.01  246.73 
             247.11  247.89  249.13  250.70  252.56 
             254.70  257.14  259.78  262.66  265.78 
             269.12  272.68  289.06  331.63 
/
 2  9  3  1  256.37  245.37  235.50  233.72  233.41 
             233.87  234.89  236.36  238.21  240.39 
             242.89  245.73  248.80  252.14  255.73 
             259.58  263.70  282.35  329.57 
/
 2  9  4  1  251.71  234.03  222.55  220.99  220.75 
             221.45  222.81  224.59  226.79  229.36 
             232.32  235.56  239.14  242.97  247.08 
             251.49  256.12  277.10  329.28 
/
 2  9  5  1  222.10  172.80  167.56  166.74  167.85 
             170.10  173.26  177.13  181.59  186.56 
             191.99  197.84  204.36  210.94  217.83 
             225.00  232.93  265.15  341.21 
/
 2  9  6  1  132.76  123.61  122.38  124.47  128.24 
             133.25  139.42  146.49  154.21  162.56 
             171.49  180.91  190.55  200.82  211.17 
             221.83  232.77  279.25  382.16 
/
 2  9  7  1   78.67   85.41   96.31  109.27  124.58 
             141.88  160.81  181.09  202.55  225.07 
             248.49  272.67  297.60  323.29  349.72 
             376.87  404.75  523.54  797.36 
/
 2 10  1  1  271.92  270.91  270.18  270.13  270.51 
             271.20  272.15  273.34  274.75  276.37 
             278.19  280.22  282.45  284.87  287.49 
             290.31  293.32  307.27  344.33 
/
 2 10  2  1  271.92  270.91  270.18  270.13  270.51 
             271.20  272.15  273.34  274.75  276.37 
             278.19  280.22  282.45  284.87  287.49 
             290.31  293.32  307.27  344.33 
/
 2 10  3  1  271.92  270.91  270.18  270.13  270.51 
             271.20  272.15  273.34  274.75  276.37 
             278.19  280.22  282.45  284.87  287.49 
             290.31  293.32  307.27  344.33 
/
 2 10  4  1  271.92  270.91  270.18  270.13  270.51 
             271.20  272.15  273.34  274.75  276.37 
             278.19  280.22  282.45  284.87  287.49 
             290.31  293.32  307.27  344.33 
/
 2 10  5  1  271.92  270.91  270.18  270.13  270.51 
             271.20  272.15  273.34  274.75  276.37 
             278.19  280.22  282.45  284.87  287.49 
             290.31  293.32  307.27  344.33 
/
 2 10  6  1  271.92  270.91  270.18  270.13  270.51 
             271.20  272.15  273.34  274.75  276.37 
             278.19  280.22  282.45  284.87  287.49 
             290.31  293.32  307.27  344.33 
/
 2 10  7  1  271.92  270.91  270.18  270.13  270.51 
             271.20  272.15  273.34  274.75  276.37 
             278.19  280.22  282.45  284.87  287.49 
             290.31  293.32  307.27  344.33 
/
 3  1  1  1  222.01  205.06  198.95  197.06  196.78 
             197.52  199.00  201.09  203.71  206.73 
             210.17  213.92  218.02  222.41  227.02 
             231.91  237.00  259.61  313.59 
/
 3  1  2  1  218.53  196.96  190.97  189.26  189.17 
             190.16  191.95  194.39  197.35  200.78 
             204.62  208.80  213.32  218.14  223.22 
             228.51  234.06  258.34  315.49 
/
 3  1  3  1  200.66  165.49  160.97  159.94  160.84 
             163.10  166.16  170.04  174.53  179.55 
             185.02  191.13  197.37  203.92  210.75 
             218.24  225.58  257.62  328.38 
/
 3  1  4  1  168.04  144.46  141.05  141.35  143.54 
             146.98  151.36  156.62  162.44  168.96 
             175.98  183.46  191.34  199.59  207.83 
             216.67  225.80  263.72  348.19 
/
 3  1  5  1  102.06  101.63  105.36  111.81  119.74 
             128.81  138.84  149.71  161.30  173.51 
             186.25  199.48  213.13  227.17  241.56 
             257.79  273.92  340.60  488.09 
/
 3  1  6  1   91.77   96.53  105.09  116.45  130.22 
             145.94  163.21  181.84  201.64  222.33 
             243.86  266.17  289.21  312.94  337.35 
             362.42  388.16  502.14  768.03 
/
 3  1  7  1   87.77  115.77  179.01  249.48  327.84 
             415.05  510.51  614.53  727.29  848.01 
             976.77 1112.97 1258.83 1413.27 1575.87 
            1748.54 1928.65 2732.02 4759.48 
/
 3  2  1  1  227.22  212.03  205.53  203.66  203.36 
             204.04  205.42  207.38  209.83  212.68 
             215.90  219.49  223.35  227.52  231.92 
             236.61  241.49  263.25  315.89 
/
 3  2  2  1  224.03  204.52  198.00  196.17  196.01 
             196.89  198.53  200.80  203.55  206.77 
             210.35  214.30  218.58  223.12  227.94 
             233.03  238.32  261.70  317.26 
/
 3  2  3  1  207.73  173.01  168.26  167.07  167.82 
             169.76  172.67  176.15  180.35  185.07 
             190.23  195.78  201.99  208.25  214.79 
             221.58  228.62  259.57  328.37 
/
 3  2  4  1  181.32  152.01  147.87  147.78  149.61 
             152.64  156.75  161.56  167.00  173.14 
             179.79  186.68  194.18  202.05  209.93 
             218.42  226.79  263.32  345.33 
/
 3  2  5  1  105.65  104.68  107.20  112.93  120.28 
             128.80  138.26  148.52  159.47  171.01 
             183.06  195.57  208.48  221.76  236.22 
             251.03  266.27  329.58  468.37 
/
 3  2  6  1   92.36   96.90  104.86  115.31  128.02 
             142.52  158.47  175.69  193.91  213.01 
             232.89  253.51  274.80  296.72  319.26 
             342.37  366.09  470.69  713.69 
/
 3  2  7  1   87.05  110.98  166.82  229.40  299.06 
             375.78  459.54  550.27  648.32  753.07 
             865.05  983.33 1108.30 1241.23 1381.19 
            1529.08 1684.02 2373.42 4089.87 
/
 3  3  1  1  232.58  219.33  212.48  210.67  210.37 
             210.98  212.27  214.09  216.40  219.07 
             222.10  225.48  229.13  233.05  237.28 
             241.71  246.43  267.32  318.58 
/
 3  3  2  1  229.68  212.55  205.39  203.64  203.42 
             204.19  205.68  207.74  210.28  213.28 
             216.62  220.33  224.33  228.63  233.21 
             238.01  243.09  265.48  319.44 
/
 3  3  3  1  215.01  181.30  176.35  175.11  175.69 
             177.34  179.98  183.31  187.05  191.44 
             196.27  201.50  207.07  212.97  219.15 
             226.05  232.79  261.95  328.76 
/
 3  3  4  1  196.00  160.58  155.79  155.29  156.78 
             159.46  163.12  167.53  172.70  178.28 
             184.33  191.01  197.85  205.31  212.77 
             220.89  228.87  263.41  341.79 
/
 3  3  5  1  110.11  108.71  110.14  114.91  121.55 
             129.42  138.25  147.85  158.12  168.96 
             180.29  192.05  204.20  217.26  231.05 
             245.11  259.21  318.72  449.84 
/
 3  3  6  1   93.19   97.37  104.75  114.33  126.02 
             139.35  154.00  169.76  186.47  204.01 
             222.29  241.25  260.81  280.95  301.64 
             322.86  344.59  439.95  661.20 
/
 3  3  7  1   86.49  106.64  154.98  210.21  270.75 
             337.44  409.89  489.12  573.21  663.17 
             759.16  860.56  966.97 1078.99 1198.36 
            1323.39 1454.45 2037.17 3476.07 
/
 3  4  1  1  239.06  227.26  219.89  218.13  217.83 
             218.39  219.58  221.27  223.39  225.92 
             228.75  231.90  235.37  239.08  243.05 
             247.31  251.76  271.87  321.58 
/
 3  4  2  1  236.43  220.90  213.39  211.57  211.32 
             212.00  213.35  215.28  217.62  220.36 
             223.50  226.93  230.67  234.72  239.01 
             243.58  248.35  269.74  321.97 
/
 3  4  3  1  223.40  190.40  185.39  184.00  184.40 
             185.93  188.29  191.31  194.82  198.88 
             203.39  208.14  213.37  218.91  224.75 
             230.87  237.29  265.00  328.93 
/
 3  4  4  1  209.91  169.96  165.04  164.14  165.27 
             167.58  170.86  174.86  179.47  184.61 
             190.21  196.20  202.85  209.57  216.57 
             223.85  231.82  264.79  339.52 
/
 3  4  5  1  115.76  113.88  114.58  118.24  123.96 
             131.04  139.11  147.98  157.50  167.58 
             178.14  189.12  201.09  213.45  226.53 
             239.50  252.83  308.58  431.34 
/
 3  4  6  1   94.91   97.95  104.77  113.54  124.27 
             136.44  149.77  164.13  179.37  195.40 
             212.11  229.43  247.30  265.70  284.58 
             303.92  323.73  410.63  611.44 
/
 3  4  7  1   86.19  102.89  143.68  190.87  243.73 
             301.23  363.12  430.71  501.59  578.38 
             659.51  744.84  834.15  928.46 1026.70 
            1131.11 1240.26 1724.81 2914.10 
/
 3  5  1  1  246.04  235.28  227.71  226.11  225.72 
             226.23  227.32  228.89  230.91  233.22 
             235.87  238.82  242.05  245.59  249.34 
             253.34  257.61  276.79  324.79 
/
 3  5  2  1  243.72  229.82  221.94  220.13  219.83 
             220.42  221.63  223.36  225.51  228.07 
             230.94  234.13  237.65  241.41  245.43 
             249.74  254.24  274.60  324.89 
/
 3  5  3  1  232.32  201.58  195.45  193.97  194.18 
             195.45  197.50  200.16  203.35  207.02 
             211.09  215.55  220.35  225.49  230.94 
             236.64  242.60  268.70  329.54 
/
 3  5  4  1  220.56  180.69  175.65  174.55  175.32 
             177.26  180.03  183.58  187.73  192.38 
             197.49  203.00  208.87  215.07  221.58 
             228.79  235.86  266.41  337.70 
/
 3  5  5  1  123.87  120.66  120.63  123.49  128.18 
             134.24  141.38  149.37  158.03  167.25 
             177.17  188.03  199.17  210.52  222.27 
             234.39  246.86  298.68  412.93 
/
 3  5  6  1   98.10   99.19  105.05  113.04  122.82 
             133.83  145.91  158.93  172.75  187.28 
             202.43  218.13  234.33  250.99  268.09 
             285.60  303.52  382.64  562.95 
/
 3  5  7  1   86.24  100.01  132.78  172.88  217.38 
             265.73  318.90  374.31  434.74  498.72 
             565.42  635.93  710.05  787.65  868.73 
             953.17 1041.01 1433.26 2397.02 
/
 3  6  1  1  253.08  244.10  236.06  234.40  234.10 
             234.55  235.56  237.01  238.83  240.99 
             243.47  246.23  249.30  252.59  256.13 
             259.91  263.97  282.27  328.66 
/
 3  6  2  1  251.10  239.65  230.99  229.22  228.90 
             229.40  230.50  232.06  234.03  236.35 
             239.00  241.99  245.22  248.72  252.47 
             256.52  260.75  279.98  328.28 
/
 3  6  3  1  241.41  215.17  206.59  205.10  205.18 
             206.22  207.98  210.30  213.12  216.37 
             220.02  224.03  228.37  233.02  237.95 
             243.16  248.63  272.79  330.35 
/
 3  6  4  1  231.45  192.91  187.78  186.50  187.01 
             188.65  191.11  194.16  197.83  201.90 
             206.49  211.48  216.83  222.51  228.49 
             234.77  241.31  269.89  336.97 
/
 3  6  5  1  137.77  129.85  128.98  131.03  134.82 
             139.87  145.95  152.96  160.99  169.49 
             178.71  188.33  198.19  208.65  219.53 
             230.45  241.67  289.26  394.65 
/
 3  6  6  1  103.40  102.60  106.62  113.59  122.27 
             132.09  142.88  154.52  166.89  179.89 
             193.46  207.53  222.05  236.99  252.31 
             267.99  284.04  356.28  516.59 
/
 3  6  7  1   86.63   97.86  123.24  155.20  191.64 
             231.96  275.63  321.80  371.11  423.21 
             478.00  535.26  594.98  657.25  722.14 
             788.87  858.56 1167.70 1927.88 
/
 3  7  1  1  259.99  252.58  244.79  243.18  242.89 
             243.30  244.23  245.57  247.26  249.28 
             251.58  254.16  257.00  260.09  263.43 
             267.04  270.84  288.26  332.82 
/
 3  7  2  1  258.38  248.81  240.50  238.80  238.49 
             238.93  239.92  241.34  243.14  245.27 
             247.71  250.47  253.46  256.71  260.21 
             263.95  267.98  286.14  332.34 
/
 3  7  3  1  250.48  229.43  219.48  217.89  217.77 
             218.57  220.01  221.99  224.44  227.26 
             230.48  234.00  237.86  241.99  246.44 
             251.11  256.08  278.21  332.19 
/
 3  7  4  1  242.41  208.61  201.81  200.39  200.62 
             201.87  203.86  206.45  209.55  213.11 
             217.09  221.44  226.14  231.17  236.50 
             242.13  248.02  274.22  336.29 
/
 3  7  5  1  165.54  144.08  141.29  142.38  145.25 
             149.42  154.59  160.58  167.28  174.58 
             182.44  190.78  199.79  208.99  218.55 
             228.45  238.26  281.30  377.52 
/
 3  7  6  1  111.30  109.63  111.32  116.53  123.70 
             132.10  141.46  151.62  162.46  173.88 
             185.81  198.20  211.00  224.18  237.69 
             251.54  266.96  331.22  471.96 
/
 3  7  7  1   87.48   96.49  116.31  140.78  169.19 
             200.95  235.49  272.49  311.62  352.81 
             396.01  441.00  487.74  536.28  586.66 
             638.89  693.05  928.55 1505.14 
/
 3  8  1  1  266.55  260.04  253.82  252.44  252.05 
             252.44  253.31  254.56  256.14  258.01 
             260.17  262.58  265.24  268.15  271.28 
             274.65  278.29  294.78  337.59 
/
 3  8  2  1  265.33  257.98  250.57  248.95  248.65 
             249.04  249.94  251.24  252.88  254.83 
             257.07  259.58  262.35  265.37  268.62 
             272.16  275.88  292.91  336.99 
/
 3  8  3  1  259.31  244.58  233.81  232.15  231.88 
             232.44  233.61  235.26  237.31  239.73 
             242.49  245.60  248.97  252.61  256.57 
             260.74  265.20  285.24  335.34 
/
 3  8  4  1  253.20  228.83  217.92  216.53  216.59 
             217.53  219.12  221.23  223.80  226.78 
             230.13  233.85  237.88  242.23  246.86 
             251.77  256.95  280.13  336.66 
/
 3  8  5  1  206.92  164.41  159.60  159.49  161.32 
             164.39  168.36  173.08  178.58  184.52 
             190.94  198.03  205.58  213.23  221.54 
             229.83  238.82  276.11  362.30 
/
 3  8  6  1  124.29  121.34  121.52  124.70  129.72 
             136.16  143.69  152.05  161.10  170.73 
             180.85  191.40  202.94  214.91  227.36 
             239.95  252.94  307.63  428.97 
/
 3  8  7  1   88.98   96.40  111.13  129.10  150.28 
             174.18  200.34  228.33  257.98  289.15 
             321.78  355.63  390.67  426.91  464.39 
             503.10  543.06  715.60 1129.72 
/
 3  9  1  1  272.52  267.39  263.15  261.95  261.61 
             262.00  262.82  264.00  265.47  267.23 
             269.25  271.51  274.00  276.73  279.69 
             282.86  286.25  301.90  342.96 
/
 3  9  2  1  271.71  266.00  261.05  259.58  259.32 
             259.69  260.44  261.64  263.16  264.96 
             267.03  269.35  271.91  274.71  277.79 
             281.04  284.51  300.52  342.38 
/
 3  9  3  1  267.65  258.90  249.36  247.75  247.30 
             247.72  248.68  250.06  251.80  253.88 
             256.25  258.95  261.88  265.08  268.52 
             272.20  276.17  294.10  340.09 
/
 3  9  4  1  263.55  249.37  237.76  236.05  235.83 
             236.42  237.60  239.23  241.32  243.71 
             246.44  249.51  252.85  256.46  260.39 
             264.54  268.93  289.02  339.49 
/
 3  9  5  1  237.90  191.74  186.53  185.51  186.26 
             188.11  190.88  194.32  198.35  202.70 
             207.67  213.06  218.83  224.96  231.82 
             238.62  245.70  276.61  349.98 
/
 3  9  6  1  163.55  144.02  141.53  142.85  145.92 
             150.28  155.64  161.83  168.85  176.40 
             184.52  193.34  202.43  211.94  221.81 
             232.05  242.61  287.37  388.77 
/
 3  9  7  1   91.76   98.04  107.95  120.19  134.77 
             151.37  169.64  189.30  210.17  232.15 
             255.00  278.71  303.23  328.54  354.62 
             381.47  409.05  526.90  799.77 
/
 3 10  1  1  281.97  280.96  280.23  280.18  280.56 
             281.24  282.20  283.38  284.79  286.41 
             288.24  290.27  292.49  294.92  297.54 
             300.35  303.36  317.31  354.36 
/
 3 10  2  1  281.97  280.96  280.23  280.18  280.56 
             281.24  282.20  283.38  284.79  286.41 
             288.24  290.27  292.49  294.92  297.54 
             300.35  303.36  317.31  354.36 
/
 3 10  3  1  281.97  280.96  280.23  280.18  280.56 
             281.24  282.20  283.38  284.79  286.41 
             288.24  290.27  292.49  294.92  297.54 
             300.35  303.36  317.31  354.36 
/
 3 10  4  1  281.97  280.96  280.23  280.18  280.56 
             281.24  282.20  283.38  284.79  286.41 
             288.24  290.27  292.49  294.92  297.54 
             300.35  303.36  317.31  354.36 
/
 3 10  5  1  281.97  280.96  280.23  280.18  280.56 
             281.24  282.20  283.38  284.79  286.41 
             288.24  290.27  292.49  294.92  297.54 
             300.35  303.36  317.31  354.36 
/
 3 10  6  1  281.97  280.96  280.23  280.18  280.56 
             281.24  282.20  283.38  284.79  286.41 
             288.24  290.27  292.49  294.92  297.54 
             300.35  303.36  317.31  354.36 
/
 3 10  7  1  281.97  280.96  280.23  280.18  280.56 
             281.24  282.20  283.38  284.79  286.41 
             288.24  290.27  292.49  294.92  297.54 
             300.35  303.36  317.31  354.36 
/
 4  1  1  1  245.49  237.00  231.24  229.64  229.20 
             229.66  230.75  232.36  234.40  236.82 
             239.62  242.71  246.10  249.80  253.74 
             257.92  262.39  282.41  332.44 
/
 4  1  2  1  242.71  230.62  224.72  222.93  222.58 
             223.11  224.41  226.23  228.51  231.21 
             234.30  237.71  241.46  245.46  249.78 
             254.32  259.14  280.67  333.52 
/
 4  1  3  1  229.31  201.61  197.00  195.60  195.92 
             197.40  199.75  202.80  206.43  210.59 
             215.21  220.25  225.66  231.41  237.49 
             243.85  250.30  279.11  345.37 
/
 4  1  4  1  215.77  182.35  178.07  177.17  178.27 
             180.65  183.95  188.08  192.86  198.21 
             204.04  210.55  217.25  224.29  232.00 
             239.69  247.66  282.47  362.50 
/
 4  1  5  1  135.15  133.37  134.21  138.24  144.54 
             152.35  161.29  171.14  181.77  193.07 
             204.96  217.38  230.26  243.77  258.59 
             273.64  289.14  353.61  498.16 
/
 4  1  6  1  117.52  120.84  128.23  138.43  151.12 
             165.65  181.79  199.30  217.98  237.69 
             258.35  279.87  302.17  325.23  349.02 
             373.52  398.73  511.33  774.28 
/
 4  1  7  1  111.33  134.05  190.88  258.56  335.38 
             421.30  515.98  619.39  731.44  851.98 
             980.17 1116.30 1261.91 1415.95 1578.46 
            1749.78 1929.40 2733.95 4759.73 
/
 4  2  1  1  250.31  242.85  236.89  235.27  234.93 
             235.34  236.41  237.96  239.96  242.29 
             244.95  247.92  251.19  254.76  258.55 
             262.60  266.93  286.39  335.37 
/
 4  2  2  1  247.70  237.05  230.65  228.99  228.59 
             229.15  230.35  232.12  234.30  236.87 
             239.79  243.07  246.62  250.46  254.60 
             258.97  263.62  284.45  336.03 
/
 4  2  3  1  235.36  208.43  203.73  202.24  202.45 
             203.77  205.91  208.72  212.10  215.97 
             220.30  225.02  230.12  235.56  241.31 
             247.38  253.72  281.35  345.62 
/
 4  2  4  1  222.85  189.26  184.66  183.70  184.57 
             186.71  189.73  193.58  198.06  203.09 
             208.61  214.57  220.91  227.61  234.63 
             242.34  249.98  282.95  360.48 
/
 4  2  5  1  139.45  137.28  137.58  140.97  146.42 
             153.47  161.69  170.84  180.75  191.33 
             202.48  214.14  226.25  239.66  253.44 
             267.63  281.99  343.03  479.77 
/
 4  2  6  1  119.09  121.28  128.14  137.57  149.28 
             162.66  177.49  193.58  210.77  228.94 
             247.98  267.81  288.37  309.62  331.53 
             354.07  377.25  480.45  720.36 
/
 4  2  7  1  111.00  130.44  179.72  239.38  306.79 
             382.22  465.34  555.52  652.91  757.64 
             869.02  986.79 1111.43 1244.04 1383.95 
            1530.94 1685.46 2375.05 4089.42 
/
 4  3  1  1  255.29  248.95  242.73  241.29  240.92 
             241.38  242.42  243.91  245.80  248.04 
             250.59  253.48  256.62  260.03  263.69 
             267.64  271.78  290.66  338.39 
/
 4  3  2  1  252.88  243.83  237.03  235.44  235.05 
             235.58  236.73  238.37  240.44  242.91 
             245.69  248.78  252.20  255.87  259.80 
             264.03  268.46  288.57  338.80 
/
 4  3  3  1  241.62  215.83  211.12  209.59  209.70 
             210.86  212.81  215.39  218.50  222.09 
             226.11  230.52  235.29  240.41  245.85 
             251.55  257.52  283.78  345.66 
/
 4  3  4  1  230.24  196.99  192.15  191.04  191.80 
             193.69  196.43  199.99  204.00  208.67 
             213.82  219.40  225.37  231.70  238.34 
             245.29  252.53  284.57  357.68 
/
 4  3  5  1  144.68  142.09  141.84  144.62  149.36 
             155.56  162.94  171.29  180.42  190.21 
             200.57  211.43  223.70  236.18  249.12 
             262.28  275.86  332.65  460.62 
/
 4  3  6  1  121.73  122.14  128.18  136.90  147.64 
             159.88  173.44  188.17  203.92  220.57 
             238.02  256.20  275.04  294.51  314.57 
             335.20  356.40  450.95  669.44 
/
 4  3  7  1  110.83  127.43  168.94  220.53  279.84 
             345.08  417.21  494.49  578.54  668.42 
             763.30  864.34  970.74 1082.65 1201.31 
            1326.03 1456.58 2038.13 3478.66 
/
 4  4  1  1  261.42  255.89  249.11  247.62  247.35 
             247.80  248.80  250.23  252.03  254.17 
             256.62  259.36  262.37  265.64  269.20 
             272.97  276.97  295.25  341.82 
/
 4  4  2  1  259.19  250.89  243.84  242.31  241.94 
             242.44  243.52  245.08  247.03  249.37 
             252.01  254.95  258.17  261.67  265.46 
             269.47  273.71  293.07  341.75 
/
 4  4  3  1  249.03  225.18  219.24  217.70  217.73 
             218.75  220.51  222.86  225.71  229.01 
             232.73  236.82  241.26  246.04  251.11 
             256.45  262.06  286.86  346.27 
/
 4  4  4  1  238.81  205.64  200.66  199.37  199.90 
             201.57  204.09  207.31  211.11  215.44 
             220.24  225.33  230.92  236.86  243.12 
             249.70  256.56  286.56  356.75 
/
 4  4  5  1  153.95  148.09  147.27  149.44  153.48 
             158.90  165.43  172.88  181.12  190.02 
             199.94  210.63  221.73  233.16  245.06 
             257.05  269.75  323.06  442.57 
/
 4  4  6  1  125.31  124.35  128.83  136.63  146.35 
             157.47  169.81  183.21  197.54  212.70 
             228.58  245.12  262.27  279.98  298.23 
             316.98  336.25  422.25  620.16 
/
 4  4  7  1  110.86  124.82  158.98  202.62  252.95 
             309.09  370.50  437.07  507.75  583.76 
             664.26  749.20  838.63  932.48 1030.29 
            1134.12 1243.12 1726.78 2917.95 
/
 4  5  1  1  268.10  262.42  255.88  254.41  254.15 
             254.59  255.48  256.85  258.58  260.67 
             263.01  265.63  268.51  271.65  275.04 
             278.66  282.56  300.18  345.53 
/
 4  5  2  1  266.13  258.92  251.24  249.63  249.33 
             249.72  250.74  252.21  254.05  256.27 
             258.76  261.55  264.61  267.94  271.56 
             275.38  279.44  298.00  345.18 
/
 4  5  3  1  257.11  235.99  228.27  226.72  226.63 
             227.55  229.11  231.25  233.84  236.87 
             240.27  244.04  248.13  252.52  257.22 
             262.20  267.45  290.75  347.45 
/
 4  5  4  1  248.08  215.30  210.32  208.91  209.22 
             210.61  212.79  215.62  219.00  222.88 
             227.20  231.92  237.02  242.47  248.25 
             254.32  260.69  288.88  355.36 
/
 4  5  5  1  165.95  155.95  154.31  155.86  159.19 
             163.82  169.48  176.23  183.82  192.20 
             201.11  210.63  220.48  231.01  242.02 
             253.15  264.64  313.86  424.63 
/
 4  5  6  1  130.03  128.45  130.91  137.39  145.90 
             155.82  166.88  178.93  191.83  205.48 
             219.80  234.71  250.18  266.15  282.60 
             299.52  316.87  394.92  572.34 
/
 4  5  7  1  111.12  122.67  150.82  186.65  228.42 
             275.24  326.47  381.83  441.09  504.14 
             570.84  640.93  714.53  791.71  872.43 
             956.58 1044.67 1438.06 2403.82 
/
 4  6  1  1  274.85  268.96  262.99  261.55  261.30 
             261.71  262.62  263.92  265.56  267.51 
             269.75  272.25  275.01  278.02  281.27 
             284.75  288.46  305.54  349.55 
/
 4  6  2  1  273.16  266.32  258.90  257.34  257.06 
             257.48  258.44  259.81  261.54  263.60 
             265.96  268.59  271.49  274.65  278.10 
             281.75  285.63  303.42  349.11 
/
 4  6  3  1  265.38  247.72  238.46  236.86  236.69 
             237.40  238.77  240.65  242.97  245.72 
             248.79  252.23  255.96  260.01  264.32 
             268.93  273.76  295.59  349.42 
/
 4  6  4  1  257.64  226.67  221.27  219.80  219.94 
             221.07  222.94  225.41  228.38  231.80 
             235.65  239.88  244.46  249.39  254.63 
             260.17  265.99  292.04  354.43 
/
 4  6  5  1  186.25  167.26  164.02  164.82  167.49 
             171.41  176.38  182.21  188.78  196.02 
             204.02  212.41  221.30  230.64  240.39 
             250.53  261.04  305.91  407.90 
/
 4  6  6  1  136.50  134.28  135.48  140.10  147.06 
             155.57  165.22  175.81  187.20  199.29 
             211.99  225.24  238.99  253.21  267.87 
             282.92  298.39  369.41  526.66 
/
 4  6  7  1  111.71  121.13  143.72  172.57  206.50 
             244.69  286.55  331.76  379.99  431.05 
             484.95  541.43  600.51  662.24  726.69 
             793.85  863.75 1173.84 1934.43 
/
 4  7  1  1  281.47  275.65  270.57  269.12  268.77 
             269.17  270.04  271.28  272.85  274.71 
             276.84  279.24  281.88  284.76  287.87 
             291.21  294.78  311.25  354.01 
/
 4  7  2  1  280.09  273.48  267.09  265.55  265.27 
             265.67  266.56  267.85  269.47  271.41 
             273.64  276.13  278.88  281.87  285.11 
             288.58  292.28  309.32  353.31 
/
 4  7  3  1  273.66  259.97  249.76  247.99  247.73 
             248.30  249.47  251.12  253.19  255.63 
             258.43  261.51  264.90  268.60  272.54 
             276.78  281.22  301.46  352.23 
/
 4  7  4  1  267.30  242.67  233.64  232.21  232.23 
             233.16  234.75  236.87  239.46  242.46 
             245.84  249.58  253.67  258.09  262.80 
             267.81  273.09  296.72  354.62 
/
 4  7  5  1  222.72  182.34  177.35  177.29  179.17 
             182.25  186.31  191.15  196.79  202.92 
             209.76  217.13  224.74  233.03  241.42 
             250.50  259.55  299.58  391.93 
/
 4  7  6  1  145.81  142.84  142.88  146.12  151.34 
             158.04  165.97  174.88  184.57  194.96 
             205.93  217.42  229.39  241.78  254.99 
             269.17  283.79  345.29  482.86 
/
 4  7  7  1  112.74  120.48  137.95  160.20  186.69 
             216.72  249.76  285.44  323.43  363.62 
             405.89  450.02  496.01  543.89  593.70 
             645.44  699.13  933.58 1511.03 
/
 4  8  1  1  287.72  282.38  278.38  276.98  276.64 
             277.02  277.85  279.03  280.52  282.30 
             284.33  286.62  289.14  291.90  294.88 
             298.08  301.51  317.32  358.79 
/
 4  8  2  1  286.68  280.71  275.76  274.25  273.87 
             274.25  275.09  276.30  277.84  279.67 
             281.76  284.12  286.72  289.56  292.63 
             295.93  299.45  315.75  358.06 
/
 4  8  3  1  281.73  272.27  262.00  260.20  259.86 
             260.23  261.24  262.70  264.57  266.74 
             269.22  271.99  275.05  278.37  281.99 
             285.82  289.89  308.51  356.14 
/
 4  8  4  1  276.84  260.03  248.25  246.76  246.62 
             247.32  248.62  250.40  252.64  255.22 
             258.14  261.42  264.97  268.86  272.99 
             277.43  282.10  303.32  356.51 
/
 4  8  5  1  246.77  200.64  195.56  194.66  195.74 
             197.97  201.05  204.94  209.46  214.54 
             220.11  226.14  232.59  239.42  246.61 
             254.54  262.41  296.69  378.70 
/
 4  8  6  1  166.87  156.20  155.00  156.87  160.53 
             165.49  171.51  178.43  186.12  194.47 
             204.08  213.99  224.62  235.62  247.12 
             258.77  271.15  323.48  441.77 
/
 4  8  7  1  114.43  120.90  133.72  149.93  169.49 
             191.88  216.63  243.38  271.91  302.07 
             333.72  366.67  400.92  436.47  473.32 
             511.47  550.91  721.80 1135.87 
/
 4  9  1  1  293.36  288.99  286.05  284.98  284.81 
             285.19  285.99  287.09  288.52  290.21 
             292.15  294.33  296.74  299.38  302.24 
             305.31  308.59  323.81  363.89 
/
 4  9  2  1  292.68  287.86  284.47  283.20  282.97 
             283.24  284.05  285.19  286.65  288.37 
             290.35  292.58  295.04  297.73  300.64 
             303.77  307.12  322.62  363.32 
/
 4  9  3  1  289.32  282.06  275.10  273.39  273.04 
             273.32  274.19  275.47  277.08  279.01 
             281.23  283.71  286.50  289.50  292.74 
             296.21  299.92  317.02  361.27 
/
 4  9  4  1  285.99  276.26  265.32  263.57  263.27 
             263.74  264.76  266.21  268.04  270.22 
             272.74  275.52  278.58  281.91  285.51 
             289.39  293.49  312.27  360.38 
/
 4  9  5  1  265.59  225.11  219.95  218.63  219.01 
             220.42  222.60  225.40  228.74  232.57 
             236.85  241.54  246.62  252.06  257.84 
             263.95  270.36  298.87  367.72 
/
 4  9  6  1  222.40  182.17  177.36  177.54  179.62 
             182.89  187.15  192.29  198.04  204.55 
             211.65  219.09  227.22  235.82  244.87 
             253.97  263.79  305.60  402.18 
/
 4  9  7  1  118.20  122.82  131.29  142.34  155.71 
             171.15  188.27  206.82  226.66  247.58 
             269.52  292.39  316.17  340.80  366.25 
             392.50  419.56  535.58  805.94 
/
 4 10  1  1  302.07  301.06  300.32  300.28  300.65 
             301.34  302.29  303.48  304.89  306.51 
             308.33  310.36  312.59  315.01  317.63 
             320.44  323.45  337.39  374.43 
/
 4 10  2  1  302.07  301.06  300.32  300.28  300.65 
             301.34  302.29  303.48  304.89  306.51 
             308.33  310.36  312.59  315.01  317.63 
             320.44  323.45  337.39  374.43 
/
 4 10  3  1  302.07  301.06  300.32  300.28  300.65 
             301.34  302.29  303.48  304.89  306.51 
             308.33  310.36  312.59  315.01  317.63 
             320.44  323.45  337.39  374.43 
/
 4 10  4  1  302.07  301.06  300.32  300.28  300.65 
             301.34  302.29  303.48  304.89  306.51 
             308.33  310.36  312.59  315.01  317.63 
             320.44  323.45  337.39  374.43 
/
 4 10  5  1  302.07  301.06  300.32  300.28  300.65 
             301.34  302.29  303.48  304.89  306.51 
             308.33  310.36  312.59  315.01  317.63 
             320.44  323.45  337.39  374.43 
/
 4 10  6  1  302.07  301.06  300.32  300.28  300.65 
             301.34  302.29  303.48  304.89  306.51 
             308.33  310.36  312.59  315.01  317.63 
             320.44  323.45  337.39  374.43 
/
 4 10  7  1  302.07  301.06  300.32  300.28  300.65 
             301.34  302.29  303.48  304.89  306.51 
             308.33  310.36  312.59  315.01  317.63 
             320.44  323.45  337.39  374.43 
/
 5  1  1  1  267.03  263.65  258.67  257.33  257.00 
             257.43  258.39  259.80  261.59  263.73 
             266.18  268.93  271.95  275.25  278.80 
             282.64  286.68  305.19  352.54 
/
 5  1  2  1  264.56  259.01  253.36  251.85  251.48 
             251.94  253.00  254.54  256.49  258.81 
             261.47  264.44  267.74  271.29  275.11 
             279.22  283.54  303.22  353.13 
/
 5  1  3  1  253.66  232.59  228.42  226.92  226.94 
             227.99  229.82  232.27  235.27  238.75 
             242.66  246.97  251.66  256.69  262.03 
             267.68  273.59  299.67  362.27 
/
 5  1  4  1  242.94  214.90  210.47  209.32  209.96 
             211.79  214.53  218.02  222.14  226.82 
             231.91  237.53  243.44  249.84  256.60 
             263.67  271.06  303.38  378.63 
/
 5  1  5  1  167.01  164.36  163.92  166.61  171.38 
             177.70  185.30  193.96  203.52  213.85 
             224.84  236.42  249.16  262.71  276.60 
             290.77  305.43  367.74  509.45 
/
 5  1  6  1  145.65  145.35  151.38  160.80  172.48 
             185.99  201.10  217.62  235.40  254.27 
             274.14  294.93  316.56  338.99  362.21 
             386.18  410.91  522.83  783.49 
/
 5  1  7  1  135.39  154.87  205.53  270.05  344.88 
             429.72  523.35  626.24  737.86  857.61 
             985.43 1120.94 1266.08 1419.72 1581.88 
            1752.89 1932.19 2738.80 4766.22 
/
 5  2  1  1  271.68  268.40  263.68  262.39  262.10 
             262.55  263.51  264.90  266.65  268.74 
             271.13  273.80  276.75  279.96  283.42 
             287.17  291.11  309.22  355.60 
/
 5  2  2  1  269.34  264.66  258.66  257.21  256.88 
             257.35  258.39  259.89  261.78  264.03 
             266.60  269.51  272.66  276.10  279.80 
             283.79  287.98  307.14  355.85 
/
 5  2  3  1  259.17  238.87  234.63  233.12  233.10 
             234.07  235.77  238.08  240.90  244.17 
             247.86  251.94  256.38  261.15  266.22 
             271.58  277.22  302.19  362.78 
/
 5  2  4  1  249.22  221.40  216.81  215.53  216.01 
             217.64  220.13  223.33  227.14  231.48 
             236.32  241.59  247.28  253.33  259.74 
             266.47  273.51  304.49  377.07 
/
 5  2  5  1  172.59  168.71  167.82  170.03  174.21 
             179.89  186.76  194.65  203.41  212.93 
             223.11  234.40  246.52  259.04  271.91 
             285.27  299.11  357.55  491.36 
/
 5  2  6  1  148.30  147.11  151.68  160.23  170.93 
             183.33  197.21  212.38  228.70  246.05 
             264.31  283.42  303.30  323.92  345.25 
             367.26  389.95  492.38  729.86 
/
 5  2  7  1  135.25  152.01  195.42  251.58  317.21 
             391.33  473.46  562.98  659.69  763.76 
             874.68  992.09 1116.16 1248.37 1387.89 
            1536.13 1690.15 2379.52 4095.45 
/
 5  3  1  1  276.50  273.36  268.94  267.73  267.55 
             267.95  268.91  270.27  271.98  274.01 
             276.34  278.94  281.81  284.93  288.34 
             291.95  295.80  313.49  358.98 
/
 5  3  2  1  274.31  270.19  264.25  262.96  262.66 
             263.13  264.14  265.59  267.42  269.59 
             272.07  274.85  277.90  281.22  284.83 
             288.66  292.73  311.34  358.94 
/
 5  3  3  1  264.90  246.67  241.44  239.94  239.88 
             240.76  242.34  244.50  247.14  250.21 
             253.67  257.50  261.67  266.16  270.96 
             276.04  281.40  305.25  363.66 
/
 5  3  4  1  255.79  228.59  223.91  222.54  222.86 
             224.29  226.54  229.46  232.95  236.95 
             241.43  246.32  251.62  257.28  263.28 
             269.61  276.25  305.64  375.10 
/
 5  3  5  1  182.80  173.97  172.62  174.33  177.94 
             182.96  189.10  196.21  204.15  212.91 
             222.80  233.28  244.39  255.90  267.94 
             280.17  293.16  348.16  473.46 
/
 5  3  6  1  151.59  149.94  152.83  160.22  169.84 
             181.10  193.74  207.57  222.46  238.29 
             254.97  272.41  290.57  309.40  328.87 
             348.96  369.66  462.81  678.26 
/
 5  3  7  1  135.27  149.51  186.53  234.49  290.94 
             355.00  425.74  502.79  585.92  675.05 
             769.45  869.99  975.98 1087.58 1206.05 
            1330.66 1461.23 2044.18 3484.72 
/
 5  4  1  1  282.48  278.91  274.75  273.53  273.28 
             273.74  274.67  275.95  277.62  279.59 
             281.85  284.38  287.20  290.24  293.51 
             297.02  300.77  318.02  362.59 
/
 5  4  2  1  280.44  276.01  270.39  269.04  268.83 
             269.24  270.22  271.62  273.39  275.48 
             277.87  280.54  283.52  286.72  290.17 
             293.87  297.81  315.87  362.30 
/
 5  4  3  1  271.81  255.60  249.07  247.54  247.38 
             248.18  249.62  251.60  254.05  256.89 
             260.14  263.70  267.62  271.85  276.34 
             281.14  286.21  308.84  365.00 
/
 5  4  4  1  263.56  236.52  231.85  230.42  230.62 
             231.85  233.86  236.50  239.68  243.35 
             247.45  251.97  256.87  262.12  267.71 
             273.62  279.83  307.53  373.55 
/
 5  4  5  1  190.40  180.80  178.59  179.81  182.84 
             187.19  192.60  199.25  206.63  214.87 
             223.74  233.07  243.15  253.80  264.70 
             276.04  288.16  339.13  455.78 
/
 5  4  6  1  155.75  153.61  155.38  161.17  169.52 
             179.55  190.90  203.36  216.81  231.13 
             246.23  262.03  278.48  295.54  313.19 
             331.39  350.13  435.22  629.43 
/
 5  4  7  1  135.46  147.38  178.42  218.89  266.80 
             321.00  380.84  446.06  516.31  591.46 
             671.20  755.55  844.51  937.96 1035.43 
            1139.25 1248.02 1731.14 2923.99 
/
 5  5  1  1  289.07  284.88  280.81  279.58  279.42 
             279.79  280.70  281.99  283.60  285.51 
             287.70  290.15  292.85  295.79  298.97 
             302.38  306.02  322.82  366.44 
/
 5  5  2  1  287.26  282.29  276.97  275.60  275.39 
             275.77  276.72  278.06  279.75  281.76 
             284.05  286.63  289.45  292.54  295.91 
             299.48  303.28  320.79  365.96 
/
 5  5  3  1  279.49  265.85  257.41  255.86  255.61 
             256.29  257.63  259.44  261.68  264.34 
             267.33  270.64  274.30  278.23  282.46 
             286.95  291.72  313.15  366.88 
/
 5  5  4  1  272.14  245.29  240.74  239.29  239.38 
             240.44  242.23  244.60  247.48  250.81 
             254.55  258.68  263.17  268.01  273.17 
             278.64  284.44  310.29  372.85 
/
 5  5  5  1  205.05  190.23  186.50  187.15  189.65 
             193.44  198.30  204.05  210.59  217.83 
             225.87  234.36  243.38  252.90  262.89 
             273.32  284.16  330.82  438.39 
/
 5  5  6  1  161.14  158.48  159.32  163.75  170.54 
             179.13  189.07  200.10  212.05  224.82 
             238.31  252.46  267.21  282.51  298.34 
             314.68  331.49  408.50  583.17 
/
 5  5  7  1  135.88  145.74  171.18  204.54  244.31 
             289.46  339.28  393.47  451.72  513.91 
             579.77  649.14  722.11  798.74  878.98 
             962.66 1050.30 1442.49 2410.52 
/
 5  6  1  1  295.71  291.06  287.30  286.04  285.77 
             286.21  287.08  288.32  289.88  291.73 
             293.84  296.21  298.83  301.68  304.76 
             308.07  311.61  327.90  370.53 
/
 5  6  2  1  294.17  288.82  283.90  282.53  282.31 
             282.66  283.57  284.85  286.47  288.40 
             290.60  293.07  295.79  298.75  301.96 
             305.44  309.11  325.99  369.91 
/
 5  6  3  1  287.39  276.45  266.52  264.95  264.63 
             265.21  266.38  268.07  270.12  272.54 
             275.30  278.39  281.76  285.42  289.38 
             293.57  298.01  318.23  369.37 
/
 5  6  4  1  281.02  257.75  250.67  249.26  249.28 
             250.19  251.77  253.89  256.47  259.47 
             262.86  266.61  270.71  275.14  279.88 
             284.92  290.26  314.15  372.88 
/
 5  6  5  1  242.96  201.66  196.84  196.75  198.65 
             201.77  205.90  210.83  216.59  222.88 
             229.90  237.50  245.38  253.96  263.02 
             272.15  282.02  324.27  422.71 
/
 5  6  6  1  168.37  165.13  165.02  168.32  173.72 
             180.71  189.02  198.42  208.75  219.86 
             231.67  244.10  257.09  270.59  284.58 
             299.03  315.21  383.71  538.05 
/
 5  6  7  1  136.58  144.68  164.95  191.65  223.71 
             260.28  300.75  344.76  391.94  442.10 
             495.16  550.87  609.28  670.43  734.34 
             801.03  870.46 1179.05 1938.86 
/
 5  7  1  1  302.22  297.38  294.05  292.77  292.59 
             292.91  293.76  294.95  296.45  298.23 
             300.27  302.56  305.09  307.85  310.84 
             314.05  317.48  333.33  374.85 
/
 5  7  2  1  300.97  295.52  291.31  289.91  289.58 
             289.98  290.83  292.06  293.60  295.44 
             297.55  299.91  302.53  305.37  308.46 
             311.77  315.31  331.62  374.31 
/
 5  7  3  1  295.33  286.33  276.54  274.83  274.54 
             275.01  276.05  277.53  279.40  281.62 
             284.15  286.98  290.12  293.51  297.15 
             301.05  305.23  324.20  372.69 
/
 5  7  4  1  290.04  272.98  262.13  260.64  260.58 
             261.34  262.71  264.60  266.89  269.59 
             272.64  276.01  279.70  283.71  287.99 
             292.58  297.44  319.36  374.18 
/
 5  7  5  1  258.13  215.05  210.22  209.45  210.66 
             213.12  216.55  220.64  225.47  230.89 
             236.86  243.31  250.47  257.82  265.56 
             273.66  282.53  320.14  408.20 
/
 5  7  6  1  181.74  174.59  173.50  175.66  179.74 
             185.24  191.89  199.54  208.06  217.33 
             227.27  237.82  248.92  261.38  274.34 
             287.80  301.54  360.42  495.86 
/
 5  7  7  1  137.73  144.41  160.03  180.45  205.28 
             233.81  265.52  300.02  336.98  376.24 
             417.62  460.96  506.25  553.50  602.75 
             653.98  707.22  940.13 1515.48 
/
 5  8  1  1  308.35  303.73  300.78  299.72  299.55 
             299.95  300.75  301.87  303.32  305.04 
             307.00  309.21  311.64  314.31  317.19 
             320.30  323.62  339.01  379.53 
/
 5  8  2  1  307.41  302.30  298.96  297.59  297.25 
             297.63  298.44  299.61  301.09  302.84 
             304.81  307.08  309.58  312.31  315.27 
             318.46  321.86  337.67  379.01 
/
 5  8  3  1  303.06  295.12  287.27  285.70  285.25 
             285.65  286.57  287.90  289.60  291.62 
             293.93  296.53  299.39  302.52  305.89 
             309.54  313.39  331.15  376.94 
/
 5  8  4  1  298.95  287.83  275.56  273.89  273.67 
             274.24  275.38  276.97  278.96  281.34 
             284.02  287.00  290.31  293.87  297.71 
             301.85  306.21  326.18  376.78 
/
 5  8  5  1  274.06  232.24  227.08  225.96  226.64 
             228.45  231.10  234.44  238.39  242.87 
             247.86  253.30  259.18  265.45  272.10 
             279.11  286.45  318.91  396.60 
/
 5  8  6  1  200.79  189.85  186.78  187.75  190.53 
             194.62  199.74  205.84  212.76  220.45 
             228.71  237.75  247.20  257.42  267.91 
             278.87  290.27  339.94  454.66 
/
 5  8  7  1  139.65  145.16  156.41  171.27  189.49 
             210.59  234.14  259.79  287.31  316.54 
             347.26  379.41  412.97  447.90  484.20 
             521.82  560.78  730.09 1141.65 
/
 5  9  1  1  313.84  309.95  307.43  306.57  306.52 
             306.96  307.78  308.92  310.33  312.00 
             313.90  316.04  318.40  320.98  323.76 
             326.77  329.98  344.87  384.25 
/
 5  9  2  1  313.23  308.98  306.17  305.19  305.06 
             305.47  306.27  307.40  308.82  310.51 
             312.44  314.61  317.01  319.63  322.46 
             325.52  328.79  343.94  383.93 
/
 5  9  3  1  310.29  304.02  298.86  297.24  296.90 
             297.23  297.97  299.18  300.72  302.56 
             304.68  307.05  309.68  312.55  315.66 
             319.00  322.57  339.10  382.13 
/
 5  9  4  1  307.46  299.09  290.58  288.82  288.47 
             288.79  289.72  291.07  292.79  294.82 
             297.20  299.82  302.71  305.87  309.28 
             312.94  316.88  334.80  381.14 
/
 5  9  5  1  290.34  254.45  249.60  248.22  248.40 
             249.53  251.37  253.78  256.70  260.06 
             263.84  268.02  272.57  277.48  282.73 
             288.30  294.18  320.65  386.10 
/
 5  9  6  1  261.86  215.16  210.27  209.58  210.99 
             213.64  217.26  221.66  226.73  232.41 
             238.64  245.38  252.84  260.52  268.60 
             277.43  286.28  325.51  418.44 
/
 5  9  7  1  147.01  147.17  154.61  164.70  177.13 
             191.63  207.75  225.32  244.20  264.24 
             285.39  307.54  330.64  354.65  379.52 
             405.24  431.78  546.14  814.99 
/
 5 10  1  1  322.17  321.15  320.42  320.37  320.75 
             321.44  322.39  323.57  324.98  326.60 
             328.43  330.45  332.68  335.10  337.72 
             340.53  343.53  357.47  394.49 
/
 5 10  2  1  322.17  321.15  320.42  320.37  320.75 
             321.44  322.39  323.57  324.98  326.60 
             328.43  330.45  332.68  335.10  337.72 
             340.53  343.53  357.47  394.49 
/
 5 10  3  1  322.17  321.15  320.42  320.37  320.75 
             321.44  322.39  323.57  324.98  326.60 
             328.43  330.45  332.68  335.10  337.72 
             340.53  343.53  357.47  394.49 
/
 5 10  4  1  322.17  321.15  320.42  320.37  320.75 
             321.44  322.39  323.57  324.98  326.60 
             328.43  330.45  332.68  335.10  337.72 
             340.53  343.53  357.47  394.49 
/
 5 10  5  1  322.17  321.15  320.42  320.37  320.75 
             321.44  322.39  323.57  324.98  326.60 
             328.43  330.45  332.68  335.10  337.72 
             340.53  343.53  357.47  394.49 
/
 5 10  6  1  322.17  321.15  320.42  320.37  320.75 
             321.44  322.39  323.57  324.98  326.60 
             328.43  330.45  332.68  335.10  337.72 
             340.53  343.53  357.47  394.49 
/
 5 10  7  1  322.17  321.15  320.42  320.37  320.75 
             321.44  322.39  323.57  324.98  326.60 
             328.43  330.45  332.68  335.10  337.72 
             340.53  343.53  357.47  394.49 
/
 6  1  1  1  287.65  285.69  283.06  282.08  281.91 
             282.34  283.29  284.63  286.31  288.31 
             290.60  293.17  296.00  299.09  302.42 
             306.00  309.81  327.40  373.00 
/
 6  1  2  1  285.30  282.56  278.67  277.50  277.27 
             277.71  278.71  280.13  281.92  284.05 
             286.49  289.23  292.24  295.55  299.09 
             302.88  306.92  325.48  373.31 
/
 6  1  3  1  275.72  260.43  256.66  255.27  255.21 
             256.05  257.60  259.73  262.34  265.39 
             268.85  272.67  276.85  281.35  286.14 
             291.25  296.63  320.67  380.34 
/
 6  1  4  1  266.85  243.92  239.81  238.54  238.88 
             240.30  242.55  245.48  249.01  253.06 
             257.59  262.57  267.96  273.73  279.87 
             286.35  293.15  323.39  395.00 
/
 6  1  5  1  201.57  193.96  192.71  194.53  198.35 
             203.67  210.21  217.80  226.32  235.64 
             246.13  257.36  269.33  281.99  295.05 
             308.67  322.47  382.65  522.60 
/
 6  1  6  1  173.92  172.26  175.49  183.55  194.19 
             206.78  221.01  236.68  253.62  271.71 
             290.85  310.94  331.93  353.78  376.45 
             399.93  424.20  534.88  792.84 
/
 6  1  7  1  159.42  176.50  222.97  284.09  356.89 
             440.23  533.03  634.95  745.79  865.07 
             992.37 1127.71 1272.46 1426.01 1588.18 
            1759.40 1938.81 2742.35 4773.06 
/
 6  2  1  1  292.24  290.28  287.79  286.75  286.68 
             287.13  288.08  289.40  291.06  292.99 
             295.24  297.76  300.54  303.60  306.87 
             310.38  314.12  331.33  376.17 
/
 6  2  2  1  290.00  287.32  283.61  282.48  282.27 
             282.77  283.71  285.11  286.87  288.95 
             291.33  294.00  296.94  300.14  303.62 
             307.33  311.27  329.42  376.21 
/
 6  2  3  1  280.93  266.99  262.62  261.16  261.07 
             261.85  263.32  265.32  267.80  270.69 
             273.98  277.60  281.58  285.85  290.45 
             295.33  300.45  323.59  381.26 
/
 6  2  4  1  272.65  250.05  245.86  244.53  244.77 
             246.05  248.13  250.85  254.13  257.92 
             262.16  266.84  271.91  277.36  283.16 
             289.30  295.75  324.54  393.26 
/
 6  2  5  1  207.03  198.55  196.92  198.34  201.67 
             206.42  212.33  219.22  226.99  236.08 
             245.83  256.32  267.34  278.74  290.94 
             303.72  316.67  373.39  503.75 
/
 6  2  6  1  176.89  174.84  177.05  183.74  193.26 
             204.68  217.65  231.96  247.45  264.01 
             281.53  299.95  319.18  339.21  359.98 
             381.48  403.70  504.86  740.67 
/
 6  2  7  1  159.41  174.04  214.14  267.25  330.66 
             403.07  483.79  572.28  668.44  771.79 
             882.12  999.06 1123.11 1255.28 1394.84 
            1541.50 1695.21 2383.47 4104.52 
/
 6  3  1  1  296.99  295.05  292.75  291.73  291.70 
             292.15  293.10  294.41  296.05  297.94 
             300.15  302.62  305.34  308.30  311.54 
             314.98  318.65  335.54  379.65 
/
 6  3  2  1  294.88  292.28  288.81  287.73  287.56 
             288.07  289.05  290.38  292.10  294.13 
             296.45  299.05  301.94  305.06  308.42 
             312.03  315.87  333.60  379.47 
/
 6  3  3  1  286.38  274.55  269.08  267.59  267.47 
             268.19  269.55  271.45  273.77  276.50 
             279.61  283.04  286.81  290.87  295.24 
             299.87  304.79  326.95  382.65 
/
 6  3  4  1  278.75  256.77  252.57  251.20  251.36 
             252.51  254.41  256.92  259.97  263.49 
             267.45  271.81  276.56  281.67  287.13 
             292.91  299.02  326.29  392.04 
/
 6  3  5  1  213.41  204.67  202.06  203.04  205.89 
             210.15  215.59  222.00  229.30  237.41 
             246.29  255.86  265.87  276.69  287.80 
             299.41  311.47  364.04  486.17 
/
 6  3  6  1  180.52  178.07  179.49  184.87  193.05 
             203.19  214.85  227.78  241.82  256.85 
             272.77  289.52  307.02  325.24  344.14 
             363.71  383.92  476.30  689.31 
/
 6  3  7  1  159.55  171.92  206.00  251.44  305.91 
             368.14  437.43  513.36  595.58  683.91 
             778.04  877.93  983.33 1094.32 1212.39 
            1336.64 1466.84 2048.59 3491.22 
/
 6  4  1  1  302.92  300.43  298.14  297.18  297.05 
             297.50  298.43  299.72  301.32  303.21 
             305.36  307.77  310.44  313.34  316.47 
             319.83  323.42  339.98  383.20 
/
 6  4  2  1  300.95  297.87  294.58  293.38  293.28 
             293.72  294.68  296.02  297.68  299.66 
             301.91  304.44  307.22  310.25  313.52 
             317.03  320.77  338.06  382.96 
/
 6  4  3  1  293.00  283.27  276.10  274.60  274.44 
             275.10  276.36  278.12  280.30  282.88 
             285.80  289.06  292.60  296.45  300.60 
             304.99  309.68  330.89  384.47 
/
 6  4  4  1  286.05  264.14  260.00  258.64  258.73 
             259.75  261.48  263.79  266.60  269.86 
             273.53  277.58  282.01  286.78  291.89 
             297.32  303.05  328.72  391.35 
/
 6  4  5  1  222.60  213.10  208.68  209.20  211.61 
             215.34  220.17  225.92  232.49  239.79 
             247.78  256.39  265.58  275.31  285.55 
             296.27  307.44  355.90  469.07 
/
 6  4  6  1  185.06  182.18  182.80  187.17  193.98 
             202.67  212.92  224.40  236.95  250.42 
             264.73  279.81  295.58  312.02  329.07 
             346.74  364.98  448.63  640.85 
/
 6  4  7  1  159.87  170.21  198.63  236.76  282.76 
             335.37  393.91  458.05  527.36  601.68 
             680.67  764.35  852.72  945.62 1042.92 
            1145.91 1254.28 1736.15 2929.51 
/
 6  5  1  1  309.49  306.22  303.87  302.87  302.72 
             303.21  304.05  305.31  306.87  308.70 
             310.81  313.16  315.76  318.59  321.64 
             324.93  328.44  344.65  387.08 
/
 6  5  2  1  307.74  303.93  300.64  299.50  299.30 
             299.78  300.70  301.94  303.56  305.47 
             307.66  310.10  312.80  315.74  318.92 
             322.33  325.97  342.81  386.71 
/
 6  5  3  1  300.53  292.57  283.76  282.24  282.05 
             282.63  283.80  285.43  287.47  289.89 
             292.63  295.67  299.01  302.66  306.56 
             310.72  315.17  335.35  386.78 
/
 6  5  4  1  294.28  273.38  268.25  266.91  266.96 
             267.87  269.45  271.56  274.13  277.13 
             280.52  284.26  288.37  292.81  297.56 
             302.61  307.95  331.98  391.34 
/
 6  5  5  1  257.81  221.51  217.05  216.93  218.82 
             221.99  226.19  231.23  237.11  243.57 
             250.80  258.63  266.79  275.68  285.08 
             294.61  304.90  349.22  453.59 
/
 6  5  6  1  190.87  187.53  187.35  190.73  196.33 
             203.63  212.35  222.26  233.21  245.06 
             257.71  271.08  285.11  299.75  314.97 
             330.73  348.11  422.99  594.96 
/
 6  5  7  1  160.39  168.95  192.12  223.38  261.33 
             304.90  353.42  406.51  463.81  525.17 
             590.23  658.92  731.29  807.37  887.10 
             970.31 1057.90 1449.22 2414.48 
/
 6  6  1  1  316.12  312.22  309.72  308.81  308.73 
             309.15  309.99  311.20  312.72  314.50 
             316.50  318.80  321.32  324.08  327.07 
             330.27  333.70  349.54  391.16 
/
 6  6  2  1  314.63  310.24  307.15  305.94  305.71 
             306.16  307.04  308.23  309.79  311.63 
             313.75  316.12  318.73  321.58  324.66 
             327.97  331.51  347.84  390.70 
/
 6  6  3  1  308.30  300.58  292.19  290.62  290.37 
             290.82  291.89  293.40  295.30  297.57 
             300.12  302.97  306.11  309.51  313.22 
             317.15  321.33  340.50  389.77 
/
 6  6  4  1  302.85  286.51  277.62  276.23  276.22 
             277.05  278.46  280.36  282.72  285.47 
             288.56  292.01  295.77  299.86  304.23 
             308.91  313.84  336.25  392.23 
/
 6  6  5  1  270.59  231.85  227.31  226.77  228.08 
             230.65  234.27  238.59  243.67  249.39 
             255.67  262.68  270.00  277.77  285.97 
             294.90  303.90  343.84  439.02 
/
 6  6  6  1  198.52  194.69  193.71  196.11  200.54 
             206.50  213.72  222.03  231.29  241.41 
             252.28  263.84  276.04  288.83  302.57 
             317.43  332.87  398.82  550.29 
/
 6  6  7  1  161.20  168.21  186.61  211.45  241.84 
             276.94  316.13  359.03  405.24  454.57 
             506.80  561.80  619.58  680.16  743.57 
             809.79  878.80 1185.85 1943.67 
/
 6  7  1  1  322.60  318.36  315.78  314.89  314.82 
             315.27  316.12  317.30  318.77  320.50 
             322.49  324.72  327.18  329.87  332.78 
             335.90  339.24  354.73  395.55 
/
 6  7  2  1  321.40  316.71  313.76  312.68  312.47 
             312.85  313.69  314.88  316.33  318.11 
             320.15  322.44  324.97  327.73  330.72 
             333.92  337.35  353.23  394.94 
/
 6  7  3  1  316.12  308.60  301.28  299.67  299.38 
             299.75  300.72  302.11  303.86  305.94 
             308.32  310.98  313.95  317.15  320.60 
             324.30  328.25  346.40  393.36 
/
 6  7  4  1  311.55  300.44  288.45  287.02  286.87 
             287.51  288.73  290.42  292.52  295.01 
             297.81  300.92  304.37  308.09  312.11 
             316.38  320.95  341.64  394.09 
/
 6  7  5  1  284.31  244.68  239.80  238.90  239.82 
             241.93  244.92  248.65  253.03  257.92 
             263.41  269.29  275.72  282.59  289.86 
             297.51  305.53  340.95  425.76 
/
 6  7  6  1  215.18  204.61  202.83  204.27  207.57 
             212.21  217.97  224.68  232.24  240.58 
             249.61  260.07  270.82  282.41  294.44 
             306.74  319.90  376.41  508.69 
/
 6  7  7  1  162.44  168.18  182.22  201.17  224.58 
             251.79  282.31  315.73  351.73  390.13 
             430.64  473.24  517.88  564.58  613.31 
             664.08  716.89  948.32 1521.45 
/
 6  8  1  1  328.69  324.51  322.00  321.17  321.13 
             321.59  322.43  323.59  325.02  326.71 
             328.65  330.81  333.21  335.82  338.65 
             341.69  344.94  360.02  399.89 
/
 6  8  2  1  327.81  323.25  320.43  319.44  319.32 
             319.74  320.57  321.72  323.17  324.89 
             326.86  329.06  331.50  334.17  337.06 
             340.16  343.49  358.89  399.53 
/
 6  8  3  1  323.75  316.88  311.11  309.48  309.16 
             309.45  310.32  311.59  313.20  315.12 
             317.33  319.81  322.55  325.55  328.78 
             332.25  335.96  353.11  397.74 
/
 6  8  4  1  320.16  310.75  300.75  299.08  298.81 
             299.30  300.34  301.81  303.67  305.86 
             308.38  311.19  314.32  317.68  321.32 
             325.21  329.40  348.43  397.32 
/
 6  8  5  1  298.71  260.78  255.84  254.61  255.05 
             256.53  258.80  261.71  265.18  269.17 
             273.62  278.52  283.84  289.56  295.65 
             302.11  308.91  339.31  413.72 
/
 6  8  6  1  259.70  222.02  217.15  217.44  219.63 
             223.12  227.59  233.00  239.19  246.12 
             253.73  261.96  270.56  279.90  289.77 
             300.14  311.00  358.35  469.89 
/
 6  8  7  1  166.22  169.16  179.13  192.89  209.97 
             229.96  252.46  277.12  303.71  332.02 
             361.95  393.40  426.33  460.68  496.44 
             533.58  572.10  739.91 1149.03 
/
 6  9  1  1  334.13  330.52  328.30  327.60  327.62 
             328.12  328.96  330.11  331.52  333.17 
             335.06  337.17  339.49  342.04  344.79 
             347.74  350.91  365.60  404.51 
/
 6  9  2  1  333.56  329.67  327.21  326.40  326.37 
             326.83  327.66  328.80  330.21  331.88 
             333.79  335.92  338.28  340.86  343.65 
             346.64  349.85  364.75  404.16 
/
 6  9  3  1  330.85  325.27  321.50  320.02  319.64 
             319.88  320.67  321.83  323.32  325.10 
             327.14  329.44  331.99  334.78  337.80 
             341.05  344.53  360.62  402.88 
/
 6  9  4  1  328.36  320.96  314.42  312.53  312.17 
             312.53  313.33  314.61  316.24  318.19 
             320.43  322.94  325.72  328.80  332.08 
             335.60  339.37  356.71  401.92 
/
 6  9  5  1  313.44  281.19  276.73  275.40  275.51 
             276.50  278.15  280.33  282.98  286.05 
             289.52  293.36  297.57  302.12  306.99 
             312.19  317.70  342.68  405.46 
/
 6  9  6  1  288.93  244.93  239.95  239.20  240.32 
             242.61  245.70  249.65  254.14  259.32 
             265.07  271.33  278.07  285.26  292.87 
             300.88  309.27  346.34  436.00 
/
 6  9  7  1  175.36  173.41  178.12  187.22  198.86 
             212.47  227.72  244.43  262.50  281.79 
             302.21  323.69  346.16  369.58  393.92 
             419.13  445.22  558.00  825.47 
/
 6 10  1  1  342.28  341.25  340.52  340.47  340.84 
             341.53  342.48  343.67  345.07  346.69 
             348.52  350.54  352.77  355.19  357.81 
             360.62  363.62  377.55  414.56 
/
 6 10  2  1  342.28  341.25  340.52  340.47  340.84 
             341.53  342.48  343.67  345.07  346.69 
             348.52  350.54  352.77  355.19  357.81 
             360.62  363.62  377.55  414.56 
/
 6 10  3  1  342.28  341.25  340.52  340.47  340.84 
             341.53  342.48  343.67  345.07  346.69 
             348.52  350.54  352.77  355.19  357.81 
             360.62  363.62  377.55  414.56 
/
 6 10  4  1  342.28  341.25  340.52  340.47  340.84 
             341.53  342.48  343.67  345.07  346.69 
             348.52  350.54  352.77  355.19  357.81 
             360.62  363.62  377.55  414.56 
/
 6 10  5  1  342.28  341.25  340.52  340.47  340.84 
             341.53  342.48  343.67  345.07  346.69 
             348.52  350.54  352.77  355.19  357.81 
             360.62  363.62  377.55  414.56 
/
 6 10  6  1  342.28  341.25  340.52  340.47  340.84 
             341.53  342.48  343.67  345.07  346.69 
             348.52  350.54  352.77  355.19  357.81 
             360.62  363.62  377.55  414.56 
/
 6 10  7  1  342.28  341.25  340.52  340.47  340.84 
             341.53  342.48  343.67  345.07  346.69 
             348.52  350.54  352.77  355.19  357.81 
             360.62  363.62  377.55  414.56 
/
 7  1  1  1  307.88  306.73  305.42  304.88  304.90 
             305.42  306.40  307.73  309.33  311.27 
             313.48  315.95  318.67  321.64  324.86 
             328.30  331.97  348.95  393.33 
/
 7  1  2  1  305.52  303.90  301.92  301.01  300.96 
             301.51  302.47  303.85  305.57  307.60 
             309.93  312.53  315.39  318.52  321.90 
             325.51  329.37  347.15  393.51 
/
 7  1  3  1  296.45  286.06  282.79  281.48  281.42 
             282.16  283.53  285.43  287.78  290.56 
             293.69  297.19  301.00  305.12  309.54 
             314.26  319.24  341.90  399.16 
/
 7  1  4  1  288.86  270.38  266.79  265.60  265.84 
             267.05  269.02  271.61  274.76  278.39 
             282.49  287.00  291.92  297.21  302.87 
             308.88  315.22  343.46  411.89 
/
 7  1  5  1  229.81  222.13  220.33  221.59  224.76 
             229.35  235.12  242.05  250.11  258.94 
             268.72  279.16  290.31  301.89  314.34 
             327.08  340.72  398.86  535.45 
/
 7  1  6  1  201.19  198.99  200.95  207.24  216.63 
             228.21  241.53  256.35  272.48  289.82 
             308.25  327.68  348.06  369.33  391.48 
             414.48  438.92  547.77  804.34 
/
 7  1  7  1  183.28  198.46  241.80  300.40  371.31 
             452.98  544.58  645.58  755.63  874.19 
            1000.77 1135.51 1279.76 1432.85 1595.11 
            1765.42 1945.21 2746.81 4779.20 
/
 7  2  1  1  312.45  311.24  309.91  309.39  309.48 
             310.01  310.98  312.26  313.88  315.79 
             317.97  320.41  323.09  326.01  329.17 
             332.56  336.18  352.90  396.69 
/
 7  2  2  1  310.20  308.55  306.68  305.77  305.72 
             306.29  307.23  308.60  310.29  312.29 
             314.57  317.12  319.92  322.99  326.30 
             329.84  333.63  351.07  396.65 
/
 7  2  3  1  301.50  293.01  288.37  287.06  286.98 
             287.68  288.99  290.80  293.04  295.69 
             298.68  302.01  305.68  309.61  313.87 
             318.39  323.22  345.05  400.55 
/
 7  2  4  1  294.38  276.22  272.57  271.36  271.54 
             272.66  274.49  276.92  279.87  283.30 
             287.15  291.42  296.06  301.08  306.44 
             312.14  318.16  345.05  410.82 
/
 7  2  5  1  235.25  227.85  224.86  225.73  228.52 
             232.71  238.09  244.48  251.82  259.90 
             268.87  278.40  288.78  299.58  310.94 
             323.17  335.62  389.69  517.98 
/
 7  2  6  1  204.37  201.82  203.08  208.40  216.47 
             226.74  238.74  252.17  266.85  282.63 
             299.44  317.18  335.79  355.24  375.47 
             396.49  418.56  518.74  751.27 
/
 7  2  7  1  183.35  196.30  233.59  284.30  345.84 
             416.76  496.26  583.75  679.05  781.62 
             891.27 1007.53 1131.00 1262.67 1401.79 
            1548.12 1701.39 2388.44 4109.03 
/
 7  3  1  1  317.19  315.94  314.61  314.11  314.23 
             314.82  315.77  317.05  318.65  320.54 
             322.68  325.07  327.67  330.55  333.65 
             336.98  340.54  356.97  400.08 
/
 7  3  2  1  315.06  313.41  311.67  310.78  310.75 
             311.32  312.26  313.60  315.27  317.22 
             319.45  321.95  324.70  327.69  330.93 
             334.40  338.11  355.20  399.98 
/
 7  3  3  1  306.80  300.75  294.38  293.08  292.99 
             293.65  294.90  296.62  298.75  301.28 
             304.13  307.30  310.78  314.57  318.63 
             322.99  327.59  348.65  402.29 
/
 7  3  4  1  300.21  282.58  278.95  277.74  277.87 
             278.89  280.59  282.86  285.62  288.83 
             292.45  296.47  300.83  305.56  310.62 
             316.00  321.67  347.19  410.09 
/
 7  3  5  1  241.53  234.50  230.47  230.93  233.32 
             237.05  241.85  247.64  254.27  261.68 
             269.81  278.60  288.01  298.01  308.54 
             319.61  331.18  381.65  501.01 
/
 7  3  6  1  208.23  205.32  205.89  210.29  217.23 
             226.14  236.71  248.68  261.85  276.08 
             291.25  307.31  324.17  341.80  360.16 
             379.21  399.54  490.56  701.25 
/
 7  3  7  1  183.58  194.50  226.07  269.27  321.92 
             382.63  450.72  525.61  606.98  694.50 
             787.92  887.20  991.98 1102.76 1220.57 
            1344.54 1474.42 2054.14 3495.10 
/
 7  4  1  1  323.10  321.23  319.72  319.19  319.30 
             319.88  320.84  322.12  323.69  325.53 
             327.62  329.96  332.55  335.37  338.42 
             341.70  345.16  361.32  403.77 
/
 7  4  2  1  321.10  318.89  317.00  316.23  316.14 
             316.69  317.65  318.92  320.54  322.45 
             324.63  327.07  329.75  332.68  335.84 
             339.23  342.86  359.59  403.39 
/
 7  4  3  1  313.25  307.88  301.01  299.69  299.52 
             300.14  301.32  302.94  304.97  307.37 
             310.07  313.09  316.41  320.03  323.91 
             328.05  332.49  352.66  404.43 
/
 7  4  4  1  307.22  289.72  285.98  284.78  284.88 
             285.81  287.40  289.51  292.07  295.06 
             298.45  302.20  306.30  310.73  315.48 
             320.53  325.88  350.01  409.99 
/
 7  4  5  1  272.68  241.41  237.43  237.30  239.24 
             242.48  246.78  251.95  257.88  264.65 
             271.93  279.99  288.66  297.63  307.36 
             317.61  327.97  374.33  484.64 
/
 7  4  6  1  213.00  209.73  209.61  213.11  218.96 
             226.60  235.74  246.19  257.79  270.41 
             283.92  298.27  313.38  329.19  345.68 
             362.81  381.67  463.31  653.06 
/
 7  4  7  1  183.97  193.07  219.31  255.41  299.64 
             350.76  408.08  471.20  539.60  613.11 
             691.39  774.44  862.24  954.60 1051.34 
            1154.50 1262.51 1742.46 2934.01 
/
 7  5  1  1  329.68  326.95  325.17  324.58  324.66 
             325.22  326.15  327.41  328.94  330.75 
             332.80  335.10  337.63  340.40  343.38 
             346.59  350.01  365.87  407.64 
/
 7  5  2  1  327.92  324.85  322.72  321.94  321.93 
             322.42  323.32  324.59  326.12  327.98 
             330.10  332.47  335.09  337.94  341.03 
             344.33  347.87  364.23  407.17 
/
 7  5  3  1  320.76  314.84  308.27  306.89  306.67 
             307.24  308.33  309.85  311.76  314.01 
             316.57  319.43  322.61  326.04  329.72 
             333.67  337.92  357.24  407.02 
/
 7  5  4  1  315.29  300.21  293.97  292.74  292.76 
             293.59  295.02  296.97  299.34  302.12 
             305.26  308.74  312.57  316.70  321.12 
             325.86  330.86  353.58  410.64 
/
 7  5  5  1  283.60  249.69  245.54  245.21  246.62 
             249.41  253.14  257.67  262.99  268.97 
             275.55  282.69  290.58  298.75  307.38 
             316.79  326.28  368.55  470.01 
/
 7  5  6  1  219.04  215.38  214.57  217.21  221.99 
             228.39  236.15  245.10  255.10  266.04 
             277.84  290.41  303.71  317.68  332.29 
             348.43  365.24  438.15  607.48 
/
 7  5  7  1  184.58  192.07  213.40  242.84  279.15 
             321.29  368.58  420.64  477.04  537.58 
             601.89  669.92  741.72  817.28  896.52 
             979.26 1066.31 1456.34 2419.64 
/
 7  6  1  1  336.32  332.87  330.85  330.20  330.27 
             330.81  331.72  332.94  334.44  336.20 
             338.21  340.45  342.93  345.63  348.55 
             351.69  355.04  370.57  411.57 
/
 7  6  2  1  334.84  331.04  328.70  327.89  327.87 
             328.37  329.26  330.49  332.02  333.82 
             335.88  338.19  340.71  343.49  346.50 
             349.73  353.17  369.15  411.21 
/
 7  6  3  1  328.56  322.22  316.10  314.67  314.40 
             314.91  315.92  317.34  319.13  321.25 
             323.67  326.38  329.36  332.61  336.15 
             339.91  343.91  362.37  410.23 
/
 7  6  4  1  323.72  313.41  303.05  301.73  301.59 
             302.30  303.62  305.38  307.54  310.08 
             312.99  316.20  319.75  323.57  327.70 
             332.09  336.78  358.01  411.94 
/
 7  6  5  1  295.54  259.72  255.23  254.55  255.69 
             258.03  261.29  265.33  269.99  275.25 
             281.14  287.34  294.22  301.57  309.35 
             317.54  326.13  364.11  456.37 
/
 7  6  6  1  232.12  222.83  221.33  223.13  226.88 
             232.08  238.49  245.95  254.37  263.64 
             273.69  284.46  295.89  308.82  322.37 
             336.56  351.16  414.61  564.23 
/
 7  6  7  1  185.48  191.59  208.46  231.71  260.63 
             294.40  332.42  374.28  419.58  468.10 
             519.54  573.86  631.04  691.11  754.04 
             819.83  888.43 1193.98 1949.81 
/
 7  7  1  1  342.80  338.92  336.73  336.05  336.10 
             336.62  337.51  338.70  340.17  341.89 
             343.85  346.04  348.46  351.10  353.96 
             357.03  360.30  375.51  415.72 
/
 7  7  2  1  341.62  337.41  334.94  334.11  334.08 
             334.57  335.44  336.64  338.12  339.87 
             341.87  344.11  346.58  349.28  352.20 
             355.34  358.70  374.26  415.35 
/
 7  7  3  1  336.43  329.97  324.65  323.15  322.81 
             323.24  324.11  325.44  327.12  329.11 
             331.38  333.94  336.76  339.83  343.19 
             346.75  350.56  368.10  413.96 
/
 7  7  4  1  332.31  323.11  313.24  311.71  311.54 
             312.11  313.24  314.81  316.78  319.09 
             321.73  324.71  327.95  331.48  335.30 
             339.36  343.69  363.53  414.34 
/
 7  7  5  1  308.35  271.99  267.32  266.30  267.00 
             268.79  271.40  274.71  278.63  283.11 
             288.10  293.58  299.51  305.88  312.65 
             319.82  327.37  361.03  443.16 
/
 7  7  6  1  243.70  233.77  230.80  231.79  234.55 
             238.59  243.68  249.84  256.95  264.87 
             273.70  283.00  293.16  303.99  315.21 
             326.99  339.66  394.09  522.55 
/
 7  7  7  1  187.61  191.74  204.47  222.18  244.38 
             270.41  299.85  332.29  367.40  404.91 
             444.64  486.57  530.62  576.79  625.05 
             675.39  727.79  957.81 1530.35 
/
 7  8  1  1  348.89  344.98  342.76  342.09  342.14 
             342.66  343.53  344.70  346.13  347.81 
             349.73  351.87  354.24  356.81  359.61 
             362.61  365.81  380.69  420.10 
/
 7  8  2  1  348.03  343.82  341.36  340.57  340.56 
             341.04  341.90  343.06  344.51  346.21 
             348.15  350.32  352.73  355.35  358.19 
             361.24  364.50  379.64  419.70 
/
 7  8  3  1  344.08  337.99  333.89  332.32  331.91 
             332.19  333.04  334.27  335.83  337.68 
             339.82  342.22  344.87  347.77  350.92 
             354.29  357.89  374.57  418.25 
/
 7  8  4  1  340.82  332.50  324.61  322.95  322.57 
             323.03  324.00  325.40  327.17  329.26 
             331.66  334.35  337.31  340.58  344.07 
             347.81  351.80  370.17  417.73 
/
 7  8  5  1  321.79  287.16  282.59  281.36  281.69 
             282.99  285.02  287.65  290.81  294.46 
             298.55  303.07  308.00  313.31  319.00 
             325.04  331.43  360.24  431.91 
/
 7  8  6  1  291.69  250.40  246.01  245.64  247.43 
             250.48  254.47  259.35  265.07  271.39 
             278.50  286.05  294.37  303.00  312.42 
             322.01  332.42  377.75  486.34 
/
 7  8  7  1  192.81  192.85  201.80  214.63  230.76 
             249.78  271.35  295.10  320.81  348.31 
             377.51  408.31  440.65  474.47  509.73 
             546.41  584.51  750.92 1159.07 
/
 7  9  1  1  354.31  350.89  348.85  348.26  348.35 
             348.88  349.75  350.90  352.31  353.96 
             355.84  357.93  360.24  362.76  365.49 
             368.42  371.56  386.11  424.71 
/
 7  9  2  1  353.77  350.10  347.89  347.21  347.25 
             347.75  348.61  349.75  351.17  352.83 
             354.72  356.83  359.17  361.71  364.47 
             367.44  370.61  385.33  424.37 
/
 7  9  3  1  351.17  346.08  342.77  341.57  341.34 
             341.70  342.50  343.65  345.11  346.84 
             348.85  351.10  353.59  356.32  359.27 
             362.46  365.85  381.64  423.28 
/
 7  9  4  1  348.89  342.20  337.13  335.40  334.92 
             335.26  336.02  337.25  338.82  340.70 
             342.87  345.30  348.00  350.95  354.13 
             357.56  361.22  378.12  422.41 
/
 7  9  5  1  335.55  308.18  302.12  300.89  300.99 
             301.91  303.45  305.49  307.96  310.85 
             314.11  317.73  321.69  325.98  330.60 
             335.54  340.77  364.65  425.34 
/
 7  9  6  1  313.80  272.47  267.59  266.68  267.54 
             269.52  272.35  275.91  280.11  284.89 
             290.20  296.03  302.34  309.10  316.29 
             323.90  331.90  367.56  454.36 
/
 7  9  7  1  202.78  200.17  202.91  210.43  221.05 
             233.76  248.17  264.11  281.41  299.99 
             319.74  340.59  362.47  385.34  409.16 
             433.90  459.54  570.82  837.04 
/
 7 10  1  1  362.38  361.35  360.61  360.57  360.94 
             361.63  362.58  363.76  365.17  366.79 
             368.61  370.64  372.86  375.28  377.90 
             380.71  383.71  397.63  434.62 
/
 7 10  2  1  362.38  361.35  360.61  360.57  360.94 
             361.63  362.58  363.76  365.17  366.79 
             368.61  370.64  372.86  375.28  377.90 
             380.71  383.71  397.63  434.62 
/
 7 10  3  1  362.38  361.35  360.61  360.57  360.94 
             361.63  362.58  363.76  365.17  366.79 
             368.61  370.64  372.86  375.28  377.90 
             380.71  383.71  397.63  434.62 
/
 7 10  4  1  362.38  361.35  360.61  360.57  360.94 
             361.63  362.58  363.76  365.17  366.79 
             368.61  370.64  372.86  375.28  377.90 
             380.71  383.71  397.63  434.62 
/
 7 10  5  1  362.38  361.35  360.61  360.57  360.94 
             361.63  362.58  363.76  365.17  366.79 
             368.61  370.64  372.86  375.28  377.90 
             380.71  383.71  397.63  434.62 
/
 7 10  6  1  362.38  361.35  360.61  360.57  360.94 
             361.63  362.58  363.76  365.17  366.79 
             368.61  370.64  372.86  375.28  377.90 
             380.71  383.71  397.63  434.62 
/
 7 10  7  1  362.38  361.35  360.61  360.57  360.94 
             361.63  362.58  363.76  365.17  366.79 
             368.61  370.64  372.86  375.28  377.90 
             380.71  383.71  397.63  434.62 
/
 8  1  1  1  328.05  327.25  326.42  326.19  326.46 
             327.15  328.19  329.53  331.17  333.08 
             335.25  337.67  340.34  343.24  346.38 
             349.75  353.35  369.96  413.69 
/
 8  1  2  1  325.59  324.59  323.49  323.09  323.26 
             323.90  324.92  326.28  327.97  329.95 
             332.18  334.71  337.49  340.52  343.80 
             347.32  351.07  368.40  413.83 
/
 8  1  3  1  316.37  310.86  307.01  305.93  305.94 
             306.66  307.95  309.72  311.90  314.47 
             317.39  320.66  324.22  328.10  332.28 
             336.73  341.46  363.13  418.57 
/
 8  1  4  1  309.73  295.02  291.99  290.98  291.23 
             292.35  294.16  296.54  299.44  302.80 
             306.59  310.77  315.34  320.28  325.56 
             331.17  337.11  363.70  429.83 
/
 8  1  5  1  256.20  250.41  247.00  247.89  250.68 
             254.90  260.28  266.68  274.01  282.31 
             291.29  301.01  311.62  322.69  334.37 
             346.64  359.46  415.52  549.31 
/
 8  1  6  1  227.38  224.92  226.19  231.55  239.75 
             250.20  262.57  276.52  291.87  308.46 
             326.19  344.98  364.77  385.51  407.15 
             429.68  454.95  561.97  816.55 
/
 8  1  7  1  206.86  220.58  261.22  317.53  386.66 
             466.90  557.35  657.41  766.60  884.43 
            1010.29 1144.77 1288.54 1441.31 1602.70 
            1773.25 1952.00 2752.33 4782.50 
/
 8  2  1  1  332.61  331.74  330.86  330.63  330.91 
             331.59  332.63  333.96  335.58  337.47 
             339.61  342.00  344.63  347.49  350.58 
             353.90  357.44  373.82  416.94 
/
 8  2  2  1  330.25  329.20  328.06  327.67  327.85 
             328.49  329.52  330.88  332.53  334.47 
             336.69  339.17  341.91  344.89  348.10 
             351.56  355.25  372.29  417.02 
/
 8  2  3  1  321.34  317.57  312.36  311.28  311.27 
             311.93  313.17  314.87  316.97  319.46 
             322.26  325.39  328.83  332.58  336.59 
             340.88  345.48  366.40  420.22 
/
 8  2  4  1  315.07  300.63  297.57  296.55  296.75 
             297.80  299.50  301.76  304.48  307.66 
             311.25  315.22  319.55  324.23  329.24 
             334.58  340.22  365.65  429.10 
/
 8  2  5  1  262.25  255.37  251.86  252.34  254.72 
             258.50  263.43  269.25  276.01  283.58 
             291.91  300.93  310.62  320.94  331.84 
             343.31  354.97  407.51  532.34 
/
 8  2  6  1  230.70  227.93  228.58  233.10  240.24 
             249.46  260.43  272.93  286.76  301.79 
             317.88  334.96  352.97  371.86  391.58 
             412.12  434.85  532.65  763.69 
/
 8  2  7  1  207.00  218.66  253.53  302.10  361.88 
             431.38  509.72  596.25  690.69  792.50 
             901.49 1017.09 1140.40 1271.22 1409.90 
            1555.89 1709.51 2394.56 4113.47 
/
 8  3  1  1  337.34  336.41  335.50  335.27  335.56 
             336.24  337.27  338.59  340.20  342.06 
             344.17  346.52  349.11  351.93  354.97 
             358.24  361.73  377.85  420.35 
/
 8  3  2  1  335.11  334.01  332.86  332.48  332.67 
             333.32  334.34  335.68  337.32  339.24 
             341.42  343.86  346.53  349.45  352.61 
             356.00  359.61  376.34  420.25 
/
 8  3  3  1  326.59  322.99  318.09  317.03  317.02 
             317.64  318.83  320.46  322.47  324.84 
             327.53  330.55  333.85  337.43  341.30 
             345.45  349.85  370.04  422.07 
/
 8  3  4  1  320.72  306.95  303.76  302.72  302.87 
             303.83  305.42  307.54  310.11  313.10 
             316.48  320.22  324.31  328.74  333.49 
             338.53  343.89  368.08  428.91 
/
 8  3  5  1  288.06  261.16  257.81  257.71  259.71 
             263.06  267.42  272.73  278.94  285.79 
             293.48  301.64  310.61  319.93  330.04 
             340.38  351.53  400.12  515.95 
/
 8  3  6  1  234.69  231.62  231.66  235.36  241.48 
             249.50  259.12  270.16  282.44  295.85 
             310.29  325.65  341.88  358.93  376.75 
             395.58  416.37  504.85  713.87 
/
 8  3  7  1  207.27  217.05  246.51  287.76  338.70 
             398.01  464.95  538.85  619.39  706.12 
             798.88  897.55 1001.73 1112.30 1229.32 
            1352.89 1482.43 2060.91 3500.06 
/
 8  4  1  1  343.24  341.67  340.54  340.26  340.52 
             341.18  342.19  343.49  345.07  346.90 
             348.97  351.28  353.83  356.59  359.59 
             362.80  366.23  382.09  423.94 
/
 8  4  2  1  341.16  339.44  338.09  337.66  337.84 
             338.47  339.47  340.79  342.39  344.27 
             346.40  348.79  351.41  354.27  357.36 
             360.68  364.23  380.63  423.80 
/
 8  4  3  1  333.00  329.09  324.45  323.27  323.24 
             323.83  324.96  326.51  328.43  330.69 
             333.27  336.14  339.32  342.76  346.47 
             350.43  354.66  374.10  424.41 
/
 8  4  4  1  327.53  314.60  310.70  309.61  309.67 
             310.56  312.02  313.98  316.39  319.18 
             322.36  325.87  329.72  333.88  338.36 
             343.12  348.19  371.11  429.24 
/
 8  4  5  1  297.00  267.98  264.27  264.17  265.79 
             268.68  272.53  277.34  282.91  289.16 
             296.05  303.53  311.57  320.12  329.46 
             339.00  348.98  393.50  501.21 
/
 8  4  6  1  239.60  236.22  235.65  238.56  243.69 
             250.55  258.86  268.45  279.20  290.98 
             303.72  317.32  331.75  346.94  362.86 
             380.43  398.76  478.56  665.92 
/
 8  4  7  1  207.72  215.83  240.26  274.59  317.21 
             366.97  423.14  485.27  552.84  625.54 
             703.12  785.58  872.84  964.66 1061.20 
            1163.61 1271.26 1751.04 2939.63 
/
 8  5  1  1  349.83  347.36  345.92  345.54  345.75 
             346.39  347.37  348.64  350.18  351.97 
             354.01  356.28  358.77  361.49  364.43 
             367.58  370.95  386.54  427.73 
/
 8  5  2  1  348.01  345.36  343.70  343.19  343.33 
             343.93  344.90  346.18  347.75  349.58 
             351.66  353.99  356.55  359.35  362.37 
             365.61  369.08  385.13  427.45 
/
 8  5  3  1  340.60  335.92  331.33  330.16  330.01 
             330.59  331.65  333.08  334.90  337.05 
             339.51  342.28  345.30  348.59  352.13 
             355.93  359.99  378.68  427.30 
/
 8  5  4  1  335.56  326.49  318.44  317.21  317.23 
             318.00  319.34  321.18  323.40  326.00 
             328.97  332.25  335.84  339.76  343.95 
             348.45  353.20  374.87  430.20 
/
 8  5  5  1  307.42  276.09  272.07  271.61  272.95 
             275.49  278.99  283.29  288.25  293.84 
             299.91  306.69  314.00  321.80  330.08 
             338.79  347.94  388.45  487.31 
/
 8  5  6  1  247.89  242.05  240.89  243.03  247.21 
             252.94  259.98  268.16  277.39  287.57 
             298.61  310.47  323.07  336.38  351.37 
             367.02  383.35  453.90  620.61 
/
 8  5  7  1  208.40  215.03  234.84  262.71  297.55 
             338.39  384.56  435.64  491.20  550.92 
             614.51  681.92  753.17  828.24  907.02 
             989.29 1076.30 1464.67 2425.96 
/
 8  6  1  1  356.47  353.24  351.51  351.05  351.22 
             351.83  352.78  354.01  355.52  357.27 
             359.27  361.49  363.93  366.60  369.48 
             372.58  375.89  391.20  431.71 
/
 8  6  2  1  354.95  351.51  349.57  348.98  349.09 
             349.66  350.60  351.84  353.37  355.15 
             357.18  359.45  361.95  364.68  367.63 
             370.80  374.19  389.88  431.33 
/
 8  6  3  1  348.50  343.17  338.86  337.59  337.37 
             337.88  338.82  340.20  341.93  343.97 
             346.30  348.91  351.78  354.92  358.31 
             361.95  365.82  383.76  430.51 
/
 8  6  4  1  343.97  335.87  327.13  325.77  325.69 
             326.30  327.50  329.20  331.24  333.65 
             336.38  339.46  342.81  346.45  350.39 
             354.58  359.04  379.47  431.96 
/
 8  6  5  1  318.80  285.81  281.56  280.79  281.73 
             283.78  286.69  290.34  294.64  299.53 
             304.97  310.93  317.38  324.30  331.66 
             339.45  347.64  384.18  473.44 
/
 8  6  6  1  258.97  249.64  247.90  249.30  252.57 
             257.21  263.01  269.83  277.57  286.16 
             295.54  306.26  317.74  329.74  342.47 
             355.91  370.02  431.39  577.99 
/
 8  6  7  1  209.70  214.73  230.30  252.25  279.90 
             312.47  349.42  390.31  434.76  482.46 
             533.17  586.84  643.47  703.04  765.54 
             830.92  899.13 1204.02 1958.83 
/
 8  7  1  1  362.96  359.25  357.30  356.77  356.91 
             357.49  358.40  359.61  361.08  362.80 
             364.75  366.92  369.32  371.93  374.76 
             377.79  381.04  396.07  435.89 
/
 8  7  2  1  361.76  357.82  355.67  355.03  355.11 
             355.66  356.56  357.77  359.26  360.99 
             362.97  365.19  367.63  370.29  373.17 
             376.26  379.57  394.90  435.47 
/
 8  7  3  1  356.47  350.80  347.08  345.57  345.37 
             345.73  346.64  347.88  349.51  351.43 
             353.64  356.12  358.85  361.84  365.07 
             368.54  372.24  389.36  434.31 
/
 8  7  4  1  352.57  344.52  336.73  335.25  334.99 
             335.55  336.62  338.12  340.00  342.21 
             344.73  347.59  350.69  354.08  357.73 
             361.66  365.82  384.96  434.52 
/
 8  7  5  1  331.03  297.58  293.25  292.24  292.82 
             294.41  296.78  299.80  303.41  307.54 
             312.16  317.25  322.78  328.74  335.11 
             341.87  349.01  381.11  460.62 
/
 8  7  6  1  298.42  262.32  257.93  258.50  260.92 
             264.63  269.43  275.09  281.65  289.13 
             297.27  306.11  315.62  325.77  336.52 
             347.85  359.76  412.68  538.47 
/
 8  7  7  1  213.05  215.05  226.71  243.39  264.50 
             289.50  317.97  349.51  383.74  420.41 
             459.44  500.74  544.26  589.92  637.72 
             687.64  739.67  968.35 1538.78 
/
 8  8  1  1  369.04  365.27  363.23  362.67  362.79 
             363.35  364.25  365.42  366.86  368.54 
             370.45  372.58  374.93  377.49  380.26 
             383.23  386.41  401.16  440.28 
/
 8  8  2  1  368.18  364.17  361.96  361.31  361.38 
             361.91  362.79  363.97  365.41  367.11 
             369.04  371.19  373.57  376.17  378.97 
             381.99  385.22  400.19  439.86 
/
 8  8  3  1  364.22  358.68  355.27  354.04  353.81 
             354.20  355.03  356.20  357.73  359.54 
             361.60  363.94  366.54  369.37  372.44 
             375.75  379.28  395.64  438.72 
/
 8  8  4  1  361.10  353.63  347.52  345.76  345.48 
             345.84  346.77  348.12  349.82  351.84 
             354.15  356.75  359.61  362.74  366.12 
             369.75  373.65  391.50  438.20 
/
 8  8  5  1  343.88  312.01  307.83  306.69  306.98 
             308.17  310.05  312.50  315.45  318.86 
             322.70  326.95  331.58  336.60  341.98 
             347.72  353.80  381.36  450.79 
/
 8  8  6  1  316.74  277.09  272.88  272.64  274.06 
             276.78  280.48  285.05  290.36  296.20 
             302.94  310.14  317.88  326.15  334.90 
             344.48  354.19  397.75  502.69 
/
 8  8  7  1  218.66  217.22  224.37  236.41  251.71 
             269.89  290.61  313.52  338.44  365.24 
             393.78  423.96  455.74  489.04  523.83 
             560.09  597.79  762.87 1168.72 
/
 8  9  1  1  374.45  371.12  369.21  368.69  368.83 
             369.39  370.27  371.43  372.85  374.49 
             376.36  378.45  380.75  383.26  385.97 
             388.89  392.01  406.48  444.88 
/
 8  9  2  1  373.92  370.39  368.33  367.75  367.84 
             368.38  369.25  370.41  371.83  373.48 
             375.36  377.47  379.79  382.32  385.06 
             388.00  391.15  405.76  444.53 
/
 8  9  3  1  371.36  366.62  363.65  362.62  362.49 
             362.90  363.73  364.88  366.33  368.05 
             370.03  372.25  374.70  377.38  380.29 
             383.42  386.76  402.29  443.36 
/
 8  9  4  1  369.18  363.03  358.99  357.47  357.01 
             357.32  358.06  359.25  360.78  362.60 
             364.71  367.05  369.68  372.55  375.67 
             379.02  382.60  399.19  442.90 
/
 8  9  5  1  357.02  335.87  326.27  325.17  325.29 
             326.19  327.65  329.60  331.96  334.71 
             337.83  341.29  345.08  349.20  353.62 
             358.36  363.40  386.44  445.84 
/
 8  9  6  1  337.30  298.35  293.71  292.75  293.46 
             295.22  297.79  301.04  304.90  309.31 
             314.25  319.67  325.56  331.90  338.67 
             345.86  353.44  387.48  471.60 
/
 8  9  7  1  229.20  226.21  228.18  234.50  243.80 
             255.51  269.08  284.24  300.83  318.72 
             337.83  358.08  379.40  401.74  425.07 
             449.35  474.57  584.44  849.46 
/
 8 10  1  1  382.48  381.45  380.71  380.66  381.04 
             381.72  382.67  383.86  385.26  386.88 
             388.70  390.73  392.95  395.37  397.99 
             400.80  403.80  417.71  454.69 
/
 8 10  2  1  382.48  381.45  380.71  380.66  381.04 
             381.72  382.67  383.86  385.26  386.88 
             388.70  390.73  392.95  395.37  397.99 
             400.80  403.80  417.71  454.69 
/
 8 10  3  1  382.48  381.45  380.71  380.66  381.04 
             381.72  382.67  383.86  385.26  386.88 
             388.70  390.73  392.95  395.37  397.99 
             400.80  403.80  417.71  454.69 
/
 8 10  4  1  382.48  381.45  380.71  380.66  381.04 
             381.72  382.67  383.86  385.26  386.88 
             388.70  390.73  392.95  395.37  397.99 
             400.80  403.80  417.71  454.69 
/
 8 10  5  1  382.48  381.45  380.71  380.66  381.04 
             381.72  382.67  383.86  385.26  386.88 
             388.70  390.73  392.95  395.37  397.99 
             400.80  403.80  417.71  454.69 
/
 8 10  6  1  382.48  381.45  380.71  380.66  381.04 
             381.72  382.67  383.86  385.26  386.88 
             388.70  390.73  392.95  395.37  397.99 
             400.80  403.80  417.71  454.69 
/
 8 10  7  1  382.48  381.45  380.71  380.66  381.04 
             381.72  382.67  383.86  385.26  386.88 
             388.70  390.73  392.95  395.37  397.99 
             400.80  403.80  417.71  454.69 
/
 9  1  1  1  348.35  347.59  346.94  346.89  347.29 
             348.07  349.16  350.54  352.20  354.11 
             356.27  358.67  361.31  364.17  367.27 
             370.59  374.14  390.52  433.72 
/
 9  1  2  1  345.75  344.98  344.25  344.10  344.45 
             345.19  346.28  347.68  349.38  351.35 
             353.58  356.06  358.79  361.76  364.98 
             368.43  372.11  389.13  433.94 
/
 9  1  3  1  335.92  333.36  329.96  329.14  329.20 
             329.91  331.17  332.87  334.95  337.40 
             340.18  343.28  346.69  350.41  354.40 
             358.66  363.21  384.15  438.24 
/
 9  1  4  1  329.84  318.60  315.96  315.11  315.40 
             316.49  318.19  320.44  323.16  326.31 
             329.86  333.80  338.10  342.76  347.74 
             353.03  358.65  383.99  448.28 
/
 9  1  5  1  283.01  275.78  273.06  273.43  275.90 
             279.74  284.78  290.75  297.69  305.34 
             313.89  323.18  333.17  343.83  354.83 
             366.70  379.14  433.49  565.12 
/
 9  1  6  1  252.60  250.07  250.90  255.61  263.03 
             272.61  284.05  297.14  311.68  327.54 
             344.60  362.77  381.98  402.19  423.35 
             446.47  470.95  576.07  828.16 
/
 9  1  7  1  230.11  242.67  281.04  335.31  402.75 
             481.64  570.97  670.13  778.47  895.57 
            1020.70 1154.58 1297.91 1450.22 1611.24 
            1781.31 1959.85 2760.17 4787.48 
/
 9  2  1  1  352.89  352.06  351.37  351.31  351.71 
             352.47  353.56  354.93  356.56  358.45 
             360.58  362.95  365.55  368.38  371.43 
             374.71  378.21  394.37  437.01 
/
 9  2  2  1  350.41  349.57  348.79  348.63  348.98 
             349.71  350.80  352.18  353.85  355.79 
             357.98  360.43  363.11  366.04  369.19 
             372.59  376.21  392.94  437.04 
/
 9  2  3  1  340.89  338.39  335.17  334.26  334.32 
             335.04  336.23  337.87  339.89  342.25 
             344.93  347.94  351.23  354.81  358.67 
             362.80  367.20  387.44  439.94 
/
 9  2  4  1  335.06  324.31  321.51  320.60  320.83 
             321.83  323.43  325.55  328.13  331.11 
             334.49  338.22  342.32  346.75  351.48 
             356.54  361.90  386.15  447.99 
/
 9  2  5  1  304.23  280.73  277.81  278.04  280.13 
             283.56  288.07  293.56  299.98  307.06 
             314.86  323.50  332.59  342.51  352.76 
             363.86  375.15  426.01  548.60 
/
 9  2  6  1  256.00  253.20  253.47  257.42  263.87 
             272.31  282.46  294.12  307.13  321.39 
             336.77  353.20  370.61  388.95  408.18 
             429.52  451.62  547.65  776.71 
/
 9  2  7  1  230.30  240.96  273.80  320.45  378.61 
             446.77  524.00  609.61  703.21  804.28 
             912.61 1027.56 1150.35 1281.20 1419.03 
            1564.56 1717.90 2402.80 4118.91 
/
 9  3  1  1  357.60  356.71  355.99  355.92  356.31 
             357.07  358.15  359.50  361.11  362.98 
             365.08  367.41  369.98  372.77  375.78 
             379.01  382.46  398.39  440.46 
/
 9  3  2  1  355.26  354.36  353.55  353.39  353.73 
             354.46  355.53  356.90  358.54  360.45 
             362.61  365.01  367.65  370.52  373.62 
             376.95  380.51  396.95  440.31 
/
 9  3  3  1  346.15  343.72  340.75  339.82  339.86 
             340.52  341.69  343.27  345.22  347.49 
             350.07  352.96  356.13  359.58  363.31 
             367.33  371.57  391.12  442.06 
/
 9  3  4  1  340.61  330.49  327.59  326.61  326.78 
             327.70  329.20  331.20  333.62  336.44 
             339.64  343.17  347.05  351.24  355.75 
             360.56  365.65  388.80  448.03 
/
 9  3  5  1  311.35  286.48  283.24  283.33  285.21 
             288.26  292.31  297.25  303.06  309.58 
             316.77  324.59  332.99  341.95  351.73 
             361.74  372.23  419.18  532.73 
/
 9  3  6  1  260.08  257.02  256.74  259.95  265.47 
             272.80  281.69  291.95  303.46  316.12 
             329.83  344.51  360.10  376.56  393.84 
             413.47  433.48  520.18  727.06 
/
 9  3  7  1  230.62  239.53  267.21  306.71  356.10 
             414.12  479.95  552.90  632.63  718.61 
             810.71  908.79 1012.38 1122.41 1239.57 
            1362.24 1491.41 2068.74 3505.99 
/
 9  4  1  1  363.48  361.96  361.00  360.86  361.22 
             361.95  363.00  364.33  365.91  367.74 
             369.81  372.11  374.63  377.38  380.34 
             383.52  386.91  402.61  444.08 
/
 9  4  2  1  361.30  359.77  358.73  358.50  358.81 
             359.52  360.57  361.90  363.51  365.38 
             367.50  369.85  372.44  375.26  378.30 
             381.57  385.06  401.20  443.80 
/
 9  4  3  1  352.56  349.73  346.86  345.87  345.87 
             346.49  347.61  349.12  350.98  353.16 
             355.65  358.42  361.47  364.80  368.38 
             372.23  376.32  395.25  444.54 
/
 9  4  4  1  347.28  339.39  334.27  333.24  333.35 
             334.19  335.58  337.44  339.73  342.37 
             345.37  348.72  352.38  356.35  360.61 
             365.17  370.00  392.05  448.68 
/
 9  4  5  1  319.87  293.20  289.67  289.45  290.97 
             293.71  297.42  301.96  307.24  313.15 
             319.66  326.84  334.58  342.57  351.31 
             360.52  370.19  413.14  518.55 
/
 9  4  6  1  265.06  261.73  260.92  263.42  268.03 
             274.29  281.95  290.86  300.90  311.99 
             324.04  336.99  350.78  365.37  381.76 
             398.88  416.77  494.33  679.30 
/
 9  4  7  1  231.11  238.44  261.34  294.14  335.33 
             383.83  438.94  500.12  566.87  638.80 
             715.71  797.58  884.31  975.62 1071.98 
            1174.24 1280.95 1759.53 2948.29 
/
 9  5  1  1  370.05  367.62  366.34  366.09  366.40 
             367.09  368.10  369.40  370.95  372.74 
             374.77  377.03  379.50  382.20  385.11 
             388.24  391.58  407.03  447.89 
/
 9  5  2  1  368.15  365.66  364.28  363.95  364.21 
             364.88  365.89  367.19  368.76  370.58 
             372.65  374.96  377.49  380.25  383.23 
             386.43  389.85  405.68  447.51 
/
 9  5  3  1  360.28  356.51  353.60  352.49  352.42 
             352.97  354.03  355.46  357.23  359.32 
             361.70  364.35  367.28  370.47  373.92 
             377.62  381.56  399.77  447.41 
/
 9  5  4  1  355.33  348.93  341.79  340.64  340.67 
             341.37  342.65  344.40  346.52  348.99 
             351.81  354.94  358.39  362.13  366.14 
             370.45  375.01  395.97  450.02 
/
 9  5  5  1  329.94  301.13  297.36  296.85  298.01 
             300.30  303.48  307.42  312.05  317.31 
             323.15  329.54  336.46  343.87  351.76 
             360.11  368.89  408.10  504.22 
/
 9  5  6  1  275.76  267.67  266.34  268.15  271.90 
             277.12  283.60  291.20  299.80  309.35 
             319.78  331.02  343.63  357.09  371.41 
             386.27  401.89  470.50  634.47 
/
 9  5  7  1  231.96  237.78  256.33  282.85  316.41 
             356.07  401.21  451.36  506.11  565.03 
             627.93  694.74  765.47  840.07  918.41 
            1000.24 1087.24 1473.98 2433.33 
/
 9  6  1  1  376.67  373.49  371.90  371.55  371.79 
             372.45  373.42  374.69  376.20  377.95 
             379.94  382.15  384.59  387.23  390.10 
             393.17  396.45  411.65  451.88 
/
 9  6  2  1  375.08  371.79  370.09  369.66  369.86 
             370.50  371.47  372.73  374.26  376.04 
             378.06  380.31  382.79  385.49  388.40 
             391.54  394.89  410.40  451.44 
/
 9  6  3  1  368.31  363.71  360.83  359.70  359.53 
             360.00  360.98  362.28  363.97  365.96 
             368.23  370.77  373.57  376.63  379.93 
             383.48  387.28  404.79  450.82 
/
 9  6  4  1  363.79  356.88  350.10  348.83  348.70 
             349.35  350.50  352.09  354.05  356.36 
             358.99  361.94  365.16  368.66  372.44 
             376.51  380.80  400.60  451.93 
/
 9  6  5  1  340.97  310.57  306.64  305.88  306.71 
             308.57  311.25  314.62  318.60  323.16 
             328.25  333.83  339.90  346.43  353.40 
             360.79  368.59  403.65  490.46 
/
 9  6  6  1  284.43  275.84  273.50  274.66  277.58 
             281.81  287.15  293.47  301.01  309.36 
             318.70  328.76  339.42  351.02  363.37 
             376.12  389.51  449.52  592.73 
/
 9  6  7  1  234.21  237.62  252.11  272.97  299.51 
             331.02  366.99  406.99  450.63  497.51 
             547.52  600.60  656.72  715.82  777.89 
             842.88  910.72 1214.21 1967.20 
/
 9  7  1  1  383.13  379.47  377.65  377.20  377.40 
             378.02  378.96  380.19  381.66  383.38 
             385.33  387.49  389.88  392.48  395.29 
             398.31  401.53  416.47  456.06 
/
 9  7  2  1  381.89  378.08  376.13  375.62  375.77 
             376.37  377.30  378.53  380.02  381.75 
             383.72  385.92  388.34  390.98  393.83 
             396.90  400.18  415.37  455.60 
/
 9  7  3  1  376.40  371.28  368.26  367.20  367.08 
             367.54  368.45  369.69  371.28  373.14 
             375.30  377.72  380.40  383.32  386.48 
             389.88  393.52  410.35  454.66 
/
 9  7  4  1  372.48  365.37  359.36  357.93  357.68 
             358.21  359.20  360.64  362.45  364.59 
             367.02  369.78  372.78  376.06  379.59 
             383.38  387.42  406.09  454.78 
/
 9  7  5  1  352.83  321.93  317.97  317.02  317.55 
             319.03  321.23  324.06  327.43  331.31 
             335.66  340.47  345.70  351.35  357.40 
             363.84  370.65  401.49  478.79 
/
 9  7  6  1  323.03  287.99  284.22  284.34  286.45 
             289.91  294.31  299.74  305.90  312.93 
             320.71  329.02  338.16  347.95  358.37 
             369.06  380.62  431.34  555.25 
/
 9  7  7  1  237.86  238.10  248.86  264.66  284.85 
             308.94  336.53  367.20  400.58  436.53 
             474.90  515.62  558.61  603.80  651.17 
             700.69  752.35  979.74 1548.13 
/
 9  8  1  1  389.19  385.46  383.52  383.03  383.20 
             383.79  384.70  385.89  387.33  389.02 
             390.92  393.05  395.39  397.94  400.69 
             403.66  406.82  421.50  460.44 
/
 9  8  2  1  388.31  384.40  382.34  381.79  381.91 
             382.48  383.39  384.58  386.03  387.72 
             389.64  391.79  394.15  396.73  399.52 
             402.52  405.73  420.59  460.01 
/
 9  8  3  1  384.24  379.10  376.10  375.08  374.96 
             375.41  376.27  377.48  378.99  380.78 
             382.83  385.14  387.68  390.47  393.48 
             396.73  400.20  416.29  458.80 
/
 9  8  4  1  381.11  374.32  369.74  368.01  367.63 
             368.04  368.89  370.19  371.84  373.79 
             376.04  378.57  381.36  384.41  387.70 
             391.25  395.03  412.52  458.44 
/
 9  8  5  1  365.30  335.75  331.97  330.94  331.23 
             332.37  334.15  336.47  339.27  342.51 
             346.17  350.22  354.65  359.43  364.59 
             370.08  375.92  402.51  470.10 
/
 9  8  6  1  340.44  302.48  298.40  298.04  299.46 
             302.06  305.60  309.95  314.92  320.64 
             326.81  333.71  341.17  349.16  357.65 
             366.63  376.07  418.13  520.71 
/
 9  8  7  1  243.77  241.99  247.19  258.25  272.76 
             290.17  310.13  332.31  356.53  382.67 
             410.59  440.21  471.44  504.26  538.60 
             574.44  611.76  775.57 1180.59 
/
 9  9  1  1  394.59  391.28  389.44  388.97  389.14 
             389.72  390.62  391.79  393.20  394.85 
             396.72  398.80  401.10  403.60  406.31 
             409.21  412.32  426.74  465.02 
/
 9  9  2  1  394.05  390.58  388.63  388.11  388.25 
             388.81  389.70  390.87  392.28  393.94 
             395.82  397.91  400.22  402.74  405.47 
             408.40  411.54  426.07  464.68 
/
 9  9  3  1  391.46  386.97  384.27  383.38  383.32 
             383.78  384.63  385.79  387.24  388.95 
             390.91  393.10  395.53  398.18  401.05 
             404.14  407.44  422.78  463.43 
/
 9  9  4  1  389.29  383.56  379.92  378.60  378.32 
             378.68  379.49  380.67  382.17  383.96 
             386.03  388.36  390.94  393.76  396.82 
             400.11  403.64  419.98  463.11 
/
 9  9  5  1  378.05  364.86  349.53  348.55  348.72 
             349.60  351.03  352.91  355.20  357.85 
             360.86  364.21  367.87  371.86  376.15 
             380.73  385.61  408.01  466.21 
/
 9  9  6  1  359.88  323.01  318.66  317.72  318.35 
             319.97  322.36  325.39  329.00  333.15 
             337.79  342.91  348.48  354.50  360.94 
             367.79  375.03  407.77  489.57 
/
 9  9  7  1  254.68  251.54  252.98  258.59  267.01 
             277.69  290.37  304.76  320.64  337.88 
             356.36  376.03  396.81  418.66  441.52 
             465.37  490.17  598.67  862.53 
/
 9 10  1  1  402.58  401.55  400.80  400.76  401.13 
             401.82  402.77  403.96  405.36  406.97 
             408.80  410.82  413.04  415.46  418.08 
             420.88  423.88  437.80  474.75 
/
 9 10  2  1  402.58  401.55  400.80  400.76  401.13 
             401.82  402.77  403.96  405.36  406.97 
             408.80  410.82  413.04  415.46  418.08 
             420.88  423.88  437.80  474.75 
/
 9 10  3  1  402.58  401.55  400.80  400.76  401.13 
             401.82  402.77  403.96  405.36  406.97 
             408.80  410.82  413.04  415.46  418.08 
             420.88  423.88  437.80  474.75 
/
 9 10  4  1  402.58  401.55  400.80  400.76  401.13 
             401.82  402.77  403.96  405.36  406.97 
             408.80  410.82  413.04  415.46  418.08 
             420.88  423.88  437.80  474.75 
/
 9 10  5  1  402.58  401.55  400.80  400.76  401.13 
             401.82  402.77  403.96  405.36  406.97 
             408.80  410.82  413.04  415.46  418.08 
             420.88  423.88  437.80  474.75 
/
 9 10  6  1  402.58  401.55  400.80  400.76  401.13 
             401.82  402.77  403.96  405.36  406.97 
             408.80  410.82  413.04  415.46  418.08 
             420.88  423.88  437.80  474.75 
/
 9 10  7  1  402.58  401.55  400.80  400.76  401.13 
             401.82  402.77  403.96  405.36  406.97 
             408.80  410.82  413.04  415.46  418.08 
             420.88  423.88  437.80  474.75 
/
10  1  1  1  368.60  367.87  367.26  367.26  367.72 
             368.54  369.67  371.09  372.76  374.69 
             376.85  379.25  381.89  384.74  387.83 
             391.14  394.66  410.96  453.92 
/
10  1  2  1  366.06  365.31  364.68  364.67  365.12 
             365.94  367.09  368.52  370.22  372.19 
             374.42  376.88  379.59  382.54  385.72 
             389.13  392.77  409.58  453.95 
/
10  1  3  1  355.37  353.78  352.03  351.30  351.48 
             352.24  353.48  355.14  357.16  359.53 
             362.22  365.22  368.51  372.10  375.97 
             380.11  384.52  404.89  457.91 
/
10  1  4  1  349.44  341.53  339.09  338.36  338.67 
             339.72  341.34  343.48  346.05  349.04 
             352.41  356.15  360.25  364.67  369.42 
             374.48  379.83  404.35  467.22 
/
10  1  5  1  320.51  300.13  297.66  298.25  300.50 
             304.06  308.76  314.39  320.94  328.28 
             336.36  345.32  354.78  365.10  375.79 
             387.04  399.19  452.03  581.73 
/
10  1  6  1  276.98  274.50  275.07  279.31  286.12 
             295.03  305.73  318.07  331.86  347.01 
             363.40  380.94  399.59  419.29  440.66 
             463.52  487.24  591.27  841.35 
/
10  1  7  1  253.01  264.66  301.12  353.59  419.46 
             497.07  585.33  683.60  791.11  907.49 
            1031.92 1165.26 1308.56 1460.00 1620.60 
            1790.37 1968.57 2767.65 4793.35 
/
10  2  1  1  373.14  372.34  371.68  371.67  372.12 
             372.93  374.06  375.45  377.10  379.00 
             381.14  383.51  386.11  388.93  391.97 
             395.23  398.71  414.80  457.22 
/
10  2  2  1  370.70  369.88  369.21  369.19  369.63 
             370.44  371.57  372.98  374.66  376.60 
             378.79  381.22  383.88  386.78  389.91 
             393.26  396.84  413.40  457.09 
/
10  2  3  1  360.37  358.77  357.09  356.33  356.50 
             357.23  358.45  360.03  361.99  364.29 
             366.89  369.79  372.98  376.46  380.20 
             384.22  388.51  408.27  459.84 
/
10  2  4  1  354.58  347.01  344.47  343.73  343.96 
             344.93  346.48  348.49  350.94  353.78 
             356.99  360.55  364.46  368.67  373.22 
             378.04  383.18  406.69  467.09 
/
10  2  5  1  326.72  305.05  302.29  302.59  304.65 
             307.99  312.26  317.45  323.43  330.25 
             337.76  345.94  354.75  364.14  374.10 
             384.59  395.60  445.00  565.64 
/
10  2  6  1  280.44  277.72  277.78  281.32  287.24 
             295.07  304.56  315.52  327.84  341.41 
             356.13  371.93  388.74  406.52  426.11 
             447.03  468.63  563.11  790.26 
/
10  2  7  1  253.25  263.12  294.26  339.24  395.91 
             462.81  538.97  623.70  716.47  816.83 
             924.53 1038.79 1161.50 1291.48 1429.52 
            1574.76 1727.14 2410.84 4125.27 
/
10  3  1  1  377.84  376.98  376.29  376.27  376.71 
             377.52  378.62  380.00  381.63  383.50 
             385.61  387.94  390.50  393.29  396.29 
             399.50  402.94  418.80  460.67 
/
10  3  2  1  375.54  374.66  373.95  373.92  374.35 
             375.15  376.26  377.65  379.31  381.22 
             383.37  385.75  388.37  391.22  394.30 
             397.60  401.12  417.40  460.40 
/
10  3  3  1  365.66  364.07  362.47  361.78  361.86 
             362.61  363.75  365.30  367.20  369.39 
             371.91  374.72  377.80  381.16  384.79 
             388.68  392.82  411.98  462.07 
/
10  3  4  1  360.06  353.04  350.39  349.55  349.77 
             350.67  352.11  354.01  356.32  359.01 
             362.07  365.45  369.15  373.17  377.49 
             382.10  387.00  409.49  467.48 
/
10  3  5  1  333.56  310.74  307.71  307.73  309.44 
             312.36  316.27  321.03  326.58  332.83 
             339.75  347.30  355.35  364.04  373.14 
             382.87  393.10  438.62  550.16 
/
10  3  6  1  284.57  281.62  281.19  284.05  289.11 
             295.90  304.20  313.84  324.72  336.74 
             349.82  363.89  378.91  395.00  412.90 
             431.53  451.06  536.02  740.73 
/
10  3  7  1  253.62  261.85  288.04  326.00  374.00 
             430.81  495.60  567.65  646.56  731.82 
             823.30  920.80 1023.80 1133.82 1250.09 
            1373.05 1501.99 2077.38 3512.82 
/
10  4  1  1  383.71  382.21  381.29  381.20  381.60 
             382.37  383.45  384.80  386.40  388.24 
             390.31  392.60  395.12  397.86  400.81 
             403.98  407.36  423.00  464.29 
/
10  4  2  1  381.56  380.04  379.11  379.01  379.40 
             380.16  381.24  382.60  384.22  386.09 
             388.20  390.55  393.12  395.91  398.93 
             402.17  405.63  421.63  463.91 
/
10  4  3  1  372.09  370.03  368.30  367.68  367.74 
             368.39  369.52  370.98  372.80  374.94 
             377.36  380.07  383.04  386.29  389.79 
             393.55  397.56  416.06  464.63 
/
10  4  4  1  366.63  362.23  356.91  356.01  356.16 
             356.95  358.29  360.08  362.26  364.82 
             367.70  370.90  374.40  378.23  382.32 
             386.71  391.39  412.83  468.36 
/
10  4  5  1  341.73  317.37  314.09  313.84  315.22 
             317.73  321.16  325.37  330.30  335.89 
             342.10  348.89  356.24  364.12  372.51 
             381.38  390.73  432.50  535.43 
/
10  4  6  1  293.40  286.41  285.50  287.72  291.94 
             297.74  304.88  313.25  322.72  333.23 
             344.70  357.08  370.48  385.51  401.25 
             417.89  435.10  510.86  694.39 
/
10  4  7  1  254.19  260.88  282.53  313.95  353.86 
             401.22  455.34  515.61  581.56  652.74 
             729.02  810.33  896.53  987.33 1083.52 
            1185.10 1292.13 1768.84 2955.68 
/
10  5  1  1  390.25  387.86  386.61  386.41  386.75 
             387.48  388.52  389.83  391.39  393.19 
             395.23  397.48  399.96  402.65  405.55 
             408.67  412.00  427.39  468.10 
/
10  5  2  1  388.38  385.92  384.64  384.42  384.75 
             385.47  386.51  387.83  389.41  391.23 
             393.30  395.59  398.11  400.85  403.81 
             406.99  410.39  426.09  467.64 
/
10  5  3  1  379.93  376.80  374.74  374.05  374.14 
             374.72  375.78  377.16  378.90  380.94 
             383.27  385.87  388.70  391.83  395.20 
             398.82  402.69  420.55  467.58 
/
10  5  4  1  374.73  369.52  364.18  363.17  363.24 
             363.93  365.17  366.83  368.88  371.26 
             373.97  377.01  380.32  383.92  387.81 
             392.00  396.42  416.83  469.81 
/
10  5  5  1  351.57  325.14  321.66  321.18  322.24 
             324.35  327.31  330.99  335.33  340.26 
             345.77  351.81  358.36  365.41  372.93 
             380.91  389.32  427.15  521.01 
/
10  5  6  1  300.26  292.40  291.03  292.63  296.06 
             300.90  306.94  314.07  322.17  331.21 
             341.53  352.79  364.99  377.86  391.57 
             406.06  420.97  487.81  650.20 
/
10  5  7  1  255.70  260.30  277.76  303.16  335.60 
             374.20  418.39  467.69  521.61  579.77 
             642.02  708.27  778.50  852.65  930.56 
            1011.95 1098.47 1485.03 2441.73 
/
10  6  1  1  396.85  393.70  392.15  391.84  392.12 
             392.80  393.80  395.08  396.60  398.36 
             400.35  402.56  404.99  407.63  410.49 
             413.55  416.83  431.98  472.08 
/
10  6  2  1  395.30  392.02  390.42  390.08  390.35 
             391.02  392.02  393.30  394.83  396.62 
             398.63  400.88  403.34  406.03  408.93 
             412.04  415.37  430.78  471.59 
/
10  6  3  1  388.07  384.00  381.62  380.85  380.89 
             381.46  382.46  383.80  385.45  387.41 
             389.63  392.12  394.85  397.85  401.10 
             404.59  408.31  425.52  470.91 
/
10  6  4  1  383.30  377.39  372.29  371.12  371.03 
             371.66  372.79  374.29  376.19  378.42 
             380.99  383.82  386.94  390.34  394.01 
             397.95  402.15  421.50  471.99 
/
10  6  5  1  362.36  334.34  330.75  330.05  330.82 
             332.57  335.08  338.25  342.00  346.31 
             351.12  356.43  362.19  368.41  375.07 
             382.15  389.64  423.46  508.17 
/
10  6  6  1  308.83  302.14  298.52  299.43  302.14 
             306.15  311.33  317.48  324.55  332.48 
             341.37  350.93  361.24  372.52  384.28 
             396.70  409.77  467.69  609.24 
/
10  6  7  1  258.27  260.24  273.84  293.77  319.35 
             349.92  385.00  424.18  467.00  513.14 
             562.50  615.03  670.65  729.31  790.97 
             855.58  923.04 1225.98 1976.44 
/
10  7  1  1  403.30  399.66  397.87  397.46  397.69 
             398.33  399.29  400.53  402.01  403.73 
             405.68  407.85  410.23  412.83  415.63 
             418.64  421.86  436.76  476.25 
/
10  7  2  1  402.08  398.29  396.43  395.99  396.19 
             396.82  397.78  399.02  400.51  402.25 
             404.22  406.41  408.82  411.45  414.29 
             417.34  420.60  435.71  475.76 
/
10  7  3  1  396.28  391.56  388.94  388.10  388.10 
             388.63  389.57  390.84  392.42  394.29 
             396.41  398.80  401.43  404.30  407.41 
             410.75  414.33  430.89  474.64 
/
10  7  4  1  392.14  385.80  381.33  379.97  379.73 
             380.18  381.20  382.60  384.31  386.39 
             388.76  391.42  394.35  397.54  401.02 
             404.73  408.69  426.96  474.86 
/
10  7  5  1  374.00  345.34  341.76  340.91  341.43 
             342.83  344.93  347.61  350.82  354.51 
             358.66  363.24  368.25  373.65  379.46 
             385.64  392.20  422.01  497.45 
/
10  7  6  1  346.48  312.65  309.29  309.44  311.30 
             314.49  318.69  323.82  329.74  336.41 
             343.77  351.97  360.64  369.90  380.01 
             390.42  401.72  450.98  571.71 
/
10  7  7  1  262.09  261.45  270.87  285.94  305.33 
             328.62  355.39  385.24  417.88  453.16 
             490.94  531.10  573.57  618.31  665.26 
             714.40  765.71  992.41 1558.32 
/
10  8  1  1  409.34  405.63  403.72  403.26  403.45 
             404.05  404.98  406.18  407.63  409.31 
             411.22  413.35  415.68  418.23  420.98 
             423.94  427.10  441.75  480.61 
/
10  8  2  1  408.47  404.59  402.60  402.10  402.26 
             402.86  403.78  404.98  406.44  408.13 
             410.05  412.19  414.55  417.12  419.90 
             422.89  426.08  440.89  480.16 
/
10  8  3  1  404.23  399.36  396.67  395.81  395.79 
             396.29  397.18  398.40  399.91  401.69 
             403.72  406.00  408.51  411.26  414.23 
             417.44  420.86  436.74  478.78 
/
10  8  4  1  400.97  394.71  390.95  389.61  389.30 
             389.67  390.49  391.76  393.37  395.29 
             397.49  399.92  402.66  405.65  408.88 
             412.36  416.08  433.30  478.69 
/
10  8  5  1  386.25  358.68  355.28  354.36  354.68 
             355.79  357.51  359.75  362.44  365.55 
             369.07  372.97  377.24  381.86  386.83 
             392.14  397.79  423.60  489.79 
/
10  8  6  1  363.21  326.86  322.98  322.58  323.86 
             326.26  329.55  333.61  338.37  343.77 
             349.79  356.37  363.51  371.18  379.36 
             388.03  397.16  438.12  539.12 
/
10  8  7  1  268.21  266.25  270.61  280.41  294.07 
             310.71  329.94  351.43  374.99  400.50 
             427.84  456.92  487.66  520.00  553.92 
             589.36  626.32  788.91 1191.77 
/
10  9  1  1  414.72  411.43  409.61  409.16  409.34 
             409.94  410.84  412.02  413.44  415.09 
             416.96  419.04  421.33  423.83  426.53 
             429.44  432.54  446.94  485.16 
/
10  9  2  1  414.19  410.74  408.84  408.36  408.52 
             409.10  410.00  411.18  412.59  414.25 
             416.13  418.22  420.53  423.04  425.76 
             428.69  431.81  446.31  484.81 
/
10  9  3  1  411.53  407.21  404.70  403.93  403.93 
             404.43  405.30  406.47  407.92  409.62 
             411.57  413.75  416.15  418.78  421.63 
             424.69  427.96  443.16  483.50 
/
10  9  4  1  409.31  403.90  400.58  399.43  399.24 
             399.64  400.47  401.66  403.15  404.93 
             406.97  409.27  411.81  414.59  417.61 
             420.85  424.32  440.43  483.04 
/
10  9  5  1  398.77  386.65  372.11  371.26  371.47 
             372.36  373.77  375.61  377.84  380.43 
             383.36  386.62  390.19  394.07  398.25 
             402.73  407.49  429.41  486.56 
/
10  9  6  1  381.84  346.75  342.71  341.82  342.41 
             343.94  346.20  349.08  352.50  356.45 
             360.87  365.76  371.09  376.85  383.02 
             389.61  396.58  428.24  508.06 
/
10  9  7  1  279.38  276.22  277.31  282.38  290.15 
             300.11  311.98  325.59  340.77  357.36 
             375.25  394.37  414.63  435.99  458.40 
             481.84  506.26  613.42  876.47 
/
10 10  1  1  422.68  421.64  420.90  420.85  421.23 
             421.92  422.86  424.05  425.45  427.07 
             428.89  430.91  433.13  435.55  438.17 
             440.97  443.97  457.88  494.82 
/
10 10  2  1  422.68  421.64  420.90  420.85  421.23 
             421.92  422.86  424.05  425.45  427.07 
             428.89  430.91  433.13  435.55  438.17 
             440.97  443.97  457.88  494.82 
/
10 10  3  1  422.68  421.64  420.90  420.85  421.23 
             421.92  422.86  424.05  425.45  427.07 
             428.89  430.91  433.13  435.55  438.17 
             440.97  443.97  457.88  494.82 
/
10 10  4  1  422.68  421.64  420.90  420.85  421.23 
             421.92  422.86  424.05  425.45  427.07 
             428.89  430.91  433.13  435.55  438.17 
             440.97  443.97  457.88  494.82 
/
10 10  5  1  422.68  421.64  420.90  420.85  421.23 
             421.92  422.86  424.05  425.45  427.07 
             428.89  430.91  433.13  435.55  438.17 
             440.97  443.97  457.88  494.82 
/
10 10  6  1  422.68  421.64  420.90  420.85  421.23 
             421.92  422.86  424.05  425.45  427.07 
             428.89  430.91  433.13  435.55  438.17 
             440.97  443.97  457.88  494.82 
/
10 10  7  1  422.68  421.64  420.90  420.85  421.23 
             421.92  422.86  424.05  425.45  427.07 
             428.89  430.91  433.13  435.55  438.17 
             440.97  443.97  457.88  494.82 
/
