# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._event_grid_management_client_enums import *


class AdvancedFilter(msrest.serialization.Model):
    """This is the base type that represents an advanced filter. To configure an advanced filter, do not directly instantiate an object of this class. Instead, instantiate an object of a derived class such as BoolEqualsAdvancedFilter, NumberInAdvancedFilter, StringEqualsAdvancedFilter etc. depending on the type of the key based on which you want to filter.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: BoolEqualsAdvancedFilter, NumberGreaterThanAdvancedFilter, NumberGreaterThanOrEqualsAdvancedFilter, NumberInAdvancedFilter, NumberLessThanAdvancedFilter, NumberLessThanOrEqualsAdvancedFilter, NumberNotInAdvancedFilter, StringBeginsWithAdvancedFilter, StringContainsAdvancedFilter, StringEndsWithAdvancedFilter, StringInAdvancedFilter, StringNotInAdvancedFilter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    _subtype_map = {
        'operator_type': {'BoolEquals': 'BoolEqualsAdvancedFilter', 'NumberGreaterThan': 'NumberGreaterThanAdvancedFilter', 'NumberGreaterThanOrEquals': 'NumberGreaterThanOrEqualsAdvancedFilter', 'NumberIn': 'NumberInAdvancedFilter', 'NumberLessThan': 'NumberLessThanAdvancedFilter', 'NumberLessThanOrEquals': 'NumberLessThanOrEqualsAdvancedFilter', 'NumberNotIn': 'NumberNotInAdvancedFilter', 'StringBeginsWith': 'StringBeginsWithAdvancedFilter', 'StringContains': 'StringContainsAdvancedFilter', 'StringEndsWith': 'StringEndsWithAdvancedFilter', 'StringIn': 'StringInAdvancedFilter', 'StringNotIn': 'StringNotInAdvancedFilter'}
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        **kwargs
    ):
        super(AdvancedFilter, self).__init__(**kwargs)
        self.operator_type = None  # type: Optional[str]
        self.key = key


class EventSubscriptionDestination(msrest.serialization.Model):
    """Information about the destination for an event subscription.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: AzureFunctionEventSubscriptionDestination, EventHubEventSubscriptionDestination, HybridConnectionEventSubscriptionDestination, ServiceBusQueueEventSubscriptionDestination, ServiceBusTopicEventSubscriptionDestination, StorageQueueEventSubscriptionDestination, WebHookEventSubscriptionDestination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'AzureFunction': 'AzureFunctionEventSubscriptionDestination', 'EventHub': 'EventHubEventSubscriptionDestination', 'HybridConnection': 'HybridConnectionEventSubscriptionDestination', 'ServiceBusQueue': 'ServiceBusQueueEventSubscriptionDestination', 'ServiceBusTopic': 'ServiceBusTopicEventSubscriptionDestination', 'StorageQueue': 'StorageQueueEventSubscriptionDestination', 'WebHook': 'WebHookEventSubscriptionDestination'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = None  # type: Optional[str]


class AzureFunctionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the azure function destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Azure Function
     destination of an event subscription.
    :type resource_id: str
    :param max_events_per_batch: Maximum number of events per batch.
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
    :type preferred_batch_size_in_kilobytes: int
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        max_events_per_batch: Optional[int] = None,
        preferred_batch_size_in_kilobytes: Optional[int] = None,
        **kwargs
    ):
        super(AzureFunctionEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'AzureFunction'  # type: str
        self.resource_id = resource_id
        self.max_events_per_batch = max_events_per_batch
        self.preferred_batch_size_in_kilobytes = preferred_batch_size_in_kilobytes


class BoolEqualsAdvancedFilter(AdvancedFilter):
    """BoolEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The boolean filter value.
    :type value: bool
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[bool] = None,
        **kwargs
    ):
        super(BoolEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'BoolEquals'  # type: str
        self.value = value


class ConnectionState(msrest.serialization.Model):
    """ConnectionState information.

    :param status: Status of the connection. Possible values include: "Pending", "Approved",
     "Rejected", "Disconnected".
    :type status: str or ~azure.mgmt.eventgrid.models.PersistedConnectionStatus
    :param description: Description of the connection state.
    :type description: str
    :param actions_required: Actions required (if any).
    :type actions_required: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'actions_required': {'key': 'actionsRequired', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "PersistedConnectionStatus"]] = None,
        description: Optional[str] = None,
        actions_required: Optional[str] = None,
        **kwargs
    ):
        super(ConnectionState, self).__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = actions_required


class DeadLetterDestination(msrest.serialization.Model):
    """Information about the dead letter destination for an event subscription. To configure a deadletter destination, do not directly instantiate an object of this class. Instead, instantiate an object of a derived class. Currently, StorageBlobDeadLetterDestination is the only class that derives from this class.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: StorageBlobDeadLetterDestination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the dead letter destination.Constant
     filled by server.  Possible values include: "StorageBlob".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.DeadLetterEndPointType
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
    }

    _subtype_map = {
        'endpoint_type': {'StorageBlob': 'StorageBlobDeadLetterDestination'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DeadLetterDestination, self).__init__(**kwargs)
        self.endpoint_type = None  # type: Optional[str]


class Resource(msrest.serialization.Model):
    """Definition of a Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """Definition of a Tracked Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags


class Domain(TrackedResource):
    """EventGrid Domain.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param private_endpoint_connections: List of private endpoint connections.
    :type private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the domain. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.DomainProvisioningState
    :ivar endpoint: Endpoint for the domain.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should expect for incoming
     events published to the domain. Possible values include: "EventGridSchema",
     "CustomEventSchema", "CloudEventSchemaV1_0".
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: Information about the InputSchemaMapping which specified the info
     about mapping event payload.
    :type input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the domain.
    :vartype metric_resource_id: str
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        private_endpoint_connections: Optional[List["PrivateEndpointConnection"]] = None,
        input_schema: Optional[Union[str, "InputSchema"]] = None,
        input_schema_mapping: Optional["InputSchemaMapping"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["InboundIpRule"]] = None,
        **kwargs
    ):
        super(Domain, self).__init__(location=location, tags=tags, **kwargs)
        self.private_endpoint_connections = private_endpoint_connections
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = input_schema
        self.input_schema_mapping = input_schema_mapping
        self.metric_resource_id = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class DomainRegenerateKeyRequest(msrest.serialization.Model):
    """Domain regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        **kwargs
    ):
        super(DomainRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = key_name


class DomainSharedAccessKeys(msrest.serialization.Model):
    """Shared access keys of the Domain.

    :param key1: Shared access key1 for the domain.
    :type key1: str
    :param key2: Shared access key2 for the domain.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key1: Optional[str] = None,
        key2: Optional[str] = None,
        **kwargs
    ):
        super(DomainSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class DomainsListResult(msrest.serialization.Model):
    """Result of the List Domains operation.

    :param value: A collection of Domains.
    :type value: list[~azure.mgmt.eventgrid.models.Domain]
    :param next_link: A link for the next page of domains.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Domain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Domain"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DomainsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DomainTopic(Resource):
    """Domain Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param provisioning_state: Provisioning state of the domain topic. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or ~azure.mgmt.eventgrid.models.DomainTopicProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "DomainTopicProvisioningState"]] = None,
        **kwargs
    ):
        super(DomainTopic, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state


class DomainTopicsListResult(msrest.serialization.Model):
    """Result of the List Domain Topics operation.

    :param value: A collection of Domain Topics.
    :type value: list[~azure.mgmt.eventgrid.models.DomainTopic]
    :param next_link: A link for the next page of domain topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DomainTopic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["DomainTopic"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DomainTopicsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DomainUpdateParameters(msrest.serialization.Model):
    """Properties of the Domain update.

    :param tags: A set of tags. Tags of the domains resource.
    :type tags: dict[str, str]
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.DomainUpdateParameterProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["InboundIpRule"]] = None,
        **kwargs
    ):
        super(DomainUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class EventHubEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the event hub destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of an Event Hub
     destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        super(EventHubEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'EventHub'  # type: str
        self.resource_id = resource_id


class EventSubscription(Resource):
    """Event Subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar topic: Name of the topic of the event subscription.
    :vartype topic: str
    :ivar provisioning_state: Provisioning state of the event subscription. Possible values
     include: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed",
     "AwaitingManualAction".
    :vartype provisioning_state: str or
     ~azure.mgmt.eventgrid.models.EventSubscriptionProvisioningState
    :param destination: Information about the destination where events have to be delivered for the
     event subscription.
    :type destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Expiration time of the event subscription.
    :type expiration_time_utc: ~datetime.datetime
    :param event_delivery_schema: The event delivery schema for the event subscription. Possible
     values include: "EventGridSchema", "CustomInputSchema", "CloudEventSchemaV1_0".
    :type event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to configure maximum number
     of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The DeadLetter destination of the event subscription.
    :type dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'topic': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'topic': {'key': 'properties.topic', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'destination': {'key': 'properties.destination', 'type': 'EventSubscriptionDestination'},
        'filter': {'key': 'properties.filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'properties.labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'properties.expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'properties.eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'properties.retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'properties.deadLetterDestination', 'type': 'DeadLetterDestination'},
    }

    def __init__(
        self,
        *,
        destination: Optional["EventSubscriptionDestination"] = None,
        filter: Optional["EventSubscriptionFilter"] = None,
        labels: Optional[List[str]] = None,
        expiration_time_utc: Optional[datetime.datetime] = None,
        event_delivery_schema: Optional[Union[str, "EventDeliverySchema"]] = None,
        retry_policy: Optional["RetryPolicy"] = None,
        dead_letter_destination: Optional["DeadLetterDestination"] = None,
        **kwargs
    ):
        super(EventSubscription, self).__init__(**kwargs)
        self.topic = None
        self.provisioning_state = None
        self.destination = destination
        self.filter = filter
        self.labels = labels
        self.expiration_time_utc = expiration_time_utc
        self.event_delivery_schema = event_delivery_schema
        self.retry_policy = retry_policy
        self.dead_letter_destination = dead_letter_destination


class EventSubscriptionFilter(msrest.serialization.Model):
    """Filter for the Event Subscription.

    :param subject_begins_with: An optional string to filter events for an event subscription based
     on a resource path prefix.
     The format of this depends on the publisher of the events.
     Wildcard characters are not supported in this path.
    :type subject_begins_with: str
    :param subject_ends_with: An optional string to filter events for an event subscription based
     on a resource path suffix.
     Wildcard characters are not supported in this path.
    :type subject_ends_with: str
    :param included_event_types: A list of applicable event types that need to be part of the event
     subscription. If it is desired to subscribe to all default event types, set the
     IncludedEventTypes to null.
    :type included_event_types: list[str]
    :param is_subject_case_sensitive: Specifies if the SubjectBeginsWith and SubjectEndsWith
     properties of the filter
     should be compared in a case sensitive manner.
    :type is_subject_case_sensitive: bool
    :param advanced_filters: An array of advanced filters that are used for filtering event
     subscriptions.
    :type advanced_filters: list[~azure.mgmt.eventgrid.models.AdvancedFilter]
    """

    _attribute_map = {
        'subject_begins_with': {'key': 'subjectBeginsWith', 'type': 'str'},
        'subject_ends_with': {'key': 'subjectEndsWith', 'type': 'str'},
        'included_event_types': {'key': 'includedEventTypes', 'type': '[str]'},
        'is_subject_case_sensitive': {'key': 'isSubjectCaseSensitive', 'type': 'bool'},
        'advanced_filters': {'key': 'advancedFilters', 'type': '[AdvancedFilter]'},
    }

    def __init__(
        self,
        *,
        subject_begins_with: Optional[str] = None,
        subject_ends_with: Optional[str] = None,
        included_event_types: Optional[List[str]] = None,
        is_subject_case_sensitive: Optional[bool] = False,
        advanced_filters: Optional[List["AdvancedFilter"]] = None,
        **kwargs
    ):
        super(EventSubscriptionFilter, self).__init__(**kwargs)
        self.subject_begins_with = subject_begins_with
        self.subject_ends_with = subject_ends_with
        self.included_event_types = included_event_types
        self.is_subject_case_sensitive = is_subject_case_sensitive
        self.advanced_filters = advanced_filters


class EventSubscriptionFullUrl(msrest.serialization.Model):
    """Full endpoint url of an event subscription.

    :param endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :type endpoint_url: str
    """

    _attribute_map = {
        'endpoint_url': {'key': 'endpointUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        endpoint_url: Optional[str] = None,
        **kwargs
    ):
        super(EventSubscriptionFullUrl, self).__init__(**kwargs)
        self.endpoint_url = endpoint_url


class EventSubscriptionsListResult(msrest.serialization.Model):
    """Result of the List EventSubscriptions operation.

    :param value: A collection of EventSubscriptions.
    :type value: list[~azure.mgmt.eventgrid.models.EventSubscription]
    :param next_link: A link for the next page of event subscriptions.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventSubscription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventSubscription"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(EventSubscriptionsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EventSubscriptionUpdateParameters(msrest.serialization.Model):
    """Properties of the Event Subscription update.

    :param destination: Information about the destination where events have to be delivered for the
     event subscription.
    :type destination: ~azure.mgmt.eventgrid.models.EventSubscriptionDestination
    :param filter: Information about the filter for the event subscription.
    :type filter: ~azure.mgmt.eventgrid.models.EventSubscriptionFilter
    :param labels: List of user defined labels.
    :type labels: list[str]
    :param expiration_time_utc: Information about the expiration time for the event subscription.
    :type expiration_time_utc: ~datetime.datetime
    :param event_delivery_schema: The event delivery schema for the event subscription. Possible
     values include: "EventGridSchema", "CustomInputSchema", "CloudEventSchemaV1_0".
    :type event_delivery_schema: str or ~azure.mgmt.eventgrid.models.EventDeliverySchema
    :param retry_policy: The retry policy for events. This can be used to configure maximum number
     of delivery attempts and time to live for events.
    :type retry_policy: ~azure.mgmt.eventgrid.models.RetryPolicy
    :param dead_letter_destination: The DeadLetter destination of the event subscription.
    :type dead_letter_destination: ~azure.mgmt.eventgrid.models.DeadLetterDestination
    """

    _attribute_map = {
        'destination': {'key': 'destination', 'type': 'EventSubscriptionDestination'},
        'filter': {'key': 'filter', 'type': 'EventSubscriptionFilter'},
        'labels': {'key': 'labels', 'type': '[str]'},
        'expiration_time_utc': {'key': 'expirationTimeUtc', 'type': 'iso-8601'},
        'event_delivery_schema': {'key': 'eventDeliverySchema', 'type': 'str'},
        'retry_policy': {'key': 'retryPolicy', 'type': 'RetryPolicy'},
        'dead_letter_destination': {'key': 'deadLetterDestination', 'type': 'DeadLetterDestination'},
    }

    def __init__(
        self,
        *,
        destination: Optional["EventSubscriptionDestination"] = None,
        filter: Optional["EventSubscriptionFilter"] = None,
        labels: Optional[List[str]] = None,
        expiration_time_utc: Optional[datetime.datetime] = None,
        event_delivery_schema: Optional[Union[str, "EventDeliverySchema"]] = None,
        retry_policy: Optional["RetryPolicy"] = None,
        dead_letter_destination: Optional["DeadLetterDestination"] = None,
        **kwargs
    ):
        super(EventSubscriptionUpdateParameters, self).__init__(**kwargs)
        self.destination = destination
        self.filter = filter
        self.labels = labels
        self.expiration_time_utc = expiration_time_utc
        self.event_delivery_schema = event_delivery_schema
        self.retry_policy = retry_policy
        self.dead_letter_destination = dead_letter_destination


class EventType(Resource):
    """Event Type for a subject under a topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param display_name: Display name of the event type.
    :type display_name: str
    :param description: Description of the event type.
    :type description: str
    :param schema_url: Url of the schema for this event type.
    :type schema_url: str
    :param is_in_default_set: IsInDefaultSet flag of the event type.
    :type is_in_default_set: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'schema_url': {'key': 'properties.schemaUrl', 'type': 'str'},
        'is_in_default_set': {'key': 'properties.isInDefaultSet', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        schema_url: Optional[str] = None,
        is_in_default_set: Optional[bool] = None,
        **kwargs
    ):
        super(EventType, self).__init__(**kwargs)
        self.display_name = display_name
        self.description = description
        self.schema_url = schema_url
        self.is_in_default_set = is_in_default_set


class EventTypesListResult(msrest.serialization.Model):
    """Result of the List Event Types operation.

    :param value: A collection of event types.
    :type value: list[~azure.mgmt.eventgrid.models.EventType]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventType]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventType"]] = None,
        **kwargs
    ):
        super(EventTypesListResult, self).__init__(**kwargs)
        self.value = value


class HybridConnectionEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the HybridConnection destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource ID of an hybrid connection that is the destination of an
     event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        super(HybridConnectionEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'HybridConnection'  # type: str
        self.resource_id = resource_id


class InboundIpRule(msrest.serialization.Model):
    """InboundIpRule.

    :param ip_mask: IP Address in CIDR notation e.g., 10.0.0.0/8.
    :type ip_mask: str
    :param action: Action to perform based on the match or no match of the IpMask. Possible values
     include: "Allow".
    :type action: str or ~azure.mgmt.eventgrid.models.IpActionType
    """

    _attribute_map = {
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_mask: Optional[str] = None,
        action: Optional[Union[str, "IpActionType"]] = None,
        **kwargs
    ):
        super(InboundIpRule, self).__init__(**kwargs)
        self.ip_mask = ip_mask
        self.action = action


class InputSchemaMapping(msrest.serialization.Model):
    """By default, Event Grid expects events to be in the Event Grid event schema. Specifying an input schema mapping enables publishing to Event Grid using a custom input schema. Currently, the only supported type of InputSchemaMapping is 'JsonInputSchemaMapping'.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: JsonInputSchemaMapping.

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Type of the custom mapping.Constant filled by
     server.  Possible values include: "Json".
    :type input_schema_mapping_type: str or ~azure.mgmt.eventgrid.models.InputSchemaMappingType
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
    }

    _subtype_map = {
        'input_schema_mapping_type': {'Json': 'JsonInputSchemaMapping'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InputSchemaMapping, self).__init__(**kwargs)
        self.input_schema_mapping_type = None  # type: Optional[str]


class JsonField(msrest.serialization.Model):
    """This is used to express the source of an input schema mapping for a single target field in the Event Grid Event schema. This is currently used in the mappings for the 'id', 'topic' and 'eventtime' properties. This represents a field in the input event schema.

    :param source_field: Name of a field in the input event schema that's to be used as the source
     of a mapping.
    :type source_field: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_field: Optional[str] = None,
        **kwargs
    ):
        super(JsonField, self).__init__(**kwargs)
        self.source_field = source_field


class JsonFieldWithDefault(msrest.serialization.Model):
    """This is used to express the source of an input schema mapping for a single target field
in the Event Grid Event schema. This is currently used in the mappings for the 'subject',
'eventtype' and 'dataversion' properties. This represents a field in the input event schema
along with a default value to be used, and at least one of these two properties should be provided.

    :param source_field: Name of a field in the input event schema that's to be used as the source
     of a mapping.
    :type source_field: str
    :param default_value: The default value to be used for mapping when a SourceField is not
     provided or if there's no property with the specified name in the published JSON event payload.
    :type default_value: str
    """

    _attribute_map = {
        'source_field': {'key': 'sourceField', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_field: Optional[str] = None,
        default_value: Optional[str] = None,
        **kwargs
    ):
        super(JsonFieldWithDefault, self).__init__(**kwargs)
        self.source_field = source_field
        self.default_value = default_value


class JsonInputSchemaMapping(InputSchemaMapping):
    """This enables publishing to Event Grid using a custom input schema. This can be used to map properties from a custom input JSON schema to the Event Grid event schema.

    All required parameters must be populated in order to send to Azure.

    :param input_schema_mapping_type: Required. Type of the custom mapping.Constant filled by
     server.  Possible values include: "Json".
    :type input_schema_mapping_type: str or ~azure.mgmt.eventgrid.models.InputSchemaMappingType
    :param id: The mapping information for the Id property of the Event Grid Event.
    :type id: ~azure.mgmt.eventgrid.models.JsonField
    :param topic: The mapping information for the Topic property of the Event Grid Event.
    :type topic: ~azure.mgmt.eventgrid.models.JsonField
    :param event_time: The mapping information for the EventTime property of the Event Grid Event.
    :type event_time: ~azure.mgmt.eventgrid.models.JsonField
    :param event_type: The mapping information for the EventType property of the Event Grid Event.
    :type event_type: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param subject: The mapping information for the Subject property of the Event Grid Event.
    :type subject: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    :param data_version: The mapping information for the DataVersion property of the Event Grid
     Event.
    :type data_version: ~azure.mgmt.eventgrid.models.JsonFieldWithDefault
    """

    _validation = {
        'input_schema_mapping_type': {'required': True},
    }

    _attribute_map = {
        'input_schema_mapping_type': {'key': 'inputSchemaMappingType', 'type': 'str'},
        'id': {'key': 'properties.id', 'type': 'JsonField'},
        'topic': {'key': 'properties.topic', 'type': 'JsonField'},
        'event_time': {'key': 'properties.eventTime', 'type': 'JsonField'},
        'event_type': {'key': 'properties.eventType', 'type': 'JsonFieldWithDefault'},
        'subject': {'key': 'properties.subject', 'type': 'JsonFieldWithDefault'},
        'data_version': {'key': 'properties.dataVersion', 'type': 'JsonFieldWithDefault'},
    }

    def __init__(
        self,
        *,
        id: Optional["JsonField"] = None,
        topic: Optional["JsonField"] = None,
        event_time: Optional["JsonField"] = None,
        event_type: Optional["JsonFieldWithDefault"] = None,
        subject: Optional["JsonFieldWithDefault"] = None,
        data_version: Optional["JsonFieldWithDefault"] = None,
        **kwargs
    ):
        super(JsonInputSchemaMapping, self).__init__(**kwargs)
        self.input_schema_mapping_type = 'Json'  # type: str
        self.id = id
        self.topic = topic
        self.event_time = event_time
        self.event_type = event_type
        self.subject = subject
        self.data_version = data_version


class NumberGreaterThanAdvancedFilter(AdvancedFilter):
    """NumberGreaterThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(NumberGreaterThanAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberGreaterThan'  # type: str
        self.value = value


class NumberGreaterThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberGreaterThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(NumberGreaterThanOrEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberGreaterThanOrEquals'  # type: str
        self.value = value


class NumberInAdvancedFilter(AdvancedFilter):
    """NumberIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[float]] = None,
        **kwargs
    ):
        super(NumberInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberIn'  # type: str
        self.values = values


class NumberLessThanAdvancedFilter(AdvancedFilter):
    """NumberLessThan Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(NumberLessThanAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberLessThan'  # type: str
        self.value = value


class NumberLessThanOrEqualsAdvancedFilter(AdvancedFilter):
    """NumberLessThanOrEquals Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param value: The filter value.
    :type value: float
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        value: Optional[float] = None,
        **kwargs
    ):
        super(NumberLessThanOrEqualsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberLessThanOrEquals'  # type: str
        self.value = value


class NumberNotInAdvancedFilter(AdvancedFilter):
    """NumberNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[float]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[float]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[float]] = None,
        **kwargs
    ):
        super(NumberNotInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'NumberNotIn'  # type: str
        self.values = values


class Operation(msrest.serialization.Model):
    """Represents an operation returned by the GetOperations request.

    :param name: Name of the operation.
    :type name: str
    :param display: Display name of the operation.
    :type display: ~azure.mgmt.eventgrid.models.OperationInfo
    :param origin: Origin of the operation.
    :type origin: str
    :param properties: Properties of the operation.
    :type properties: object
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationInfo'},
        'origin': {'key': 'origin', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["OperationInfo"] = None,
        origin: Optional[str] = None,
        properties: Optional[object] = None,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationInfo(msrest.serialization.Model):
    """Information about an operation.

    :param provider: Name of the provider.
    :type provider: str
    :param resource: Name of the resource type.
    :type resource: str
    :param operation: Name of the operation.
    :type operation: str
    :param description: Description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs
    ):
        super(OperationInfo, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationsListResult(msrest.serialization.Model):
    """Result of the List Operations operation.

    :param value: A collection of operations.
    :type value: list[~azure.mgmt.eventgrid.models.Operation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Operation"]] = None,
        **kwargs
    ):
        super(OperationsListResult, self).__init__(**kwargs)
        self.value = value


class PrivateEndpoint(msrest.serialization.Model):
    """PrivateEndpoint information.

    :param id: The ARM identifier for Private Endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(Resource):
    """PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param private_endpoint: The Private Endpoint resource for this Connection.
    :type private_endpoint: ~azure.mgmt.eventgrid.models.PrivateEndpoint
    :param group_ids: GroupIds from the private link service resource.
    :type group_ids: list[str]
    :param private_link_service_connection_state: Details about the state of the connection.
    :type private_link_service_connection_state: ~azure.mgmt.eventgrid.models.ConnectionState
    :param provisioning_state: Provisioning state of the Private Endpoint Connection. Possible
     values include: "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or ~azure.mgmt.eventgrid.models.ResourceProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'group_ids': {'key': 'properties.groupIds', 'type': '[str]'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'ConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["PrivateEndpoint"] = None,
        group_ids: Optional[List[str]] = None,
        private_link_service_connection_state: Optional["ConnectionState"] = None,
        provisioning_state: Optional[Union[str, "ResourceProvisioningState"]] = None,
        **kwargs
    ):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = private_endpoint
        self.group_ids = group_ids
        self.private_link_service_connection_state = private_link_service_connection_state
        self.provisioning_state = provisioning_state


class PrivateEndpointConnectionListResult(msrest.serialization.Model):
    """Result of the list of all private endpoint connections operation.

    :param value: A collection of private endpoint connection resources.
    :type value: list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :param next_link: A link for the next page of private endpoint connection resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateEndpointConnection]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateEndpointConnectionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkResource(msrest.serialization.Model):
    """Information of the private link resource.

    :param id: Fully qualified identifier of the resource.
    :type id: str
    :param name: Name of the resource.
    :type name: str
    :param type: Type of the resource.
    :type type: str
    :param group_id:
    :type group_id: str
    :param display_name:
    :type display_name: str
    :param required_members:
    :type required_members: list[str]
    :param required_zone_names:
    :type required_zone_names: list[str]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        type: Optional[str] = None,
        group_id: Optional[str] = None,
        display_name: Optional[str] = None,
        required_members: Optional[List[str]] = None,
        required_zone_names: Optional[List[str]] = None,
        **kwargs
    ):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.type = type
        self.group_id = group_id
        self.display_name = display_name
        self.required_members = required_members
        self.required_zone_names = required_zone_names


class PrivateLinkResourcesListResult(msrest.serialization.Model):
    """Result of the List private link resources operation.

    :param value: A collection of private link resources.
    :type value: list[~azure.mgmt.eventgrid.models.PrivateLinkResource]
    :param next_link: A link for the next page of private link resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(PrivateLinkResourcesListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RetryPolicy(msrest.serialization.Model):
    """Information about the retry policy for an event subscription.

    :param max_delivery_attempts: Maximum number of delivery retry attempts for events.
    :type max_delivery_attempts: int
    :param event_time_to_live_in_minutes: Time To Live (in minutes) for events.
    :type event_time_to_live_in_minutes: int
    """

    _attribute_map = {
        'max_delivery_attempts': {'key': 'maxDeliveryAttempts', 'type': 'int'},
        'event_time_to_live_in_minutes': {'key': 'eventTimeToLiveInMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        max_delivery_attempts: Optional[int] = None,
        event_time_to_live_in_minutes: Optional[int] = None,
        **kwargs
    ):
        super(RetryPolicy, self).__init__(**kwargs)
        self.max_delivery_attempts = max_delivery_attempts
        self.event_time_to_live_in_minutes = event_time_to_live_in_minutes


class ServiceBusQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Service Bus
     destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'ServiceBusQueue'  # type: str
        self.resource_id = resource_id


class ServiceBusTopicEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the service bus topic destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource Id that represents the endpoint of the Service Bus Topic
     destination of an event subscription.
    :type resource_id: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        **kwargs
    ):
        super(ServiceBusTopicEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'ServiceBusTopic'  # type: str
        self.resource_id = resource_id


class StorageBlobDeadLetterDestination(DeadLetterDestination):
    """Information about the storage blob based dead letter destination.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the dead letter destination.Constant
     filled by server.  Possible values include: "StorageBlob".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.DeadLetterEndPointType
    :param resource_id: The Azure Resource ID of the storage account that is the destination of the
     deadletter events.
    :type resource_id: str
    :param blob_container_name: The name of the Storage blob container that is the destination of
     the deadletter events.
    :type blob_container_name: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'blob_container_name': {'key': 'properties.blobContainerName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        blob_container_name: Optional[str] = None,
        **kwargs
    ):
        super(StorageBlobDeadLetterDestination, self).__init__(**kwargs)
        self.endpoint_type = 'StorageBlob'  # type: str
        self.resource_id = resource_id
        self.blob_container_name = blob_container_name


class StorageQueueEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the storage queue destination for an event subscription.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param resource_id: The Azure Resource ID of the storage account that contains the queue that
     is the destination of an event subscription.
    :type resource_id: str
    :param queue_name: The name of the Storage queue under a storage account that is the
     destination of an event subscription.
    :type queue_name: str
    """

    _validation = {
        'endpoint_type': {'required': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'queue_name': {'key': 'properties.queueName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        queue_name: Optional[str] = None,
        **kwargs
    ):
        super(StorageQueueEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'StorageQueue'  # type: str
        self.resource_id = resource_id
        self.queue_name = queue_name


class StringBeginsWithAdvancedFilter(AdvancedFilter):
    """StringBeginsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringBeginsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringBeginsWith'  # type: str
        self.values = values


class StringContainsAdvancedFilter(AdvancedFilter):
    """StringContains Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringContainsAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringContains'  # type: str
        self.values = values


class StringEndsWithAdvancedFilter(AdvancedFilter):
    """StringEndsWith Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringEndsWithAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringEndsWith'  # type: str
        self.values = values


class StringInAdvancedFilter(AdvancedFilter):
    """StringIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringIn'  # type: str
        self.values = values


class StringNotInAdvancedFilter(AdvancedFilter):
    """StringNotIn Advanced Filter.

    All required parameters must be populated in order to send to Azure.

    :param operator_type: Required. The operator type used for filtering, e.g., NumberIn,
     StringContains, BoolEquals and others.Constant filled by server.  Possible values include:
     "NumberIn", "NumberNotIn", "NumberLessThan", "NumberGreaterThan", "NumberLessThanOrEquals",
     "NumberGreaterThanOrEquals", "BoolEquals", "StringIn", "StringNotIn", "StringBeginsWith",
     "StringEndsWith", "StringContains".
    :type operator_type: str or ~azure.mgmt.eventgrid.models.AdvancedFilterOperatorType
    :param key: The field/property in the event based on which you want to filter.
    :type key: str
    :param values: The set of filter values.
    :type values: list[str]
    """

    _validation = {
        'operator_type': {'required': True},
    }

    _attribute_map = {
        'operator_type': {'key': 'operatorType', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
        'values': {'key': 'values', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        key: Optional[str] = None,
        values: Optional[List[str]] = None,
        **kwargs
    ):
        super(StringNotInAdvancedFilter, self).__init__(key=key, **kwargs)
        self.operator_type = 'StringNotIn'  # type: str
        self.values = values


class Topic(TrackedResource):
    """EventGrid Topic.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param location: Required. Location of the resource.
    :type location: str
    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param private_endpoint_connections:
    :type private_endpoint_connections:
     list[~azure.mgmt.eventgrid.models.PrivateEndpointConnection]
    :ivar provisioning_state: Provisioning state of the topic. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :vartype provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicProvisioningState
    :ivar endpoint: Endpoint for the topic.
    :vartype endpoint: str
    :param input_schema: This determines the format that Event Grid should expect for incoming
     events published to the topic. Possible values include: "EventGridSchema", "CustomEventSchema",
     "CloudEventSchemaV1_0".
    :type input_schema: str or ~azure.mgmt.eventgrid.models.InputSchema
    :param input_schema_mapping: This enables publishing using custom event schemas. An
     InputSchemaMapping can be specified to map various properties of a source schema to various
     required properties of the EventGridEvent schema.
    :type input_schema_mapping: ~azure.mgmt.eventgrid.models.InputSchemaMapping
    :ivar metric_resource_id: Metric resource id for the topic.
    :vartype metric_resource_id: str
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'endpoint': {'readonly': True},
        'metric_resource_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'endpoint': {'key': 'properties.endpoint', 'type': 'str'},
        'input_schema': {'key': 'properties.inputSchema', 'type': 'str'},
        'input_schema_mapping': {'key': 'properties.inputSchemaMapping', 'type': 'InputSchemaMapping'},
        'metric_resource_id': {'key': 'properties.metricResourceId', 'type': 'str'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        private_endpoint_connections: Optional[List["PrivateEndpointConnection"]] = None,
        input_schema: Optional[Union[str, "InputSchema"]] = None,
        input_schema_mapping: Optional["InputSchemaMapping"] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["InboundIpRule"]] = None,
        **kwargs
    ):
        super(Topic, self).__init__(location=location, tags=tags, **kwargs)
        self.private_endpoint_connections = private_endpoint_connections
        self.provisioning_state = None
        self.endpoint = None
        self.input_schema = input_schema
        self.input_schema_mapping = input_schema_mapping
        self.metric_resource_id = None
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class TopicRegenerateKeyRequest(msrest.serialization.Model):
    """Topic regenerate share access key request.

    All required parameters must be populated in order to send to Azure.

    :param key_name: Required. Key name to regenerate key1 or key2.
    :type key_name: str
    """

    _validation = {
        'key_name': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        **kwargs
    ):
        super(TopicRegenerateKeyRequest, self).__init__(**kwargs)
        self.key_name = key_name


class TopicSharedAccessKeys(msrest.serialization.Model):
    """Shared access keys of the Topic.

    :param key1: Shared access key1 for the topic.
    :type key1: str
    :param key2: Shared access key2 for the topic.
    :type key2: str
    """

    _attribute_map = {
        'key1': {'key': 'key1', 'type': 'str'},
        'key2': {'key': 'key2', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key1: Optional[str] = None,
        key2: Optional[str] = None,
        **kwargs
    ):
        super(TopicSharedAccessKeys, self).__init__(**kwargs)
        self.key1 = key1
        self.key2 = key2


class TopicsListResult(msrest.serialization.Model):
    """Result of the List Topics operation.

    :param value: A collection of Topics.
    :type value: list[~azure.mgmt.eventgrid.models.Topic]
    :param next_link: A link for the next page of topics.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Topic]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["Topic"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(TopicsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class TopicTypeInfo(Resource):
    """Properties of a topic type info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified identifier of the resource.
    :vartype id: str
    :ivar name: Name of the resource.
    :vartype name: str
    :ivar type: Type of the resource.
    :vartype type: str
    :param provider: Namespace of the provider of the topic type.
    :type provider: str
    :param display_name: Display Name for the topic type.
    :type display_name: str
    :param description: Description of the topic type.
    :type description: str
    :param resource_region_type: Region type of the resource. Possible values include:
     "RegionalResource", "GlobalResource".
    :type resource_region_type: str or ~azure.mgmt.eventgrid.models.ResourceRegionType
    :param provisioning_state: Provisioning state of the topic type. Possible values include:
     "Creating", "Updating", "Deleting", "Succeeded", "Canceled", "Failed".
    :type provisioning_state: str or ~azure.mgmt.eventgrid.models.TopicTypeProvisioningState
    :param supported_locations: List of locations supported by this topic type.
    :type supported_locations: list[str]
    :param source_resource_format: Source resource format.
    :type source_resource_format: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provider': {'key': 'properties.provider', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'resource_region_type': {'key': 'properties.resourceRegionType', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'supported_locations': {'key': 'properties.supportedLocations', 'type': '[str]'},
        'source_resource_format': {'key': 'properties.sourceResourceFormat', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        resource_region_type: Optional[Union[str, "ResourceRegionType"]] = None,
        provisioning_state: Optional[Union[str, "TopicTypeProvisioningState"]] = None,
        supported_locations: Optional[List[str]] = None,
        source_resource_format: Optional[str] = None,
        **kwargs
    ):
        super(TopicTypeInfo, self).__init__(**kwargs)
        self.provider = provider
        self.display_name = display_name
        self.description = description
        self.resource_region_type = resource_region_type
        self.provisioning_state = provisioning_state
        self.supported_locations = supported_locations
        self.source_resource_format = source_resource_format


class TopicTypesListResult(msrest.serialization.Model):
    """Result of the List Topic Types operation.

    :param value: A collection of topic types.
    :type value: list[~azure.mgmt.eventgrid.models.TopicTypeInfo]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TopicTypeInfo]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["TopicTypeInfo"]] = None,
        **kwargs
    ):
        super(TopicTypesListResult, self).__init__(**kwargs)
        self.value = value


class TopicUpdateParameters(msrest.serialization.Model):
    """Properties of the Topic update.

    :param tags: A set of tags. Tags of the resource.
    :type tags: dict[str, str]
    :param public_network_access: This determines if traffic is allowed over public network. By
     default it is enabled.
     You can further restrict to specific IPs by configuring :code:`<seealso
     cref="P:Microsoft.Azure.Events.ResourceProvider.Common.Contracts.TopicUpdateParameterProperties.InboundIpRules"
     />`. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or ~azure.mgmt.eventgrid.models.PublicNetworkAccess
    :param inbound_ip_rules: This can be used to restrict traffic from specific IPs instead of all
     IPs. Note: These are considered only if PublicNetworkAccess is enabled.
    :type inbound_ip_rules: list[~azure.mgmt.eventgrid.models.InboundIpRule]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'public_network_access': {'key': 'properties.publicNetworkAccess', 'type': 'str'},
        'inbound_ip_rules': {'key': 'properties.inboundIpRules', 'type': '[InboundIpRule]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        public_network_access: Optional[Union[str, "PublicNetworkAccess"]] = None,
        inbound_ip_rules: Optional[List["InboundIpRule"]] = None,
        **kwargs
    ):
        super(TopicUpdateParameters, self).__init__(**kwargs)
        self.tags = tags
        self.public_network_access = public_network_access
        self.inbound_ip_rules = inbound_ip_rules


class WebHookEventSubscriptionDestination(EventSubscriptionDestination):
    """Information about the webhook destination for an event subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param endpoint_type: Required. Type of the endpoint for the event subscription
     destination.Constant filled by server.  Possible values include: "WebHook", "EventHub",
     "StorageQueue", "HybridConnection", "ServiceBusQueue", "ServiceBusTopic", "AzureFunction".
    :type endpoint_type: str or ~azure.mgmt.eventgrid.models.EndpointType
    :param endpoint_url: The URL that represents the endpoint of the destination of an event
     subscription.
    :type endpoint_url: str
    :ivar endpoint_base_url: The base URL that represents the endpoint of the destination of an
     event subscription.
    :vartype endpoint_base_url: str
    :param max_events_per_batch: Maximum number of events per batch.
    :type max_events_per_batch: int
    :param preferred_batch_size_in_kilobytes: Preferred batch size in Kilobytes.
    :type preferred_batch_size_in_kilobytes: int
    :param azure_active_directory_tenant_id: The Azure Active Directory Tenant ID to get the access
     token that will be included as the bearer token in delivery requests.
    :type azure_active_directory_tenant_id: str
    :param azure_active_directory_application_id_or_uri: The Azure Active Directory Application ID
     or URI to get the access token that will be included as the bearer token in delivery requests.
    :type azure_active_directory_application_id_or_uri: str
    """

    _validation = {
        'endpoint_type': {'required': True},
        'endpoint_base_url': {'readonly': True},
    }

    _attribute_map = {
        'endpoint_type': {'key': 'endpointType', 'type': 'str'},
        'endpoint_url': {'key': 'properties.endpointUrl', 'type': 'str'},
        'endpoint_base_url': {'key': 'properties.endpointBaseUrl', 'type': 'str'},
        'max_events_per_batch': {'key': 'properties.maxEventsPerBatch', 'type': 'int'},
        'preferred_batch_size_in_kilobytes': {'key': 'properties.preferredBatchSizeInKilobytes', 'type': 'int'},
        'azure_active_directory_tenant_id': {'key': 'properties.azureActiveDirectoryTenantId', 'type': 'str'},
        'azure_active_directory_application_id_or_uri': {'key': 'properties.azureActiveDirectoryApplicationIdOrUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        endpoint_url: Optional[str] = None,
        max_events_per_batch: Optional[int] = None,
        preferred_batch_size_in_kilobytes: Optional[int] = None,
        azure_active_directory_tenant_id: Optional[str] = None,
        azure_active_directory_application_id_or_uri: Optional[str] = None,
        **kwargs
    ):
        super(WebHookEventSubscriptionDestination, self).__init__(**kwargs)
        self.endpoint_type = 'WebHook'  # type: str
        self.endpoint_url = endpoint_url
        self.endpoint_base_url = None
        self.max_events_per_batch = max_events_per_batch
        self.preferred_batch_size_in_kilobytes = preferred_batch_size_in_kilobytes
        self.azure_active_directory_tenant_id = azure_active_directory_tenant_id
        self.azure_active_directory_application_id_or_uri = azure_active_directory_application_id_or_uri
