# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models
from .._serialization import Deserializer, Serializer
from ._configuration import CostManagementClientConfiguration
from .operations import (
    AlertsOperations,
    BenefitRecommendationsOperations,
    BenefitUtilizationSummariesOperations,
    DimensionsOperations,
    ExportsOperations,
    ForecastOperations,
    GenerateCostDetailsReportOperations,
    GenerateDetailedCostReportOperationResultsOperations,
    GenerateDetailedCostReportOperationStatusOperations,
    GenerateDetailedCostReportOperations,
    GenerateReservationDetailsReportOperations,
    Operations,
    PriceSheetOperations,
    QueryOperations,
    ScheduledActionsOperations,
    ViewsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class CostManagementClient:  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """CostManagement management client provides access to CostManagement resources for Azure
    Enterprise Subscriptions.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.costmanagement.aio.operations.Operations
    :ivar views: ViewsOperations operations
    :vartype views: azure.mgmt.costmanagement.aio.operations.ViewsOperations
    :ivar alerts: AlertsOperations operations
    :vartype alerts: azure.mgmt.costmanagement.aio.operations.AlertsOperations
    :ivar forecast: ForecastOperations operations
    :vartype forecast: azure.mgmt.costmanagement.aio.operations.ForecastOperations
    :ivar dimensions: DimensionsOperations operations
    :vartype dimensions: azure.mgmt.costmanagement.aio.operations.DimensionsOperations
    :ivar query: QueryOperations operations
    :vartype query: azure.mgmt.costmanagement.aio.operations.QueryOperations
    :ivar generate_reservation_details_report: GenerateReservationDetailsReportOperations
     operations
    :vartype generate_reservation_details_report:
     azure.mgmt.costmanagement.aio.operations.GenerateReservationDetailsReportOperations
    :ivar exports: ExportsOperations operations
    :vartype exports: azure.mgmt.costmanagement.aio.operations.ExportsOperations
    :ivar generate_cost_details_report: GenerateCostDetailsReportOperations operations
    :vartype generate_cost_details_report:
     azure.mgmt.costmanagement.aio.operations.GenerateCostDetailsReportOperations
    :ivar generate_detailed_cost_report: GenerateDetailedCostReportOperations operations
    :vartype generate_detailed_cost_report:
     azure.mgmt.costmanagement.aio.operations.GenerateDetailedCostReportOperations
    :ivar generate_detailed_cost_report_operation_results:
     GenerateDetailedCostReportOperationResultsOperations operations
    :vartype generate_detailed_cost_report_operation_results:
     azure.mgmt.costmanagement.aio.operations.GenerateDetailedCostReportOperationResultsOperations
    :ivar generate_detailed_cost_report_operation_status:
     GenerateDetailedCostReportOperationStatusOperations operations
    :vartype generate_detailed_cost_report_operation_status:
     azure.mgmt.costmanagement.aio.operations.GenerateDetailedCostReportOperationStatusOperations
    :ivar price_sheet: PriceSheetOperations operations
    :vartype price_sheet: azure.mgmt.costmanagement.aio.operations.PriceSheetOperations
    :ivar scheduled_actions: ScheduledActionsOperations operations
    :vartype scheduled_actions: azure.mgmt.costmanagement.aio.operations.ScheduledActionsOperations
    :ivar benefit_recommendations: BenefitRecommendationsOperations operations
    :vartype benefit_recommendations:
     azure.mgmt.costmanagement.aio.operations.BenefitRecommendationsOperations
    :ivar benefit_utilization_summaries: BenefitUtilizationSummariesOperations operations
    :vartype benefit_utilization_summaries:
     azure.mgmt.costmanagement.aio.operations.BenefitUtilizationSummariesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2022-10-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "AsyncTokenCredential", base_url: str = "https://management.azure.com", **kwargs: Any
    ) -> None:
        self._config = CostManagementClientConfiguration(credential=credential, **kwargs)
        self._client = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.views = ViewsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.alerts = AlertsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.forecast = ForecastOperations(self._client, self._config, self._serialize, self._deserialize)
        self.dimensions = DimensionsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.query = QueryOperations(self._client, self._config, self._serialize, self._deserialize)
        self.generate_reservation_details_report = GenerateReservationDetailsReportOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.exports = ExportsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.generate_cost_details_report = GenerateCostDetailsReportOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.generate_detailed_cost_report = GenerateDetailedCostReportOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.generate_detailed_cost_report_operation_results = GenerateDetailedCostReportOperationResultsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.generate_detailed_cost_report_operation_status = GenerateDetailedCostReportOperationStatusOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.price_sheet = PriceSheetOperations(self._client, self._config, self._serialize, self._deserialize)
        self.scheduled_actions = ScheduledActionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.benefit_recommendations = BenefitRecommendationsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.benefit_utilization_summaries = BenefitUtilizationSummariesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "CostManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details) -> None:
        await self._client.__aexit__(*exc_details)
