# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.containerservicefleet.aio import ContainerServiceFleetMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerServiceFleetMgmtFleetsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerServiceFleetMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleets_list_by_subscription(self, resource_group):
        response = self.client.fleets.list_by_subscription(
            api_version="2025-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleets_list_by_resource_group(self, resource_group):
        response = self.client.fleets.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleets_get(self, resource_group):
        response = await self.client.fleets.get(
            resource_group_name=resource_group.name,
            fleet_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleets_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.fleets.begin_create_or_update(
                resource_group_name=resource_group.name,
                fleet_name="str",
                resource={
                    "location": "str",
                    "eTag": "str",
                    "hubProfile": {
                        "agentProfile": {"subnetId": "str", "vmSize": "str"},
                        "apiServerAccessProfile": {
                            "enablePrivateCluster": bool,
                            "enableVnetIntegration": bool,
                            "subnetId": "str",
                        },
                        "dnsPrefix": "str",
                        "fqdn": "str",
                        "kubernetesVersion": "str",
                        "portalFqdn": "str",
                    },
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "name": "str",
                    "provisioningState": "str",
                    "status": {
                        "lastOperationError": {
                            "additionalInfo": [{"info": {}, "type": "str"}],
                            "code": "str",
                            "details": [...],
                            "message": "str",
                            "target": "str",
                        },
                        "lastOperationId": "str",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleets_begin_update(self, resource_group):
        response = await (
            await self.client.fleets.begin_update(
                resource_group_name=resource_group.name,
                fleet_name="str",
                properties={
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "tags": {"str": "str"},
                },
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleets_begin_delete(self, resource_group):
        response = await (
            await self.client.fleets.begin_delete(
                resource_group_name=resource_group.name,
                fleet_name="str",
                api_version="2025-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_fleets_list_credentials(self, resource_group):
        response = await self.client.fleets.list_credentials(
            resource_group_name=resource_group.name,
            fleet_name="str",
            api_version="2025-03-01",
        )

        # please add some check logic here by yourself
        # ...
