/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with Foobar; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <iostream>
#include <string>

#include "db.hh"


std::string tsqlite::str(std::string str) {
	char formated[255];
	sqlite3_snprintf(255, formated, "'%q'", str.c_str());
	return formated;
}

bool tsqlite::open(const char *path) {
	char *zErrMsg = 0;
	int rc;

	rc = sqlite3_open(path, &this->db);
	if (rc){
		fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(this->db));
		sqlite3_close(this->db);
		
		return false;
	}

	return true;
}

bool tsqlite::close() {
	sqlite3_close(this->db);

	return true;
}

int tsqlite::changes() {
	return sqlite3_changes(db);
}

bool tsqlite::exec(const std::string sql,  int (*callback)(void*,int,char**,char**), void *params) {
	char *zErrMsg = 0;
	int rc;
	rc = sqlite3_exec(this->db, sql.c_str(), callback, params, &zErrMsg);

	if (rc != SQLITE_OK) {
		fprintf(stderr, "SQL error: %s\n", zErrMsg);
		sqlite3_free(zErrMsg);
		return false;
	}
	return true;
}

int tsqlite::last_insert_rowid() {
	return sqlite3_last_insert_rowid(this->db);
}

bool tsqlite::query(const std::string sql) {
//	std::cout << sql << std::endl;
	return exec(sql.c_str(), NULL, NULL);
}

