/*! \file */ 
#ifndef _OSM_MEM_TILES
#define _OSM_MEM_TILES

#include "tile_data.h"
#include "osm_store.h"
#include "geometry_cache.h"

// NB: Currently, USE_NODE_STORE and USE_WAY_STORE are equivalent.
// If we permit LayerAsCentroid to be generated from the OSM stores,
// this will have to change.
#define OSM_THRESHOLD (1ull << TILE_DATA_ID_SIZE)
#define USE_NODE_STORE (2ull << TILE_DATA_ID_SIZE)
#define IS_NODE(x) (((x) >> TILE_DATA_ID_SIZE) == (USE_NODE_STORE >> TILE_DATA_ID_SIZE))
#define USE_WAY_STORE (1ull << TILE_DATA_ID_SIZE)
#define IS_WAY(x) (((x) >> TILE_DATA_ID_SIZE) == (USE_WAY_STORE >> TILE_DATA_ID_SIZE))
#define OSM_ID(x) ((x) & 0b1111111111111111111111111111111111)

class NodeStore;
class WayStore;

/**
	\brief OsmMemTiles stores OSM objects in memory and provides a vector of OutputObjectf for specified tiles
	
	The input objects are generated by PbfReader. The output objects are sent to OsmMemTiles for storage.

	This class provides a consistent interface for Lua scripts to access.
*/
class OsmMemTiles : public TileDataSource {

public:
	OsmMemTiles(
		size_t threadNum,
		uint baseZoom,
		bool includeID,
		const NodeStore& nodeStore,
		const WayStore& wayStore
	);

	std::string name() const override { return "osm"; }

	Geometry buildWayGeometry(
		const OutputGeometryType geomType, 
		const NodeID objectID,
		const TileBbox &bbox
	) override;
	LatpLon buildNodeGeometry(NodeID const objectID, const TileBbox &bbox) const override;


	void Clear();

private:
	void populateLinestring(Linestring& ls, NodeID objectID) const;
	Linestring& getOrBuildLinestring(NodeID objectID) const;
	void populateMultiPolygon(MultiPolygon& dst, NodeID objectID) override;

	const NodeStore& nodeStore;
	const WayStore& wayStore;
};

#endif //_OSM_MEM_TILES

