/*

Copyright (C) 2001  Gopal Narayanan <gopal@astro.umass.edu>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

*/

/*
 * units.h
 */

#ifndef __UNITS_H
#define __UNITS_H



#define FREQ_GHZ 0
#define FREQ_HZ  1
#define FREQ_KHZ 2
#define FREQ_MHZ 3

#define LENGTH_MIL 0
#define LENGTH_CM  1
#define LENGTH_MM  2
#define LENGTH_M   3
#define LENGTH_UM  4
#define LENGTH_IN  5
#define LENGTH_FT  6

#define RES_OHM  0
#define RES_KOHM 1

#define ANG_DEG 0
#define ANG_RAD 1

/*
#define in_to_m(a) (a*2.54e-2)
#define mil_to_m(a) (1e-3*in_to_m(a))
#define cm_to_m(a) (a*1e-2)
#define mm_to_m(a) (a*1e-3)
#define um_to_m(a) (a*1e-6)
#define ft_to_m(a) (a*12*2.54e-2)

#define m_to_in(a) (a/2.54e-2)
#define m_to_mil(a) (m_to_in(a)*1000)
#define m_to_cm(a) (a*100.)
#define m_to_mm(a) (a*1000.)
#define m_to_um(a) (a*1e6)
#define m_to_ft(a) (a/0.3048)

#define ghz_to_hz(a) (a*1e9)
#define khz_to_hz(a) (a*1e3)
#define mhz_to_hz(a) (a*1e6)

#define hz_to_ghz(a) (a*1e-9)
#define hz_to_khz(a) (a*1e-3)
#define hz_to_mhz(a) (a*1e-6)

#define rad_to_deg(a) (a*180.0/M_PI)
#define deg_to_rad(a) (a*M_PI/180.0)

#define kohm_to_ohm(a) (a*1000.0)
#define ohm_to_kohm(a) (a/1000.0)
*/

short length_unit, freq_unit, res_unit, ang_unit;

#endif
