/*	############################################################
	# @(#) chr_mac.h
	# @(#)
	# @(#) Copyright (c) 1995-2001 by Dirk Hagedorn
	# @(#) Dirk Hagedorn (udo@dirk-hagedorn.de)
	#
	# This program is free software; you can redistribute it and/or
	# modify it under the terms of the GNU General Public License
	# as published by the Free Software Foundation; either version 2
	# of the License, or (at your option) any later version.
	# 
	# This program is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU General Public License for more details.
	# 
	# You should have received a copy of the GNU General Public License
	# along with this program; if not, write to the Free Software
	# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
	# 
	# @(#) Uebersetzungstabellen fuer Apple Macintosh
	# gemaess Scan von Martin Osieka @ OF2
	############################################################	*/

#include	"portab.h"

#ifndef ID_CHARSET_H
#define	ID_CHARSET_H
const char *id_charset_h= "@(#) chr_mac.h   07.12.1997";
#endif

#ifndef	THIS_CHARSET
#define	THIS_CHARSET	"MacOS"
#endif


/*	------------------------------------------------------------	*/

/*	############################################################
	# ISO-Zeichensatz in System-Zeichensatz umsetzen
	############################################################	*/
typedef struct _iso2sys
{	unsigned char	iso;
	unsigned char	sys;
}	ISO2SYS;


LOCAL const ISO2SYS iso2sys_item[128]=
{
	{ 128, 0 },				/* null		*/
	{ 129, 0 },				/* null		*/
	{ 130, '\342' },		/* '' (9u)	*/
	{ 131, '\304' },		/* #f		*/
	{ 132, '\343' },		/* "" (99u)	*/
	{ 133, '\311' },		/* !..		*/
	{ 134, '\240' },		/* #dag		*/
	{ 135, '\340' },		/* 2x#dag	*/
	{ 136, '\366' },		/* #circ	*/
	{ 137, '\344' },		/* #promill	*/
	{ 138, 'S'    },		/* vS		*/	/* !!!! */
	{ 139, '\334' },		/* <		*/
	{ 140, '\316' },		/* &OE		*/
	{ 141, 0 },				/* null		*/
	{ 142, 0 },				/* null		*/
	{ 143, 0 },				/* null		*/
	{ 144, 0 },				/* null		*/
	{ 145, '\324' },		/* ` (6o)	*/
	{ 146, '\325' },		/* '' (9o)	*/
	{ 147, '\322' },		/* "" (66o)	*/
	{ 148, '\323' },		/* "" (99o)	*/
	{ 149, '\245' },		/* #bullet	*/
	{ 150, '\320' },		/* --		*/
	{ 151, '\321' },		/* ---		*/
	{ 152, '~'    },		/* !~		*/	/* !!!! */
	{ 153, '\252' },		/* #tm		*/
	{ 154, 's'    },		/* vs		*/	/* !!!! */
	{ 155, '\335' },		/* >		*/
	{ 156, '\317' },		/* &oe		*/
	{ 157, 0 },				/* null		*/
	{ 158, 0 },				/* null		*/
	{ 159, '\331' },		/* "Y		*/
	{ 160, 0 },				/* null		*/
	{ 161, '\301' },		/* #!		*/
	{ 162, '\242' },		/* #cent	*/
	{ 163, '\243' },		/* #pound	*/
	{ 164, '\333' },		/* general currency	*/
	{ 165, '\264' },		/* #yen		*/
	{ 166, '|'    },		/* broken dash	*/	/* !!!! */
	{ 167, '\244' },		/* #sect	*/
	{ 168, '\254' },		/* #"		*/
	{ 169, '\251' },		/* #copy	*/
	{ 170, '\273' },		/* _a		*/
	{ 171, '\307' },		/* #<		*/
	{ 172, '\302' },		/* #neg		*/
	{ 173, 0 },				/* strich	*/
	{ 174, '\250' },		/* #reg		*/
	{ 175, 0 },				/* #macron	*/
	{ 176, '\241' },		/* #degree	*/
	{ 177, '\261' },		/* #pm		*/
	{ 178, 0 },				/* #^2		*/
	{ 179, 0 },				/* #^3		*/
	{ 180, '\253' },		/* #'		*/
	{ 181, '\265' },		/* #mu		*/
	{ 182, '\246' },		/* #p		*/
	{ 183, '\372' },		/* #cdot	*/
	{ 184, '\374' },		/* cedille	*/
	{ 185, '\365' },		/* #^1		*/
	{ 186, '\274' },		/* _o		*/
	{ 187, '\310' },		/* #>		*/
	{ 188, 0 },				/* #1/4		*/
	{ 189, 0 },				/* #1/2		*/
	{ 190, 0 },				/* #3/4		*/
	{ 191, '\300' },		/* #?		*/
	{ 192, '\313' },		/* `A		*/
	{ 193, '\347' },		/* 'A		*/
	{ 194, '\345' },		/* ^A		*/
	{ 195, '\314' },		/* ~A		*/
	{ 196, '\200' },		/* "A		*/
	{ 197, '\201' },		/* .A		*/
	{ 198, '\256' },		/* &AE		*/
	{ 199, '\202' },		/* ,C		*/
	{ 200, '\351' },		/* `E		*/
	{ 201, '\203' },		/* 'E		*/
	{ 202, '\346' },		/* ^E		*/
	{ 203, '\350' },		/* "E		*/
	{ 204, '\355' },		/* `I		*/
	{ 205, '\352' },		/* 'I		*/
	{ 206, '\353' },		/* ^I		*/
	{ 207, '\354' },		/* "I		*/
	{ 208, 0 },				/* -D		*/
	{ 209, '\204' },		/* ~N		*/
	{ 210, '\361' },		/* `O		*/
	{ 211, '\356' },		/* 'O		*/
	{ 212, '\357' },		/* ^O		*/
	{ 213, '\315' },		/* ~O		*/
	{ 214, '\205' },		/* "O		*/
	{ 215, 'x'    },		/* #times	*/	/* !!!! */
	{ 216, '\257' },		/* /O		*/
	{ 217, '\364' },		/* `U		*/
	{ 218, '\362' },		/* 'U		*/
	{ 219, '\363' },		/* ^U		*/
	{ 220, '\206' },		/* "U		*/
	{ 221, 'Y'    },		/* 'Y		*/	/* !!!! */
	{ 222, 0 },				/* |b		*/
	{ 223, '\247' },		/* "s (sz)	*/
	{ 224, '\210' },		/* `a		*/
	{ 225, '\207' },		/* 'a		*/
	{ 226, '\211' },		/* ^a		*/
	{ 227, '\213' },		/* ~a		*/
	{ 228, '\212' },		/* "a		*/
	{ 229, '\214' },		/* .a		*/
	{ 230, '\276' },		/* &ae		*/
	{ 231, '\215' },		/* ,c		*/
	{ 232, '\217' },		/* `e		*/
	{ 233, '\216' },		/* 'e		*/
	{ 234, '\220' },		/* ^e		*/
	{ 235, '\221' },		/* "e		*/
	{ 236, '\223' },		/* `i		*/
	{ 237, '\222' },		/* 'i		*/
	{ 238, '\224' },		/* ^i		*/
	{ 239, '\225' },		/* "i		*/
	{ 240, 0 },				/* o|''		*/	/* !!!! */
	{ 241, '\226' },		/* ~n		*/
	{ 242, '\230' },		/* `o		*/
	{ 243, '\227' },		/* 'o		*/
	{ 244, '\231' },		/* ^o		*/
	{ 245, '\233' },		/* ~o		*/
	{ 246, '\232' },		/* "o		*/
	{ 247, '\326' },		/* #div		*/
	{ 248, '\277' },		/* /o		*/
	{ 249, '\235' },		/* `u		*/
	{ 250, '\234' },		/* 'u		*/
	{ 251, '\236' },		/* ^u		*/
	{ 252, '\237' },		/* "u		*/
	{ 253, 'y'    },		/* 'y		*/	/* !!!! */
	{ 254, 0 },				/* |B		*/
	{ 255, '\330' }			/* "y		*/
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# Systemzeichensatz in andere Zeichensaetze umwandeln
	############################################################	*/

typedef struct _chartable
{
	unsigned char	system;
	char ascii[16];
	char ansi[16];
	char tex[16];
	char html[10];
        char ps[6];
}	CHARTABLE;

LOCAL /* const */ CHARTABLE chrtab[128]=
{
	{	'\200',	"Ae",	"\\'C4",		"{\\\"A}",			"&Auml;",	"\\304" },
	{	'\201',	"A",	"\\'C5",		"{\\AA}",			"&Aring;",	"\\305" },
	{	'\202',	"C",	"\\'C7",		"\\c{C}",			"&Ccedil;",	"\\307"	},
	{	'\203',	"E",	"\\'C9",		"\\'{E}",			"&Eacute;",	"\\311"	},
	{	'\204',	"N",	"\\'D1",		"\\~{N}",			"&Ntilde;",	"\\321" },
	{	'\205',	"Oe",	"\\'D6",		"{\\\"O}",			"&Ouml;",	"\\326"	},
	{	'\206',	"Ue",	"\\'DC",		"{\\\"U}",			"&Uuml;",	"\\334"	},
	{	'\207',	"a",	"\\'E1",		"\\'{a}",			"&aacute;",	"\\341"	},

	{	'\210',	"a",	"\\'E0",		"\\`{a}",			"&agrave;",	"\\340"	},
	{	'\211',	"a",	"\\'E2",		"\\^{a}",			"&acirc;",	"\\342"	},
	{	'\212',	"ae",	"\\'E4",		"{\\\"a}",			"&auml;",	"\\344"	},
	{	'\213',	"a",	"\\'E3",		"\\~{a}",			"&atilde;",	"\\343"	},
	{	'\214',	"a",	"\\'E5",		"{\\aa}",			"&aring;",	"\\345"	},
	{	'\215',	"c",	"\\'E7",		"\\c{c}",			"&ccedil;",	"\\347"	},
	{	'\216',	"e",	"\\'E9",		"\\'{e}",			"&eacute;",	"\\351" },
	{	'\217',	"e",	"\\'E8",		"\\`{e}",			"&egrave;",	"\\350"	},

	{	'\220',	"e",	"\\'EA",		"\\^{e}",			"&ecirc;",	"\\352"	},
	{	'\221',	"e",	"\\'EB",		"\\\"{e}",			"&euml;",	"\\353"	},
	{	'\222',	"i",	"\\'ED",		"\\'{i}",			"&iacute;",	"\\355"	},
	{	'\223',	"i",	"\\'EC",		"\\`{i}",			"&igrave;",	"\\354"	},
	{	'\224',	"i",	"\\'EE",		"\\^{i}",			"&icirc;",	"\\356"	},
	{	'\225',	"i",	"\\'EF",		"\\\"{i}",			"&iuml;",	"\\357"	},
	{	'\226',	"n",	"\\'F1",		"\\~{n}",			"&ntilde;",	"\\361"	},
	{	'\227',	"o",	"\\'F3",		"\\'{o}",			"&oacute;",	"\\363"	},

	{	'\230',	"o",	"\\'F2",		"\\`{o}",			"&ograve;",	"\\362"	},
	{	'\231',	"o",	"\\'F4",		"\\^{o}",			"&ocirc;",	"\\364"	},
	{	'\232',	"oe",	"\\'F6",		"{\\\"o}",			"&ouml;",	"\\366"	},
	{	'\233',	"o",	"\\'F5",		"\\~{o}",			"&otilde;",	"\\365"	},
	{	'\234',	"u",	"\\'FA",		"\\'{u}",			"&uacute;",	"\\372"	},
	{	'\235',	"u",	"\\'F9",		"\\`{u}",			"&ugrave;",	"\\371"	},
	{	'\236',	"u",	"\\'FB",		"\\^{u}",			"&ucirc;",	"\\373"	},
	{	'\237',	"ue",	"\\'FC",		"{\\\"u}",			"&uuml;",	"\\371"	},

	{	'\240',	"",	"\\'86",		"\\dag{}",			"&#134;",	"\\206"	},
	{	'\241',	"",	"\\'B0",		"$\\circ$",			"&#176;",	"\\260"	},
	{	'\242',	"",	"\\'A2",		"cent",				"&#162;",	"\\242"	},
	{	'\243',	"",	"\\'A3",		"\\pounds{}",			"&#163;",	"\\243"	},
	{	'\244',	"",	"\\'A7",		"\\S{}",			"&sect;",	"\\167"	},
	{	'\245',	"",	"\\'95",		"$\\bullet$",			"&#149;",	"\\225"	},
	{	'\246',	"",	"\\'B6",		"\\P{}",			"&#182;",	"\\266"	},
	{	'\247',	"ss",	"\\'DF",		"{\\ss}",			"&szlig;",	"\\337"	},

	{	'\250',	"(R)",	"\\'AE",		"(R)",				"&#174;",	"\\256"	},
	{	'\251',	"(C)",	"\\'A9",		"\\copyright{}",		"&#169;",	"\\251"	},
	{	'\252',	"(TM)",	"\\'99",		"(TM)",				"&#153;",	"\\231"	},
	{	'\253',	"",	"\\'B4",		"\\'{ }",			"&#180;",	"\\264"	},
	{	'\254',	"",	"\\'A8",		"\\!{ }",			"&#168;",	"\\250"	},
	{	'\255',	"",	"{\\f2 \\'B9}",		"$\\neq$",			"&#172;",	"\\254"	},
	{	'\256',	"AE",	"\\'C6",		"{\\AE}",			"&AElig;",	"\\306"	},
	{	'\257',	"O",	"\\'D8",		"{\\O}",			"&Oslash;",	"\\330"	},

	{	'\260',	"",	"{\\f2 \\'A5}",		"$\\infty$",			"&nbsp;",	""	},
	{	'\261',	"",	"\\'B1",		"$\\pm$",			"&#177;",	"\\261"	},
	{	'\262',	"",	"{\\f2 \\'A3}",		"$\\leq$",			"",		""	},
	{	'\263',	"",	"{\\f2 \\'B3}",		"$\\geq$",			"",		""	},
	{	'\264',	"",	"\\'A5",		"yen",				"&#165;",	"\\245"	},
	{	'\265',	"",	"\\'B5",		"$\\mu$",			"&#181;",	"\\365"	},
	{	'\266',	"",	"{\\f2 \\'B6}",		"$\\partial$",			"",		""	},
	{	'\267',	"",	"{\\f2 S}",		"$\\Sigma$",			"",		""	},

	{	'\270',	"",	"{\\f2 P}",		"$\\Pi$",			"",		""	},
	{	'\271',	"",	"{\\f2 p}",		"$\\pi$",			"",		""	},
	{	'\272',	"",	"",			"",				"",		""	},
	{	'\273',	"",	"\\'AA",		"\\b{a}",			"&#170;",	"\\252"	},
	{	'\274',	"",	"\\'BA",		"\\b{o}",			"&#186;",	"\\272"	},
	{	'\275',	"",	"{\\f2 W}",		"$\\Omega$",			"",		""	},
	{	'\276',	"ae",	"\\'E6",		"{\\ae}",			"&aelig;",	"\\346"	},
	{	'\277',	"o",	"\\'F8",		"{\\o}",			"&oslash;",	"\\370"	},

	{	'\300',	"?",	"\\'BF",		"?`",				"&#191;",	"\\277"	},
	{	'\301',	"!",	"\\'A1",		"!`",				"&#161;",	"\\241"	},
	{	'\302',	"",	"\\'AC",		"$\\neg$",			"&#172;",	"\\254"	},
	{	'\303',	"",	"{\\f2 \\'D6}",		"$\\surd$",			"",		"?"	},
	{	'\304',	"",	"\\'83",		"$f$",				"&#131;",	"\\203"	},
	{	'\305',	"",	"{\\f2 \\'BB}",		"$\\approx$",			"",		"?"	},
	{	'\306',	"",	"{\\f2 D}",		"$\\Delta$",			"",		"?"	},
	{	'\307',	"<<",	"\\'AB",		"\"<",				"&#171;",	"\\253"	},

	{	'\310',	">>",	"\\'BB",		"\">",				"&#187;",	"\\273"	},
	{	'\311',	"...",	"\\'85",		"\\ldots{}",			"&#133;",	"\\205"	},
	{	'\312',	"",	"\\~",			"~",				"&nbsp;",	""	},
	{	'\313',	"A",	"\\'C0",		"\\`{A}",			"&Agrave;",	"\\300"	},
	{	'\314',	"A",	"\\'C3",		"\\~{A}",			"&Atilde;",	"\\303"	},
	{	'\315',	"O",	"\\'D5",		"\\~{O}",			"&Otilde;",	"\\325"	},
	{	'\316',	"OE",	"\\'8C",		"{\\OE}",			"&#140;",	"\\214"	},
	{	'\317',	"oe",	"\\'9C",		"{\\oe}",			"&#156;",	"\\234"	},

	{	'\320',	"--",	"\\'96",		"--",				"&#150;",	"\\226"	},
	{	'\321',	"---",	"\\'97",		"---",				"&#151;",	"\\227"	},
	{	'\322',	"",	"\\'93",		"``",				"&#147;",	"\\223"	},
	{	'\323',	"",	"\\'94",		"''",				"&#148;",	"\\224"	},
	{	'\324',	"",	"\\'91",		"`",				"&#145;",	"\\221"	},
	{	'\325',	"",	"\\'92",		"'",				"&#146;",	"\\222"	},
	{	'\326',	"",	"{\\f2 \\'B8}",		"$\\div$",			"&#247;",	"\\367"	},
	{	'\327',	"",	"{\\f2 \\'E0}",		"$\\Diamond$",			"",		"?"	},

	{	'\330',	"y",	"\\'FF",		"\\\"{y}",			"&yuml;",	"\\377"	},
	{	'\331',	"Y",	"\\'9F",		"\\\"{Y}",			"&Yuml;",	"?"	},
	{	'\332',	"/",	"{\\f2 \\'A4}",		"/",				"/",		"/"	},
	{	'\333',	"",	"\\'A4",		"",				"&#164;",	"?"	},	/* gcs */
	{	'\334',	"<",	"<",			"$<$",				"&lt;",		"<"	},
	{	'\335',	">",	">",			"$>$",				"&gt;",		">"	},
	{	'\336',	"fi",	"fi",			"fi",				"fi",		"?"	},
	{	'\337',	"fl",	"fl",			"fl",				"fl",		"?"	},

	{	'\340',	"",	"\\'87",		"$\\ddagger$",			"&#135;",	"\\207"	},
	{	'\341',	"",	"\\'82",		"`",				"&#130;",	"\\202"	},
	{	'\342',	"",	"\\'84",		"``",				"&#132;",	"\\204"	},
	{	'\343',	"",	"\\'89",		"",				"&#137;",	"\\211"	},
	{	'\344',	"A",	"\\'C2",		"\\^{A}",			"&Acirc;",	"\\302"	},
	{	'\345',	"E",	"\\'CA",		"\\^{E}",			"&Ecirc;",	"\\312"	},
	{	'\346',	"A",	"\\'C1",		"\\'{A}",			"&Aacute;",	"\\301"	},
	{	'\347',	"ss",	"\\'DF",		"{\\ss}",			"&szlig;",	"\\337"	},

	{	'\350',	"E",	"\\'CB",		"\\\"{E}",			"&Euml;",	"\\313"	},
	{	'\351',	"E",	"\\'C8",		"\\`{E}",			"&Egrave;",	"\\310"	},
	{	'\352',	"I",	"\\'CD",		"\\'{I}",			"&Iacute;",	"\\315"	},
	{	'\353',	"I",	"\\'CE",		"\\^{I}",			"&Icirc;",	"\\316"	},
	{	'\354',	"I",	"\\'CF",		"\\\"{I}",			"&Iuml;",	"\\317"	},
	{	'\355',	"I",	"\\'CC",		"\\`{I}",			"&Igrave;",	"\\314"	},
	{	'\356',	"O",	"\\'D3",		"\\'{O}",			"&Oacute;",	"\\323"	},
	{	'\357',	"O",	"\\'D4",		"\\^{O}",			"&Ocirc;",	"\\324"	},

	{	'\360',	"",	"",			"",				"",		""	},	/* Apple-Logo */
	{	'\361',	"O",	"\\'D2",		"\\`{O}",			"&Ograve;",	"\\322"	},
	{	'\362',	"U",	"\\'DA",		"\\'{U}",			"&Uacute;",	"\\332"	},
	{	'\363',	"U",	"\\'DB",		"\\^{U}",			"&Ucirc;",	"\\333"	},
	{	'\364',	"U",	"\\'D9",		"\\`{U}",			"&Ugrave;",	"\\331"	},
	{	'\365',	"",	"\\'B9",		"$^1$",				"&#185;",	"\\271"	},
	{	'\366',	"",	"\\'F7",		"\\^{ }",			"^",		"^"	},
	{	'\367',	"",	"~",			"\\~{ }",			"~",		"~"	},

	{	'\370',	"",	"",			"\\={ }",			"",		"?"	},
	{	'\371',	"",	"",			"\\u{ }",			"",		"?"	},
	{	'\372',	"",	"\\'B7",		"\\.{ }",			"&#183;",	"\\267"	},
	{	'\373',	"",	"\\'B0",		"$\\circ$",			"&#176;",	"\\260"	},
	{	'\374',	"",	"\\'B8",		"\\c{ }",			"&#184;",	"\\270"	},
	{	'\375',	"",	"{\\f2 \\'B2}",		"\\H{ }",			"",		""	},
	{	'\376',	"",	"",			"",				"",		""	},
	{	'\377',	"",	"",			"\\v{ }",			"",		""	}
};

/*	------------------------------------------------------------	*/

/*	############################################################
	# universellen Zeichensatz in ASCII-Zeichensatz umsetzen
	############################################################	*/
typedef struct _uni2systab
{
	char			uni[8];
	unsigned char	system[2];
}	UNI2SYSTAB;

#define	UNI2SYSTABSIZE	64

LOCAL const UNI2SYSTAB uni2sys[UNI2SYSTABSIZE]=
{
	{	"(!\"a)",	"\212"	},
	{	"(!\"e)",	"\221"	},
	{	"(!\"i)",	"\225"	},
	{	"(!\"o)",	"\232"	},
	{	"(!\"u)",	"\237"	},
	{	"(!\"y)",	"\330"	},
	{	"(!\"s)",	"\247"	},
	{	"(!\"A)",	"\200"	},
	{	"(!\"E)",	"\350"	},
	{	"(!\"I)",	"\354"	},
	{	"(!\"O)",	"\205"	},
	{	"(!\"U)",	"\206"	},
	{	"(!\"Y)",	"Y"		},	/* 13 */

	{	"(!'a)",	"\207"	},
	{	"(!'e)",	"\216"	},
	{	"(!'i)",	"\222"	},
	{	"(!'o)",	"\227"	},
	{	"(!'u)",	"\234"	},
	{	"(!'y)",	""		},
	{	"(!'A)",	"\347"	},
	{	"(!'E)",	"\203"	},
	{	"(!'I)",	"\352"	},
	{	"(!'O)",	"\356"	},
	{	"(!'U)",	"\362"	},
	{	"(!'Y)",	""		},	/* 12 */

	{	"(!`a)",	"\210"	},
	{	"(!`e)",	"\217"	},
	{	"(!`i)",	"\223"	},
	{	"(!`o)",	"\230"	},
	{	"(!`u)",	"\235"	},
	{	"(!`A)",	"\313"	},
	{	"(!`E)",	"\351"	},
	{	"(!`I)",	"\355"	},
	{	"(!`O)",	"\361"	},
	{	"(!`U)",	"\364"	},	/* 10 */

	{	"(!^a)",	"\211"	},
	{	"(!^e)",	"\220"	},
	{	"(!^i)",	"\224"	},
	{	"(!^o)",	"\231"	},
	{	"(!^u)",	"\236"	},
	{	"(!^A)",	"\345"	},
	{	"(!^E)",	"\346"	},
	{	"(!^I)",	"\353"	},
	{	"(!^O)",	"\357"	},
	{	"(!^U)",	"\363"	},	/* 10 */

	{	"(!~a)",	"\213"	},
	{	"(!~n)",	"\226"	},
	{	"(!~o)",	"\233"	},
	{	"(!~A)",	"\314"	},
	{	"(!~N)",	"\204"	},
	{	"(!~O)",	"\315"	},	/*  6 */

	{	"(!.a)",	"\214"	},
	{	"(!.A)",	"\201"	},	/*  2 */

	{	"(!&ae)",	"\276"	},
	{	"(!&AE)",	"\256"	},
	{	"(!&oe)",	"\317"	},
	{	"(!&OE)",	"\316"	},	/*  4 */

	{	"(!,c)",	"\215"	},
	{	"(!,C)",	"\202"	},	/*  2 */

	{	"(!_a)",	"\273"	},
	{	"(!_o)",	"\274"	},	/*  2 */

	{	"(!\\o)",	"\277"	},
	{	"(!\\O)",	"\257"	},	/*  2 */

	{	"(!#S)",	"\244"	},
};


/*	############################################################
	# chr_mac.h
	############################################################	*/
