/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;

final class ParallelWorldClassLoader
extends ClassLoader {
    private final String prefix;

    protected ParallelWorldClassLoader(ClassLoader parent, String prefix) {
        super(parent);
        this.prefix = prefix;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        StringBuffer sb = new StringBuffer(name.length() + this.prefix.length() + 6);
        if (this.prefix.equals("1.0")) {
            sb.append(this.prefix).append('/').append(name.replace('.', '/')).append(".class");
        } else {
            sb.append(name.replace('.', '/')).append(".class");
        }
        InputStream is = this.getParent().getResourceAsStream(sb.toString());
        if (is == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            String pkgname;
            Package pkg;
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) >= 0) {
                baos.write(buf, 0, len);
            }
            buf = baos.toByteArray();
            int packIndex = name.lastIndexOf(46);
            if (packIndex != -1 && (pkg = this.getPackage(pkgname = name.substring(0, packIndex))) == null) {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
            return this.defineClass(name, buf, 0, buf.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    protected URL findResource(String name) {
        return this.getParent().getResource(this.prefix + '/' + name);
    }

    protected Enumeration findResources(String name) throws IOException {
        return this.getParent().getResources(this.prefix + '.' + name);
    }
}

