/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.util.misc;

import com.sun.appserv.management.util.misc.ClassUtil;
import com.sun.appserv.management.util.misc.ResourceBundleStringSource;
import com.sun.appserv.management.util.misc.StringSource;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;

public class PackageStringSources {
    static final Map<Class, StringSource> mSources = new HashMap<Class, StringSource>();

    public static StringSource get(Class theClass, StringSource delegate) {
        StringSource source = mSources.get(theClass);
        if (source == null) {
            source = PackageStringSources.init(theClass, delegate);
            mSources.put(theClass, source);
        }
        return source;
    }

    private PackageStringSources() {
    }

    private static StringSource init(Class theClass, StringSource delegate) {
        StringSource source = null;
        String packageName = theClass.getPackage().getName();
        try {
            String classname = packageName + ".PackageStrings";
            Class packageStringSourceClass = ClassUtil.getClassFromName(classname);
            Constructor c = packageStringSourceClass.getConstructor(StringSource.class);
            source = (StringSource)c.newInstance(delegate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (source == null) {
            ResourceBundle bundle = ResourceBundle.getBundle(packageName + ".Strings", Locale.getDefault(), theClass.getClassLoader());
            source = new ResourceBundleStringSource(bundle, delegate);
        }
        return source;
    }
}

