/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb.infra.Util;

import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;
import spec.jbb.infra.Util.TransactionLogBuffer;

public class XMLTransactionLog {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright Sun Microsystems, Inc.All rights reserved,Licensed Materials - Property of SPEC";
    static FileOutputStream fout = new FileOutputStream(FileDescriptor.out);
    static Document templateDocument;
    static DocumentBuilder builder;
    private ArrayList<Node> lineCache = new ArrayList(0);
    Document document;

    public XMLTransactionLog() {
        this.copy(templateDocument);
    }

    public void populateXML(TransactionLogBuffer transactionLogBuffer) {
        for (int i = 0; i < transactionLogBuffer.getLineCount(); ++i) {
            this.putLine(transactionLogBuffer.getLine(i), i);
        }
    }

    public void clear() {
        Element element = this.document.getDocumentElement();
        Node node = element.getLastChild();
        Node node2 = null;
        while ((node2 = node.getPreviousSibling()) != null) {
            Node node3 = element.removeChild(node);
            if (node3.getNodeName().equals("Line")) {
                node3.getLastChild().getLastChild().setNodeValue("");
                this.lineCache.add(node3);
            }
            node = node2;
        }
    }

    public void copy(Document document) {
        this.document = (Document)document.cloneNode(true);
    }

    private final void putLine(String string, int n) {
        int n2 = n;
        Node node = this.document.getLastChild();
        int n3 = this.lineCache.size();
        if (n3 > 0) {
            Node node2 = this.lineCache.remove(n3 - 1);
            node.appendChild(node2);
            node2.getLastChild().getLastChild().setNodeValue(string);
        } else {
            Element element = this.document.createElement("Line");
            node.appendChild(element);
            Element element2 = this.document.createElement("LineData");
            element.appendChild(element2);
            Text text = this.document.createTextNode(string);
            element2.appendChild(text);
        }
    }

    static {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            builder = documentBuilderFactory.newDocumentBuilder();
            templateDocument = builder.parse("xml/template-document.xml");
        }
        catch (SAXException sAXException) {
            System.err.println("SAX Error in template-document initialization.");
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
            System.exit(1);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("Parser configuration error in template-document initialization.");
            parserConfigurationException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println("I/O error in template-document initialization.");
            iOException.printStackTrace();
            System.exit(1);
        }
    }
}

