// WideMargin. Simple fast bible software.
// Copyright (C) 2011  Daniel Hughes
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

using System;
using System.Collections.Generic;

namespace WideMargin.Database
{
	public class Book
	{
		protected Chapter[] _chapters;		
		
		public Book (string name, int[] verseCounts, IEnumerable<string> catagories)
		{
			Name = name;
			_chapters = new Chapter[verseCounts.Length];
			for(int index = 0; index< verseCounts.Length ; index++)
			{
				int verseCount = verseCounts[index];
				_chapters[index] = new Chapter(index + 1, verseCount);
			}
			
			Catagories = catagories;
		}
		
		public string Name
		{
			get;
			private set;
		}
		
		public int ChapterCount
		{
			get
			{
				return _chapters.Length;	
			}
		}
		
		public Chapter GetNextChapter(Chapter chapter)
		{
			int number = chapter.Number;
			if(number >= _chapters.Length)
			{
				return null;
			}
			return _chapters[number];	
		}
		
		public Chapter GetPreviousChapter(Chapter chapter)
		{
			int previousNumber = chapter.Number - 1;
			if(previousNumber < 1)
			{
				return null;
			}
			return _chapters[previousNumber - 1];	
		}
		
		public Chapter GetChapter(int number)
		{
			return _chapters[number - 1];
		}
		
		public Chapter LastChapter
		{
			get
			{
				return _chapters[_chapters.Length - 1];
			}
		}
		
		public IEnumerable<string> Catagories
		{
			private set;
			get;
		}
		
		/// <summary>
		/// Zero based index of book in biblical order.
		/// </summary>
		public int Index
		{
			get;
			set;
		}
	}
}

