package input

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"errors"
	"fmt"
	"strconv"
	"time"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// TouchPoint [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#type-TouchPoint
type TouchPoint struct {
	X                  float64 `json:"x"`                            // X coordinate of the event relative to the main frame's viewport in CSS pixels.
	Y                  float64 `json:"y"`                            // Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.
	RadiusX            float64 `json:"radiusX,omitempty"`            // X radius of the touch area (default: 1.0).
	RadiusY            float64 `json:"radiusY,omitempty"`            // Y radius of the touch area (default: 1.0).
	RotationAngle      float64 `json:"rotationAngle,omitempty"`      // Rotation angle (default: 0.0).
	Force              float64 `json:"force,omitempty"`              // Force (default: 1.0).
	TangentialPressure float64 `json:"tangentialPressure,omitempty"` // The normalized tangential pressure, which has a range of [-1,1] (default: 0).
	TiltX              int64   `json:"tiltX,omitempty"`              // The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0)
	TiltY              int64   `json:"tiltY,omitempty"`              // The plane angle between the X-Z plane and the plane containing both the stylus axis and the X axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0).
	Twist              int64   `json:"twist,omitempty"`              // The clockwise rotation of a pen stylus around its own major axis, in degrees in the range [0,359] (default: 0).
	ID                 float64 `json:"id,omitempty"`                 // Identifier used to track touch sources between events, must be unique within an event.
}

// GestureSourceType [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#type-GestureSourceType
type GestureSourceType string

// String returns the GestureSourceType as string value.
func (t GestureSourceType) String() string {
	return string(t)
}

// GestureSourceType values.
const (
	GestureDefault GestureSourceType = "default"
	GestureTouch   GestureSourceType = "touch"
	GestureMouse   GestureSourceType = "mouse"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t GestureSourceType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t GestureSourceType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *GestureSourceType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch GestureSourceType(in.String()) {
	case GestureDefault:
		*t = GestureDefault
	case GestureTouch:
		*t = GestureTouch
	case GestureMouse:
		*t = GestureMouse

	default:
		in.AddError(errors.New("unknown GestureSourceType value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *GestureSourceType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// MouseButton [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#type-MouseButton
type MouseButton string

// String returns the MouseButton as string value.
func (t MouseButton) String() string {
	return string(t)
}

// MouseButton values.
const (
	None    MouseButton = "none"
	Left    MouseButton = "left"
	Middle  MouseButton = "middle"
	Right   MouseButton = "right"
	Back    MouseButton = "back"
	Forward MouseButton = "forward"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t MouseButton) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t MouseButton) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *MouseButton) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch MouseButton(in.String()) {
	case None:
		*t = None
	case Left:
		*t = Left
	case Middle:
		*t = Middle
	case Right:
		*t = Right
	case Back:
		*t = Back
	case Forward:
		*t = Forward

	default:
		in.AddError(errors.New("unknown MouseButton value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *MouseButton) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// TimeSinceEpoch UTC time in seconds, counted from January 1, 1970.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#type-TimeSinceEpoch
type TimeSinceEpoch time.Time

// Time returns the TimeSinceEpoch as time.Time value.
func (t TimeSinceEpoch) Time() time.Time {
	return time.Time(t)
}

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t TimeSinceEpoch) MarshalEasyJSON(out *jwriter.Writer) {
	v := float64(time.Time(t).UnixNano() / int64(time.Second))

	out.Buffer.EnsureSpace(20)
	out.Buffer.Buf = strconv.AppendFloat(out.Buffer.Buf, v, 'f', -1, 64)
}

// MarshalJSON satisfies json.Marshaler.
func (t TimeSinceEpoch) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *TimeSinceEpoch) UnmarshalEasyJSON(in *jlexer.Lexer) {
	*t = TimeSinceEpoch(time.Unix(0, int64(in.Float64()*float64(time.Second))))
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *TimeSinceEpoch) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// Modifier input key modifier type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#method-dispatchKeyEvent
type Modifier int64

// Int64 returns the Modifier as int64 value.
func (t Modifier) Int64() int64 {
	return int64(t)
}

// Modifier values.
const (
	ModifierNone  Modifier = 0
	ModifierAlt   Modifier = 1
	ModifierCtrl  Modifier = 2
	ModifierMeta  Modifier = 4
	ModifierShift Modifier = 8
)

// String returns the Modifier as string value.
func (t Modifier) String() string {
	switch t {
	case ModifierNone:
		return "None"
	case ModifierAlt:
		return "Alt"
	case ModifierCtrl:
		return "Ctrl"
	case ModifierMeta:
		return "Meta"
	case ModifierShift:
		return "Shift"
	}

	return fmt.Sprintf("Modifier(%d)", t)
}

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t Modifier) MarshalEasyJSON(out *jwriter.Writer) {
	out.Int64(int64(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t Modifier) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *Modifier) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch Modifier(in.Int64()) {
	case ModifierNone:
		*t = ModifierNone
	case ModifierAlt:
		*t = ModifierAlt
	case ModifierCtrl:
		*t = ModifierCtrl
	case ModifierMeta:
		*t = ModifierMeta
	case ModifierShift:
		*t = ModifierShift

	default:
		in.AddError(errors.New("unknown Modifier value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *Modifier) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// ModifierCommand is an alias for ModifierMeta.
const ModifierCommand Modifier = ModifierMeta

// KeyType type of the key event.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#method-dispatchKeyEvent
type KeyType string

// String returns the KeyType as string value.
func (t KeyType) String() string {
	return string(t)
}

// KeyType values.
const (
	KeyDown    KeyType = "keyDown"
	KeyUp      KeyType = "keyUp"
	KeyRawDown KeyType = "rawKeyDown"
	KeyChar    KeyType = "char"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t KeyType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t KeyType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *KeyType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch KeyType(in.String()) {
	case KeyDown:
		*t = KeyDown
	case KeyUp:
		*t = KeyUp
	case KeyRawDown:
		*t = KeyRawDown
	case KeyChar:
		*t = KeyChar

	default:
		in.AddError(errors.New("unknown KeyType value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *KeyType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// MouseType type of the mouse event.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#method-dispatchMouseEvent
type MouseType string

// String returns the MouseType as string value.
func (t MouseType) String() string {
	return string(t)
}

// MouseType values.
const (
	MousePressed  MouseType = "mousePressed"
	MouseReleased MouseType = "mouseReleased"
	MouseMoved    MouseType = "mouseMoved"
	MouseWheel    MouseType = "mouseWheel"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t MouseType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t MouseType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *MouseType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch MouseType(in.String()) {
	case MousePressed:
		*t = MousePressed
	case MouseReleased:
		*t = MouseReleased
	case MouseMoved:
		*t = MouseMoved
	case MouseWheel:
		*t = MouseWheel

	default:
		in.AddError(errors.New("unknown MouseType value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *MouseType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// DispatchMouseEventPointerType pointer type (default: "mouse").
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#method-dispatchMouseEvent
type DispatchMouseEventPointerType string

// String returns the DispatchMouseEventPointerType as string value.
func (t DispatchMouseEventPointerType) String() string {
	return string(t)
}

// DispatchMouseEventPointerType values.
const (
	Mouse DispatchMouseEventPointerType = "mouse"
	Pen   DispatchMouseEventPointerType = "pen"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t DispatchMouseEventPointerType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t DispatchMouseEventPointerType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *DispatchMouseEventPointerType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch DispatchMouseEventPointerType(in.String()) {
	case Mouse:
		*t = Mouse
	case Pen:
		*t = Pen

	default:
		in.AddError(errors.New("unknown DispatchMouseEventPointerType value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *DispatchMouseEventPointerType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// TouchType type of the touch event. TouchEnd and TouchCancel must not
// contain any touch points, while TouchStart and TouchMove must contains at
// least one.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Input#method-dispatchTouchEvent
type TouchType string

// String returns the TouchType as string value.
func (t TouchType) String() string {
	return string(t)
}

// TouchType values.
const (
	TouchStart  TouchType = "touchStart"
	TouchEnd    TouchType = "touchEnd"
	TouchMove   TouchType = "touchMove"
	TouchCancel TouchType = "touchCancel"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t TouchType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t TouchType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *TouchType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch TouchType(in.String()) {
	case TouchStart:
		*t = TouchStart
	case TouchEnd:
		*t = TouchEnd
	case TouchMove:
		*t = TouchMove
	case TouchCancel:
		*t = TouchCancel

	default:
		in.AddError(errors.New("unknown TouchType value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *TouchType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
