## --------------------------------------------------------- ##
##  Check if rename(2) is available and working.             ##
##  Replace if necessary                                     ##
##                           demaille@inf.enst.fr            ##
## --------------------------------------------------------- ##

dnl rename.c should be available

# serial 1

AC_DEFUN(ad_CHECK_FUNC_RENAME,
[AC_CHECK_FUNCS(rename)
if test $ac_cv_func_rename = yes; then
  AC_CACHE_CHECK([whether rename works], ac_cv_func_rename_works,
  [ac_cv_func_rename=no
   : >conftest.1
   : >conftest.2
   AC_TRY_RUN([#include <stdio.h>
int main () { exit (rename ("conftest.1", "conftest.2")); }],
   test -f conftest.1 || ac_cv_func_rename_works=yes,,:)])
fi])

AC_DEFUN(ad_REPLACE_FUNC_RENAME,
[AC_REQUIRE(ad_CHECK_FUNC_RENAME)
AC_REQUIRE(AC_HEADER_STAT)
if test "$ac_cv_func_rename" = no ||
   test "$ac_cv_func_rename_works" = no; then
  AC_CHECK_FUNCS(link)
  dnl FIXME: Define MVDIR
  LIBOBJS="$LIBOBJS rename.o"
  AC_DEFINE_UNQUOTED(rename, rpl_rename,
   [Define to the replacement function if should be used.])
fi])
