;;; -*- Mode: Lisp; Package: DSYS; Base: 10; Syntax: Common-Lisp -*-

(in-package "DSYS")

(defsystem clue
    (:pretty-name "CLUE")
  (:module common-lisp common-lisp (:type :system))
  (:module clx clx (:type :system))
  (:parallel
   common-lisp
   clx
   (:forms :compile 
	   (progn
	     (setq *compile-system-proclamation* *normal-declaration*)
	     (proclaim *compile-system-proclamation*)
	     #+akcl (setq compiler::*compile-ordinaries* t)))
   (:parallel
    "clue"		;; Define packages
    "exports"           ;; external cluei symbols
    (:load "precom")
    "clx-patch"         ;; Modify xlib:create-window, 
    "window-doc"	;; pointer documentation window support
    "event-parse"	;; Utilities for event translation
    "defcontact"	;; CLOS extension for resources and type conversion
    "intrinsics"	;; The "guts"
    "caches"		;; Support for gcontext, pixmap, cursor cacheing
    "resource"		;; Resource and type conversion
    "gray"		;; Gray stipple patterns
    "cursor"		;; Standard cursor names
    "events"		;; Event handling
    "virtual"		;; Support for windowless contacts
    "shells"		;; Support for top-level window/session mgr interaction
    "root-gmgmt"	;; Geometry management methods for root contacts
    ;;"stream"		;; interactive-stream (non-portable!!)
    "package"		;; External cluei symbols exported from clue
    "menu"              ;; example
    (:compile "precom")
    )))

(defvar *clue-files*
  '((("system") "lisp"
     "clue")
    (("clue") nil
     "README")
    (("clue" "clue") nil
     "README")
    (("clue" "clue") "lisp"
     "caches" "clos-patch" "clue" "clx-patch" "common-lisp" "cursor" "defcontact"
     "defsystem" "event-parse" "events" "gray" "intrinsics" "menu"
     "obsolete" "package" "precom" "resource" "root-gmgmt" "shells"
     "stream" "virtual" "window-doc")
    (("clue" "clue" "examples") "lisp"
     "menu")
    (("clue" "clue" "doc") nil
     "clue.index" "clue.ps" "clue.tex" "examples.text" "release.7-1" "release.7-20" 
     "turbo-clue.index" "turbo-clue.ps" "turbo-clue.tex")
    (("clue" "clio") nil
     "README")
    (("clue" "clio") "lisp"
     "buffer" "buttons" "choices" "clio" "command" "confirm" "core-mixins" 
     "defsystem" "display-imag" "display-text" "dlog-button" "edit-text" "form" 
     "gravity" "mchoices" "menu" "ol-defs" "ol-images" "psheet" "scroll-frame" 
     "scroller" "slider" "table" "text-command" "utility")
    (("clue" "clio" "examples") "lisp"
     "cmd-frame" "defsystem" "package" "precom" "sketch" "sketchpad")
    (("clue" "clio" "doc") nil
     "clio.index" "clio.ps" "clio.tex" "release.1-0" "text-cmds.text")
    (("clue" "pictures") nil
     "README" "RELEASE")
    (("clue" "pictures") "lisp"
     "bspline" "circle" "class-def" "defgeneric" "defsystem" "edge" "ellipse" "extent" 
     "fdefsystem" "font-family" "gevents" "gimage" "grabber" "graphic" "gstack" "gstate" 
     "header" "label" "line" "macros" "package" "picture" "polygon" "polypoint" "rectangle" 
     "restore" "save" "scene" "sequence" "transform" "types" "utilities" "view-draw" 
     "view-events" "view-pan" "view-select" "view-zoom" "view")
    (("clue" "pictures" "examples") "lisp"
     "road-demo")
    (("clue" "pictures" "doc") nil
     "pictures.rtf" "pictures.text")))
