/*
 * Copyright (C) 1999-2001 Free Software Foundation, Inc.
 * This file is part of the GNU LIBICONV Library.
 *
 * The GNU LIBICONV Library is free software; you can redistribute it
 * and/or modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * The GNU LIBICONV Library is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the GNU LIBICONV Library; see the file COPYING.LIB.
 * If not, write to the Free Software Foundation, Inc., 59 Temple Place -
 * Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * CNS 11643-1992 plane 15
 */

static const unsigned short cns11643_15_2uni_page21[7169] = {
  /* 0x21 */
  0x5002, 0x508c, 0x50d4, 0x51a5, 0x5092, 0x5093, 0x50d8, 0x50d9,
  0x51a7, 0x562b, 0x562c, 0x562d, 0x5630, 0x562e, 0x56ab, 0x1901,
  0x592d, 0x596d, 0x4ffd, 0x5a0f, 0x4ffd, 0x5b9d, 0x61a2, 0x65d4,
  0x6b56, 0x6bc3, 0x7014, 0x4ffd, 0x971a, 0x500f, 0x5010, 0x509a,
  0x509b, 0x4ffd, 0x51ac, 0x0036, 0x5097, 0x5546, 0x4ffd, 0x5576,
  0x5577, 0x55ae, 0x563a, 0x567d, 0x6bc5, 0x5ba8, 0x4ffd, 0x19fa,
  0x6241, 0x6242, 0x65d8, 0x65d9, 0x66aa, 0x66ab, 0x6942, 0x6941,
  0x4e99, 0x6bc6, 0x4ffd, 0x6d35, 0x6d36, 0x6d37, 0x4ffd, 0xb34d,
  0x4ffd, 0x71b5, 0x7317, 0x7482, 0x83b6, 0x2c49, 0x8c72, 0x955c,
  0x95a8, 0x43b7, 0x65e3, 0x0006, 0x4ffd, 0x50e6, 0x5144, 0x5145,
  0x1629, 0x4ffd, 0x51c4, 0x51c5, 0x51c6, 0x51c7, 0x51c8, 0x51c9,
  0x51ca, 0x51d4, 0x557d, 0xb272, 0x55b2, 0x55b4,
  /* 0x22 */
  0x5682, 0x56c7, 0x56c8, 0x4ffd, 0x583c, 0x583d, 0x583e, 0x583f,
  0x4ffd, 0x58d3, 0x5147, 0x194e, 0x5a3d, 0x5ae2, 0x5bb8, 0x5bb9,
  0x5bc2, 0x5bba, 0x5bc6, 0x5bbb, 0x61ad, 0x624c, 0x624d, 0x4ffd,
  0x66b2, 0x66b3, 0x66b4, 0x66b5, 0x69c3, 0x69c4, 0x69c5, 0x69c6,
  0x69c7, 0x4ffd, 0x6bce, 0x6c30, 0x6d47, 0x6d48, 0x2181, 0x705c,
  0x4ffd, 0x705f, 0x7318, 0x7319, 0x737e, 0x2310, 0x75b0, 0x7a75,
  0x2468, 0x7a76, 0x8041, 0x8142, 0x4ffd, 0x83bd, 0x2742, 0x2740,
  0x17ea, 0x8b1e, 0x8b1f, 0x8c87, 0x2c62, 0x8c78, 0x9188, 0x9189,
  0x918a, 0x9617, 0x9615, 0x4ffd, 0x4ffd, 0x3191, 0xa0e5, 0xa609,
  0xa73b, 0xa74f, 0x4ffd, 0xb62e, 0xb62f, 0xbaff, 0xbafd, 0xbafe,
  0x43bb, 0x43bc, 0x4ffd, 0x5023, 0x50ea, 0x512a, 0x5149, 0x514a,
  0x514b, 0x51df, 0x51e0, 0x51e1, 0x51e2, 0x55c1,
  /* 0x23 */
  0x51e3, 0x51e4, 0x51e5, 0x55c0, 0x51e6, 0x51f7, 0x4ffd, 0x51e7,
  0x51e8, 0x51e9, 0x51ea, 0x51eb, 0x550e, 0x5580, 0x5581, 0x55ba,
  0x55bb, 0x55bc, 0x55bd, 0x563f, 0x5640, 0x5688, 0x4ffd, 0x5846,
  0x4ffd, 0x5847, 0x5848, 0x5936, 0x5972, 0x5996, 0x5a47, 0x5ae7,
  0x5b34, 0x5b35, 0x5b36, 0x5b37, 0x5be3, 0x5be4, 0x5be5, 0x5beb,
  0x0175, 0x5be6, 0x5be7, 0x5be8, 0x4ffd, 0x4ffd, 0x61b9, 0x1ce8,
  0x61ba, 0x1d5b, 0x6263, 0x6264, 0x4ffd, 0x6265, 0x4ffd, 0x6266,
  0x627c, 0x6267, 0x4ffd, 0x6559, 0x65e9, 0x65ea, 0x65eb, 0x65ec,
  0x65ed, 0x65ee, 0x65ef, 0x66bf, 0x66cb, 0x66c3, 0x66d5, 0x66c4,
  0x66c5, 0x66d3, 0x66c6, 0x66c7, 0x66c8, 0x66c9, 0x66ca, 0x694a,
  0x4ffd, 0x69d1, 0x6b61, 0x6c37, 0x4ffd, 0x6d64, 0x6d66, 0x4ffd,
  0x6d67, 0x6d68, 0x6d69, 0x2197, 0x6d73, 0x6d6a,
  /* 0x24 */
  0x6d6b, 0x2762, 0x4ffd, 0x7072, 0x043c, 0x71b9, 0x731c, 0x7336,
  0x73bc, 0x73be, 0x73bf, 0x73c0, 0x7487, 0x75dc, 0x75dd, 0x75f5,
  0x75de, 0x75df, 0x4ffd, 0x75e0, 0x75e1, 0x75e2, 0x7a2c, 0x7a2d,
  0x24a4, 0x7aa9, 0x7a9c, 0x7a9d, 0x7a9e, 0x7a9f, 0x7aa0, 0x7aa1,
  0x7aa2, 0x4ffd, 0x7aa3, 0x7aa4, 0x7aa7, 0x8042, 0x8093, 0x8151,
  0x4ffd, 0x8152, 0x8144, 0x8153, 0x8322, 0x83c6, 0x83c7, 0x83c9,
  0x4ffd, 0x83ca, 0x2766, 0x83c8, 0x8b24, 0x8b25, 0x8b26, 0x4ffd,
  0x8b27, 0x8b28, 0x4ffd, 0x8c58, 0x4ffd, 0x8ca7, 0x8c88, 0x8c89,
  0x8ca5, 0x8ca8, 0x8ca9, 0x8caa, 0x8cab, 0x8cac, 0x8cad, 0x2ca3,
  0x8c79, 0x4ffd, 0x9194, 0x9195, 0x9196, 0x4ffd, 0x4ffd, 0x9197,
  0x2f7f, 0x9198, 0x954e, 0x954f, 0x9619, 0x4ffd, 0x9741, 0x4ffd,
  0x98f7, 0x9c04, 0x9c19, 0x9c17, 0xa040, 0xa0ec,
  /* 0x25 */
  0xa41b, 0xa41c, 0x35f6, 0xa60e, 0xa752, 0xaad8, 0xae26, 0xb274,
  0x4ffd, 0xb275, 0xb9c6, 0xbb0b, 0xbb0c, 0xbb0d, 0xbb0e, 0xbb0f,
  0xbb10, 0x43c8, 0xd459, 0xd45a, 0xd683, 0xd684, 0xd685, 0x4ffd,
  0x4ffd, 0xde20, 0xde21, 0xde22, 0xde23, 0xde24, 0xde29, 0x50f4,
  0x4ffd, 0x658f, 0x5151, 0x16ab, 0x5217, 0x5218, 0x525b, 0x5219,
  0x521a, 0x0053, 0x521b, 0x521c, 0x521d, 0x521e, 0x521f, 0x5220,
  0x5221, 0x548b, 0x5488, 0x212d, 0x5585, 0xb287, 0x55c7, 0x564c,
  0x564d, 0x56fc, 0x56fd, 0x56fe, 0x56ff, 0x4ffd, 0x4ffd, 0x5856,
  0x5857, 0x5858, 0x5859, 0x58dc, 0x58dd, 0x5973, 0x599d, 0x59a1,
  0x599e, 0x599f, 0x59a0, 0x59e6, 0x5a51, 0x5a52, 0x5b3d, 0x5c22,
  0x1a9c, 0x5c23, 0x5c24, 0x5c25, 0x5c26, 0x5c27, 0x5c28, 0x5c29,
  0x5c2a, 0x5c2b, 0x4ffd, 0x5c40, 0x5c2c, 0x5c2d,
  /* 0x26 */
  0x5c2e, 0x5c2f, 0x5c30, 0x61d0, 0x62a8, 0x6294, 0x6295, 0x6296,
  0x6297, 0x6298, 0x629c, 0x629b, 0x4ffd, 0x62a1, 0x62a0, 0x6299,
  0x629a, 0x62a7, 0x1d88, 0x6564, 0x4ffd, 0x6600, 0x6601, 0x4ffd,
  0x4ffd, 0x66e5, 0x66e9, 0x66fb, 0x66fc, 0x66ea, 0x66eb, 0x66ec,
  0x66ed, 0x66ee, 0x66ef, 0x66fa, 0x66f0, 0x66f1, 0x66f2, 0x66f3,
  0x66f4, 0x6952, 0x6953, 0x6954, 0x6955, 0x6958, 0x6956, 0x4ffd,
  0x69dd, 0x69de, 0x69e3, 0x69df, 0x69e0, 0x6b22, 0x6b23, 0x6b68,
  0x6bdf, 0x00ac, 0x6c44, 0x6d94, 0x6d95, 0x6d96, 0x6d97, 0x6d98,
  0x6d99, 0x4ffd, 0x6d9a, 0x6d9b, 0x6d9d, 0x6d9e, 0x6d9f, 0x6da0,
  0x6ff3, 0x6ff2, 0x701f, 0x7088, 0x718f, 0x7190, 0x4ffd, 0x71fd,
  0x71fe, 0x71ff, 0x7200, 0x7201, 0x761a, 0x4ffd, 0x75e3, 0x75e4,
  0x75e5, 0x75e6, 0x75e7, 0x75eb, 0x75e8, 0x75e9,
  /* 0x27 */
  0x75ea, 0x761d, 0x79a4, 0x79a3, 0x7ad4, 0x7ac6, 0x7ac7, 0x7ac8,
  0x7ac9, 0x7aca, 0x7acb, 0x7acc, 0x7acd, 0x4ffd, 0x7ace, 0x24c3,
  0x7eb8, 0x7eb9, 0x7eba, 0x806e, 0x80db, 0x80dc, 0x8168, 0x8169,
  0x816a, 0x816b, 0x816c, 0x816d, 0x816e, 0x2619, 0x8324, 0x8325,
  0x4ffd, 0x8400, 0x83e5, 0x83f9, 0x83e7, 0x83e8, 0x83e9, 0x83fe,
  0x83ea, 0x83eb, 0x83ec, 0x0749, 0x83ed, 0x27a1, 0x83ee, 0x27a6,
  0x83ef, 0x4ffd, 0x8417, 0x83f0, 0x83f1, 0x8894, 0x895b, 0x895c,
  0x895d, 0x8b2f, 0x0891, 0x8b30, 0x8b31, 0x8b32, 0x8b33, 0x8ccc,
  0x8ccd, 0x8cce, 0x8cae, 0x8caf, 0x8cb0, 0x08d3, 0x8ccf, 0x8cd0,
  0x8cd1, 0x8cd2, 0x8cd3, 0x4ffd, 0x8cd4, 0x4ffd, 0x91a6, 0x91a7,
  0x91a8, 0x91b0, 0x91a9, 0x91aa, 0x91ab, 0x91ac, 0x91ad, 0x94fb,
  0x94fc, 0x4ffd, 0x962d, 0x962e, 0x9650, 0x962f,
  /* 0x28 */
  0x9630, 0x9765, 0x98e6, 0x990c, 0x9902, 0x9903, 0x9904, 0x9905,
  0x9906, 0x4ffd, 0x9bc0, 0x9c24, 0x9c25, 0x9d16, 0x9d32, 0xa420,
  0xa421, 0xa422, 0xa423, 0x35fe, 0xa425, 0xa619, 0xa624, 0xa61a,
  0xa61b, 0xa61c, 0xa61d, 0x4ffd, 0xa61e, 0xa75a, 0xa75b, 0xa75c,
  0xa75d, 0xa75e, 0xa931, 0x4ffd, 0xae29, 0x4ffd, 0xaf88, 0xaf89,
  0xb289, 0x3c57, 0xb356, 0xb4d1, 0xb4e6, 0xb532, 0xb533, 0xb652,
  0xb653, 0x0dd5, 0xb654, 0xb655, 0x4ffd, 0x4ffd, 0xbb29, 0xbb2a,
  0xbb2b, 0xbb2c, 0xbb2d, 0x4ffd, 0xbb2e, 0xbb2f, 0xbb30, 0xbb31,
  0xbb32, 0xbb33, 0x3dc5, 0xbb34, 0xc19b, 0xc223, 0xc224, 0x4ffd,
  0xc225, 0xc227, 0xc616, 0xcca0, 0xd46f, 0x43df, 0xd470, 0xd471,
  0x43dc, 0x128c, 0xd472, 0xd473, 0xd474, 0xd69c, 0xd6aa, 0xd69d,
  0xd69e, 0x4ffd, 0xd6ab, 0xd69f, 0xde35, 0xde38,
  /* 0x29 */
  0xf38d, 0x5035, 0x5036, 0xaaee, 0x50b4, 0xf6c9, 0x5132, 0x5155,
  0x5244, 0x5245, 0x5246, 0x5247, 0x16e4, 0x5248, 0x5249, 0x4ffd,
  0x524a, 0x524b, 0x524c, 0x524d, 0x524e, 0x524f, 0x5250, 0x5251,
  0xb299, 0x55d1, 0x4ffd, 0x55d2, 0x55d3, 0x55d4, 0x55d5, 0x5721,
  0x5722, 0x5723, 0x5868, 0x5869, 0x586a, 0x58e2, 0x5945, 0x59ec,
  0x59ed, 0x59ee, 0x59ef, 0x4ffd, 0x5a62, 0x5a63, 0x5af4, 0x506f,
  0x5b44, 0x5b45, 0x5c79, 0x1b1b, 0x5c7a, 0x5c7b, 0x5c7c, 0x5c7d,
  0x5c7e, 0x5c7f, 0x5c80, 0x0188, 0x4ffd, 0x5c81, 0x5c82, 0x5c83,
  0x5c84, 0x5c85, 0x5c86, 0x5c87, 0x5c8f, 0x5c88, 0x5c89, 0x62c5,
  0x62c6, 0x1daa, 0x62c7, 0x62c8, 0x62c9, 0x62ca, 0x62cb, 0x62cc,
  0x1dab, 0x62cd, 0x62ce, 0x62e3, 0x62cf, 0x62d0, 0x62d1, 0x62d2,
  0x62d3, 0x62c4, 0x62d4, 0x62d5, 0x62d6, 0x6520,
  /* 0x2a */
  0x6521, 0x661a, 0x6612, 0x6614, 0x6615, 0x6616, 0x6619, 0x6617,
  0x6618, 0x02c9, 0x4ffd, 0x4ffd, 0x6712, 0x6713, 0x6714, 0x6715,
  0x6716, 0x6717, 0x6718, 0x6719, 0x6961, 0x6962, 0x6963, 0x69f5,
  0x20a9, 0x69f6, 0x69f7, 0x69f8, 0x6b29, 0x0517, 0x6c5d, 0x6c57,
  0x6c58, 0x6c59, 0x6c5a, 0x6c5b, 0x6dbb, 0x6dd1, 0x6dbc, 0x6dbd,
  0xb8df, 0x6dd0, 0x6dbe, 0x6dbf, 0x6dc0, 0x6dc1, 0x6dc2, 0x6dc3,
  0x6dc4, 0xbb6c, 0x70a1, 0x70a2, 0x70a3, 0x7193, 0x720d, 0x720f,
  0x720e, 0x7210, 0x7211, 0x7212, 0x4ffd, 0x74e5, 0x762f, 0x4ffd,
  0x7657, 0x7630, 0x7668, 0x762b, 0x7631, 0x7658, 0x4ffd, 0x7632,
  0x7659, 0x4ffd, 0x765a, 0x7633, 0x765b, 0x765c, 0x765d, 0x761e,
  0x79ae, 0x79af, 0x7a3b, 0x7a3c, 0x7a3d, 0x7b07, 0x7b08, 0x7b09,
  0x7b0a, 0x7b0b, 0x7b0c, 0x7b0d, 0x7b0e, 0x7b0f,
  /* 0x2b */
  0x7b10, 0x7b22, 0x7b11, 0x7b12, 0x7b13, 0x7b14, 0x7b15, 0x7b16,
  0x7b17, 0x7b18, 0x4ffd, 0x4ffd, 0x8046, 0x8047, 0x8048, 0x80e1,
  0x8181, 0x8183, 0x5c75, 0x4ffd, 0x8185, 0x8186, 0x832a, 0x4ffd,
  0x832b, 0x836b, 0x8418, 0x8419, 0x841a, 0x4ffd, 0x841b, 0x841c,
  0x841d, 0x841e, 0x841f, 0x8420, 0x8421, 0x8422, 0x8423, 0x2811,
  0x8424, 0x8425, 0x8426, 0x8427, 0x8428, 0x8429, 0x842a, 0x89ef,
  0x8b49, 0x8b4a, 0x8b4b, 0x8b4c, 0x8b4d, 0x8b4e, 0x8b4f, 0x8b50,
  0x8b51, 0x8b52, 0x8b53, 0x8b54, 0x8b5a, 0x8b55, 0x8c5f, 0x8d02,
  0x8d03, 0x8d04, 0x8d05, 0x8cd5, 0x8d06, 0x8d07, 0x8cd6, 0x8d08,
  0x8d09, 0x8d0a, 0x8d0b, 0x8cd7, 0x8d0c, 0x8d0d, 0x91c8, 0x91c9,
  0x91ca, 0x91cb, 0x91cc, 0x91cd, 0x91ce, 0x91cf, 0x91d0, 0x91d1,
  0x91d2, 0x3351, 0x91d3, 0x91d4, 0x91d5, 0x91d6,
  /* 0x2c */
  0x91d7, 0x91e2, 0x91d8, 0x9504, 0x9505, 0x9506, 0x4ffd, 0x9643,
  0x9644, 0x9784, 0x978f, 0x9785, 0x9786, 0x992f, 0x991a, 0x991b,
  0x991c, 0x0abd, 0x991d, 0x991e, 0x991f, 0x9920, 0x9921, 0x9922,
  0x4ffd, 0x9923, 0x9924, 0x990e, 0x9925, 0x992b, 0x992c, 0x990b,
  0x9aee, 0x4ffd, 0x9bc3, 0x9bd8, 0x9bd9, 0x9c38, 0x9c39, 0x9c3a,
  0x9c3b, 0x3353, 0x9c3c, 0x9c3d, 0x9c3e, 0x9c3f, 0x9c40, 0x9d48,
  0x9d4c, 0x9f28, 0x9f51, 0x9f52, 0xa04c, 0xa123, 0x4ffd, 0xa124,
  0xa431, 0xa432, 0xa433, 0x3618, 0xa434, 0xa435, 0xa436, 0xa440,
  0xa437, 0x4ffd, 0xa438, 0xa43d, 0xa638, 0xa639, 0xa63a, 0xa63b,
  0xa63c, 0xa64c, 0xa773, 0xa774, 0x0c33, 0xa775, 0xa776, 0xa779,
  0xa941, 0xa942, 0xa943, 0xaa5b, 0x4ffd, 0x38d7, 0x88a6, 0xaa5c,
  0xaae5, 0xaae6, 0xaae7, 0xaae8, 0xaaed, 0xae30,
  /* 0x2d */
  0x3a7e, 0xae31, 0xaf94, 0xb351, 0xb3fd, 0xb3fe, 0xb4e9, 0x4ffd,
  0xb6b3, 0xb684, 0xb694, 0x4ffd, 0xb69c, 0x4ffd, 0xb685, 0xb900,
  0xb937, 0xb957, 0xbb54, 0xbb68, 0xbb55, 0xbb5c, 0xbb56, 0xbb57,
  0xbb58, 0xbb59, 0xbb5a, 0xbb5b, 0xc234, 0x3f7e, 0xc235, 0x4ffd,
  0xc239, 0xc236, 0xc237, 0xc238, 0xc5e5, 0xc659, 0x4ffd, 0xc63a,
  0xc63b, 0xcd28, 0xce89, 0x4ffd, 0xce8a, 0xce8b, 0xce8c, 0xce8d,
  0xcfbc, 0xd2a3, 0x1244, 0xd2a4, 0xd493, 0xd494, 0xd495, 0xd496,
  0xd497, 0xd6b9, 0xde4f, 0xde50, 0xde51, 0xe076, 0x4ffd, 0x50fb,
  0x5083, 0x5138, 0x515d, 0x5271, 0x4ffd, 0x5277, 0x5278, 0x4ffd,
  0x52c3, 0x5279, 0x527a, 0x527b, 0x527c, 0x5272, 0x527d, 0x52a0,
  0x527e, 0x527f, 0x5280, 0x5281, 0x5282, 0x5283, 0x529e, 0x5284,
  0x5285, 0x5286, 0x5287, 0x5288, 0x5493, 0x5494,
  /* 0x2e */
  0x5495, 0x54ef, 0x54f0, 0x4ffd, 0x558d, 0x558f, 0x5590, 0x5591,
  0x5592, 0x55de, 0x55e1, 0x5653, 0x1866, 0x574a, 0x574b, 0x574c,
  0x5751, 0x574d, 0x5748, 0x5874, 0x5875, 0x5920, 0x5921, 0x59a5,
  0x59a6, 0x5a73, 0x5a74, 0x5b50, 0x5b51, 0x5b52, 0x5b53, 0x5cdb,
  0x5cdc, 0x1b20, 0x5cdd, 0x5cde, 0x5cff, 0x4ffd, 0x4ffd, 0x5cdf,
  0x5ce0, 0x1b21, 0x5ce1, 0x5ce2, 0x5ce3, 0x5ce4, 0x5ce5, 0x5ce6,
  0x5ce7, 0x5ce8, 0x5ce9, 0x5cea, 0x6307, 0x6308, 0x6309, 0x630a,
  0x630b, 0x630c, 0x630d, 0x1dd7, 0x631a, 0x630e, 0x630f, 0x6310,
  0x631c, 0x6527, 0x6566, 0x6598, 0x6599, 0x6633, 0x6624, 0x6625,
  0x6626, 0x4ffd, 0x02e1, 0x673e, 0x4ffd, 0x673f, 0x6757, 0x6740,
  0x6741, 0x6758, 0x6742, 0x6743, 0x6744, 0x6745, 0x6746, 0x02e2,
  0x6747, 0x696b, 0x696c, 0x6a10, 0x6a11, 0x20be,
  /* 0x2f */
  0x6b75, 0x6bef, 0x6c6a, 0x6c6b, 0x4ffd, 0x6c6c, 0x6c6d, 0x6c6e,
  0x6def, 0x6df0, 0x6df1, 0x6df2, 0x6df3, 0x6df4, 0x6df5, 0x6dff,
  0x6df6, 0x6e02, 0x6df7, 0x7022, 0x70c4, 0x70c3, 0x7228, 0x047c,
  0x7320, 0x7325, 0x7322, 0x7323, 0x73eb, 0x04e3, 0x74f9, 0x74fa,
  0x7699, 0x769a, 0x769b, 0x7663, 0x4ffd, 0x765e, 0x765f, 0x7660,
  0x769c, 0x7661, 0x769d, 0x7b54, 0x7b55, 0x7b56, 0x7b57, 0x7b58,
  0x7b59, 0x7b5a, 0x7b19, 0x7b6a, 0x7b5b, 0x7b5c, 0x7b5d, 0x7b66,
  0x4ffd, 0x7b5e, 0x7b5f, 0x7b1a, 0x7b60, 0x7b61, 0x4ffd, 0x7b62,
  0x7b1b, 0x7b63, 0xb410, 0xb411, 0x804c, 0x809b, 0x80eb, 0x80ec,
  0x80ed, 0x80ee, 0x81a3, 0x81a8, 0x81a6, 0x06ec, 0x832f, 0x8330,
  0x8331, 0x8332, 0x8333, 0x844f, 0x8451, 0x8452, 0x847d, 0x8453,
  0x8454, 0x8455, 0x8456, 0x8457, 0x8458, 0x8459,
  /* 0x30 */
  0x845a, 0x845b, 0x845c, 0x2857, 0x845d, 0x845e, 0x845f, 0x846f,
  0x8460, 0x8461, 0x8462, 0x8463, 0x8472, 0x8464, 0x4ffd, 0x846e,
  0x88b5, 0x8b65, 0x8b66, 0x8b67, 0x8b68, 0x8b69, 0x8b6a, 0x8b6b,
  0x8b6c, 0x8d0e, 0x8d43, 0x4ffd, 0x8d0f, 0x8d44, 0x8d45, 0x8d46,
  0x8d47, 0x8d48, 0x8d49, 0x8d10, 0x8d4a, 0x8d4b, 0x8d4c, 0x8d4d,
  0x4ffd, 0x8d4e, 0x8d4f, 0x8d50, 0x8d51, 0x8d52, 0x8d53, 0x8d54,
  0x8d55, 0x8d56, 0x8d57, 0x8d58, 0x8d59, 0x8d5a, 0x8d1d, 0x8d5b,
  0x8d5c, 0x8d5d, 0x4ffd, 0x4ffd, 0x91fe, 0x91ff, 0x9200, 0x9201,
  0x9202, 0x9203, 0x9204, 0x9205, 0x9206, 0x9207, 0x9218, 0x9208,
  0x9209, 0x91f3, 0x920a, 0x920b, 0x921b, 0x920c, 0x920d, 0x920e,
  0x920f, 0x9210, 0x950f, 0x9561, 0x9579, 0x97c1, 0x97ac, 0x97ad,
  0x9943, 0x9944, 0x9945, 0x9946, 0x9947, 0x9948,
  /* 0x31 */
  0x9949, 0x9964, 0x994a, 0x994b, 0x994c, 0x994d, 0x4ffd, 0x4ffd,
  0x9b39, 0x9c57, 0x9c58, 0x9c59, 0x9c5f, 0x9c5a, 0x9d6a, 0x9f2b,
  0x9f5d, 0x9f5e, 0x9f5f, 0x4ffd, 0x9f60, 0x9f61, 0xa058, 0xa059,
  0xa14a, 0xa14b, 0xa14c, 0xa14d, 0xa14e, 0xa457, 0xa3b3, 0xa3b4,
  0xa46e, 0xa45b, 0xa45c, 0x4ffd, 0xa45d, 0xa45e, 0x4ffd, 0xa46c,
  0xa63d, 0xa654, 0xa63e, 0xa655, 0xa656, 0xa63f, 0xa657, 0xa658,
  0xa659, 0xa65a, 0xa65b, 0xa65c, 0xa788, 0xa789, 0x4ffd, 0xa958,
  0xa959, 0xa95a, 0x4ffd, 0xaa67, 0xaa68, 0xaa69, 0xaa6a, 0x4ffd,
  0xaa6b, 0xaa6c, 0xaafe, 0xaaff, 0xab00, 0xab01, 0xab02, 0xab03,
  0xab04, 0xab05, 0xae39, 0xae3a, 0xae3b, 0xae3c, 0x4ffd, 0x4ffd,
  0xafb2, 0xafb3, 0xafb4, 0xafb5, 0xafb6, 0xafb7, 0xafb8, 0x3c3c,
  0xb2a2, 0xb361, 0xb362, 0xb414, 0x4ffd, 0xb4eb,
  /* 0x32 */
  0xb542, 0xb548, 0x4ffd, 0xb543, 0xb54e, 0xb544, 0xb545, 0xb6b4,
  0xb6b5, 0x4ffd, 0x4ffd, 0x4ffd, 0xb6b6, 0x4ffd, 0xb8e1, 0xb905,
  0x4ffd, 0x3d73, 0xbb9a, 0x4ffd, 0xbb9b, 0xbb9c, 0xbb9d, 0xbb9e,
  0xbb9f, 0x4ffd, 0xbba0, 0xbba1, 0xbba2, 0xbbb5, 0xbba3, 0xbba4,
  0x4ffd, 0xbba5, 0xbba6, 0xbba7, 0xbba8, 0xbbaf, 0xbba9, 0xbbaa,
  0xbbab, 0xbbac, 0xbbad, 0xbbb3, 0x4ffd, 0xc1a0, 0xc256, 0xc634,
  0x1027, 0xc63c, 0xc80c, 0x4ffd, 0xcc3e, 0xcca3, 0xcd30, 0xcd31,
  0xce97, 0xce98, 0xce99, 0xce9a, 0xce9b, 0xd2b2, 0xd2ab, 0xd2ac,
  0xd6fc, 0xd6e8, 0xd6e9, 0xd6ea, 0xd7f1, 0xd93f, 0xdcce, 0xde6d,
  0xde6e, 0xde6f, 0xde70, 0xde71, 0xde72, 0xde73, 0x49be, 0xe078,
  0xe83a, 0x5167, 0x26fa, 0x5164, 0x5165, 0x5307, 0x52c4, 0x52c5,
  0x52c6, 0x52c7, 0x52c8, 0x52c9, 0x52e5, 0x52ca,
  /* 0x33 */
  0x52cb, 0x4ffd, 0x52cc, 0x52cd, 0x52ce, 0x52cf, 0x52d0, 0x5497,
  0x549a, 0x549b, 0x55ea, 0x55ec, 0x55ed, 0x55f7, 0x55ee, 0x55ef,
  0x565b, 0x565c, 0x565d, 0x576d, 0x576e, 0x4ffd, 0x576f, 0x5881,
  0x5882, 0x594f, 0x59ad, 0xd70a, 0x5a7e, 0x5b69, 0x5d54, 0x5d55,
  0x5d56, 0x5d57, 0x01ab, 0x5d58, 0x5d59, 0x5d5a, 0x5d5b, 0x5d5c,
  0x5d5d, 0x4ffd, 0x4ffd, 0x5d5e, 0x5d5f, 0x633b, 0x6336, 0x633c,
  0x633d, 0x633e, 0x633f, 0x6340, 0x6341, 0x6342, 0x024b, 0x6343,
  0x6344, 0x6345, 0x6337, 0x4ffd, 0x4ffd, 0x6346, 0x6347, 0x6348,
  0x6349, 0x652d, 0x65a5, 0x663d, 0x663f, 0x696e, 0x67e7, 0x6775,
  0x6776, 0x6777, 0x6778, 0x6779, 0x677a, 0x677b, 0x677c, 0x678e,
  0x677d, 0x677e, 0x1f72, 0x677f, 0x6780, 0x6781, 0x6782, 0x6783,
  0x6784, 0x6785, 0x6786, 0x6787, 0x6788, 0x6789,
  /* 0x34 */
  0x678a, 0x678b, 0x678c, 0x696f, 0x6970, 0x6971, 0x6972, 0x6a2a,
  0x6a2b, 0x6a2c, 0x6a2d, 0x6a2e, 0x6a2f, 0x6a30, 0x6a31, 0x6b83,
  0x6c84, 0x6c85, 0x6c93, 0x4ffd, 0x6c86, 0x6c87, 0x6c88, 0x6c89,
  0x6c8a, 0x6c8b, 0x6e36, 0x6e38, 0x6e39, 0x6e3a, 0x03e2, 0x6e3b,
  0x6e3c, 0x6e3d, 0x6e3e, 0x6e3f, 0x4ffd, 0x6e40, 0x6e41, 0x6e42,
  0x70de, 0x70df, 0x70e0, 0x70e1, 0x724a, 0x724b, 0x724c, 0x724d,
  0x724e, 0x724f, 0x7250, 0x7327, 0x73f9, 0x73fa, 0x73fb, 0x7498,
  0x7499, 0x749a, 0x4ffd, 0x751e, 0x769e, 0x76f7, 0x769f, 0x76a0,
  0x76f0, 0x76f8, 0x76f9, 0x76a1, 0x76a2, 0x76a3, 0x76a4, 0x76a5,
  0x76fa, 0x76fb, 0x76fc, 0x76fd, 0x76fe, 0x771f, 0x76ff, 0x7700,
  0x778c, 0x7701, 0x79c2, 0x79c3, 0x4ffd, 0x79d3, 0x7a4e, 0x7baf,
  0x7bb0, 0x7bb1, 0x7bb2, 0x7bb3, 0x7bc6, 0x7bb4,
  /* 0x35 */
  0x4ffd, 0x7bb5, 0x7bb6, 0x7bb7, 0x7bb8, 0x7bb9, 0x7bba, 0x7bbb,
  0x7bbc, 0x7bbd, 0x7bbe, 0x7bbf, 0x7bc1, 0x7bc0, 0x7bc2, 0x7bc3,
  0x7f51, 0x7f52, 0x7f53, 0x7f54, 0x7f55, 0x805a, 0x8050, 0x8051,
  0x8078, 0x80f8, 0x80f9, 0x81c6, 0x81cb, 0x81cc, 0x81cd, 0x81ce,
  0x81cf, 0x81d0, 0x81d1, 0x81d2, 0x81d3, 0x81d4, 0x81d5, 0x4ffd,
  0x8337, 0x8338, 0x8373, 0x8490, 0x8491, 0x84bf, 0x8492, 0x8493,
  0x8494, 0x8495, 0x8496, 0x8497, 0x8498, 0x8499, 0x28bd, 0x849a,
  0x849b, 0x849c, 0x849d, 0x849e, 0x849f, 0x84a0, 0x84a1, 0x84a2,
  0x84a3, 0x84a4, 0x84a5, 0x4ffd, 0x84a6, 0x84a7, 0x88bf, 0x88c0,
  0x88c1, 0x88c2, 0x88c3, 0x88c4, 0x88c5, 0x88c6, 0x8975, 0x8a43,
  0x8a12, 0x8a9f, 0x8a91, 0x4ffd, 0x8a92, 0x8a93, 0x8a94, 0x8b7e,
  0x8b7f, 0x8b80, 0x8b81, 0x8b82, 0x8c4c, 0x8c63,
  /* 0x36 */
  0x8dc0, 0x8dc1, 0x8dc2, 0x923a, 0x8dc3, 0x8dc4, 0x8dc5, 0x8dc6,
  0x2d15, 0x8dc7, 0x4ffd, 0x8dc8, 0x8d73, 0x8dc9, 0x8dca, 0x8dcb,
  0x8dcc, 0x8dcd, 0x4ffd, 0x4ffd, 0x4ffd, 0x8dce, 0x8dcf, 0x8dd0,
  0x8dd1, 0x8dd2, 0x8dd3, 0x8dd4, 0x8dd5, 0x923b, 0x923c, 0x923d,
  0x923e, 0x4ffd, 0x923f, 0x9240, 0x9241, 0x9242, 0x9243, 0x09c1,
  0x9244, 0x9245, 0x9259, 0x9246, 0x9247, 0x9248, 0x4ffd, 0x9249,
  0x9513, 0x9582, 0x9583, 0x9666, 0x9667, 0x9965, 0x3213, 0x9966,
  0x4ffd, 0x9975, 0x9974, 0x9967, 0x996d, 0x9976, 0x9968, 0x9969,
  0x996a, 0x996b, 0x994f, 0x996c, 0x9af8, 0x9b45, 0x32f8, 0x9b46,
  0x9be4, 0x9c85, 0x9c6f, 0x9c70, 0x9d82, 0x9d83, 0x9d84, 0x9d8b,
  0x9f2d, 0x9f68, 0x9f69, 0x9f77, 0x9f64, 0x9f6a, 0x4ffd, 0x9ff2,
  0x9fe2, 0xa063, 0xa064, 0xa065, 0xa066, 0x393d,
  /* 0x37 */
  0xa067, 0xa068, 0x34d8, 0x4ffd, 0xa172, 0xa17d, 0xa369, 0xa484,
  0xa486, 0xa487, 0xa488, 0xa49e, 0x4ffd, 0xa489, 0xa48a, 0xa496,
  0xa48b, 0xa48c, 0xa48d, 0xa679, 0xa683, 0xa67a, 0xa65d, 0xa67b,
  0x4ffd, 0xa79f, 0x4ffd, 0xa7a0, 0xa7a1, 0xa7a2, 0x37fc, 0xa96a,
  0xa96b, 0xa96c, 0xa96d, 0xa96e, 0xaa78, 0x4ffd, 0xaa79, 0xaa7c,
  0xab21, 0xab22, 0xab23, 0xab24, 0x3939, 0xab25, 0xab26, 0xae51,
  0xae52, 0xae56, 0x4ffd, 0x3b4b, 0xafe1, 0x4ffd, 0x4ffd, 0xafd6,
  0xafd7, 0xafd8, 0xafd9, 0xb2b5, 0xb36c, 0xb36f, 0xb370, 0xb4bc,
  0xb4bd, 0xb4ed, 0xb55b, 0xb55c, 0xb55d, 0xb55e, 0xb686, 0xb687,
  0xb6ed, 0x4ffd, 0xb6ee, 0x4ffd, 0xb90e, 0xb90f, 0x4ffd, 0xba2d,
  0xba2a, 0xba2e, 0xbacc, 0xbbf9, 0xbbfa, 0xbbfb, 0xbbfc, 0x3eb9,
  0xbbfd, 0xbc1b, 0xbbfe, 0xbbff, 0xbc00, 0xbc01,
  /* 0x38 */
  0xbc02, 0xbc03, 0xbc21, 0xbc04, 0xbc05, 0xbc06, 0xbc07, 0xbc08,
  0xbc09, 0xbc0a, 0xbc0b, 0xbc0c, 0xbc0d, 0xbc0e, 0xbc0f, 0xbc10,
  0xbc11, 0xbc12, 0xbc13, 0xbc14, 0xbc15, 0xc27b, 0xc27c, 0xc27d,
  0xc27e, 0x3fcf, 0xc27f, 0xc280, 0xc266, 0xc281, 0xc282, 0xc283,
  0xc5b2, 0x4ffd, 0xc67f, 0xc672, 0xc65a, 0xc7eb, 0xc815, 0x4ffd,
  0xc816, 0x4ffd, 0xc817, 0x4ffd, 0xc8c5, 0xc8c6, 0xc8c7, 0xc988,
  0xc989, 0x4ffd, 0xc98a, 0xc98b, 0xc98c, 0xc98d, 0xcbdf, 0x4ffd,
  0xcd3b, 0xcd3c, 0xcd3d, 0xcd3e, 0xcd3f, 0xcd40, 0xcd41, 0xcd42,
  0xce5c, 0xceaf, 0xcea9, 0xceaa, 0xceab, 0xceac, 0xceb5, 0xcead,
  0xceae, 0xcfe2, 0xd224, 0x42ae, 0xd2c4, 0x4ffd, 0xd4ea, 0xd4d3,
  0xd4d4, 0xd4d5, 0xd686, 0x4ffd, 0xd687, 0xd6fd, 0xd805, 0xd949,
  0xdc5f, 0xdcd3, 0xdcd5, 0xde8a, 0xde8b, 0xde8c,
  /* 0x39 */
  0xde8d, 0xde8e, 0xde8f, 0xde90, 0xde91, 0xde92, 0xde93, 0xe07d,
  0xe07e, 0x49eb, 0x4ffd, 0x4ffd, 0xe1ec, 0xe25b, 0xec87, 0xec86,
  0x4ffd, 0x5046, 0x5047, 0x5102, 0x516d, 0x516e, 0x516f, 0x530d,
  0x530e, 0x530f, 0x5310, 0x5311, 0x5312, 0x5313, 0x5314, 0x549f,
  0x54a0, 0x54a1, 0x54a3, 0x5521, 0x5522, 0x837c, 0x5595, 0x5596,
  0x5661, 0x5667, 0x5791, 0x5792, 0x5793, 0x5794, 0x588a, 0x588b,
  0x58f7, 0x5924, 0x59b0, 0x59b1, 0x5a8e, 0x5b04, 0x5b6a, 0x5b6b,
  0x5b6c, 0x5b6d, 0x5de8, 0x5e0c, 0x5de9, 0x5dea, 0x5e0d, 0x4ffd,
  0x5deb, 0x5dec, 0x5ded, 0x5dee, 0x5def, 0x5df0, 0x5df1, 0x5df2,
  0x5e16, 0x5df3, 0x5e04, 0x5e1d, 0x5df4, 0x5df5, 0x5df6, 0x5df7,
  0x1bb0, 0x6202, 0x6203, 0x6204, 0x639a, 0x637c, 0x63c5, 0x637d,
  0x637e, 0x637f, 0x6380, 0x6381, 0x1e40, 0x1e42,
  /* 0x3a */
  0x6382, 0x6383, 0x6384, 0x6385, 0x6386, 0x6387, 0x65ae, 0x664d,
  0x67b0, 0x67dc, 0x67b6, 0x67b7, 0x67b8, 0x67b9, 0x67ba, 0x67bb,
  0x67db, 0x67bc, 0x67bd, 0x67be, 0x4ffd, 0x67bf, 0x67c0, 0x67c1,
  0x67c2, 0x67c3, 0x67ce, 0x0301, 0x67d9, 0x67c4, 0x67c5, 0x67da,
  0x67c6, 0x67c7, 0x67c8, 0x67c9, 0x67ca, 0x697e, 0x697b, 0x6a4e,
  0x6a4f, 0x6a50, 0x6a51, 0x6a52, 0x6a53, 0x6a54, 0x6a55, 0x6b8f,
  0x6bfc, 0x6ca6, 0x6ca7, 0x6ca8, 0x6d23, 0x6e8b, 0x4ffd, 0x6e8c,
  0x6e8d, 0x6e8e, 0x6e8f, 0x6ea4, 0x5599, 0x7024, 0x7046, 0x7047,
  0x7048, 0x70fd, 0x70fe, 0x4ffd, 0x726e, 0x727c, 0x726f, 0x7270,
  0x7271, 0x7272, 0x7329, 0x732a, 0x735f, 0x74a2, 0x7530, 0x752b,
  0x7761, 0x7702, 0x7703, 0x7704, 0x7705, 0x7706, 0x7707, 0x4ffd,
  0x7708, 0x7709, 0x7762, 0x770a, 0x770b, 0x770c,
  /* 0x3b */
  0x770d, 0x770e, 0x7763, 0x7727, 0x770f, 0x4ffd, 0x771b, 0x7764,
  0x7710, 0x7711, 0x7781, 0x7712, 0x7765, 0x7713, 0x79ce, 0x7c29,
  0x7bc4, 0x7c2a, 0x4ffd, 0x7c2b, 0x7c2c, 0x7c2d, 0x7c2e, 0x7c2f,
  0x7c30, 0x7c31, 0x7c32, 0x7c33, 0x7c34, 0x4ffd, 0x7c35, 0x7c36,
  0x7be3, 0x7c37, 0x7c38, 0x7c39, 0x7c3a, 0x7c3b, 0x7c4d, 0x7c3c,
  0x7c3d, 0x7c3e, 0x4ffd, 0x7ed0, 0x7ed1, 0x8055, 0x8102, 0x8104,
  0x81fc, 0x8207, 0x81fd, 0x81fe, 0x4ffd, 0x81ff, 0x8200, 0x8208,
  0x8201, 0x8202, 0x8235, 0x8203, 0x8204, 0x4ffd, 0x833b, 0x8389,
  0x8381, 0x8382, 0xb733, 0x84eb, 0x84ec, 0x4ffd, 0x84ed, 0x84ee,
  0x84ef, 0x4ffd, 0x84f0, 0x84f1, 0x84f2, 0x292b, 0x84f3, 0x2916,
  0x84f4, 0x84f5, 0x504b, 0x84f6, 0x84f7, 0x84f8, 0x84f9, 0x84fa,
  0x84fb, 0x84fc, 0x84fd, 0x84fe, 0x84ff, 0x8500,
  /* 0x3c */
  0x291b, 0x8501, 0x8502, 0x8503, 0x8504, 0x8505, 0x8506, 0x8507,
  0x2927, 0x8508, 0x8509, 0x850a, 0x850b, 0x850c, 0x850d, 0x88d7,
  0x88d8, 0x8a29, 0x8a9c, 0x8af8, 0x8b98, 0x8ba4, 0x8b99, 0x8b9a,
  0x8b9b, 0x8b97, 0x8b9c, 0x2bf5, 0x8b9d, 0x4ffd, 0x8b9e, 0x8b9f,
  0x8c65, 0x8dd6, 0x0920, 0x8e32, 0x8e33, 0x8e34, 0x2d82, 0x8e35,
  0x8e36, 0x8e37, 0x8dd7, 0x4ffd, 0x8dd8, 0x8e38, 0x8e39, 0x8e3a,
  0x8e3b, 0x8e3c, 0x8e3d, 0x8e3e, 0x8e3f, 0x8e40, 0x8dd9, 0x8e41,
  0x8e42, 0x0921, 0x8e43, 0x8e44, 0x2d7a, 0x927c, 0x927d, 0x927e,
  0x927f, 0x9280, 0x9281, 0x9282, 0x4ffd, 0x9283, 0x9284, 0x9285,
  0x9286, 0x92a5, 0x9287, 0x9288, 0x9289, 0x928a, 0x928b, 0x928c,
  0x928d, 0x928e, 0x4ffd, 0x4ffd, 0x928f, 0x4ffd, 0x9290, 0x9291,
  0x9292, 0x9293, 0x9294, 0x9295, 0x4ffd, 0x3029,
  /* 0x3d */
  0x9296, 0x9556, 0x9557, 0x95e1, 0x960e, 0x960f, 0x967a, 0x967b,
  0x968b, 0x97f2, 0x97f3, 0x9993, 0x9994, 0x9995, 0x9996, 0x9997,
  0x99ad, 0x9998, 0x99ab, 0x997b, 0x9999, 0x999a, 0x999b, 0x9985,
  0x999c, 0x999d, 0x0ada, 0x4ffd, 0x99ac, 0x9979, 0x999e, 0x99a4,
  0x9afd, 0x9beb, 0x9bea, 0x9c8f, 0x9c90, 0x9c86, 0x9c87, 0x9c88,
  0x9dac, 0x9dad, 0x9fec, 0xa073, 0xa074, 0x4ffd, 0xa1aa, 0xa1ab,
  0xa1ac, 0xa3d1, 0xa3d7, 0xa4b9, 0xa4ba, 0xa4bb, 0xa4bc, 0xa68e,
  0xa68f, 0xa690, 0xa67c, 0xa691, 0xa692, 0xa693, 0xa694, 0x4ffd,
  0xa69a, 0xa695, 0xa696, 0xa697, 0xa7bd, 0xa7c7, 0xa7be, 0x4ffd,
  0xa7bf, 0x4ffd, 0xa993, 0x6a5e, 0xaa86, 0xaa87, 0xaa88, 0xaa89,
  0xab41, 0xab42, 0xab43, 0xab44, 0xab45, 0xab46, 0xab4a, 0xab47,
  0xab48, 0xab49, 0xae6b, 0xae66, 0x4ffd, 0xae67,
  /* 0x3e */
  0x3aab, 0xae68, 0x3aac, 0x4ffd, 0xaffd, 0xaffe, 0xafff, 0xb000,
  0xb001, 0xb002, 0xb003, 0xb004, 0xb005, 0xb006, 0xb233, 0xb2c2,
  0xb2d0, 0x4ffd, 0xb395, 0xb396, 0xb435, 0xb436, 0xb567, 0xb568,
  0xb569, 0xb56a, 0xb572, 0xb56b, 0xb56c, 0xb56d, 0xb56e, 0xb56f,
  0xb722, 0x4ffd, 0x4ffd, 0xb723, 0xb741, 0xb724, 0xb725, 0xb726,
  0xb727, 0xb728, 0xb729, 0xb6b7, 0x4ffd, 0x4ffd, 0x4ffd, 0xb9da,
  0xbacf, 0xbada, 0xbc89, 0xbcb7, 0xbc8a, 0xbc8b, 0xbd5e, 0xbc8c,
  0x4ffd, 0xbc8d, 0xbc8e, 0xbc8f, 0xbc90, 0xbc91, 0xbc92, 0xbc93,
  0xbc94, 0xbcb6, 0xbc95, 0xbc96, 0xbc97, 0x3ef7, 0x4ffd, 0xbc98,
  0xbc99, 0xbc9a, 0x0eea, 0x4ffd, 0xbc9b, 0xbcbd, 0xbc9c, 0xbc9d,
  0xbc9e, 0xbc9f, 0xbcc0, 0xbca0, 0xbca1, 0xbca2, 0xbca3, 0xbca4,
  0xbca5, 0xbca6, 0xbca7, 0xbca8, 0xbca9, 0xbcaa,
  /* 0x3f */
  0x4ffd, 0xc1b4, 0xc1b5, 0xc1b6, 0xc2b9, 0xc2ba, 0xc2bb, 0xc291,
  0xc2bc, 0xc5ee, 0xc5ef, 0xc696, 0xc697, 0xc673, 0xc698, 0xc699,
  0xc7ed, 0xc7ee, 0xc8de, 0xc9b0, 0xc9b1, 0xc9b2, 0xc9b3, 0xc9b4,
  0xc9b5, 0xc9b6, 0x4ffd, 0xc9b7, 0xcbe3, 0xccb9, 0xcd55, 0xcd7e,
  0xcd56, 0xcd57, 0xcd58, 0xcd59, 0xcd5a, 0x4ffd, 0xcec4, 0xcec5,
  0xcec6, 0xcec7, 0xcec8, 0xcec9, 0xceee, 0xcecf, 0xceca, 0xcecb,
  0xcecc, 0xd009, 0x4ffd, 0xd003, 0xd22f, 0xd230, 0xd231, 0xd232,
  0xd50e, 0xd50f, 0xd510, 0xd511, 0xd512, 0x4ffd, 0xd513, 0xd514,
  0xd515, 0xd4ff, 0xd71f, 0xd720, 0xd721, 0xd72d, 0x4ffd, 0xd81b,
  0xd81c, 0xd81d, 0xd81e, 0xd953, 0xd954, 0xd955, 0xd956, 0xd964,
  0xd959, 0xd957, 0x4ffd, 0xd958, 0xdc6b, 0x1389, 0x4ffd, 0xdce7,
  0xdce8, 0xdce9, 0xdcea, 0xdceb, 0xdcec, 0x4896,
  /* 0x40 */
  0xdced, 0xdeb1, 0xdeb4, 0x4ffd, 0xe08a, 0xe08d, 0xe08c, 0xe1f2,
  0xe1f3, 0x4ffd, 0x7108, 0xe417, 0x14b2, 0xe59f, 0xe6a0, 0x4ffd,
  0xe86d, 0x807d, 0xef90, 0xf5c4, 0x504c, 0x5174, 0x5175, 0x5176,
  0x5349, 0x534a, 0x534b, 0x534c, 0x534d, 0x534e, 0x534f, 0x5350,
  0x5351, 0x5352, 0x5353, 0x5354, 0x5355, 0x5356, 0x54a4, 0x54a9,
  0x552a, 0x552b, 0x57b3, 0x57c1, 0x5898, 0x58fb, 0x58fc, 0x59bc,
  0x5a96, 0x5b0a, 0x4ffd, 0x5ea2, 0x4ffd, 0x5e81, 0x5e82, 0x5e83,
  0x5e84, 0x5e85, 0x5e86, 0x5e87, 0x5e88, 0x5e89, 0x5e8a, 0x5e8b,
  0x5e8c, 0x1bf1, 0x5e8d, 0x5ed1, 0x6214, 0x63c9, 0x63ca, 0x63cb,
  0xeafd, 0x63cc, 0x63cd, 0x63ce, 0x63cf, 0x63d0, 0x63d1, 0x63d2,
  0x63d3, 0x63d4, 0x63d5, 0x6571, 0x504d, 0x6662, 0x680e, 0x67fe,
  0x67ff, 0x6800, 0x4ffd, 0x6801, 0x6802, 0x6803,
  /* 0x41 */
  0x6815, 0x6804, 0x6805, 0x4ffd, 0x6987, 0x6989, 0x6a6e, 0x6a6f,
  0x6a70, 0x6a71, 0x4ffd, 0x6a72, 0x6a73, 0x6a74, 0x6b9d, 0x6cb8,
  0x6cb9, 0x6cba, 0x6ec2, 0x6ec3, 0x6ed5, 0x6ec4, 0x6ec0, 0x6ec5,
  0x6ec6, 0x728a, 0x728b, 0x728c, 0x7364, 0xab8c, 0x2341, 0x740d,
  0x74a8, 0x753b, 0x753c, 0x753d, 0x753e, 0x753f, 0x7540, 0x7766,
  0x77cb, 0x77b7, 0x77b8, 0x77b9, 0x77ba, 0x7767, 0x77bb, 0x7768,
  0x7769, 0x776a, 0x77bc, 0x4ffd, 0x79db, 0x7c81, 0x7c82, 0x7c83,
  0x7c84, 0x7c85, 0x7c86, 0x7c87, 0x7c88, 0x7c89, 0x4ffd, 0x7c8a,
  0x7c8b, 0x4ffd, 0x7c8c, 0x7c8d, 0x7c8e, 0x7c8f, 0x7c90, 0x7ca1,
  0x7c91, 0x7ed6, 0x7f9f, 0x8058, 0x8085, 0x810b, 0x810c, 0x8237,
  0x8238, 0x4ffd, 0x8239, 0x823a, 0x823b, 0x823c, 0x823d, 0x823e,
  0x8240, 0x8241, 0x8242, 0x4ffd, 0x8243, 0x838a,
  /* 0x42 */
  0x838b, 0x8590, 0x8559, 0x855b, 0x855c, 0x855d, 0x855e, 0x298a,
  0x855f, 0x8560, 0x8561, 0x8562, 0x8563, 0x8564, 0x8593, 0x8565,
  0x8566, 0x8567, 0x8568, 0x8569, 0x856a, 0x856b, 0x8595, 0x856c,
  0x856d, 0x856e, 0x856f, 0x298c, 0x8570, 0x8571, 0x8572, 0x8573,
  0x8574, 0x8575, 0x8576, 0x8577, 0x8578, 0x8579, 0x2980, 0x857a,
  0x297f, 0x857b, 0x85a9, 0x857c, 0x88f1, 0x88eb, 0x898a, 0x8a3d,
  0x8aa6, 0x8aa7, 0x8bba, 0x4ffd, 0x8bbb, 0x8bbc, 0x8bbd, 0x8e91,
  0x8e92, 0x8e93, 0x8e94, 0x8e95, 0x8e96, 0x8e97, 0x8dda, 0x8e98,
  0x8e99, 0x8e9a, 0x4ffd, 0x4ffd, 0x8e9b, 0x8e9c, 0x8e9d, 0x8e9e,
  0x8e9f, 0x8ea0, 0x8ebf, 0x8ea1, 0x8ea2, 0x8ea3, 0x8ea4, 0x8ea5,
  0x8ea6, 0x8ea7, 0x8e5b, 0x4ffd, 0x8ea8, 0x92cb, 0x4ffd, 0x09da,
  0x92cc, 0x934f, 0x92cd, 0x92ce, 0x92cf, 0x934e,
  /* 0x43 */
  0x92d0, 0x92d1, 0x92d2, 0x4ffd, 0x92d3, 0x92d4, 0x92d5, 0x92d6,
  0x92d7, 0x92d8, 0x92d9, 0x92fa, 0x92da, 0x92db, 0x4ffd, 0x92dc,
  0x4ffd, 0x4ffd, 0x92dd, 0x92de, 0x92df, 0x92e0, 0x92e1, 0x92e2,
  0x92e3, 0x92e4, 0x92e5, 0x09db, 0x92e6, 0x92e7, 0x958e, 0x9698,
  0x9699, 0x4ffd, 0x980a, 0x4ffd, 0x9826, 0x9827, 0x99bd, 0x99df,
  0x0ae2, 0x99be, 0x99de, 0x99bf, 0x99c0, 0x99c1, 0x99c2, 0x999f,
  0x99c3, 0x99c4, 0x99c5, 0x99c6, 0x99c7, 0x0ae3, 0x99c8, 0x99c9,
  0x99e3, 0x99ca, 0x99cb, 0x99cc, 0x99cd, 0x99ce, 0x99cf, 0x99d0,
  0x99d1, 0x99d2, 0x99d3, 0x4ffd, 0x99d4, 0x9b04, 0x9b65, 0x9bee,
  0x9ca0, 0x9ca1, 0x9ddd, 0x9dde, 0x9f83, 0x9ffa, 0xa07f, 0xa080,
  0xa1e8, 0xa1e9, 0xa1ea, 0x85a6, 0xa3e1, 0x4ffd, 0xa4db, 0xa4dc,
  0xa4dd, 0xa4de, 0xa4df, 0xa4e0, 0xa4e1, 0xa4e2,
  /* 0x44 */
  0xa4e3, 0xa4e4, 0xa4e5, 0xa4e6, 0x369c, 0xa4e7, 0xa6b0, 0xa698,
  0xa6b1, 0xa699, 0xa6b2, 0xa6b3, 0xa6b4, 0xa6b5, 0xa6b6, 0xa6b7,
  0xa6b8, 0xa6b9, 0xa7e2, 0xa7e3, 0xa7e4, 0xa7e5, 0xa7e6, 0xa7e7,
  0xa7e8, 0xa7e9, 0xa9ad, 0xa9cf, 0xa9ae, 0xa9af, 0xa9b0, 0xa9b1,
  0xaa92, 0xaa93, 0xaa94, 0xab79, 0x397b, 0xab7a, 0xab7b, 0xab7c,
  0xab7d, 0xab7e, 0xab7f, 0xab80, 0xab81, 0xab82, 0xab83, 0xab84,
  0xae97, 0xae84, 0xae85, 0xae89, 0xae86, 0xae87, 0xb02c, 0xb02d,
  0xb02e, 0xb02f, 0xb030, 0xb031, 0xb032, 0xb033, 0xb034, 0xb035,
  0xb036, 0xb037, 0xb2d2, 0xb444, 0xb500, 0xb583, 0xb584, 0x4ffd,
  0xb77a, 0xb77b, 0xb77c, 0xb77d, 0xb77e, 0x4ffd, 0xb77f, 0xb787,
  0xb780, 0xba43, 0xbd34, 0x4ffd, 0xbd35, 0xbd36, 0xbd37, 0xbd38,
  0xbd39, 0xbd3a, 0xbd3b, 0xbd3c, 0xbd3d, 0xbd3e,
  /* 0x45 */
  0xbd3f, 0xbd40, 0xbd41, 0xbd42, 0xbd43, 0xbd44, 0xbd45, 0xbd46,
  0xbd47, 0xbd48, 0xbd49, 0xbd4a, 0x4ffd, 0xbd4b, 0xbd4c, 0xbd4d,
  0xbd4e, 0xc2e7, 0xc2e8, 0xc2e9, 0xc2ea, 0xc2eb, 0xc2ec, 0xc2ed,
  0xc2ee, 0xc5f7, 0xc69a, 0xc6cd, 0x4ffd, 0xc6a3, 0xc6ce, 0xc831,
  0xc832, 0xc833, 0xc9e4, 0x4ffd, 0xc9e5, 0xc9e6, 0xccc8, 0xcd74,
  0xcd75, 0xcd76, 0xcd77, 0xcd78, 0xcd79, 0xcd7a, 0xce61, 0xcedf,
  0xcee0, 0xcee1, 0xcee2, 0xcee3, 0xcee4, 0xcee5, 0xcee6, 0x11f3,
  0xd031, 0xd23d, 0xd23e, 0xd23f, 0xd2f4, 0xd2f5, 0xd2f6, 0x4ffd,
  0xd417, 0xd541, 0xd542, 0xd543, 0xd544, 0xd545, 0xd546, 0xd547,
  0xd548, 0xd549, 0xd54a, 0xd54b, 0x44d2, 0xd6ba, 0xd744, 0xd92a,
  0xd96d, 0x4ffd, 0x4ffd, 0xd97e, 0xd96e, 0xd96f, 0xd970, 0xd971,
  0xd976, 0xdc79, 0x48a0, 0x4ffd, 0xdd04, 0xdcf8,
  /* 0x46 */
  0xdd05, 0xdeda, 0xdedb, 0xdedc, 0xdedd, 0xdede, 0xdedf, 0xdee0,
  0xdee1, 0xe0c5, 0xe09a, 0xe09b, 0xe09c, 0xe1d8, 0xe1d9, 0xe1da,
  0xe26e, 0x1457, 0xe46b, 0xcd83, 0x4ffd, 0xe6d6, 0xe6bd, 0x4ffd,
  0x822e, 0xeafc, 0xed53, 0xedb7, 0xf28c, 0xf38e, 0xf2ff, 0x5076,
  0x5106, 0x517e, 0x5384, 0x5385, 0x5386, 0x5387, 0x5388, 0x53a7,
  0x5389, 0x538a, 0x538b, 0x538c, 0x538d, 0x538e, 0x538f, 0x53a3,
  0x5390, 0x5391, 0x5392, 0x5393, 0x53ac, 0x5394, 0x5395, 0x5396,
  0x54aa, 0x54ab, 0x559e, 0x17a9, 0x5608, 0x5609, 0x5668, 0x5669,
  0x566a, 0x569a, 0x57d9, 0x57da, 0x57db, 0x58a8, 0x5901, 0x5928,
  0x5977, 0x59bd, 0x59be, 0x5f60, 0x5aa0, 0x5aa2, 0x5b0f, 0x5b85,
  0x5efe, 0x5eff, 0x5f00, 0x5f01, 0x5f16, 0x5f02, 0x5f03, 0x5f04,
  0x5f05, 0x5f06, 0x5f07, 0x5f08, 0x5f22, 0x5f09,
  /* 0x47 */
  0x5f0a, 0x5f0b, 0x5f0c, 0x5f14, 0x5f29, 0x5e6e, 0x5f0d, 0x5f0e,
  0x5f0f, 0x5f10, 0x5f11, 0x5f12, 0x5f13, 0x621b, 0x621c, 0x621d,
  0x6413, 0x63ff, 0x6400, 0x6401, 0x6402, 0x6403, 0x6404, 0x640a,
  0x6405, 0x6406, 0x6407, 0x6408, 0x653a, 0x6573, 0x666f, 0x6670,
  0x6671, 0x5052, 0x4ffd, 0x6a9a, 0x6860, 0x4ffd, 0x682b, 0x6824,
  0x682c, 0x682d, 0x682e, 0x682f, 0x6830, 0x6831, 0x6832, 0x6833,
  0x6834, 0x6835, 0x6845, 0x6836, 0x6992, 0x6993, 0x6a88, 0x6a89,
  0x6a8a, 0x6a8b, 0x6b3f, 0x4ffd, 0x6cca, 0x6ef6, 0x6ef7, 0x6ef8,
  0x6ef9, 0x712b, 0x4ffd, 0x71a4, 0x71ce, 0x4ffd, 0x729e, 0x729f,
  0x72a0, 0x72a1, 0x72a2, 0x72a3, 0x72a4, 0x72a5, 0x72a6, 0x7418,
  0x7560, 0x7561, 0x7562, 0x7563, 0x7564, 0x77bd, 0x77be, 0x780b,
  0x77bf, 0x77c0, 0x4ffd, 0x780c, 0x778d, 0x780d,
  /* 0x48 */
  0x780e, 0x785e, 0x780f, 0x7810, 0x77c1, 0x7811, 0x4ffd, 0x77c2,
  0x79ea, 0x79eb, 0x7ce3, 0x7ce4, 0x7ce5, 0x7ce6, 0x7ce7, 0x7c92,
  0x7d4a, 0x4ffd, 0x7ce8, 0x7ce9, 0x7cea, 0x7d01, 0x7ceb, 0x7cec,
  0x7cef, 0x7ced, 0x7cee, 0x7cf0, 0x7cf1, 0x7cf2, 0x7cf3, 0x7cf4,
  0x7cf5, 0x7cf6, 0x7cf7, 0x7cf8, 0x7cf9, 0x7cfe, 0x7cfa, 0x7cfb,
  0x7cfc, 0x8263, 0x8264, 0x8265, 0x8266, 0x8267, 0x8268, 0x860b,
  0x860d, 0x07bc, 0x860e, 0x860f, 0x07a4, 0x8614, 0x85d4, 0x85d5,
  0x85d6, 0x85d7, 0x85d8, 0x85d9, 0x85da, 0x85db, 0x85dc, 0x85dd,
  0x85de, 0x85df, 0x85e0, 0x85e1, 0x85e2, 0x85e3, 0x85e4, 0x85e5,
  0x85e6, 0x85e7, 0x85e8, 0x85e9, 0x85ea, 0x85eb, 0x85ec, 0x86ec,
  0x85ed, 0x85ee, 0x85ef, 0x8600, 0x85f0, 0x8904, 0x4ffd, 0x8905,
  0x4ffd, 0x8ab5, 0x4ffd, 0x8bd6, 0x8bd7, 0x8bd8,
  /* 0x49 */
  0x8bd9, 0x8ea9, 0x8f00, 0x8f01, 0x8f02, 0x8f03, 0x8f04, 0x8f05,
  0x8f06, 0x8f3f, 0x8f07, 0x8f08, 0x8f09, 0x8f0a, 0x8eb6, 0x8f0b,
  0x8f0c, 0x4ffd, 0x4ffd, 0x8f0d, 0x4ffd, 0x8f0e, 0x8f0f, 0x8f10,
  0x8f11, 0x8f12, 0x8f35, 0x8f13, 0x8f14, 0x8eaa, 0x4ffd, 0x8fc1,
  0x8f15, 0x8f16, 0x8f17, 0x931e, 0x931f, 0x9320, 0x9321, 0x4ffd,
  0x9322, 0x9323, 0x3095, 0x9324, 0x9325, 0x9326, 0x9327, 0x9328,
  0x9329, 0x932a, 0x932b, 0x9307, 0x932c, 0x932d, 0x932e, 0x09e8,
  0x4ffd, 0x932f, 0x9330, 0x9348, 0x9331, 0x9332, 0x3098, 0x9333,
  0x4ffd, 0x9334, 0x9335, 0x9336, 0x9559, 0x9591, 0x95e7, 0x96b8,
  0x96b9, 0x96ba, 0x96bb, 0x96c8, 0x984d, 0x9889, 0x9850, 0x9828,
  0x99fb, 0x99fc, 0x99fd, 0x99fe, 0x99ff, 0x3278, 0x9a00, 0x9a01,
  0x9a02, 0x99e4, 0x99e5, 0x9a03, 0x9a04, 0x9a05,
  /* 0x4a */
  0x9a06, 0x9a07, 0x9a13, 0x9a08, 0x9a09, 0x99e6, 0x9a0a, 0x9a0b,
  0x9a0c, 0x9b0b, 0x9bf4, 0x9c0a, 0x9cb1, 0x9e1d, 0x4ffd, 0x9f8b,
  0x9f8c, 0x9f8f, 0x9f8d, 0x9f8e, 0xa006, 0xa086, 0xa222, 0xa223,
  0xa224, 0xa225, 0xa226, 0xa227, 0xa228, 0xa3f1, 0x36b9, 0xa523,
  0xa512, 0x4ffd, 0xa513, 0xa514, 0xa515, 0xa516, 0xa517, 0xa518,
  0xa519, 0xa54b, 0xa51a, 0xa51b, 0xa51c, 0x4ffd, 0xa51d, 0xa51e,
  0xa51f, 0xa520, 0xa6ca, 0x72ac, 0xa6cb, 0xa6cc, 0xa6cd, 0xa6ce,
  0x4ffd, 0xa6cf, 0xa810, 0xa811, 0xa812, 0xa813, 0xa814, 0xa80f,
  0xa815, 0xa816, 0xa817, 0x3833, 0xa818, 0xa9c6, 0xaa9f, 0xaaa0,
  0xaaa4, 0xaaa1, 0xabb5, 0xabb6, 0xabb7, 0xabb8, 0xabb9, 0xabba,
  0xabd0, 0xabc6, 0xabbb, 0xabbc, 0xabbd, 0xabbe, 0xabbf, 0xabc0,
  0xabc1, 0xabc2, 0x4ffd, 0xaea7, 0xaea8, 0xaea9,
  /* 0x4b */
  0xaeaa, 0xaeab, 0xaeac, 0xaebc, 0xaead, 0xaeae, 0x3ac0, 0xaeaf,
  0xaeb0, 0xaeb1, 0x3ac1, 0xaeb4, 0xaeb2, 0xb066, 0xb067, 0xb068,
  0xb069, 0xb06a, 0xb06b, 0xb06c, 0xb06d, 0xb06e, 0xb06f, 0x4ffd,
  0xb23e, 0xb23f, 0xb240, 0xb2e8, 0xb452, 0xb453, 0xb454, 0xb455,
  0xb591, 0xb592, 0xb593, 0xb594, 0xb595, 0xb596, 0xb597, 0xb598,
  0x4ffd, 0xb599, 0xb59a, 0xb59b, 0xb7b7, 0xb7b8, 0xb7b9, 0x4ffd,
  0xb7ba, 0xb7bb, 0xb7bd, 0x4ffd, 0xb7bc, 0x4ffd, 0x4ffd, 0xb8eb,
  0xb8ec, 0xb916, 0xb944, 0xb9e3, 0xba58, 0xba53, 0xba54, 0xbae0,
  0xbdb1, 0xbdb2, 0xbdb3, 0xbdea, 0x4ffd, 0xbdb4, 0xbdf0, 0xbdb5,
  0xbdb6, 0xbdb7, 0xbdb8, 0xbdb9, 0xbdba, 0xbdbb, 0xbdbc, 0xbdbd,
  0xbdbe, 0xbdbf, 0xbdc0, 0xbdc1, 0xbdc2, 0xbdc3, 0x4ffd, 0xbdc4,
  0xbdc5, 0xbdc6, 0xbdfc, 0xbdc7, 0xbdc8, 0xbdc9,
  /* 0x4c */
  0xbdca, 0xbdcb, 0xbdcc, 0xbe84, 0xbdcd, 0xbdce, 0xbdcf, 0xbdd0,
  0xbdd1, 0xbdd2, 0xc1ca, 0xc1cb, 0xc336, 0xc337, 0xc39f, 0xc338,
  0xc339, 0xc33a, 0x4044, 0xc6be, 0xc6f0, 0xc6bf, 0xc6c0, 0xc7f7,
  0xc7f8, 0xc7fa, 0xc843, 0xc844, 0xca0f, 0xca10, 0xca11, 0xca12,
  0x4ffd, 0xca13, 0xca14, 0xca15, 0xca16, 0x4ffd, 0x4ffd, 0xccd3,
  0xccd7, 0x4ffd, 0xcdb0, 0xcd98, 0xcd90, 0xcd91, 0xcd92, 0xcd97,
  0xcd93, 0xce64, 0xcf01, 0xcf02, 0xcf03, 0xcf04, 0xcf05, 0xcf06,
  0xcf07, 0xd05a, 0xd05b, 0xd24e, 0xd24f, 0xd250, 0xd319, 0xd31a,
  0xd31b, 0x4ffd, 0xd31c, 0x4ffd, 0xd419, 0xd41a, 0x1286, 0xd98a,
  0xd56e, 0xd56f, 0x4464, 0xd570, 0xd571, 0xd572, 0xd573, 0xd574,
  0xd575, 0xd576, 0xd83a, 0xd83b, 0xd83c, 0xd85a, 0xd83d, 0xd842,
  0xd98b, 0xd9a0, 0xd98c, 0xd98d, 0xd98e, 0xd9ab,
  /* 0x4d */
  0xd98f, 0x4577, 0xd990, 0xd991, 0xd992, 0xd9aa, 0x45af, 0xd993,
  0xd994, 0xd99e, 0xd9a8, 0x4ffd, 0x4ffd, 0xdf00, 0xdf01, 0xdf02,
  0xdf03, 0xdf04, 0xdf05, 0xdfc4, 0xdfc5, 0x4ffd, 0xe0ae, 0xe0b2,
  0x4ffd, 0x4ffd, 0xe1f7, 0xe213, 0xe39e, 0xe485, 0xa380, 0xe4c8,
  0xe841, 0xe881, 0xe882, 0xe883, 0xe884, 0xeac4, 0xeac5, 0xeac6,
  0xec95, 0xec96, 0xec97, 0xed58, 0xed59, 0x4ffd, 0xefa9, 0xefaa,
  0xefab, 0xf28e, 0xf303, 0xf3b3, 0x5b82, 0x5053, 0x5183, 0x5184,
  0x5185, 0x53cc, 0x53cd, 0x53ce, 0x53cf, 0x53d0, 0x4ffd, 0x53d1,
  0x53d2, 0x53da, 0x54b3, 0x54b4, 0x4ffd, 0x5613, 0x560e, 0x566b,
  0x5903, 0x5961, 0x59c1, 0x59c2, 0x5ab5, 0x5140, 0x5f98, 0x5f99,
  0x5f9a, 0x5f9b, 0x5f9c, 0x5f9d, 0x5f9e, 0x5f9f, 0x5fee, 0x5fa0,
  0x5fa1, 0x5f86, 0x6225, 0x6434, 0x6435, 0x6451,
  /* 0x4e */
  0x642d, 0x9362, 0x6454, 0x6452, 0x026d, 0x6436, 0x6437, 0x6438,
  0x6439, 0x643a, 0x643b, 0x6468, 0x643c, 0x026e, 0x6577, 0x8296,
  0x667e, 0x667f, 0x6869, 0x686a, 0x686b, 0x686c, 0x686d, 0x686e,
  0x686f, 0x685d, 0x6870, 0x6885, 0x6871, 0x6872, 0x6873, 0x6874,
  0x6875, 0x6876, 0x6884, 0x6877, 0x6883, 0x699a, 0x6aa7, 0x6aa8,
  0x6aa9, 0x6aaa, 0x6aab, 0x6aac, 0x6ab7, 0x6aad, 0x6aae, 0x4ffd,
  0x6b45, 0x6cd3, 0x6cd4, 0x6cd5, 0x6cd6, 0x6cd7, 0x6f26, 0x6f27,
  0x6f28, 0x4ffd, 0x6f29, 0x6f2a, 0x7005, 0x2264, 0x71d0, 0x72b7,
  0x4ffd, 0x72b8, 0x72b9, 0x7422, 0x7423, 0x7573, 0x7574, 0x788f,
  0x7812, 0x7813, 0x7814, 0x7815, 0x7816, 0x7817, 0x7818, 0x7861,
  0x7866, 0x7867, 0x7819, 0x7868, 0x781a, 0x7869, 0x7a04, 0x7a05,
  0x4ffd, 0x7a06, 0x79fd, 0x7d50, 0x7d51, 0x7d52,
  /* 0x4f */
  0x7d53, 0x7d54, 0x7d55, 0x7d63, 0x4ffd, 0x7d56, 0x7d57, 0x7d58,
  0x7d59, 0x7d5a, 0x7d5b, 0x4ffd, 0x7d5c, 0x7d5d, 0x7d5e, 0x7d5f,
  0x7fd7, 0x4ffd, 0x8060, 0x8061, 0x8117, 0x8139, 0x828f, 0x82c8,
  0x8290, 0x8291, 0x8398, 0x8399, 0x8644, 0x8645, 0x8646, 0x8659,
  0x86ee, 0x2a2b, 0x8647, 0x8648, 0x4ffd, 0x8649, 0x864a, 0x864b,
  0x864c, 0x864d, 0x864e, 0x864f, 0x8650, 0x8651, 0x8652, 0x8653,
  0x8654, 0x8655, 0x8656, 0x8915, 0x899a, 0x8a58, 0x8afc, 0x8afd,
  0x8f86, 0x8f87, 0x8f88, 0x8f89, 0x8f8a, 0x8f8b, 0x8f8c, 0x4ffd,
  0x901f, 0x8f8d, 0x8f8e, 0x8f8f, 0x8f90, 0x8f91, 0x8f92, 0x8f93,
  0x4ffd, 0x8f94, 0x8f95, 0x8eca, 0x8f18, 0x4ffd, 0x8f96, 0x8f97,
  0x8f98, 0x8f99, 0x8f9a, 0x8f9b, 0x8f9c, 0x8f9d, 0x8f9e, 0x8f9f,
  0x2e46, 0x4ffd, 0x8fa0, 0x8fa1, 0x2e9a, 0x8fb7,
  /* 0x50 */
  0x4ffd, 0x9396, 0x9368, 0x9369, 0x938c, 0x936a, 0x936b, 0x936c,
  0x936d, 0x936e, 0x936f, 0x937f, 0x9384, 0x9370, 0x9371, 0x9385,
  0x9372, 0x9373, 0x9374, 0x9375, 0x9376, 0x4ffd, 0x9377, 0x9378,
  0x9379, 0x937a, 0x937b, 0x937c, 0x4ffd, 0x9594, 0x96d5, 0x9829,
  0x9a2b, 0x9a2c, 0x9a2d, 0x9a2e, 0x9a2f, 0x9a30, 0x9a3e, 0x9a31,
  0x9a32, 0x9a33, 0x9a34, 0x9a35, 0x9b11, 0x0b53, 0x9cc0, 0x9e42,
  0x9e43, 0x9e44, 0x9e45, 0x9e46, 0xa08c, 0xa08d, 0xa08e, 0xa08f,
  0xa090, 0xa091, 0xa263, 0xa264, 0xa265, 0x4ffd, 0x4ffd, 0x4ffd,
  0xa3f6, 0xa536, 0xa537, 0xa52c, 0xa538, 0xa539, 0x4ffd, 0xa53a,
  0xa6e3, 0xa6e2, 0xa6f5, 0xa847, 0x4ffd, 0xa848, 0xa849, 0xa84a,
  0xa84b, 0xa84c, 0xaaa8, 0xaaa9, 0xaaaa, 0x4ffd, 0xac0b, 0xac06,
  0xac73, 0xac0c, 0xac0d, 0xac0e, 0xac0f, 0xac10,
  /* 0x51 */
  0x4ffd, 0xac11, 0x4ffd, 0xac12, 0xac14, 0xac15, 0xac16, 0x4ffd,
  0xac13, 0xac17, 0xaed9, 0xaeda, 0xaedb, 0x4ffd, 0xaedc, 0xb0a6,
  0xb0a7, 0xb0a8, 0xb0a9, 0xb0aa, 0xb0ab, 0x4ffd, 0x4ffd, 0xb0ac,
  0xb0ad, 0xb0ae, 0x4ffd, 0x4ffd, 0xb0af, 0xb0b0, 0xb0b1, 0xb244,
  0xb245, 0xb2f7, 0xb2f8, 0xb46b, 0xb46c, 0xb461, 0xb512, 0xb5af,
  0xb5b0, 0xb5b1, 0xb5b2, 0xb5b3, 0xb5b4, 0xb5b5, 0xb5b6, 0xb622,
  0xb7ea, 0xb7eb, 0xb7ec, 0xb7ed, 0x4ffd, 0xb8ed, 0xb91b, 0xb947,
  0xb9e8, 0xbad0, 0xbae7, 0xbae8, 0xbae9, 0xbe4e, 0xbe4f, 0xbe50,
  0xbe72, 0xbe51, 0xbe52, 0x4ffd, 0x0f26, 0xbe53, 0xbe54, 0xbe55,
  0xbe56, 0xbe57, 0xbe77, 0xbe58, 0xbe59, 0xbe5a, 0xbe5b, 0xbe5c,
  0xbe6e, 0xbe5d, 0x0f27, 0x4ffd, 0xbe5e, 0x0f28, 0xbe5f, 0x4ffd,
  0xc1d7, 0xc389, 0xc38a, 0x4ffd, 0x4ffd, 0xc38b,
  /* 0x52 */
  0xc38c, 0xc38d, 0xc38e, 0x4ffd, 0xc38f, 0x4ffd, 0xc39a, 0xc390,
  0xc391, 0xc392, 0xc393, 0xc712, 0xc6f1, 0x4ffd, 0xc7fe, 0xc7fb,
  0xc857, 0xca49, 0xca4a, 0xca4b, 0xca4c, 0x4ffd, 0xca4d, 0xca59,
  0xca4e, 0xca4f, 0xcbf4, 0xcc65, 0xcda6, 0xcda7, 0xcda8, 0xcf22,
  0xcf23, 0xd08b, 0xd08c, 0xd08d, 0xd08e, 0xd258, 0x4ffd, 0xd259,
  0xd33b, 0xd33c, 0xd33d, 0xd33e, 0xd448, 0xd594, 0xd595, 0xd596,
  0xd597, 0xd598, 0xd77d, 0xd6fe, 0xd77e, 0xd77f, 0x4ffd, 0xd85b,
  0xd85c, 0xd9e4, 0xd9c1, 0xd9fd, 0xd9c2, 0xd9d6, 0xd9c3, 0xd9c4,
  0x4ffd, 0xd9dc, 0xd9c5, 0xd9c6, 0xd9c7, 0xd9e1, 0xd9c8, 0xd9c9,
  0xd9ca, 0xd9cb, 0x45f2, 0xd9cc, 0xd9cd, 0xdd35, 0xdd36, 0xdd47,
  0xdd37, 0xdf1b, 0xdf1c, 0xdf1d, 0xdf1e, 0xdf1f, 0xdf20, 0xdf7b,
  0xdf7a, 0xdffe, 0xe0c6, 0xe0c7, 0xe0c8, 0xe0c9,
  /* 0x53 */
  0xe0ca, 0x4ffd, 0xe4a0, 0xe4a1, 0xe5cc, 0xe5cd, 0xe6f1, 0xe6d7,
  0xe842, 0xe846, 0xe8a3, 0xe8a5, 0xe8a6, 0xeacb, 0xeacc, 0xeb26,
  0xeb27, 0xeb28, 0xeb29, 0xecae, 0xecaf, 0xecb0, 0xed73, 0x4ffd,
  0xed7c, 0xed74, 0x4ffd, 0xef80, 0xed75, 0x4a79, 0x4ffd, 0xefcf,
  0x4ffd, 0xf38f, 0x5670, 0x5085, 0x5397, 0x53f6, 0x53f7, 0x53f8,
  0x53fa, 0x53fb, 0x54ba, 0x54bb, 0x54bc, 0x54bd, 0x5534, 0x5535,
  0x55a2, 0x5614, 0x5611, 0x566e, 0x566f, 0x5808, 0x58b8, 0x5a09,
  0x5abd, 0x5abe, 0x5b88, 0x5ffe, 0x1c7a, 0x5fff, 0x6000, 0x6001,
  0x6002, 0x6003, 0x6004, 0x6005, 0x6006, 0x4ffd, 0x6007, 0x6008,
  0x6009, 0x600a, 0x600b, 0x600c, 0x600d, 0x600e, 0x600f, 0x4ffd,
  0x4ffd, 0x4ffd, 0x622c, 0x646b, 0x4ffd, 0x646c, 0x6487, 0x646d,
  0x6578, 0x668b, 0x68a4, 0x68a5, 0x68a6, 0x68a7,
  /* 0x54 */
  0x68be, 0x68a8, 0x68a9, 0x68aa, 0x688d, 0x68ab, 0x68ac, 0x68bf,
  0x4ffd, 0x032c, 0x68ad, 0x68ae, 0x69a4, 0x69a5, 0x6ac7, 0x6ac8,
  0x6ac9, 0xcdbc, 0x6aca, 0x6acb, 0x6acc, 0x6acd, 0x6ace, 0x6c19,
  0x6ce6, 0x6f4c, 0x6f4d, 0x6f4e, 0x7006, 0x4ffd, 0x72cd, 0x72ce,
  0x72cf, 0x72d0, 0x235c, 0x7581, 0x7582, 0x5533, 0x786a, 0x786b,
  0x78b2, 0x786c, 0x786d, 0x78cc, 0x78ae, 0x78b3, 0x7891, 0x4ffd,
  0x786e, 0x78b4, 0x786f, 0x7dc9, 0x7da7, 0x7da8, 0x7da9, 0x7daa,
  0x7dab, 0x7dac, 0x7dad, 0x7dae, 0x7daf, 0x7db0, 0x7d60, 0x7db1,
  0x7ee1, 0x7fe3, 0x7ff6, 0x25d9, 0x82af, 0x82b0, 0x82b1, 0x82ba,
  0x82b2, 0x82b3, 0x834c, 0x4ffd, 0x83a0, 0x83a1, 0x86b0, 0x86b1,
  0x86b2, 0x86b3, 0x86b4, 0x4ffd, 0x86b5, 0x86b6, 0x86b7, 0x86b8,
  0x86b9, 0x86ba, 0x2a72, 0x86bb, 0x86bc, 0x86bd,
  /* 0x55 */
  0x86be, 0x86bf, 0x86df, 0x86c0, 0x86c1, 0x86c2, 0x86c3, 0x86c4,
  0x2a78, 0x4ffd, 0x86c5, 0x86c6, 0x86c7, 0x86c8, 0x86c9, 0x86ca,
  0x873c, 0x86cb, 0x86cc, 0x86cd, 0x86ce, 0x86cf, 0x86d0, 0x86d1,
  0x2b5a, 0x891d, 0x891e, 0x8a64, 0x8a65, 0x8ac5, 0x8ac6, 0x8ac7,
  0x8aff, 0x8bff, 0x8c00, 0x8c01, 0x8c02, 0x8ff5, 0x905c, 0x8ff6,
  0x8ff7, 0x8fb0, 0x8ff8, 0x8ff9, 0x905d, 0x9050, 0x8ffa, 0x8ffb,
  0x8fa2, 0x8ffc, 0x8ffd, 0x8ffe, 0x8fff, 0x4ffd, 0x9000, 0x4ffd,
  0x93c1, 0x93c2, 0x93c3, 0x93c4, 0x93c5, 0x93c6, 0x93c7, 0x93c8,
  0x93c9, 0x93ca, 0x93cb, 0xe0ef, 0x93d7, 0x93cc, 0x93cd, 0x93ce,
  0x9422, 0x93cf, 0x93d0, 0x4ffd, 0x93d1, 0x93d2, 0x93e9, 0x93d3,
  0x93d4, 0x93d5, 0x9538, 0x603b, 0x987d, 0x556f, 0x98a1, 0x9a53,
  0x9a54, 0x0afb, 0x9a55, 0x9a3c, 0x9a56, 0x4ffd,
  /* 0x56 */
  0x9a66, 0x0afc, 0x9a57, 0x9a58, 0x9a59, 0x9a5a, 0x9a5b, 0x9a67,
  0x9a5c, 0x4ffd, 0x4ffd, 0x9a6a, 0x9a5d, 0x9a3d, 0x9a5e, 0x9a65,
  0x9ce1, 0x9ccd, 0xf011, 0x9e6f, 0x9e70, 0xa01a, 0xa09a, 0xa09b,
  0xa09c, 0xa09e, 0xa09f, 0x4ffd, 0xa28e, 0x4ffd, 0xa3fd, 0x4ffd,
  0xa55e, 0xa55f, 0xa560, 0xa565, 0xa567, 0xa568, 0xa569, 0x4ffd,
  0xa56a, 0xa58f, 0xa56b, 0xa56c, 0xa56d, 0xa6f7, 0xa6f8, 0xa6f9,
  0xa6e4, 0xa6fa, 0xa8b1, 0xa875, 0xa876, 0xa9ff, 0xaa00, 0xaa01,
  0xaa02, 0xaa03, 0xaaae, 0xaaad, 0xac51, 0xac52, 0x4ffd, 0xac53,
  0xac54, 0xac55, 0xac56, 0xac57, 0xac58, 0xac59, 0xac5a, 0xac5b,
  0xac5c, 0xac5d, 0xac5e, 0xac5f, 0xac60, 0xac61, 0xac62, 0xac63,
  0xac64, 0xac4c, 0xac66, 0xaef1, 0xaef2, 0xb0f2, 0xb0f3, 0xb0f4,
  0xb0f5, 0xb0f6, 0xb0f7, 0xb0f8, 0xb0f9, 0xb0fa,
  /* 0x57 */
  0xb24c, 0xb24b, 0xb31b, 0xb3ce, 0xb3b3, 0xb47f, 0x4ffd, 0x4ffd,
  0xb51a, 0xb5c4, 0xb5c5, 0xb5c6, 0xb5c7, 0xb5c8, 0xb5c9, 0x4ffd,
  0xb819, 0xb81c, 0xb81a, 0xb94c, 0xb98e, 0xba7e, 0xbeeb, 0xbeec,
  0xbeed, 0xbeee, 0xbeef, 0xbef0, 0xbef1, 0xbed8, 0xbed9, 0xbeda,
  0xbedb, 0xbef2, 0xbef3, 0xbef4, 0xbf07, 0x4ffd, 0x4ffd, 0x4ffd,
  0xbef5, 0xbf15, 0x4ffd, 0xbef6, 0xbef7, 0xbef8, 0xbef9, 0xbefa,
  0xbefb, 0xbefc, 0xbefd, 0xbefe, 0xbfa7, 0xbeff, 0xbf00, 0xbf01,
  0xbf02, 0xbf03, 0xbf04, 0xbf05, 0xc1e9, 0xc1ea, 0xc1eb, 0xc3de,
  0xc3df, 0x4ffd, 0xc3e0, 0xc3e1, 0xc3e2, 0xc3e3, 0xc73e, 0xc73f,
  0xc740, 0xc741, 0xc871, 0xc872, 0xc873, 0xca88, 0xca89, 0xca8a,
  0xca8b, 0xca8c, 0xca8d, 0xca8e, 0xca8f, 0xca90, 0xca91, 0xca92,
  0x4ffd, 0xccf1, 0xcdbe, 0xcdbf, 0xcdc0, 0xcdc1,
  /* 0x58 */
  0xcdc2, 0xcdc3, 0xce6e, 0xcf37, 0xcf57, 0xcf38, 0xcf39, 0xcf3a,
  0xcf3b, 0xcf3c, 0xcf3d, 0xcf3e, 0xcf27, 0xcf3f, 0x4ffd, 0x4ffd,
  0xd0c0, 0xd0c1, 0x42be, 0xd267, 0x4ffd, 0xd268, 0xd358, 0xd365,
  0xd359, 0xd35a, 0xd424, 0xd5cd, 0xd5ce, 0xd5cf, 0xd5d2, 0xd79f,
  0xd722, 0xd87d, 0xd87e, 0xd9ff, 0xda25, 0xda00, 0xda01, 0x463b,
  0xda02, 0xda03, 0xda04, 0x4ffd, 0xda05, 0xda06, 0xda07, 0xda16,
  0xda08, 0xda17, 0xda09, 0xda0a, 0x4640, 0xda0b, 0xda0c, 0xda29,
  0x463a, 0xda0d, 0x4ffd, 0xda0e, 0xda10, 0xda11, 0xda1d, 0xda12,
  0xda13, 0x4ffd, 0xda14, 0xda15, 0xdc8d, 0xdd54, 0xdd55, 0xdd56,
  0xdf33, 0xdf34, 0xdf35, 0xdf36, 0xdffa, 0xe0e3, 0xe0e6, 0xe0ed,
  0xe0e7, 0xe0e8, 0xe0e9, 0xe0ea, 0xe0eb, 0xe227, 0xe220, 0x4ffd,
  0xe42a, 0xe4c9, 0x4ffd, 0xe4ca, 0xe4cb, 0xe4d9,
  /* 0x59 */
  0xe4cc, 0xe4cd, 0xe4ce, 0x4ffd, 0xe5e1, 0xe71b, 0xe71c, 0xe71d,
  0xe71e, 0xe847, 0xe8d1, 0xe8c9, 0xead0, 0xead1, 0xeb3f, 0xeb40,
  0xeb41, 0x4ffd, 0xeb42, 0xecc4, 0xed9b, 0xed92, 0xed93, 0x4a96,
  0xed94, 0xed95, 0x4ffd, 0x4ffd, 0xeff3, 0xeff4, 0xeff5, 0xeff6,
  0xf260, 0xf29e, 0xf2a0, 0xf2a1, 0xf31c, 0xf39f, 0x5056, 0x5412,
  0x541f, 0x5415, 0x5416, 0x5417, 0x4ffd, 0x5418, 0x54c2, 0x54c3,
  0x54c4, 0x55a1, 0x561b, 0x561c, 0x5671, 0x5813, 0x5b17, 0x5b8f,
  0x605f, 0x6060, 0x60ac, 0x4ffd, 0x4ffd, 0x6061, 0x6062, 0x6063,
  0x6064, 0x6065, 0x4ffd, 0x6499, 0x649a, 0x649b, 0x649c, 0x649d,
  0x649e, 0x649f, 0x64a0, 0x68da, 0x68db, 0x68dc, 0x68dd, 0x68de,
  0x68df, 0x6ad5, 0x6ad6, 0x6ad7, 0x6ad8, 0x6ae0, 0x6bb4, 0x4ffd,
  0x6f6e, 0x6f6f, 0x6f70, 0x7163, 0x4ffd, 0x72d5,
  /* 0x5a */
  0x72d6, 0x72d7, 0x72d8, 0x7430, 0x78b5, 0x78b6, 0x78c1, 0x78f7,
  0x05a0, 0x78cb, 0x78e8, 0x4ffd, 0x78e9, 0x78b7, 0x7a15, 0x7de6,
  0x7de7, 0x7de8, 0x7de9, 0x7dea, 0x7deb, 0x4ffd, 0x800b, 0x800c,
  0x8064, 0x82d4, 0x82d5, 0x82d6, 0x82d8, 0x83a5, 0x505b, 0x870f,
  0x8710, 0x4ffd, 0x8711, 0x8712, 0x8713, 0x8714, 0x8715, 0x8716,
  0x8717, 0x8718, 0x8719, 0x871a, 0x872f, 0x871b, 0x871c, 0x873f,
  0x871d, 0x871e, 0x872c, 0x871f, 0x8924, 0x89a4, 0x89a5, 0xb251,
  0x8afe, 0x8c11, 0x8c12, 0x8c13, 0x8c54, 0x905e, 0x9021, 0x903f,
  0x9040, 0x9041, 0x9042, 0x9043, 0x9044, 0x9020, 0x9045, 0x4ffd,
  0x9046, 0x90b0, 0x9047, 0x9057, 0x9001, 0x90b1, 0x905a, 0x9048,
  0x9404, 0x9405, 0x30f5, 0x944f, 0x9450, 0x9406, 0x9407, 0x9408,
  0x9409, 0x940a, 0x940b, 0x940c, 0x940d, 0x940e,
  /* 0x5b */
  0x940f, 0x9410, 0x9411, 0x9533, 0x9534, 0x9535, 0x95fc, 0x95fd,
  0x98b0, 0x98b1, 0x98b2, 0x98b3, 0x0b01, 0x9a7b, 0x9a7c, 0x9a7d,
  0x9a7e, 0x9a7f, 0x9a80, 0x9a81, 0x9a82, 0x9bf9, 0x9cda, 0x9ea1,
  0x4ffd, 0x4ffd, 0xa0ad, 0xa0ae, 0x4ffd, 0xa2c8, 0xa2c9, 0xa2ca,
  0xa582, 0xa583, 0xa584, 0xa585, 0xa586, 0xa587, 0xa588, 0xa589,
  0xa58a, 0x4ffd, 0xa707, 0xa708, 0xa701, 0xa709, 0xa702, 0xa70a,
  0xa70b, 0xa70c, 0xa8a7, 0xa898, 0xa899, 0xa89a, 0xa89b, 0xa89c,
  0x3850, 0xa89d, 0xaa1a, 0xaab2, 0xacb0, 0xacb1, 0x4ffd, 0xacb2,
  0xacb3, 0xacb4, 0xacb5, 0xacb6, 0xacc0, 0xacb7, 0xacb8, 0xacb9,
  0xacba, 0xad1d, 0xaf0c, 0xaf0d, 0xaf0e, 0xaf35, 0xaf0f, 0xaf10,
  0xaf11, 0xaf12, 0xb122, 0xb123, 0xb124, 0x4ffd, 0xb125, 0xb126,
  0xb127, 0xb128, 0xb129, 0xb12a, 0xb12b, 0xb12c,
  /* 0x5c */
  0xb12d, 0xb12e, 0xb252, 0xb253, 0xb319, 0xb3bf, 0xb48b, 0xb48c,
  0xb523, 0xb524, 0xb5f1, 0xb5d8, 0x4ffd, 0xb84e, 0xb84f, 0xb855,
  0xb850, 0xb851, 0xb852, 0xb853, 0xb802, 0xb854, 0xb8f1, 0xb924,
  0xbad1, 0xbf7c, 0xbf7d, 0xbf7e, 0xbf7f, 0xbf80, 0xbf9f, 0xbf81,
  0xbf82, 0xbf83, 0xbf84, 0xbf85, 0xbf86, 0xbf87, 0xbf88, 0xbf9b,
  0xbf89, 0xbf8a, 0xbf8b, 0xbf8c, 0x4ffd, 0xbfa1, 0xbf8d, 0xbf8e,
  0xc1f3, 0xc1f4, 0xc1f5, 0xc424, 0xc425, 0xc426, 0xc427, 0xc428,
  0xc429, 0xc42a, 0x4ffd, 0xc42b, 0xc5cd, 0xc601, 0x758d, 0xc770,
  0xc880, 0xc881, 0xcac0, 0xcac1, 0xcac2, 0xcac3, 0xcac4, 0xcac5,
  0xcac6, 0xcac7, 0xcac8, 0xccfe, 0x4ffd, 0xcdd9, 0xcddc, 0xcdda,
  0xce75, 0xcf58, 0xcf59, 0xcf5a, 0xcf5b, 0xcf5c, 0xd0ec, 0x121a,
  0xd0f3, 0xd272, 0xd273, 0xd382, 0xd383, 0xd42a,
  /* 0x5d */
  0xd42b, 0xd42c, 0xd42d, 0xd5f6, 0xd600, 0xd5f7, 0xd5f8, 0xd5f9,
  0x4ffd, 0xd894, 0xd895, 0xd896, 0xd91b, 0xda86, 0xda4c, 0xda4d,
  0xda83, 0x4ffd, 0xda82, 0xda4e, 0xda4f, 0xda50, 0xda51, 0xda81,
  0x4687, 0xda52, 0xda53, 0xda54, 0xda55, 0x4ffd, 0xda56, 0xda57,
  0x4685, 0xda58, 0xda5b, 0xda5c, 0xda5d, 0xda5e, 0xda5f, 0xda60,
  0xda61, 0xda7c, 0xda62, 0x133c, 0x4ffd, 0xda63, 0xda64, 0xdd73,
  0xdf45, 0xdf46, 0xdf47, 0xdf4c, 0xe012, 0x4ffd, 0xe013, 0xe139,
  0xe103, 0xe10d, 0xe230, 0xe2d5, 0xe3c0, 0xe4f2, 0xe4f3, 0xe4f4,
  0xe4f5, 0xe4f6, 0xe4f7, 0xe5fa, 0xe5fb, 0xe745, 0xe746, 0xe849,
  0xe8e7, 0xe8e8, 0xead8, 0xead9, 0xeb55, 0xeb56, 0xeb57, 0xecda,
  0xecdb, 0xecdc, 0xedb8, 0xedb9, 0xedba, 0x4ab1, 0xedbb, 0xef89,
  0xedbc, 0xf030, 0xf031, 0xf032, 0xf033, 0x4ffd,
  /* 0x5e */
  0xf034, 0xf035, 0xf036, 0x4c47, 0xf037, 0xf2b2, 0xf390, 0xf326,
  0xf3a2, 0xf438, 0x4ffd, 0x542e, 0x4ffd, 0x542f, 0x5430, 0x542a,
  0x542b, 0x54c9, 0x5537, 0x5620, 0x5672, 0x581f, 0x5965, 0x59ca,
  0x5ac0, 0x5ac1, 0x5ac2, 0x60b7, 0x60b8, 0x60b9, 0x60ba, 0x60bb,
  0x4ffd, 0x4ffd, 0x60bc, 0x60bd, 0x60be, 0x60f2, 0x64b5, 0x64b7,
  0x64b8, 0x60df, 0x64b9, 0x64d5, 0x64ba, 0x64bb, 0x654a, 0x68f2,
  0x68f3, 0x68f4, 0x68fa, 0x68f5, 0x6902, 0x6ae2, 0x6ae3, 0x6f8e,
  0x6f8b, 0x72e4, 0x72eb, 0x72e5, 0x7435, 0x7593, 0x78ea, 0x78eb,
  0x4ffd, 0x78ec, 0x78ed, 0x7917, 0x78ee, 0x78ef, 0x78f0, 0x7e0e,
  0x7e0f, 0x7e10, 0x7e19, 0x7e18, 0x7e11, 0x7e12, 0x7e13, 0x4ffd,
  0x7e14, 0x7e15, 0x066b, 0x7e16, 0x8065, 0x82ea, 0x82eb, 0x82ec,
  0x82ed, 0x4ffd, 0x82ee, 0x83ac, 0x87c2, 0x8769,
  /* 0x5f */
  0x8781, 0x876a, 0x876b, 0x876c, 0x876d, 0x876e, 0x876f, 0x8770,
  0x4ffd, 0x8771, 0x8772, 0x8773, 0x878c, 0x8774, 0x8775, 0x8776,
  0x8c24, 0x8c2a, 0x908e, 0x90af, 0x908f, 0x9090, 0x9091, 0x4ffd,
  0x9092, 0x9093, 0x9094, 0x9095, 0x9096, 0x9097, 0x9098, 0x9099,
  0x909a, 0x909b, 0x909c, 0x9439, 0x943b, 0x943a, 0x943c, 0x943d,
  0x943e, 0x943f, 0x9470, 0x9440, 0x9441, 0x98c0, 0x98c1, 0x9aa4,
  0x9a97, 0x9aa5, 0x9a98, 0x9a99, 0x9a9a, 0x4ffd, 0x9a9b, 0x9aa6,
  0x9a9c, 0x9a9d, 0x9a9e, 0x9a9f, 0xdace, 0x9ac8, 0x9aa0, 0x9b19,
  0x9c0d, 0xa0bf, 0xa2e9, 0xa2ea, 0xa5a2, 0xa5a3, 0xa5a4, 0xa5a5,
  0xa5a6, 0xa715, 0xa717, 0xa8bf, 0xa8c0, 0xa8c1, 0xa8c2, 0xa8c3,
  0xa8c4, 0xa8c5, 0x690d, 0xaa23, 0xaabe, 0xad03, 0xad04, 0xad05,
  0xad06, 0xad07, 0xad08, 0xad09, 0xad0a, 0xad0b,
  /* 0x60 */
  0xad0c, 0xad20, 0xad0d, 0xad0e, 0xad0f, 0x4ffd, 0xaf26, 0xaf27,
  0xaf28, 0xb15d, 0xb15e, 0xb15f, 0xb160, 0xb161, 0xb162, 0xb163,
  0xb164, 0xb165, 0xb257, 0xb3cf, 0xb3d0, 0xb499, 0xb49a, 0xb5ea,
  0xb5eb, 0xb5ec, 0xb87e, 0xb87f, 0xb880, 0x4ffd, 0x4ffd, 0xb881,
  0xb882, 0xb8f3, 0xb925, 0xb99f, 0xb9a0, 0xb9f3, 0xba00, 0xbfeb,
  0xbfec, 0xbfed, 0xbfee, 0xbfef, 0x4ffd, 0x0f5c, 0xbff0, 0xbff1,
  0xbff2, 0xbff3, 0xbff4, 0xbff5, 0xbff9, 0xbffa, 0xbffb, 0xbffc,
  0xbffd, 0xbffe, 0xbfff, 0xc000, 0x4ffd, 0xc001, 0xc002, 0xc203,
  0xc486, 0xc479, 0x4ffd, 0xc47a, 0xc47b, 0xc47c, 0xc484, 0xc47d,
  0xc47e, 0xc47f, 0xc786, 0xc787, 0xc800, 0xc801, 0xc888, 0xc889,
  0xc88a, 0xcaf5, 0x4ffd, 0xcb25, 0xcaf6, 0xcdeb, 0xcdec, 0xcded,
  0xcdee, 0x1187, 0xcdef, 0xcdf0, 0xcf6c, 0xd121,
  /* 0x61 */
  0xd122, 0xd123, 0xd124, 0xd125, 0xd126, 0xd27b, 0xd27c, 0xd391,
  0xd392, 0xd393, 0xd60e, 0xd60f, 0xd610, 0xd8b3, 0xd936, 0xdac6,
  0xdaa1, 0xdaa2, 0x46b9, 0xdaa3, 0xdacc, 0xdaa4, 0xdaa5, 0xdaa6,
  0xdacb, 0xdaa7, 0x4ffd, 0xdaa8, 0xdaa9, 0xdaaa, 0x4ffd, 0xdaab,
  0xdaac, 0xdaad, 0x46bf, 0xdaae, 0xdaaf, 0xdab0, 0xdd8c, 0xdd8d,
  0xdd8e, 0x4ffd, 0xdd92, 0xdd8f, 0xdf52, 0xdf53, 0xdf54, 0xdf55,
  0xe129, 0x4ffd, 0xe2f3, 0xe2f4, 0xe50d, 0xe50e, 0xe50f, 0xe510,
  0xe614, 0xe771, 0xe772, 0xe90f, 0xe904, 0xe906, 0x4ffd, 0xe907,
  0xeadc, 0xeadd, 0xeb6d, 0xeb79, 0xeb6e, 0x4ffd, 0xecec, 0xeddd,
  0xedde, 0xeddf, 0xede0, 0xede1, 0xede2, 0xede3, 0xede4, 0xee3a,
  0xede5, 0x4acf, 0xede6, 0xf06b, 0xf06c, 0x944e, 0x4c64, 0xf2bd,
  0xf2be, 0xf2bf, 0xf334, 0x4dbf, 0xf512, 0x5440,
  /* 0x62 */
  0x5441, 0x6102, 0x6103, 0x6104, 0x6105, 0x6106, 0x64d7, 0x64cc,
  0x6698, 0x6906, 0x6907, 0x69af, 0x69b0, 0x6aea, 0x6af2, 0x6fa2,
  0x6fa3, 0x6fa4, 0x7176, 0x72f5, 0x72f6, 0x72f7, 0x4ffd, 0x793b,
  0x7925, 0x793a, 0x793c, 0x793d, 0x793e, 0x7e37, 0x7e38, 0x7e39,
  0x7e3a, 0x7e3b, 0x7e3c, 0x7e3d, 0x7e3e, 0x7e3f, 0x7e4b, 0x4ffd,
  0x7e40, 0x8022, 0x8067, 0x80d3, 0x82fa, 0x4ffd, 0x87bc, 0x4ffd,
  0x4ffd, 0x87a5, 0x0807, 0x87b6, 0x4ffd, 0x87a6, 0x87bb, 0x87a7,
  0x87a8, 0x87a9, 0x87aa, 0x87ab, 0x87ac, 0x87bf, 0x87ad, 0x87ae,
  0x87af, 0x892e, 0x8b00, 0x909d, 0x909e, 0x90cb, 0x90cc, 0x90cd,
  0x90ce, 0x90cf, 0x4ffd, 0x909f, 0x90d0, 0x90d1, 0x90d2, 0x90d3,
  0x90d4, 0x4ffd, 0x4ffd, 0x945d, 0x945e, 0x945f, 0x9460, 0x0b05,
  0x9aba, 0x9abc, 0x4ffd, 0x9ab5, 0x9abd, 0x9ab6,
  /* 0x63 */
  0x9ab7, 0x9ab8, 0x9aa8, 0x4ffd, 0x9bfe, 0x9bfc, 0x9ee1, 0xa0c4,
  0xa0c5, 0xa314, 0xa5ae, 0xa5af, 0xa5b0, 0xa5b1, 0xa5b9, 0xa8e7,
  0xad46, 0x4ffd, 0xad47, 0xad48, 0xad49, 0xad1e, 0xad1f, 0xad4a,
  0xad4b, 0xad4c, 0xad4d, 0xad4e, 0x4ffd, 0xaf46, 0xaf4b, 0xb190,
  0xb191, 0x4ffd, 0xb192, 0xb193, 0xb194, 0xb25b, 0xb5f2, 0xb5f8,
  0xb5f9, 0xb894, 0xb8a4, 0xb897, 0xb898, 0xb929, 0xb9ae, 0xbaaf,
  0xc059, 0xc05a, 0x4ffd, 0xc05b, 0xc05c, 0xc05d, 0xc05e, 0xc05f,
  0xc060, 0xc061, 0xbfaa, 0xc062, 0xc063, 0xc064, 0xc065, 0xc066,
  0xc067, 0xc068, 0xc069, 0xc06a, 0xc06b, 0xc06c, 0xc06d, 0xc06e,
  0xc06f, 0x4ffd, 0xc4b2, 0xc4b3, 0xc4b4, 0x0ff9, 0xc4b5, 0xc4b6,
  0xc4b7, 0xc4b8, 0xc4b9, 0xc4ba, 0xc4bb, 0xc788, 0x41b8, 0xcb19,
  0xcb1a, 0xcb1b, 0xcc16, 0xce0c, 0xce0d, 0xce0e,
  /* 0x64 */
  0xce0f, 0x4ffd, 0xcf83, 0xcf84, 0xcf85, 0xd283, 0xd284, 0xd3b0,
  0x4ffd, 0xd626, 0xd627, 0xd636, 0xd628, 0xd629, 0x4ffd, 0x4ffd,
  0xdae7, 0xdae8, 0xdae9, 0x1353, 0xdaea, 0xdaeb, 0x4ffd, 0xdaec,
  0xdaed, 0xdaee, 0xdaef, 0xdaf0, 0xdaf1, 0xdb0c, 0xdaf2, 0xdaf3,
  0xdaf4, 0xdaf5, 0xdaf6, 0xdaf7, 0xdaf8, 0xdda3, 0xdda4, 0xdda5,
  0xdda6, 0xdda7, 0x4ffd, 0xdf5c, 0x4ffd, 0xe14b, 0xe1e1, 0xe315,
  0x4ffd, 0xe316, 0xe317, 0xe52c, 0xe52d, 0xe622, 0xe623, 0xe796,
  0xe797, 0x4ffd, 0xe92e, 0xe930, 0xe931, 0x4ffd, 0xeadf, 0xeb8b,
  0xeb8c, 0x4ffd, 0xeb8d, 0xecfc, 0xecfd, 0xecfe, 0xecff, 0xee17,
  0xee2d, 0xee18, 0x4af3, 0xee19, 0x4ffd, 0xee12, 0xee1a, 0xee1b,
  0xee1c, 0x1569, 0x4ffd, 0xf097, 0x4ffd, 0xf098, 0xf099, 0x4ffd,
  0xf3c4, 0x544f, 0x54cd, 0x5ac7, 0x611c, 0x611d,
  /* 0x65 */
  0x611e, 0x64e7, 0x64e9, 0x64ea, 0x64eb, 0x6915, 0x6cf1, 0x6cf2,
  0x6fb6, 0x75a0, 0x794a, 0x7a20, 0x7e60, 0x7e61, 0x7e41, 0x7e62,
  0x8303, 0x8304, 0x87d9, 0x87da, 0x87db, 0x87dc, 0x87dd, 0x4ffd,
  0x87de, 0x87df, 0x87e0, 0x87e1, 0x87e2, 0x0812, 0x87e3, 0x4ffd,
  0x8c31, 0x9105, 0x9106, 0x9107, 0x9472, 0x948a, 0x948b, 0x9488,
  0x4ffd, 0x948c, 0x948d, 0x948e, 0x948f, 0x9490, 0x9542, 0x9543,
  0x4ffd, 0x9ac1, 0x9ac2, 0x9ac3, 0x9ac4, 0xa0cb, 0xa322, 0x4ffd,
  0x4ffd, 0xa5c3, 0xa5c4, 0xa5c5, 0xa5c6, 0xa71e, 0xa725, 0xa8f3,
  0xa8f4, 0x4ffd, 0xa8f5, 0xaa38, 0xaa48, 0xaaca, 0x3a4f, 0xad7a,
  0xad7b, 0xaf55, 0xaf56, 0xb1b1, 0xb1b2, 0xb1b3, 0x4ffd, 0xb1b4,
  0xb1b5, 0xb4a4, 0xb600, 0xb601, 0xb602, 0xb8ac, 0x4ffd, 0xb9b3,
  0xc0b6, 0xc0b7, 0xc0b8, 0xc0b9, 0xc0ba, 0xc0bb,
  /* 0x66 */
  0xc0bc, 0xc0bd, 0xc0be, 0xc0bf, 0xc0c0, 0xc0c1, 0xc0c2, 0xc0c3,
  0xc0c4, 0xc0c5, 0xc0c6, 0xc0c7, 0xc4e3, 0xc4e4, 0xc4e5, 0xc4e6,
  0xc4e7, 0x4ffd, 0xc7b5, 0xc7a1, 0xc895, 0xcb3b, 0xcb3c, 0xcb3d,
  0xcb3e, 0xcc14, 0xce20, 0xce21, 0xce22, 0xce23, 0xce24, 0xcf96,
  0xcf97, 0xcf98, 0xd194, 0xd195, 0xd196, 0xd197, 0xd198, 0xd28f,
  0xd290, 0xd3bc, 0xd43b, 0xd63d, 0x4ffd, 0xd8df, 0xd91e, 0xdb23,
  0xdb24, 0xdb49, 0xdb25, 0xdb26, 0xdb27, 0xdb28, 0x4725, 0xdb29,
  0xdb2a, 0xdb2e, 0xdb2f, 0xdb4e, 0xdb30, 0x4ffd, 0xdb31, 0xdb32,
  0xdb33, 0xdb34, 0xdb35, 0xdb36, 0x4ffd, 0xdb37, 0xdb50, 0xdb38,
  0x4ffd, 0xdb39, 0xdb3a, 0xdb3b, 0xdb3c, 0xdb3d, 0xdb3e, 0xddb8,
  0xddb9, 0xdf62, 0xdf63, 0xe041, 0xe16d, 0x4ffd, 0xe352, 0xe337,
  0xe3db, 0xe53f, 0xe634, 0xe85b, 0xe946, 0xe95a,
  /* 0x67 */
  0xe95b, 0xeae1, 0xeae2, 0xeae3, 0xeae4, 0xeba7, 0xeba8, 0xeba9,
  0xed0f, 0xed2b, 0xee56, 0xee57, 0xee58, 0xee5e, 0xee59, 0xee5a,
  0xee5b, 0xee5c, 0x4ffd, 0xee68, 0x4ffd, 0xf12c, 0xf0e2, 0xf0f3,
  0xf2d2, 0xf356, 0xf3ce, 0xf461, 0xf69b, 0xf6b4, 0x545c, 0x4ffd,
  0x54d2, 0x5571, 0x5673, 0x582c, 0x5b94, 0x4ffd, 0x613f, 0x6140,
  0x64f9, 0x64fa, 0x64fd, 0x64fb, 0x691c, 0x691d, 0x6aff, 0x6b00,
  0x6cf7, 0x9cfe, 0x4ffd, 0x74b6, 0x7954, 0x7e77, 0x7e79, 0x7e7a,
  0x7e7b, 0x8069, 0x8802, 0x8803, 0x8804, 0x8805, 0x8806, 0x8807,
  0x8808, 0x8809, 0x880a, 0x880b, 0x8835, 0x4ffd, 0x8c39, 0x911e,
  0x911f, 0x9120, 0x9121, 0x4ffd, 0x9122, 0x9123, 0x9124, 0x912c,
  0x94b3, 0x94b5, 0x94b6, 0x94b7, 0x94b8, 0x9ad0, 0x9cfa, 0x9f07,
  0x9fbd, 0xa0d7, 0xa0d2, 0xa5db, 0xa5d6, 0x545d,
  /* 0x68 */
  0xaa43, 0xaacf, 0xada3, 0xada4, 0xada5, 0xada6, 0xada7, 0xada8,
  0xada9, 0xaf5d, 0xaf5e, 0xb1c9, 0xb1ca, 0xb1cb, 0xb1cc, 0xb606,
  0xb607, 0x4ffd, 0xb8c5, 0xb8f5, 0xb9b4, 0xb9b8, 0xb9b5, 0xc0fd,
  0x4ffd, 0xc0fe, 0xc0ff, 0xc100, 0xc101, 0xc102, 0xc103, 0xc109,
  0xc104, 0xc105, 0xc106, 0xc107, 0xc511, 0xc512, 0xc513, 0xc514,
  0xc515, 0x4ffd, 0xc898, 0xc899, 0xce3c, 0xce2d, 0xce2e, 0x4ffd,
  0xd1bb, 0xd1bc, 0x1278, 0xd43d, 0xd647, 0xd648, 0xd649, 0xd64a,
  0xd7e1, 0xd7e7, 0xd8eb, 0xd920, 0xd938, 0xdb62, 0xdb67, 0xdb68,
  0xdb69, 0xdb6a, 0xdb6b, 0xdb6d, 0xdb6e, 0xdb6f, 0xdb70, 0xdb71,
  0xdb72, 0xdb8f, 0xdb73, 0xdb74, 0xdb75, 0xdb76, 0xdb77, 0xddc9,
  0xddca, 0x48e6, 0xddcb, 0xddcc, 0xddcd, 0xe051, 0x4ffd, 0x4ffd,
  0xe245, 0xe559, 0xe55a, 0xe55b, 0xe640, 0xe7cf,
  /* 0x69 */
  0xe85e, 0xe97b, 0xea93, 0xebbc, 0xed16, 0xed30, 0x4ffd, 0xee8d,
  0xee8e, 0x4b2f, 0xee8f, 0xee90, 0xee91, 0xee92, 0xee93, 0xee94,
  0xee95, 0xee96, 0xf123, 0xf114, 0xf2db, 0xf40a, 0xf5ce, 0x5466,
  0x5468, 0x5467, 0x54d3, 0x6163, 0x6504, 0x669e, 0x6926, 0x692a,
  0x796c, 0x7964, 0x7e8f, 0x7e90, 0x8034, 0x830e, 0x8825, 0x8826,
  0x8827, 0x4ffd, 0x8828, 0x2b0c, 0x4ffd, 0x8829, 0x882a, 0x882b,
  0x882c, 0x8c3e, 0x9142, 0x9143, 0x9133, 0x94c1, 0x94c2, 0x94c3,
  0x9ad6, 0x9ad7, 0xa5e1, 0xa5e2, 0xa72b, 0xaad1, 0xadcc, 0xadcd,
  0xadce, 0xadcf, 0xb1de, 0xb1df, 0xb1e0, 0xb1e1, 0xb8f6, 0xc12c,
  0x4ffd, 0xc154, 0xc12d, 0xc12e, 0xc541, 0xc542, 0xc7c7, 0xc8a0,
  0xc8a1, 0xcb70, 0xcb71, 0xcb72, 0x4ffd, 0xce34, 0xce35, 0xce36,
  0xcfa6, 0xd1cc, 0x4ffd, 0xd299, 0xd8f4, 0xdb9b,
  /* 0x6a */
  0xdb9e, 0xdb9f, 0xdba0, 0xdba1, 0xdba2, 0xdba3, 0xdba4, 0xdba5,
  0xdba6, 0xdba7, 0xdba8, 0xdddb, 0xdddc, 0xdddd, 0xddd7, 0xddde,
  0xdddf, 0xe059, 0xe446, 0xe565, 0xe649, 0x4ffd, 0xe7dd, 0xe995,
  0xe996, 0xe997, 0xebd4, 0xebd6, 0xed26, 0x4b47, 0x1588, 0xeec8,
  0xeec5, 0xeec6, 0xeec7, 0xf151, 0xf152, 0xf153, 0xf154, 0xf155,
  0xf2de, 0x4ffd, 0x546d, 0x54d5, 0x6172, 0x71ae, 0x730f, 0x796b,
  0x796d, 0x796e, 0x7978, 0x7e98, 0x7e99, 0x7e9a, 0x8844, 0x885c,
  0x8845, 0x8b01, 0x9158, 0x9159, 0x915a, 0x4ffd, 0x94d9, 0x94d6,
  0x9ada, 0x9adf, 0x9adb, 0x9d03, 0xa5ef, 0x3736, 0xa733, 0xaad2,
  0xade1, 0xaf6f, 0xb264, 0xb60e, 0xc150, 0xc151, 0xc152, 0xc556,
  0xc557, 0xc558, 0x4ffd, 0xcb81, 0xcb82, 0xcc1d, 0xcc1e, 0xce43,
  0xcfaa, 0xd8fd, 0x4ffd, 0xdbc6, 0xdbc7, 0xdbd9,
  /* 0x6b */
  0xdbd7, 0x4ffd, 0xdbc8, 0xdbc9, 0xdbca, 0xdbcb, 0xdbda, 0x4ffd,
  0xdbcc, 0xdbcd, 0xdbce, 0xdbcf, 0xdbd0, 0xdbd1, 0xdbbc, 0xdde1,
  0xdde2, 0xdde3, 0xe1a9, 0xe24e, 0xe577, 0x4ffd, 0x4ffd, 0xe9ac,
  0xe9ad, 0xeab6, 0xebe5, 0xeef8, 0xeeea, 0xef8d, 0xeeeb, 0xf195,
  0x546e, 0x54d8, 0x6183, 0x66a3, 0x6930, 0x6b0f, 0x7979, 0x797a,
  0x7ea7, 0x7ea8, 0x7ea9, 0x7eaa, 0x8319, 0x8850, 0x8851, 0x8852,
  0x2b15, 0x8868, 0x8853, 0x8854, 0x98e2, 0x9adc, 0xa915, 0xa916,
  0xaa4f, 0xadf5, 0xadf6, 0xadf7, 0xb1f4, 0xb4cc, 0xb60f, 0xc166,
  0xc167, 0x4ffd, 0xc168, 0xc8a4, 0xcb8b, 0xcb8c, 0xd1fa, 0xdbe6,
  0xdbed, 0xdbee, 0xdbef, 0xdbf0, 0xdbfe, 0xdde7, 0xdde8, 0xe1b3,
  0xe1e4, 0xe583, 0xeaec, 0x4ffd, 0xef16, 0x4ffd, 0x4ffd, 0xef17,
  0xf1c3, 0xf1ac, 0xf2ed, 0x4ffd, 0x4ffd, 0xf5b4,
  /* 0x6c */
  0x4ffd, 0x618a, 0x618b, 0x6934, 0x6b14, 0x6fdf, 0x74bb, 0x797f,
  0x7981, 0x7ead, 0x7eae, 0x8862, 0x886e, 0x4ffd, 0x916e, 0x4ffd,
  0x9717, 0x9ae6, 0x9c10, 0xa919, 0x4ffd, 0xb610, 0xbaf2, 0xc176,
  0xc177, 0xcb95, 0xcb96, 0xdc00, 0xdc01, 0xdc31, 0x4ffd, 0xdc1c,
  0xe06d, 0xebf4, 0xebf5, 0xed3d, 0xef32, 0xef33, 0xf2f4, 0x4ffd,
  0x5473, 0x6937, 0x4ffd, 0x8871, 0xae0f, 0x4ffd, 0xae0e, 0xb611,
  0xc185, 0xdc14, 0xdc15, 0xdc16, 0xdc17, 0xdc18, 0xdc19, 0xdc1a,
  0xe1c3, 0xef42, 0xef43, 0xef44, 0xef48, 0xf1fb, 0x66a5, 0x69b8,
  0x7eb2, 0x803d, 0x8872, 0x94e7, 0x94e8, 0xa359, 0xa73a, 0xae14,
  0xb1ff, 0xb9c0, 0xc18d, 0x0f84, 0xc18e, 0x4ffd, 0xdc22, 0x4ffd,
  0x4ffd, 0xec04, 0xec29, 0xef51, 0xef66, 0xf20e, 0x4ffd, 0x4ffd,
  0x619b, 0x619c, 0x7316, 0x7986, 0x7987, 0x4ffd,
  /* 0x6d */
  0xdc2c, 0xdc30, 0xdc28, 0xe65f, 0x4ffd, 0x917e, 0xae19, 0xd20a,
  0xdc36, 0xddfc, 0xef6d, 0xef6e, 0xf6c6, 0x19b5, 0x887b, 0xb206,
  0xc59f, 0xf232, 0xd20d, 0x798b, 0xdc3b, 0x4ffd, 0xf23d, 0xdc3c,
  0xdc3d,
};

static const ucs4_t cns11643_15_2uni_upages[247] = {
  0x03400, 0x03500, 0x03600, 0x03700, 0x03800, 0x03900, 0x03a00, 0x03b00,
  0x03c00, 0x03d00, 0x03e00, 0x03f00, 0x04100, 0x04300, 0x04400, 0x04500,
  0x04600, 0x04700, 0x04800, 0x04900, 0x04a00, 0x04c00, 0x04f00, 0x05100,
  0x05200, 0x05300, 0x05400, 0x05500, 0x05600, 0x05700, 0x05800, 0x05a00,
  0x05b00, 0x05c00, 0x05e00, 0x05f00, 0x06200, 0x06500, 0x06600, 0x06700,
  0x06800, 0x06900, 0x06a00, 0x06b00, 0x06c00, 0x06e00, 0x06f00, 0x07000,
  0x07100, 0x07300, 0x07400, 0x07500, 0x07600, 0x07700, 0x07800, 0x07900,
  0x07a00, 0x07b00, 0x07c00, 0x07d00, 0x07f00, 0x08200, 0x08300, 0x08600,
  0x08700, 0x08900, 0x08e00, 0x08f00, 0x09000, 0x09200, 0x09300, 0x09400,
  0x09500, 0x09600, 0x09b00, 0x09c00, 0x09d00, 0x09e00, 0x09f00, 0x0ff00,
  0x20000, 0x20100, 0x20200, 0x20300, 0x20400, 0x20500, 0x20600, 0x20700,
  0x20800, 0x20900, 0x20a00, 0x20b00, 0x20c00, 0x20d00, 0x20e00, 0x20f00,
  0x21000, 0x21100, 0x21200, 0x21300, 0x21400, 0x21500, 0x21600, 0x21700,
  0x21800, 0x21900, 0x21a00, 0x21b00, 0x21c00, 0x21d00, 0x21e00, 0x21f00,
  0x22000, 0x22100, 0x22200, 0x22300, 0x22400, 0x22500, 0x22600, 0x22700,
  0x22800, 0x22900, 0x22a00, 0x22b00, 0x22c00, 0x22d00, 0x22e00, 0x22f00,
  0x23000, 0x23100, 0x23200, 0x23300, 0x23400, 0x23500, 0x23600, 0x23700,
  0x23800, 0x23900, 0x23a00, 0x23b00, 0x23c00, 0x23d00, 0x23e00, 0x23f00,
  0x24000, 0x24100, 0x24200, 0x24300, 0x24400, 0x24500, 0x24600, 0x24700,
  0x24800, 0x24900, 0x24a00, 0x24b00, 0x24c00, 0x24d00, 0x24e00, 0x24f00,
  0x25000, 0x25100, 0x25200, 0x25300, 0x25400, 0x25500, 0x25600, 0x25700,
  0x25800, 0x25900, 0x25a00, 0x25b00, 0x25c00, 0x25d00, 0x25e00, 0x25f00,
  0x26000, 0x26100, 0x26200, 0x26300, 0x26400, 0x26500, 0x26600, 0x26700,
  0x26800, 0x26900, 0x26a00, 0x26b00, 0x26c00, 0x26d00, 0x26e00, 0x26f00,
  0x27000, 0x27100, 0x27200, 0x27300, 0x27400, 0x27500, 0x27600, 0x27700,
  0x27800, 0x27900, 0x27a00, 0x27b00, 0x27c00, 0x27d00, 0x27e00, 0x27f00,
  0x28000, 0x28100, 0x28200, 0x28300, 0x28400, 0x28500, 0x28600, 0x28700,
  0x28800, 0x28900, 0x28a00, 0x28b00, 0x28c00, 0x28d00, 0x28e00, 0x28f00,
  0x29000, 0x29100, 0x29200, 0x29300, 0x29400, 0x29500, 0x29600, 0x29700,
  0x29800, 0x29900, 0x29a00, 0x29b00, 0x29c00, 0x29d00, 0x29e00, 0x29f00,
  0x2a000, 0x2a100, 0x2a200, 0x2a300, 0x2a400, 0x2a500, 0x2a600,
};

static int
cns11643_15_mbtowc (conv_t conv, ucs4_t *pwc, const unsigned char *s, int n)
{
  unsigned char c1 = s[0];
  if ((c1 >= 0x21 && c1 <= 0x6d)) {
    if (n >= 2) {
      unsigned char c2 = s[1];
      if (c2 >= 0x21 && c2 < 0x7f) {
        unsigned int i = 94 * (c1 - 0x21) + (c2 - 0x21);
        ucs4_t wc = 0xfffd;
        unsigned short swc;
        {
          if (i < 7169)
            swc = cns11643_15_2uni_page21[i],
            wc = cns11643_15_2uni_upages[swc>>8] | (swc & 0xff);
        }
        if (wc != 0xfffd) {
          *pwc = wc;
          return 2;
        }
      }
      return RET_ILSEQ;
    }
    return RET_TOOFEW(0);
  }
  return RET_ILSEQ;
}

