// Copyright (C) 2001 Free Software Foundation, Inc.
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without Pred the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// 25.2.12 [lib.alg.partitions] Partitions.

#include <algorithm>
#include <testsuite_hooks.h>

bool test __attribute__((unused)) = true;

const int A[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
const int N = sizeof(A) / sizeof(int);

// copy
void
test01()
{
    using std::copy;

    int s1[N];
    copy(A, A + N, s1);
    VERIFY(std::equal(s1, s1 + N, A));
}

// copy_backward
void
test02()
{
    using std::copy_backward;

    int s1[N];
    copy_backward(A, A + N, s1 + N);
    VERIFY(std::equal(s1, s1 + N, A));
}

int
main()
{
  test01();
  test02();

  return 0;
}
