/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.jce.prng;

import gnu.crypto.prng.LimitReachedException;
import gnu.crypto.prng.MDGenerator;
import java.security.SecureRandomSpi;
import java.util.HashMap;

abstract class SecureRandomAdapter
extends SecureRandomSpi {
    private MDGenerator adaptee;
    private String mdName;

    private /* synthetic */ void finit$() {
        this.adaptee = new MDGenerator();
    }

    protected SecureRandomAdapter(String mdName) {
        this.finit$();
        this.mdName = mdName;
    }

    public byte[] engineGenerateSeed(int numBytes) {
        if (numBytes < 1) {
            return new byte[0];
        }
        byte[] result = new byte[numBytes];
        this.engineNextBytes(result);
        return result;
    }

    public void engineNextBytes(byte[] bytes) {
        if (!this.adaptee.isInitialised()) {
            this.engineSetSeed(new byte[0]);
        }
        try {
            this.adaptee.nextBytes(bytes, 0, bytes.length);
        }
        catch (LimitReachedException limitReachedException) {
            // empty catch block
        }
    }

    public void engineSetSeed(byte[] seed) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("gnu.crypto.prng.md.hash.name", this.mdName);
        attributes.put("gnu.crypto.prng.md.seed", seed);
        this.adaptee.init(attributes);
    }
}

