/* 
 *    Programmed By: Mohammed Isam Mohammed [mohammed_isam1984@yahoo.com]
 *    Copyright 2018 (c)
 * 
 *    file: module_sh.c
 *    This file is part of mino.
 *
 *    mino is free software: you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation, either version 3 of the License, or
 *    (at your option) any later version.
 *
 *    mino is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with mino.  If not, see <http://www.gnu.org/licenses/>.
 */    
#include "modules.h"

char *ext_asm[] = { "asm", "ASM" };
char *keyword_asm[] = {
      //x86 assembly instructions
      "AAA",
      "AAD",
      "AAM",
      "AAS",
      "AAC",
      "ADD",
      "AND",
      "CALL",
      "CBW",
      "CLC",
      "CLD",
      "CLI",
      "CMC",
      "CMPSB",
      "CMPSW",
      "CWD",
      "DAA",
      "DAS",
      "DEC",
      "DIV",
      "ESC",
      "HLT",
      "IDIV",
      "IMUL",
      "INC",
      "INTO",
      "INT",
      "INS",
      "IN",
      "IRET",
      "JCC",
      "JCXZ",
      "JMP",
      "LAHF",
      "LDS",
      "LEA",
      "LES",
      "LOCK",
      "LODSB",
      "LODSW",
      "LOOPNE",
      "LOOPNZ",
      "LOOPE",
      "LOOPZ",
      "LOOPW",
      "LOOPD",
      "LOOP",
      "MOVSB",
      "MOVSW",
      "MOVSD",
      "MOVSX",
      "MOVZX",
      "MOVNTDQ",
      "MOVNTI",
      "MOVNTPD",
      "MOVSXD",
      "MOV",
      "MUL",
      "NEG",
      "NOP",
      "NOT",
      "OR",
      "OUTSD",
      "OUT",
      "POPFQ",
      "PUSHFQ",
      "POPAD",
      "POPA",
      "PUSHAD",
      "PUSHFD",
      "PUSHA",
      "POPFD",
      "POPF",
      "POP",
      "PUSHF",
      "PUSH",
      "RCL",
      "RCR",
      "REPE",
      "PERNE",
      "REPNZ",
      "REPZ",
      "REP",
      "RETN",
      "RETF",
      "RET",
      "ROL",
      "ROR",
      "SAHF",
      "SAL",
      "SAR",
      "SBB",
      "SCASD",
      "SHLD",
      "SHRD",
      "STOSD",
      "SCASB",
      "SCASW",
      "SHL",
      "SHR",
      "STC",
      "STD",
      "STI",
      "SCASQ",
      "STOSQ",
      "STOSB",
      "STOSW",
      "SUB",
      "TEST",
      "WAIT",
      "XCHG",
      "XLAT",
      "XOR",
      "BOUND",
      "ENTER",
      "LEAVE",
      "OUTS",
      "ARPL",
      "CLTS",
      "LAR",
      "LGDT",
      "LIDT",
      "LLDT",
      "LMSW",
      "LOADALL",
      "LSL",
      "LTR",
      "SGDT",
      "SIDT",
      "SLDT",
      "SMSW",
      "STR",
      "VERR",
      "VERW",
      "BSF",
      "BSR",
      "BTC",
      "BTR",
      "BTS",
      "BT",
      "CDQ",
      "CMPSD",
      "CWDE",
      "INSD",
      "JECXZ",
      "LFS",
      "LGS",
      "LSS",
      "SETAE",
      "SETA",
      "SETBE",
      "SETB",
      "SETC",
      "SETE",
      "SETGE",
      "SETG",
      "SETLE",
      "SETL",
      "SETNAE",
      "SETNA",
      "SETNBE",
      "SETNB",
      "SETNC",
      "SETNE",
      "SETNGE",
      "SETNG",
      "SETNLE",
      "SETNL",
      "SETNO",
      "SETNP",
      "SETNS",
      "SETNZ",
      "SETO",
      "SETPE",
      "SETPO",
      "SETP",
      "SETS",
      "SETZ",
      "BSWAP",
      "CMPXCHG",
      "INVD",
      "INVLPG",
      "WBINVD",
      "XADD",
      "CPUID",
      "CMPXCHG8B",
      "RDMSR",
      "RDTSC",
      "WRMSR",
      "RSM",
      "RDPMC",
      "SYSCALL",
      "SYSRET",
      "CMOVAE",
      "CMOVA",
      "CMOVBE",
      "CMOVB",
      "CMOVCE",
      "CMOVC",
      "CMOVGE",
      "CMOVG",
      "CMOVLE",
      "CMOVL",
      "CMOVNAE",
      "CMOVNA",
      "CMOVNBE",
      "CMOVNB",
      "CMOVNC",
      "CMOVNE",
      "CMOVNGE",
      "CMOVNG",
      "CMOVNLE",
      "CMOVNL",
      "CMOVNO",
      "CMOVNP",
      "CMOVNS",
      "CMOVNZ",
      "CMOVO",
      "CMOVPE",
      "CMOVPO",
      "CMOVP",
      "CMOVS",
      "CMOVZ",
      "SYSENTER",
      "SYSEXIT",
      "UD2",
      "MASKMOVQ",
      "MOVNTPS",
      "MOVNTQ",
      "PREFETCH0",
      "PREFETCH1",
      "PREFETCH2",
      "PREFETCHNTA",
      "SFENCE",
      "CLFLUSH",
      "LFENCE",
      "MASKMOVDQ",
      "MFENCE",
      "PAUSE",
      "LDDQU",
      "MONITOR",
      "MWAIT",
      "CDQE",
      "CQO",
      "CMPSQ",
      "CMPXCHG16B",
      "CMP",
      "IRETQ",
      "JRCXZ",
      "LODSQ",
      "RDTSCP",
      "SWAPGS",
      "STACK",
      "DATA",
      "CODE",
      "TEXT",
      "SECTION",
      "START",
      "SEGMENT",
      "GLOBAL",
      "BSS",
      "JZ",
      "JNZ",
      "JE",
      "JNE",
      "MODEL",
      "DB",
      "DW",
      "DD",
};

struct modulestruct module_asm =
{
    .extsCount      = 2,
    .exts           = ext_asm,
    .keywordCount   = 269,
    .keywords       = keyword_asm,
    .mlCommentStart = "/*",
    .mlCommentEnd   = "*/",
    .slCommentStart = "#",
    .caseSensitive  = 0,
};
