#!/usr/bin/env python
#
# Copyright 2003 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

from GnuRadio import *

def build_graph ():
    adc_clk_div = 2
    decim_rate = 16
    rx_freq = 0

    which_board = 0
    channel_selection_bitmask = 0x1
    output_name = "usrp-cmplx.dat"
    # output_name = "/dev/null"
    osc_freq = 125e6
    
    fg = gr_FlowGraph ()

    usrp = GrUsrpSource (which_board, channel_selection_bitmask, adc_clk_div, decim_rate)
    usrp.set_rx_freq (0, rx_freq)
    sample_rate = osc_freq / adc_clk_div / decim_rate
    print "adc_clk_div = %d  decim_rate = %d  rx_freq = %g" % (adc_clk_div, decim_rate, rx_freq)
    print "adc_clk_rate = %g  usb_sample_rate = %g" % (osc_freq / adc_clk_div, sample_rate)

    dst = GrFileSink (sizeof_VrComplex, output_name)

    fg.connect (usrp, dst)

    return fg


if __name__ == '__main__':
    fg = build_graph ()
    fg.start ()
    # fg.wait ()
    raw_input ('Press Enter to quit: ')
    fg.stop ()
    
