/* -*- Mode: c++ -*- */
/*
 * Copyright 2001,2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRMULTITASK_H_
#define _VRMULTITASK_H_

#include <VrSigProc.h>

#ifdef PERFMON
#include <VrPerfGraph.h>
#endif

extern int BufferSizeMultiplier;

//! top level of controller of scheduling

class VrMultiTask {
private:
  VrSigProc **sinks;	 //!< all sinks (connected or not)
  int numberSinks;	 //!< total number of sinks

  VrSigProc **goodSinks; //!< connected sinks
  int numSinks; 	 //!< number of connected sinks
  int numThreads;

#ifdef THREADS
  pthread_t *threads;
  
  //! Worker threads wait on this variable and are signaled when the chain starts
  pthread_cond_t start_condition;
  //! This mutex is held whenever scheduling (marking) is taking place.
  pthread_mutex_t mutex;
#endif

  volatile int stopFlag;
  struct timeval initialTime;

#ifdef PERFMON
  VrPerfGraph *perfgraph;
#endif

public:
  VrMultiTask ();
  VrMultiTask (int n_threads);
  ~VrMultiTask ();
  

  void add (VrSigProc *s);

  void start();		//!< one time call to start everything
  void stop();		//!< one time call to stop everything
  void process();	//!< one iteration of signal processing loop

  int isStarted() {return !stopFlag;}

#ifdef PERFMON
  VrPerfGraph *getGraph() {return perfgraph;}
  void print_stats();
#endif

  //Internal methods:
  void schedule();
  void startTimer();

  //Call to find out how long the system has been running:
  double elapsedTime();


#ifdef THREADS
  void start_worker_threads();
  void _start_worker();
#endif

};

#endif
