/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _VRUDPSINK_H_
#define _VRUDPSINK_H_

#include <VrSink.h>
#include <fstream>
#include <sys/socket.h> 
#include <string.h>
#include <sys/types.h> 
#include <netinet/in.h> 
#include <sys/wait.h>
#include <netdb.h> 
#include <arpa/inet.h>
#include <netinet/in.h>

#include <sys/time.h>
#include <unistd.h>

#define MAX_UDP 1990
template<class iType> 
class VrUDPSink : public VrSink<iType> {
private:
  int sockfd;
  int outputsize;
  struct sockaddr_in their_addr;
  struct hostent *he;
  long long next_time;

public:
  virtual const char *name() { return "VrUDPSink"; }
  virtual int work3(VrSampleRange output, 
		    VrSampleRange inputs[], void *i[]);

  virtual void initialize() {
    if ((sockfd = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
      perror("socket");
      exit(1);
    }
  }

  VrUDPSink(char* hostname, int port) {
    next_time = 0;
    if ((he=gethostbyname(hostname)) == NULL) {  /* get the host info */
      herror("gethostbyname");
      exit(1);
    }
    their_addr.sin_family = AF_INET;      /* host byte order */
    their_addr.sin_port = htons(port);  /* short, network byte order */
    their_addr.sin_addr = *((struct in_addr *)he->h_addr);
    bzero(&(their_addr.sin_zero), 8);     /* zero the rest of the struct */
  }
  virtual ~VrUDPSink() { }
};

template<class iType> int
VrUDPSink<iType>::work3(VrSampleRange output, 
			VrSampleRange inputs[], void *ai[])
{
  struct timeval now; 
  long long this_time;
  int current, temp;
  int left=output.size*sizeof(iType);
  unsigned char *cp = (unsigned char *)ai[0];

  gettimeofday(&now,NULL);
  this_time = now.tv_sec * (long long) 1000000 + now.tv_usec;
  if (this_time < next_time)
    usleep ((int) (next_time - this_time));

  double usecs_per_sample = 1e6 / getSamplingFrequency ();

  next_time = this_time + (long long) (output.size * usecs_per_sample);
  while (left > 0) {
    current = left;
    if (current > MAX_UDP)
       current = MAX_UDP;

    temp =sendto(sockfd, cp, current, 0,
		 (struct sockaddr *)&their_addr, sizeof(struct sockaddr));

    // FYI, there used to be a udelay here

    if (temp>0){  //ignore any errors mofo
      cp += temp;
      left -= temp;
    }
    else {
      //jca printf ("[%s:%d] sendto errno %d\n", __FILE__, __LINE__, errno);
      break;
    }
  }
  return output.size;
}

#endif
