/* -*- Mode: c++ -*- */
/*
 * Copyright 2001 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
/*
 *  Copyright 1997 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */


#ifndef _VrDECODER
#define _VrDECODER
#include <VrDecimatingSigProc.h>
#include <string.h>
#include <../G711_G721_G723/g72x.h>
#if defined (ENABLE_MMX)
#include <VrMMX.h>
#endif


// ********************************************************

// FIXME why is this a subclass of VrDecimatingSigProc and not VrSigProc??? -eb


template<class iType> 
class VrAudioDecoder : public VrDecimatingSigProc<iType,iType> {
protected:

#if defined (ENABLE_MMX)
  mmxTaps** processedTaps; //Precomputed constants, shifted four times
#endif

const int outputBytes=120; //120 is smallest number divisible by 3,4,5,8,
const int headerSize=3;
const int outputBlockSize=outputBytes+headerSize;

public: 
  int outputsize,inputsize;
  int num;
  short blockNum;
  int position;
  int enc_bits;
  int in_coding;
  int difference;
  struct g72x_state	state;
  int (*dec_routine)(int, int, g72x_state *);

  void choose_decoder(int bits){
    enc_bits=bits;
    switch (bits){
    case 3:
       dec_routine = g723_24_decoder;
       break;
     case 4:
       dec_routine = g721_decoder;
       break;
     case 5:
       dec_routine = g723_40_decoder;
       break;
     }
  }
  
  VrAudioDecoder(){
    num=0;      
    difference=0;
    g72x_init_state(&state);
  }

  virtual const char *name() { return "VrAudioDecoder"; }

  virtual int work(VrSampleRange output, iType *o[],
		   VrSampleRange inputs[], iType *i[]);

  virtual int forecast(VrSampleRange output,
		       VrSampleRange inputs[]);

  virtual void initialize();


};

template<class iType> int
VrAudioDecoder<iType>::forecast(VrSampleRange output,
					   VrSampleRange inputs[]) {
  
  cout <<"forecast called.  module "<<name()<<endl;
  double maxratio=double(5.0)/(double)8.0;

  inputs[0].index=(long unsigned)((int)output.index-difference);

  int numblocks=output.size/outputBlockSize;  

  inputs[0].size=double(output.size)*maxratio*outputBlockSize/outputBytes;
  
  cout <<"ratio= "<<maxratio<<" to get outputsize of "<<output.size<<" starting at " <<output.index<< " you need "<<inputs[0].size<< " starting at "<<inputs[0].index<<endl;

  cout <<"forecast FINISHED.  module "<<name()<<endl;

  return 0;

}  


template<class iType> int 
VrAudioDecoder<iType>::work(VrSampleRange output, iType *o[], VrSampleRange inputs[], iType *i[]) {

  unsigned int	in_buffer = 0;
  int		in_bits = 0;
  unsigned char		in_byte;
  int code;
  cout <<"work called.  module "<<name()<<endl;;
  cout <<__FUNCTION__<<" starting output.size ="<<output.size<<"starting output.index "<<output.index<<endl;

  iType *curInPos=i[0],*curOutPos=o[0];
  double ratio;
  short blocknum=0;
  unsigned char outputChar;

  int bytes_read;    
  unsigned total_bytes_written=0,total_bytes_read=0;

  while (total_bytes_written<output.size){
    choose_decoder((int)*curInPos);
    ratio=double(*curInPos)/double(8);
    cout <<"using " << ratio<<" ratio "<<total_bytes_written<<" out of "<<output.size<<endl;

    curInPos++;
    blocknum=((unsigned char)*curInPos)<<8;
    curInPos++;
    blocknum|=(unsigned char) *curInPos;
    curInPos++;
    bytes_read=headerSize;
    int written =0;
    cout <<"Decoding block "<<blocknum<<endl;


    while(bytes_read<outputBlockSize|| (in_bits>0)){
      if (in_bits < enc_bits) {
	in_byte = *(curInPos++);
	bytes_read++;
	in_buffer |= (in_byte << in_bits);
	in_bits += 8;
      }
      code = in_buffer & ((1 << enc_bits) - 1);
      in_buffer >>= enc_bits;
      in_bits -= enc_bits;
      outputChar = (*dec_routine)(code, AUDIO_ENCODING_ULAW, &state);
      written++;
      *(curOutPos++)=outputChar;
    }
    


    total_bytes_written+=written;
    total_bytes_read+=bytes_read;

    cout <<bytes_read<< " bytes read. "<< written << " bytes written"<<endl;
  }
    if (in_bits!=0)
      cout <<__FUNCTION__<<" extra bits left over..."<<endl;

    cout <<total_bytes_read<< " total bytes read. "<< total_bytes_written << " total bytes written"<<endl;

    int diff=total_bytes_written-total_bytes_read;
    difference+=diff;
    cout <<"difference for this cycle "<<diff<<endl;

    cout <<"work FINISHED.  module "<<name()<<endl;
    return output.size;
}


template<class iType> 
void VrAudioDecoder<iType>::initialize()
{
  setOutputSize(4800);
}

#endif
