#!/usr/bin/env python

#
# FIXME Needs work
#

from gnuradio import gr, eng_notation
from gnuradio import usrp
from gnuradio import audio
from gnuradio.eng_option import eng_option
from optparse import OptionParser
import math

from gnuradio.wxgui import stdgui, fftsink, scopesink
import wx


class fsk_rx_graph (stdgui.gui_flow_graph):
    def __init__(self, frame, panel, vbox, argv):
        stdgui.gui_flow_graph.__init__ (self, frame, panel, vbox, argv)

        parser = OptionParser (option_class=eng_option)
        parser.add_option ("-c", "--cordic-freq", type="eng_float", default=29.32e6,
                           help="set Tx cordic frequency to FREQ", metavar="FREQ")
        parser.add_option ("-r", "--data-rate", type="eng_float", default=100e3)
        parser.add_option ("-f", "--filename", type="string",
                           default="rx.dat", help="write data to FILENAME")
        parser.add_option ("-g", "--gain", type="eng_float", default=0,
                           help="set Rx PGA gain in dB [0,20]")
        parser.add_option ("-N", "--no-gui", action="store_true", default=False)

        (options, args) = parser.parse_args ()
        print "cordic_freq = %s" % (eng_notation.num_to_str (options.cordic_freq))

        # ----------------------------------------------------------------

        data_rate = options.data_rate
        self.samples_per_symbol = 8
        self.usrp_decim = int (64e6 / self.samples_per_symbol / data_rate)
        self.fs = data_rate * self.samples_per_symbol
        payload_size = 1024             # bytes

        print "data_rate = ", eng_notation.num_to_str(data_rate)
        print "samples_per_symbol = ", self.samples_per_symbol
        print "usrp_decim = ", self.usrp_decim
        print "fs = ", eng_notation.num_to_str(self.fs)

        max_deviation = data_rate / 4
    
        u = usrp.source_c (0, self.usrp_decim)
        u.set_rx_freq (0, -options.cordic_freq)
        u.set_pga(0, options.gain)
        u.set_pga(1, options.gain)


        filter_taps =  gr.firdes.low_pass (1,                   # gain
                                           self.fs,             # sampling rate
                                           data_rate / 2 * 1.1, # cutoff
                                           data_rate,           # trans width
                                           gr.firdes.WIN_HANN)

        print "len = ", len (filter_taps)

        filter = gr.fir_filter_ccf (1, filter_taps)

        k = 1
        # k = 2 * math.pi * max_deviation / self.fs
        fmdemod = gr.quadrature_demod_cf (k)

        corr = gr.simple_correlator (payload_size)

        filesink = gr.file_sink (gr.sizeof_char, options.filename)

        self.connect (u, filter)
        self.connect (filter, fmdemod)
        self.connect (fmdemod,corr)
        self.connect (corr,filesink)

        if 1 and not(options.no_gui):
            fft_input = fftsink.fft_sink_c (self, panel, title="Input", fft_size=512, sample_rate=self.fs)
            self.connect (u, fft_input)
            vbox.Add (fft_input.win, 1, wx.EXPAND)

        if 1 and not(options.no_gui):
            fft_filter = fftsink.fft_sink_c (self, panel, title="Post Channel Selection", fft_size=512, sample_rate=self.fs)
            self.connect (filter, fft_filter)
            vbox.Add (fft_filter.win, 1, wx.EXPAND)

        if 0 and not(options.no_gui):
            scope_input = scopesink.scope_sink_f (self, panel, title="Input", sample_rate=self.fs)
            c2f = gr.complex_to_float()
            self.connect (u, c2f)
            self.connect ((c2f, 0), (scope_input,0))
            self.connect ((c2f, 1), (scope_input,1))
            vbox.Add (scope_input.win, 1, wx.EXPAND)

        if 0:
            post_mod = fftsink.fft_sink_c (self, panel, title="Post Modulation", fft_size=512, sample_rate=self.fs)
            self.connect (sum, post_mod)
            vbox.Add (post_mod.win, 1, wx.EXPAND)
            

def main ():
    app = stdgui.stdapp (fsk_rx_graph, "FSK Rx")
    app.MainLoop ()

if __name__ == '__main__':
    main ()
