/* -*- c++ -*- */
/*
 * Copyright 2003 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _INCLUDED_MC4020_BITMASK_H_
#define _INCLUDED_MC4020_BITMASK_H_

// bitmask values for mc4020_config.bitmask

#define	MCC_CH0_EN		 0x00000001	// enable channel 0 for input
#define	MCC_CH1_EN		 0x00000002	
#define	MCC_CH2_EN		 0x00000004
#define	MCC_CH3_EN		 0x00000008
#define	MCC_CH0_5V		 0x00000010	// ch0 range: +/- 5V
#define	MCC_CH0_1V		 0x00000000	// ch0 range: +/- 1V
#define	MCC_CH1_5V		 0x00000020	// ch1 range: +/- 5V
#define	MCC_CH1_1V		 0x00000000	// ch1 range: +/- 1V
#define	MCC_CH2_5V		 0x00000040	// ch2 range: +/- 5V
#define	MCC_CH2_1V		 0x00000000	// ch2 range: +/- 1V
#define	MCC_CH3_5V		 0x00000080	// ch3 range: +/- 5V
#define	MCC_CH3_1V		 0x00000000	// ch3 range: +/- 1V
// select input source
#define	MCC_ASRC_MASK		 0x00000700
#define	MCC_ASRC_BNC		 0x00000000	// BNC connector (normal)
#define	MCC_ASRC_CAL_AGND	 0x00000100	// AGND
#define	MCC_ASRC_CAL_0_625	 0x00000200	// 0.625 V ref
#define	MCC_ASRC_CAL_4_375	 0x00000300	// 4.375 V ref
#define	MCC_ASRC_CAL_HDR	 0x00000400	// calibration header (P2)
// Trig/Ext Clk BNC threshold select
#define	MCC_EXT_BNC_THRESH_ZERO	 0x00000800
#define	MCC_EXT_BNC_THRESH_2_5V	 0x00000000
// data acquistion base clock source
#define	MCC_CLK_MASK		 0x00003000
#define	MCC_CLK_INTERNAL	 0x00000000	// 40MHz internal clock
#define	MCC_CLK_EXT_BNC	 	 0x00001000	// external BNC connector
#define	MCC_CLK_AD_START_TRIG_IN 0x00002000	// external A/D start trigger in pin
 
#define	MCC_ALL_1V		(MCC_CH0_1V | MCC_CH1_1V | MCC_CH2_1V | MCC_CH3_1V)
#define	MCC_ALL_5V		(MCC_CH0_5V | MCC_CH1_5V | MCC_CH2_5V | MCC_CH3_5V)

#endif /* _INCLUDED_MC4020_BITMASK_H_ */
