define(function (require, exports, module) {
/*
delegation
*/"use strict"

var $   = require("./events"),
    Map = require("prime/map")

require('./traversal')

$.implement({

    delegate: function(event, selector, handle){

        this.forEach(function(node){

            var self = $(node)

            var delegation = self._delegation || (self._delegation = {}),
                events     = delegation[event] || (delegation[event] = {}),
                map        = (events[selector] || (events[selector] = new Map))

            var action = function(e){
                var target = $(e.target),
                    match  = target.matches(selector) ? target : target.parent(selector)
                if (match) handle.call(self, e, match)
            }

            map.set(handle, action)

            self.on(event, action)

        })

        return this

    },

    undelegate: function(event, selector, handle){

        this.forEach(function(node){

            var self = $(node), delegation, events, map

            if (!(delegation = self._delegation) || !(events = delegation[event]) || !(map = events[selector])) return;

            var action = map.get(handle)

            if (action){
                self.off(event, action)
                map.remove(handle)

                // if there are no more handles in a given selector, delete it
                if (!map.count()) delete events[selector]
                // var evc = evd = 0, x
                var e1 = true, e2 = true, x
                for (x in events){
                    e1 = false
                    break
                }
                // if no more selectors in a given event type, delete it
                if (e1) delete delegation[event]
                for (x in delegation){
                    e2 = false
                    break
                }
                // if there are no more delegation events in the element, delete the _delegation object
                if (!e2) delete self._delegation
            }

        })

        return this
    }

})

module.exports = $

  return module.exports;

});
