/*
 * Decompiled with CFR 0.152.
 */
package classycle.ant;

import classycle.Analyser;
import classycle.ant.ClassycleTask;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import org.apache.tools.ant.BuildException;

public class ReportTask
extends ClassycleTask {
    public static final String TYPE_RAW = "raw";
    public static final String TYPE_CSV = "csv";
    public static final String TYPE_XML = "xml";
    private static final Set<String> TYPES = new HashSet<String>();
    private boolean _packagesOnly;
    private String _reportType = "xml";
    private String _title;

    public void setPackagesOnly(boolean packagesOnly) {
        this._packagesOnly = packagesOnly;
    }

    public void setReportType(String csvFile) {
        this._reportType = csvFile;
    }

    public void setTitle(String title) {
        this._title = title;
    }

    @Override
    public void execute() throws BuildException {
        super.execute();
        if (!TYPES.contains(this._reportType)) {
            throw new BuildException("invalid attribute 'reportType': " + this._reportType);
        }
        if (this._reportFile == null) {
            throw new BuildException("missing attribute 'reportFile'.");
        }
        String[] classFiles = this.getClassFileNames();
        if (classFiles.length > 0 && this._title == null) {
            this._title = classFiles[0];
        }
        Analyser analyser = new Analyser(classFiles, this.getPattern(), this.getReflectionPattern(), this.isMergeInnerClasses());
        try {
            analyser.readAndAnalyse(this._packagesOnly);
            PrintWriter writer = new PrintWriter(new FileWriter(this._reportFile));
            if (this._reportType.equals(TYPE_XML)) {
                analyser.printXML(this._title, this._packagesOnly, writer);
            } else if (this._reportType.equals(TYPE_CSV)) {
                analyser.printCSV(writer);
            } else if (this._reportType.equals(TYPE_RAW)) {
                analyser.printRaw(writer);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    static {
        TYPES.add(TYPE_RAW);
        TYPES.add(TYPE_CSV);
        TYPES.add(TYPE_XML);
    }
}

