/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.OP;
import gnu.jel.OPfunction;

public class OPlist
extends OP {
    protected int size = 0;

    public int size() {
        return this.size;
    }

    public OP getFirst() {
        return this.next;
    }

    public OP getLast() {
        return this.prev;
    }

    public void addFirst(OP oP) {
        oP.prev = null;
        oP.next = null;
        if (this.next != null) {
            oP.next = this.next;
            this.next.prev = oP;
        }
        this.next = oP;
        if (this.prev == null) {
            this.prev = oP;
        }
        ++this.size;
    }

    public void addLast(OP oP) {
        oP.prev = null;
        oP.next = null;
        if (this.prev != null) {
            oP.prev = this.prev;
            this.prev.next = oP;
        }
        this.prev = oP;
        if (this.next == null) {
            this.next = oP;
        }
        ++this.size;
    }

    public void addBefore(OP oP, OP oP2) {
        if (oP == this.next) {
            this.addFirst(oP2);
            return;
        }
        oP2.prev = oP.prev;
        oP2.next = oP;
        oP.prev.next = oP2;
        oP.prev = oP2;
        ++this.size;
    }

    public void addAfter(OP oP, OP oP2) {
        if (oP.next != null) {
            this.addBefore(oP.next, oP2);
        } else {
            this.addLast(oP2);
        }
    }

    public void remove(OP oP) {
        if (oP.prev != null) {
            oP.prev.next = oP.next;
        } else {
            this.next = oP.next;
        }
        if (oP.next != null) {
            oP.next.prev = oP.prev;
        } else {
            this.prev = oP.prev;
        }
        oP.next = null;
        oP.prev = null;
        --this.size;
    }

    public void performCF() {
        OP oP = this.next;
        while (oP != null) {
            OP oP2 = oP.next;
            if (oP instanceof OPfunction) {
                ((OPfunction)oP).eval(this);
            }
            oP = oP2;
        }
    }

    private static OP skip(OP oP) {
        if (oP instanceof OPfunction) {
            OP oP2 = oP.prev;
            int n = ((OPfunction)oP).getNParams();
            int n2 = 0;
            while (n2 < n) {
                oP2 = OPlist.skip(oP2);
                ++n2;
            }
            return oP2;
        }
        return oP.prev;
    }

    private static void compileFunc(ClassFile classFile, OPfunction oPfunction) {
        oPfunction.compile_pre(classFile);
        OPlist.compileParams(classFile, oPfunction, oPfunction.prev, oPfunction.getNParams());
        oPfunction.compile(classFile);
    }

    private static void compileParams(ClassFile classFile, OPfunction oPfunction, OP oP, int n) {
        if (n == 0) {
            return;
        }
        OPlist.compileParams(classFile, oPfunction, OPlist.skip(oP), n - 1);
        if (oP instanceof OPfunction) {
            OPlist.compileFunc(classFile, (OPfunction)oP);
        } else {
            oP.compile(classFile);
        }
        oPfunction.compile_par(classFile);
    }

    public void compile(ClassFile classFile) {
        if (this.prev instanceof OPfunction) {
            OPlist.compileFunc(classFile, (OPfunction)this.prev);
        } else {
            this.prev.compile(classFile);
        }
    }

    public String toString() {
        OP oP = this.next;
        StringBuffer stringBuffer = new StringBuffer();
        while (oP != null) {
            stringBuffer.append(oP.toString());
            oP = oP.next;
            if (oP == null) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

