/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import gnu.jel.TestingUtils;
import gnu.jel.tests.VariableProvider;

public class IntegralStaticTest
extends TestingUtils {
    Library lib;

    public IntegralStaticTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Class[] staticLib = new Class[2];
        Class[] dotAllowedOn = new Class[1];
        staticLib[0] = Class.forName("java.lang.Math");
        VariableProvider tvp = new VariableProvider();
        staticLib[1] = tvp.getClass();
        dotAllowedOn[0] = Class.forName("java.lang.String");
        this.lib = new Library(staticLib, null, dotAllowedOn, null, null);
        this.lib.markStateDependent("random", null);
    }

    public void testExpr1() throws Throwable {
        IntegralStaticTest.simExpression("2*2", new Integer(4), null, null, this.lib, null);
    }

    public void testExpr2() throws Throwable {
        IntegralStaticTest.simExpression("2L*2L", new Long(4L), null, null, this.lib, null);
    }

    public void testExpr3() throws Throwable {
        IntegralStaticTest.simExpression("2.0*2.0", new Double(4.0), null, null, this.lib, null);
    }

    public void testExpr4() throws Throwable {
        IntegralStaticTest.simExpression("2*2+3*3", new Integer(13), null, null, this.lib, null);
    }

    public void testExpr5() throws Throwable {
        IntegralStaticTest.simExpression("2/2+3/3", new Integer(2), null, null, this.lib, null);
    }

    public void testExpr6() throws Throwable {
        IntegralStaticTest.simExpression("2%2+3%3", new Integer(0), null, null, this.lib, null);
    }

    public void testExpr7() throws Throwable {
        IntegralStaticTest.simExpression("2*2-3*3", new Integer(-5), null, null, this.lib, null);
    }

    public void testExpr8() throws Throwable {
        IntegralStaticTest.simExpression("2/2-3/3", new Integer(0), null, null, this.lib, null);
    }

    public void testExpr9() throws Throwable {
        IntegralStaticTest.simExpression("2%2-3%3", new Integer(0), null, null, this.lib, null);
    }

    public void testExpr10() throws Throwable {
        IntegralStaticTest.simExpression("2.0F*2.0F", new Float(4.0f), null, null, this.lib, null);
    }

    public void testExpr11() throws Throwable {
        IntegralStaticTest.simExpression("sin(1)", new Double(Math.sin(1.0)), null, null, this.lib, null);
    }

    public void testExpr12() throws Throwable {
        IntegralStaticTest.simExpression("pow(sin(1),2)+pow(cos(1),2)", new Double(1.0), null, null, this.lib, null);
    }

    public void testExpr13() throws Throwable {
        IntegralStaticTest.simExpression("min(1+2*2,(1+2)*2)", new Integer(5), null, null, this.lib, null);
    }

    public void testExpr14() throws Throwable {
        IntegralStaticTest.simExpression("7+4-6", new Double(5.0), Double.TYPE, null, this.lib, null);
    }

    public void testExpr15() throws Throwable {
        IntegralStaticTest.simExpression("true&&false||false&&true||false", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr16() throws Throwable {
        IntegralStaticTest.simExpression("(1<<2L==4)&&(-1>>5==-1)&&(-1>>>1==0x7FFFFFFF)", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr17() throws Throwable {
        IntegralStaticTest.simExpression("(-1>>>1==0x5FFFFFFF)", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr18() throws Throwable {
        IntegralStaticTest.simExpression("(-1L>>>1L==0x7FFFFFFFFFFFFFFFL)", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr19() throws Throwable {
        IntegralStaticTest.simExpression("1+2>2==true", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr20() throws Throwable {
        IntegralStaticTest.simExpression("true?false:true?true:false", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr21() throws Throwable {
        IntegralStaticTest.simExpression("false?true:true?false:true", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr22() throws Throwable {
        IntegralStaticTest.simExpression("(1==1)&&(max(~bool2int(1<=2),~bool2int(2>=3))!=-1)", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr23() throws Throwable {
        IntegralStaticTest.simExpression("(-1==-1)&&(max(~(1<=2?1:0),~(2>=3?1:0))!=-1)", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr24() throws Throwable {
        IntegralStaticTest.simExpression("!((!true)&&(!true))", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr25() throws Throwable {
        IntegralStaticTest.simExpression("!(!(false&&false&&false)&&!false)", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr26() throws Throwable {
        IntegralStaticTest.simExpression("(!(5+1>5)?1:2)==2", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr27() throws Throwable {
        IntegralStaticTest.simFullLogic("!(!(_a&&_b&&_c)&&!_d)", 4, this.lib, null, false);
    }

    public void testExpr28() throws Throwable {
        IntegralStaticTest.simFullLogic("_a&&_b&&_c||_d", 4, this.lib, null, false);
    }

    public void testExpr29() throws Throwable {
        IntegralStaticTest.simFullLogic("_a&&(_b&&(_c||_d))", 4, this.lib, null, false);
    }

    public void testExpr30() throws Throwable {
        IntegralStaticTest.simFullLogic("_a&&((_b&&_c)||_d)", 4, this.lib, null, false);
    }

    public void testExpr31() throws Throwable {
        IntegralStaticTest.simFullLogic("(_a&&_b)||!(_c&&_d)||_e", 5, this.lib, null, false);
    }

    public void testExpr32() throws Throwable {
        IntegralStaticTest.simFullLogic("_a&&((_b&&(!(_c&&_d)||_e))||_f)", 6, this.lib, null, false);
    }

    public void testExpr33() throws Throwable {
        IntegralStaticTest.simFullLogic("_a&&(!(_b&&(!(_c&&_d)||_e))||!_f)", 6, this.lib, null, false);
    }

    public void testExpr34() throws Throwable {
        IntegralStaticTest.simFullLogic("_a&(!(_b&(!(_c&_d)|_e))|!_f)", 6, this.lib, null, false);
    }

    public void testExpr35() throws Throwable {
        IntegralStaticTest.simFullLogic("_a?_b||_c||_d:_e&&_f", 6, this.lib, null, false);
    }

    public void testExpr36() throws Throwable {
        IntegralStaticTest.simFullLogic("(_a==_b)&&(max(~bool2int(1<=2&&_c||_d),~bool2int(2>=3&&_e||_f))!=-1)", 6, this.lib, null, false);
    }

    public void testExpr37() throws Throwable {
        IntegralStaticTest.simFullLogic("_a?_b:_c?_d:_e", 5, this.lib, null, false);
    }

    public void testExpr38() throws Throwable {
        IntegralStaticTest.simExpression("\"aa\"+\"bb\"+\"cc\"", "aabbcc", null, null, this.lib, null);
    }

    public void testExpr39() throws Throwable {
        IntegralStaticTest.simExpression("\"str\"+true+1+20L+6.0F+7.0D", "strtrue1206.07.0", null, null, this.lib, null);
    }

    public void testExpr40() throws Throwable {
        IntegralStaticTest.simExpression("\"str\"+(2+3)", "str5", null, null, this.lib, null);
    }

    public void testExpr41() throws Throwable {
        IntegralStaticTest.simExpression("((~(~((((1+2-2)*2/2)^55)^55)))|1&2)==1", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr42() throws Throwable {
        IntegralStaticTest.simExpression("((~(~((((1L+2L-2L)*2L/2L)^55L)^55L)))|1L&2L)==1L", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr43() throws Throwable {
        IntegralStaticTest.simExpression("((10/3)*3+10%3)==10", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr44() throws Throwable {
        IntegralStaticTest.simExpression("((10L/3)*3+10%3L)==10L", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr45() throws Throwable {
        IntegralStaticTest.simExpression("((1>5?0:10F)/3)*3+10F%3", new Float(11.0f), null, null, this.lib, null);
    }

    public void testExpr46() throws Throwable {
        IntegralStaticTest.simExpression("((1>5?0:10D)/3)*3+10D%3", new Double(11.0), null, null, this.lib, null);
    }

    public void testExpr47() throws Throwable {
        IntegralStaticTest.simExpression("round(((10-5)==5?(6.0-((8==8)?5.0:1))*2.0:1.0+2.0-1.0)/2.0)==1", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr48() throws Throwable {
        IntegralStaticTest.simExpression("true?\"a\"+\"b\":\"c\"", "ab", null, null, this.lib, null);
    }

    public void testExpr49() throws Throwable {
        IntegralStaticTest.simExpression("true?\"a\"+\"b\":\"c\"+\"d\"", "ab", null, null, this.lib, null);
    }

    public void testExpr50() throws Throwable {
        IntegralStaticTest.simExpression("true?\"ab\":\"c\"+\"d\"", "ab", null, null, this.lib, null);
    }

    public void testExpr51() throws Throwable {
        IntegralStaticTest.simExpression("false?\"a\"+\"b\":\"c\"+\"d\"", "cd", null, null, this.lib, null);
    }

    public void testExpr52() throws Throwable {
        IntegralStaticTest.simExpression("false?\"ab\":\"c\"+\"d\"", "cd", null, null, this.lib, null);
    }

    public void testExpr53() throws Throwable {
        IntegralStaticTest.simExpression("false?\"ab\":\"cd\"", "cd", null, null, this.lib, null);
    }

    public void testExpr54() throws Throwable {
        IntegralStaticTest.simExpression("false?\"ab\":\"cd\"", "cd", null, null, this.lib, null);
    }

    public void testExpr55() throws Throwable {
        IntegralStaticTest.simExpression("(false?\"a\"+\"b\":\"c\"+\"d\")+\"e\"", "cde", null, null, this.lib, null);
    }

    public void testExpr56() throws Throwable {
        IntegralStaticTest.simExpression("\"e\"+(false?\"a\"+\"b\":\"c\"+\"d\")", "ecd", null, null, this.lib, null);
    }

    public void testNaNExt() throws Throwable {
        IntegralStaticTest.simExpression("(1>NaNd)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1<NaNd)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1>=NaNd)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1<=NaNd)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1==NaNd)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("!(1!=NaNd)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNd>1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNd<1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNd>=1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNd<=1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNd==1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("!(NaNd!=1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1>NaNf)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1<NaNf)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1>=NaNf)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1<=NaNf)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1==NaNf)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("!(1!=NaNf)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNf>1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNf<1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNf>=1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNf<=1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNf==1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("!(NaNf!=1)", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testNaNCondensed() throws Throwable {
        IntegralStaticTest.simExpression("(NaNd>1)||(NaNd<1)||(NaNd>=1)||(NaNd<=1)||(NaNd==1)||!(NaNd!=1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1>NaNd)||(1<NaNd)||(1>=NaNd)||(1<=NaNd)||(1==NaNd)||!(1!=NaNd)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(NaNf>1)||(NaNf<1)||(NaNf>=1)||(NaNf<=1)||(NaNf==1)||!(NaNf!=1)", Boolean.FALSE, null, null, this.lib, null);
        IntegralStaticTest.simExpression("(1>NaNf)||(1<NaNf)||(1>=NaNf)||(1<=NaNf)||(1==NaNf)||!(1!=NaNf)", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr57() throws Throwable {
        IntegralStaticTest.simExpression("\"aaaca\".indexOf('c')+1==4 && (1>2?\"cc\":\"aaaca\").indexOf('c')+1==4", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr58() throws Throwable {
        IntegralStaticTest.simExpression("round((float)4)", new Integer(4), null, null, this.lib, null);
    }

    public void testExpr59() throws Throwable {
        IntegralStaticTest.simExpression("(int)4.0", new Integer(4), null, null, this.lib, null);
    }

    public void testExpr60() throws Throwable {
        IntegralStaticTest.simExpression("-(int)234", new Integer(-234), null, null, this.lib, null);
    }

    public void testExpr61() throws Throwable {
        IntegralStaticTest.simExpression("-(short)(-(int)234)", new Integer(234), null, null, this.lib, null);
    }

    public void testExpr62() throws Throwable {
        IntegralStaticTest.simExpression("!(boolean)(true)", Boolean.FALSE, null, null, this.lib, null);
    }

    public void testExpr63() throws Throwable {
        IntegralStaticTest.simExpression("7+(int)4-(int)6.0+1-(int)round((double)((float)((long)1+0)+0)+0)", new Integer(5), null, null, this.lib, null);
    }

    public void testExpr64() throws Throwable {
        IntegralStaticTest.simExpression("~0", new Integer(-1), null, null, this.lib, null);
    }

    public void testExpr65() throws Throwable {
        IntegralStaticTest.simExpression("~0", new Integer(-1), null, null, this.lib, null);
    }

    public void testExpr66() throws Throwable {
        IntegralStaticTest.simExpression("(\"abbb\"+\"ccc\"+'d'+(1>2?\"e\":\"d\")).substring(1)", "bbbcccdd", null, null, this.lib, null);
    }

    public void testExpr67() throws Throwable {
        IntegralStaticTest.simExpression("\"abbb\".substring(1).equals(\"bbb\")||false", Boolean.TRUE, null, null, this.lib, null);
    }

    public void testExpr68() throws Throwable {
        IntegralStaticTest.simExpression("\"abbb\"+'d'", "abbbd", null, null, this.lib, null);
    }
}

