
;;; bak-unix.el

;; Copyright (C) 2014-2015 Davin Pearson

;; Emacs Lisp Archive Entry
;; Filename: bak-unix.el
;; Author/Maintainer: Davin Pearson <http://davin.50webs.com>
;; Keywords: Unix Backup
;; Version: 1.0

;;; Commentary:

;; This file is not part of GNU Emacs.

;;; Limitation of Warranty

;; This program is free software: you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation, either version 3 of the License, or (at
;; your option) any later version.
;;
;; This program is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs, see the file COPYING.  If not, see:
;;
;; <http://www.gnu.org/licenses/gpl-3.0.txt>.


;;; Known Bugs:

;; None so far!

;;; Code:

(defun bak ()
  (interactive)
  (assert os-type--linux-p)
  (unix-bak-rest-files)
  )

(require 'cull-same-dates)
(require 'cull-size-quota)

(defun unix-bak-rest-files ()
  (save-window-excursion

    (progn
      (if (file-exists-p "/media/www/C1TB")
          (make-directory "/media/www/C1TB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/C80GB")
          (make-directory "/media/www/C80GB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/D153GB")
          (make-directory "/media/www/D153GB/home/bak/baz"  'PARENTS))
      (if (file-exists-p "/media/www/F2TB")
          (make-directory "/media/www/F2TB/home/bak/baz"    'PARENTS))
      (if (file-exists-p "/media/www/G16GB")
          (make-directory "/media/www/G16GB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/H16GB")
          (make-directory "/media/www/I16GB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/I16GB")
          (make-directory "/media/www/H16GB/home/bak/baz"   'PARENTS))
      (if (file-exists-p "/media/www/K2TB")
          (make-directory "/media/www/K2TB/home/bak/baz"    'PARENTS))
      (if (file-exists-p "/media/www/BLU16GB")
          (make-directory "/media/www/BLU16GB/home/bak/baz" 'PARENTS))
      (if (file-exists-p "/media/www/GRN16GB")
          (make-directory "/media/www/BLU16GB/home/bak/baz" 'PARENTS))
      (if (file-exists-p "/media/www/WD2TB")
          (make-directory "/media/www/WD2TB/home/bak/baz" 'PARENTS))
      (if (file-exists-p "/media/www/WD2TB2")
          (make-directory "/media/www/WD2TB2/home/bak/baz" 'PARENTS))
      )

    (progn
      (datify--dir "~/bak")
      (datify--dir "~/bak/baz")
      (if (file-exists-p "/media/www/C1TB/home/bak")
          (datify--dir "/media/www/C1TB/home/bak"))
      (if (file-exists-p "/media/www/C80GB/home/bak")
          (datify--dir "/media/www/C80GB/home/bak"))
      (if (file-exists-p "/media/www/F2TB/home/bak")
          (datify--dir "/media/www/F2TB/home/bak"))
      (if (file-exists-p "/media/www/G16GB/home/bak")
          (datify--dir "/media/www/G16GB/home/bak"))
      (if (file-exists-p "/media/www/H16GB/home/bak")
          (datify--dir "/media/www/H16GB/home/bak"))
      (if (file-exists-p "/media/www/I16GB/home/bak")
          (datify--dir "/media/www/I16GB/home/bak"))
      (if (file-exists-p "/media/www/J600GB/home/bak")
          (datify--dir "/media/www/J600GB/home/bak"))
      (if (file-exists-p "/media/www/K2TB/home/bak")
          (datify--dir "/media/www/K2TB/home/bak"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak")
          (datify--dir "/media/www/BLU16GB/home/bak"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak")
          (datify--dir "/media/www/GRN16GB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB/home/bak")
          (datify--dir "/media/www/WD2TB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak")
          (datify--dir "/media/www/WD2TB2/home/bak"))
      )
    (progn
      (cull-same-dates "~/bak")
      (if (file-exists-p "/media/www/C1TB/home/bak")
          (cull-same-dates "/media/www/C1TB/home/bak"))
      (if (file-exists-p "/media/www/C80GB/home/bak")
          (cull-same-dates "/media/www/C80GB/home/bak"))
      ;;(if (file-exists-p "/media/www/F2TB/home/bak")
      ;;    (cull-same-dates "/media/www/F2TB/home/bak"))
      (if (file-exists-p "/media/www/G16GB/home/bak")
          (cull-same-dates "/media/www/G16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/H16GB/home/bak")
      ;;    (cull-same-dates "/media/www/H16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/I16GB/home/bak")
      ;;    (cull-same-dates "/media/www/I16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/J600GB/home/bak")
      ;;    (cull-same-dates "/media/www/J600GB/home/bak"))
      ;;(if (file-exists-p "/media/www/K2TB/home/bak")
      ;;    (cull-same-dates "/media/www/K2TB/home/bak"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak")
          (cull-same-dates "/media/www/BLU16GB/home/bak"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak")
          (cull-same-dates "/media/www/GRN16GB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB/home/bak")
          (cull-same-dates "/media/www/WD2TB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak")
          (cull-same-dates "/media/www/WD2TB2/home/bak"))
      )
    (progn
      (cull-same-dates "~/bak/baz")
      (if (file-exists-p "/media/www/C80GB/home/bak/baz")
          (cull-same-dates "/media/www/C80GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/F2TB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/F2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/G16GB/home/bak/baz")
          (cull-same-dates "/media/www/G16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/H16GB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/H16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/I16GB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/I16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/J600GB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/J600GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/K2TB/home/bak/baz")
      ;;    (cull-same-dates "/media/www/K2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak/baz")
          (cull-same-dates "/media/www/BLU16GB/home/bak/baz"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak/baz")
          (cull-same-dates "/media/www/GRN16GB/home/bak/baz"))
      (if (file-exists-p "/media/www/WD2TB/home/bak/baz")
          (cull-same-dates "/media/www/WD2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak/baz")
          (cull-same-dates "/media/www/WD2TB2/home/bak/baz"))
      )
    (progn
      (cull-size-quota "~/bak")
      (if (file-exists-p "/media/www/C80GB/home/bak")
          (cull-size-quota "/media/www/C80GB/home/bak"))
      ;;(if (file-exists-p "/media/www/F2TB/home/bak")
      ;;    (cull-size-quota "/media/www/F2TB/home/bak"))
      (if (file-exists-p "/media/www/G16GB/home/bak")
          (cull-size-quota "/media/www/G16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/H16GB/home/bak")
      ;;    (cull-size-quota "/media/www/H16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/I16GB/home/bak")
      ;;    (cull-size-quota "/media/www/I16GB/home/bak"))
      ;;(if (file-exists-p "/media/www/J600GB/home/bak")
      ;;    (cull-size-quota "/media/www/J600GB/home/bak"))
      ;;(if (file-exists-p "/media/www/K2TB/home/bak")
      ;;    (cull-size-quota "/media/www/K2TB/home/bak"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak")
          (cull-size-quota "/media/www/BLU16GB/home/bak"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak")
          (cull-size-quota "/media/www/GRN16GB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB/home/bak")
          (cull-size-quota "/media/www/WD2TB/home/bak"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak")
          (cull-size-quota "/media/www/WD2TB2/home/bak"))
      )
    (progn
      (cull-size-quota "~/bak/baz")
      (if (file-exists-p "/media/www/C1TB/home/bak/baz")
          (cull-size-quota "/media/www/C1TB/home/bak/baz"))
      (if (file-exists-p "/media/www/C80GB/home/bak/baz")
          (cull-size-quota "/media/www/C80GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/F2TB/home/bak/baz")
      ;;  (cull-size-quota "/media/www/F2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/G16GB/home/bak/baz")
          (cull-size-quota "/media/www/G16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/H16GB/home/bak/baz")
      ;;    (cull-size-quota "/media/www/H16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/I16GB/home/bak/baz")
      ;;    (cull-size-quota "/media/www/I16GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/J600GB/home/bak/baz")
      ;;    (cull-size-quota "/media/www/J600GB/home/bak/baz"))
      ;;(if (file-exists-p "/media/www/K2TB/home/bak/baz")
      ;;    (cull-size-quota "/media/www/K2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/BLU16GB/home/bak/baz")
          (cull-size-quota "/media/www/BLU16GB/home/bak/baz"))
      (if (file-exists-p "/media/www/GRN16GB/home/bak/baz")
          (cull-size-quota "/media/www/GRN16GB/home/bak/baz"))
      (if (file-exists-p "/media/www/WD2TB/home/bak/baz")
          (cull-size-quota "/media/www/WD2TB/home/bak/baz"))
      (if (file-exists-p "/media/www/WD2TB2/home/bak/baz")
          (cull-size-quota "/media/www/WD2TB2/home/bak/baz"))
      )
    (demises-get-demises)
    (message "Completed M-x bak")
    ))

(provide 'bak-unix)
;;; bak-unix.el ends here
