(test-begin "quaternion")

(import (kawa quaternions))

(test-equal 0 (+ +i+j+k -i-j-k))
(test-equal -1 (* +i +i))
(test-equal -1 (* +j +j))
(test-equal -1 (* +k +k))
(test-equal -1 (* +i +j +k))

(test-equal 1+i+j+k (+ 1 +i +j +k))
(test-equal 1-i-j-k (- 1 +i +j +k))

(test-equal 1 (/ 1+i+j+k 1+i+j+k))

(test-equal +k (* (/ -i) +j))
(test-equal -k (* +j (/ -i)))

(test-eqv #t (quaternion? 0))
(test-eqv #t (quaternion? -i))
(test-eqv #t (quaternion? 1+2i-3j+4k))
(test-eqv #f (quaternion? 10.0m))
(test-eqv #f (quaternion? "x"))
(test-eqv #t (quaternion? (java.lang.Double:valueOf 5.5)))

(test-begin "real-part")
(test-equal 0 (real-part 0))
(test-equal 0 (real-part -i))
(test-equal 1 (real-part 1+2i-3j+4k))
(test-end "real-part")

(test-begin "imag-part")
(test-equal 0 (imag-part 0))
(test-equal -1 (imag-part -i))
(test-equal 2 (imag-part 1+2i-3j+4k))
(test-end "imag-part")

(test-begin "jmag-part")
(test-equal 0 (jmag-part 0))
(test-equal 0 (jmag-part -i))
(test-equal -3 (jmag-part 1+2i-3j+4k))
(test-end "jmag-part")

(test-begin "kmag-part")
(test-equal 0 (kmag-part 0))
(test-equal 0 (kmag-part -i))
(test-equal 4 (kmag-part 1+2i-3j+4k))
(test-end "kmag-part")

(test-begin "vector-part")
(test-equal 0 (vector-part 0))
(test-equal -i (vector-part -i))
(test-equal +2i-3j+4k (vector-part 1+2i-3j+4k))
(test-end "vector-part")

(test-begin "unit-vector")
(test-equal 0 (unit-vector 0))
(test-equal -i (unit-vector -i))
(test-equal (* (/ (sqrt 3)) +i+j+k) (unit-vector 3+3i+3j+3k))
(test-equal 1.0 (magnitude (unit-vector 1+2i+3j+4k)))
(test-end "unit-vector")

(test-begin "unit-quaternion")
(test-equal 0 (unit-quaternion 0))
(test-equal +i (unit-quaternion 0.0+0.00001i+0.0j+0.0k))
(test-assert (= 1/2+1/2i+1/2j+1/2k (unit-quaternion 1+i+j+k)))
(test-end "unit-quaternion")

(test-begin "magnitude")
(test-eqv 5.0 (magnitude 3+4i))
(test-eqv 5.0 (magnitude 3-4j))
(test-eqv 5.0 (magnitude 4+3k))
(test-eqv 5.0 (magnitude +3i-4j))
(test-eqv 5.0 (magnitude -4i+3k))
(test-eqv 5.0 (magnitude -3j-4k))
(test-eqv 5.0 (magnitude +5k))
(test-end "magnitude")

(test-begin "angle")
(test-eqv 1.5 (angle 3@1.5))
(test-eqv 1.5 (angle 3@1.5%0.2))
(test-eqv 1.5 (angle 3@1.5&-0.4))
(test-eqv 1.5 (angle 3@1.5%0.2&-0.4))
(test-assert (= (/ java.lang.Math:PI 2) (angle +i)))
(test-end "angle")

(test-begin "colatitude")
(test-eqv 0 (colatitude 3@1.5))
(test-eqv 0.2 (colatitude 3@1.5%0.2))
(test-eqv 0 (colatitude 3@1.5&-0.4))
(test-eqv 0.2 (colatitude 3@1.5%0.2&-0.4))
(test-end "colatitude")

(test-begin "longitude")
(test-eqv 0 (longitude 3@1.5))
(test-eqv 0.0 (longitude 3@1.5%0.2))
(test-eqv 0 (longitude 3@1.5&-0.4))
(test-eqv -0.4 (longitude 3@1.5%0.2&-0.4))
(test-end "longitude")

(test-begin "make-rectangular")
(test-equal 1+2i+3j+4k (make-rectangular 1 2 3 4))
(test-equal 1.5-2i (make-rectangular 1.5 -2))
(test-equal 1.5-2i (make-rectangular 1.5 -2 0 0))
(test-end "make-rectangular")

(test-begin "make-polar")
(test-equal 1@1.5 (make-polar 1 1.5))
(test-equal 1@1.5 (make-polar 1 1.5 0 0))
(test-equal 1@1.5 (make-polar 1 1.5 0 0.3))
(test-equal 1@1.5%-0.2 (make-polar 1 1.5 -0.2 0))
(test-equal 1@1.5%-0.2&0.4 (make-polar 1 1.5 -0.2 0.4))
(test-end "make-polar")

(test-begin "dot-product")
(test-error #t (dot-product 1+2i+3j+4k +i+j+k))
(test-equal (- (real-part (* +i+j+k +2i-3j-4k))) (dot-product +i+j+k +2i-3j-4k))
(test-equal -5 (dot-product +i+j+k +2i-3j-4k))
(test-equal 0 (dot-product +i +j+k))
(test-end "dot-product")

(test-begin "cross-product")
(test-equal +k (cross-product +i +j))
(test-equal -3i+6j-3k (cross-product +i+2j+3k +4i+5j+6k))
(test-equal 0 (cross-product -i-j-k +3i+3j+3k))
(test-end "cross-product")

(test-begin "conjugate")
(test-equal 1-i (conjugate 1+i))
(test-equal 1+2i-3j+4k (conjugate 1-2i+3j-4k))
(test-end "conjugate")

(test-begin "expt")
(test-eqv #t (real-valued? (expt +i +i)))
(test-equal (expt +i +i) (expt +j +j))
(test-equal (expt +i +i) (expt +k +k))
(test-assert (= (java.lang.Math:exp (/ (- java.lang.Math:PI) 2))
                (expt +i +i)))
(test-end "expt")

(test-begin "sqrt")
(test-approximate (make-rectangular (/ (sqrt 2)) 0 0 (/ (sqrt 2)))
                  (sqrt +k)
                  0.0000000001+0.0000000001i+0.0000000001j+0.0000000001k)
(test-end "sqrt")

(test-end)
