/* This file is part of GNU Pies.
   Copyright (C) 2009 Sergey Poznyakoff

   GNU Pies is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Pies is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNU Pies.  If not, see <http://www.gnu.org/licenses/>. */

#include <unistd.h>
#include <stdlib.h>
#include <gettext.h>


#define _(String) gettext(String)
#define N_(String) String


#if defined HAVE_SYSCONF && defined _SC_OPEN_MAX
# define getmaxfd() sysconf(_SC_OPEN_MAX)
#elif defined (HAVE_GETDTABLESIZE)
# define getmaxfd() getdtablesize()
#else
# define getmaxfd() 256
#endif



void *xmalloc (size_t size);
void *xzalloc (size_t size);
void *xcalloc (size_t count, size_t size);
char *xstrdup (const char *str);


void mf_proctitle_init (int argc, char *argv[], char *env[]);
void mf_proctitle_format (const char *fmt, ...);


size_t longtostr (long i, char *buf, size_t size);
size_t ulongtostr (unsigned long i, char *buf, size_t size);


struct tokendef
{
  char *name;
  int tok;
};

int strtotok_len (struct tokendef *tab, const char *str, size_t len,
		  int *pres);
int strtotok_len_ci (struct tokendef *tab, const char *str, size_t len,
		     int *pres);
int strtotok (struct tokendef *tab, const char *str, int *pres);
int strtotok_ci (struct tokendef *tab, const char *str, int *pres);
int toktostr (struct tokendef *tab, int tok, const char **pres);

