%define prefix /usr

Summary: GNU Smalltalk
Name: gst
Version: 2.1.11
Release: 1
Source: ftp://ftp.gnu.org/gnu/smalltalk/smalltalk-%{version}.tar.gz
Copyright: GPL
Group: Development/Languages
URL: http://www.gnu.org/software/smalltalk/smalltalk.html
Buildroot: %{_tmppath}/%{name}-root

%description
GNU Smalltalk is an implementation that closely follows the
Smalltalk-80 language as described in the book `Smalltalk-80: the
Language and its Implementation' by Adele Goldberg and David Robson.
The Smalltalk programming language is an object oriented programming
language.
Unlike other Smalltalks (including Smalltalk-80), GNU Smalltalk
emphasizes Smalltalk's rapid prototyping features rather than the
graphical and easy-to-use nature of the programming environment.
Therefore, even though we have a nice GUI environment including a class
browser, the goal of the GNU Smalltalk project is currently to produce a
complete system to be used to write your scripts in a clear, aesthetically
pleasing, and philosophically appealing programming language.

%prep
%setup -q -n smalltalk-%{version}
./configure --prefix=%{prefix}

%build
make
make check

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc %{_prefix}/info/gst.info*
%doc %{_prefix}/man/man1/gst.1*
%{_prefix}/bin/gst
%{_prefix}/bin/gst-package
%{_prefix}/bin/gst-config 
%{_prefix}/share/gnu-smalltalk
%{_prefix}/include/gst.h   
%{_prefix}/include/gstpub.h 
%{_prefix}/lib/gnu-smalltalk
