# GNU Solfege - eartraining for GNOME
# Copyright (C) 2000, 2001  Tom Cato Amundsen
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sys, string, re
import app, mpd

import src.rcfile
src.rcfile.copy_rc14_file()

try:
    import readline
except:
    print "Failed to import readline"

del sys.argv[sys.argv.index('--txtui')]
import harmonicintervall
import configureoutput

whitespace_re = re.compile("\s+")

class UI:
    def __init__(self, argv):
        self.m_prompt = "solfege>"
        self.m_app = app.SolfegeApp(argv, self)
        self.mainloop()
    def display_docfile(self, fn):
        print "display file (not finished yet!):" , fn
    def display_error_message(self, txt):
        print "Error message:\n", txt
    def mainloop(self):
        print "Welcome to GNU Solfege %s\nType 'help' to list commands." % configureoutput.VERSION_STRING
        teacher = None
        while 1:
            s = raw_input(self.m_prompt)
            s = string.rstrip(s)
            v = whitespace_re.split(s)
            if s == '':
                print "Type 'help' to list commands."
                continue
            if s in ('exit', 'bye', 'quit'):
                break
            if s == 'help':
                print """
start harm            start the harmonic exercise
new                   new question
repeat                repeat question
repeat melodic        repeat melodic
guess xxx             xxx is short name of intervall, for example
                      m2 for minor second, M3 for major third,
                      4 for perfect fourth, d5 for diminished fifth.
exit                  quit the program.
"""
            elif v[0] == 'start':
                if len(v) < 2:
                    print "You must tell what exercise to start."
                    print "This release only support 'start harm' that will start the"
                    print "harmonic intervall exercise."
                    continue
                if v[1] == 'harm' and teacher == None:
                    self.m_prompt = "harmonic-intervall>"
                    teacher = harmonicintervall.Teacher('harmonic-intervall', self.m_app)
            elif v[0] == 'new':
                if not teacher:
                    print 'start an exercise first'
                    continue
                teacher.new_question()
                teacher.play_question()
            elif v[0] == 'repeat':
                if len(v) == 1:
                    teacher.play_question()
                elif v[1] == 'melodic':
                    teacher.play_melodic()
            elif v[0] == 'guess':
                if len(v) < 2:
                    print "missing argument"
                    continue
                i = mpd.Intervall()
                i.set_from_string(v[1])
                if teacher.guess_answer(i.get_intvalue()):
                    print "Correct"
                else:
                    print "Wrong"
            else:
                print "sorry, I don't understand you."

w = UI(sys.argv)
