/* GNU Solfege - eartraining for GNOME
 * Copyright (C) 2000, 2001, 2002  Tom Cato Amundsen
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <windows.h>
#include <mmsystem.h>

//lyd_vis(){
//  MIDIOUTCAPS     moc;
//  unsigned long   iNumDevs, i;
//
//  /* Get the number of MIDI Out devices in this computer */
//  iNumDevs = midiOutGetNumDevs();
//
//  /* Go through all of those devices, displaying their names */
//  for (i = 0; i < iNumDevs; i++)
//      /* Get info about the next device */
//      if (!midiOutGetDevCaps(i, &moc, sizeof(MIDIOUTCAPS)))
//      {
//          /* Display its Device ID and name */
//           printf("Device ID #%u: %s\r\n", i, moc.szPname);
//      }
//  }
//}


play_file(void * filename) {
  DWORD          err;
  MCI_OPEN_PARMS midiParams;
  MCI_PLAY_PARMS playParams;
  
  TCHAR          buffer[128];
  /* Open a Sequencer device associated with the C:\WINDOWS\SONG.MID file */
  midiParams.lpstrDeviceType = (LPCSTR)MCI_DEVTYPE_SEQUENCER;
  midiParams.lpstrElementName = filename;
  if ((err = mciSendCommand(0, MCI_OPEN, MCI_WAIT|MCI_OPEN_ELEMENT|MCI_OPEN_TYPE|MCI_OPEN_TYPE_ID, (DWORD)(LPVOID)&midiParams)))
  {
      /* Error */
      printf("\nERROR: Sequencer device did not open!\r\n");
      if (mciGetErrorString(err, &buffer[0], sizeof(buffer))) printf("%s\r\n", &buffer[0]);
  }
  else
  {
      /* The device opened successfully. midiParams.wDeviceID now contains
       * the device ID */
  }
  
  /* Play a Sequencer device. Assume that midiParams.wDeviceID was set
   * when calling mciSendCommand above */
  if ((err = mciSendCommand(midiParams.wDeviceID, MCI_PLAY, MCI_WAIT, (DWORD)(LPVOID)&playParams)))
  {
      /* Error */
      printf("ERROR: Midi did not play!\r\n");
      if (mciGetErrorString(err, &buffer[0], sizeof(buffer))) printf("%s\r\n", &buffer[0]);
  }
  else
  {
      /* The midi song has played from beginning to end */
  }
}

int
main(int argc, char *argv[]){
  if (argc != 2) {
     printf("midiplayer has to be called with midi file filename as argument");
     exit(-1);
  }
  play_file(argv[1]);
  return 0;
}
